/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.limiter.constant.SceneType;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class LimitSchemePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String QUERY_LIMIT = "querylimit";
    private static final String EXPORT_LIMIT = "exportlimit";

    public void registerListener(EventObject e) {
        BasedataEdit entity = (BasedataEdit)this.getView().getControl("entitynumber");
        if (entity != null) {
            entity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        ComboEdit exportLimit;
        ComboEdit queryLimit = (ComboEdit)this.getControl(QUERY_LIMIT);
        List scenes = ConcurrentSceneManager.getScenes((SceneType)SceneType.REPORT);
        if (queryLimit != null) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(scenes.size());
            for (ConcurrentScene scene : scenes) {
                if (StringUtils.equals((CharSequence)scene.getSceneCode(), (CharSequence)"REPORT_QUERY_LIMIT") || StringUtils.equals((CharSequence)scene.getSceneCode(), (CharSequence)"REPORT_EXPORT_LIMIT")) continue;
                items.add(new ComboItem(new LocaleString(String.format("%s(%s)", scene.getSceneName(), scene.getSceneCode())), scene.getSceneCode()));
            }
            queryLimit.setComboItems(items);
        }
        if ((exportLimit = (ComboEdit)this.getControl(EXPORT_LIMIT)) != null) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(scenes.size());
            for (ConcurrentScene scene : scenes) {
                if (StringUtils.equals((CharSequence)scene.getSceneCode(), (CharSequence)"REPORT_QUERY_LIMIT") || StringUtils.equals((CharSequence)scene.getSceneCode(), (CharSequence)"REPORT_EXPORT_LIMIT")) continue;
                items.add(new ComboItem(new LocaleString(String.format("%s(%s)", scene.getSceneName(), scene.getSceneCode())), scene.getSceneCode()));
            }
            exportLimit.setComboItems(items);
        }
    }

    public void afterLoadData(EventObject e) {
        Object exportLimitValue;
        Object queryLimitValue = this.getModel().getValue(QUERY_LIMIT);
        if (queryLimitValue != null) {
            this.setQueryLimit(queryLimitValue.toString());
        }
        if ((exportLimitValue = this.getModel().getValue(EXPORT_LIMIT)) != null) {
            this.setExportLimit(exportLimitValue.toString());
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)QUERY_LIMIT, (CharSequence)e.getProperty().getName())) {
            this.setQueryLimit(newValue.toString());
        } else if (StringUtils.equals((CharSequence)EXPORT_LIMIT, (CharSequence)e.getProperty().getName())) {
            this.setExportLimit(newValue.toString());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object nodeId = this.getView().getFormShowParameter().getCustomParam("treeRootNodeId");
        if (nodeId != null) {
            if (evt.getSourceMethod().equals("click")) {
                evt.getFormShowParameter().setCustomParam("treeRootNodeId", nodeId);
            } else {
                List<Object> appIds;
                boolean isCloud = ORM.create().exists("bos_devportal_bizcloud", nodeId);
                if (isCloud) {
                    ArrayList<String> cloudIds = new ArrayList<String>(2);
                    cloudIds.add(nodeId.toString());
                    DynamicObjectCollection allBizAppsByCloudID = BizAppServiceHelp.getAllBizAppsByCloudID(cloudIds);
                    appIds = new ArrayList<Object>(allBizAppsByCloudID.size());
                    for (DynamicObject dynamicObject : allBizAppsByCloudID) {
                        appIds.add(dynamicObject.getPkValue());
                    }
                } else {
                    appIds = this.geAllAppIdsByAppId(nodeId.toString());
                }
                if (appIds != null) {
                    QFilter qFilter = new QFilter("bizappid", "in", appIds);
                    evt.getCustomQFilters().add(qFilter);
                }
            }
        }
    }

    private List<Object> geAllAppIdsByAppId(String appId) {
        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp", (String)"id, bizcloud");
        DynamicObject bizcloud = app.getDynamicObject("bizcloud");
        String cloudId = bizcloud.getString("id");
        DynamicObjectCollection appList = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        ArrayList<Object> appIds = new ArrayList<Object>(appList.size());
        for (DynamicObject obj : appList) {
            String bizAppId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            if (!StringUtils.equals((CharSequence)appId, (CharSequence)tMasterId)) continue;
            appIds.add(bizAppId);
        }
        appIds.add(appId);
        return appIds;
    }

    private void setQueryLimit(String sceneCode) {
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            ConcurrentScene scene = ConcurrentSceneManager.getScene((String)sceneCode);
            this.getModel().setValue("queryrange", (Object)scene.getRange());
            this.getModel().setValue("querytenantisolation", (Object)(scene.isTenantIsolation() ? "1" : "0"));
            this.getModel().setValue("queryconcurrency", (Object)scene.getConcurrency());
            this.getModel().setValue("querylocktimeout", (Object)scene.getLockTimeout());
            this.getModel().setValue("querysingleuserlimit", (Object)scene.isSingleUserLimit1());
            this.getModel().setValue("querytimeoutkillsql", (Object)scene.isTimeoutKillSQL());
        } else {
            this.getModel().setValue("queryrange", null);
            this.getModel().setValue("querytenantisolation", null);
            this.getModel().setValue("queryconcurrency", null);
            this.getModel().setValue("querylocktimeout", null);
            this.getModel().setValue("querysingleuserlimit", null);
            this.getModel().setValue("querytimeoutkillsql", null);
        }
    }

    private void setExportLimit(String sceneCode) {
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            ConcurrentScene scene = ConcurrentSceneManager.getScene((String)sceneCode);
            this.getModel().setValue("exportrange", (Object)scene.getRange());
            this.getModel().setValue("exporttenantisolation", (Object)(scene.isTenantIsolation() ? "1" : "0"));
            this.getModel().setValue("exportconcurrency", (Object)scene.getConcurrency());
            this.getModel().setValue("exportlocktimeout", (Object)scene.getLockTimeout());
            this.getModel().setValue("exportsingleuserlimit", (Object)scene.isSingleUserLimit1());
            this.getModel().setValue("exporttimeoutkillsql", (Object)scene.isTimeoutKillSQL());
        } else {
            this.getModel().setValue("exportrange", null);
            this.getModel().setValue("exporttenantisolation", null);
            this.getModel().setValue("exportconcurrency", null);
            this.getModel().setValue("exportlocktimeout", null);
            this.getModel().setValue("exportsingleuserlimit", null);
            this.getModel().setValue("exporttimeoutkillsql", null);
        }
    }
}

