/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.lang.Lang;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class LimitSchemeTreePlugin
extends StandardTreeListPlugin {
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";

    public void initializeTree(EventObject e) {
        this.intiTree();
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractEntityTreePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("0");
        root.setIsOpened(true);
        this.getTreeListView().getTreeView().focusNode(root);
        root.addChildren(this.getAllCloudAndAPP());
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        if (this.getTreeModel().getRoot().getId().equals(e.getNodeId())) {
            e.setChildNodes(this.getAllCloudAndAPP());
        } else {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(String.valueOf(e.getNodeId()), 20);
            if (node != null) {
                ArrayList<String> cloudIds = new ArrayList<String>(2);
                cloudIds.add(node.getId());
                List<TreeNode> appNodes = this.getAppNodesByCloudId(cloudIds);
                e.setChildNodes(appNodes);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object currNodeId;
        if (e.getParameter().getStatus() == OperationStatus.ADDNEW && (currNodeId = this.getTreeModel().getCurrentNodeId()) != null && currNodeId.toString().compareTo(this.getTreeModel().getRoot().getId()) != 0) {
            e.getParameter().setCustomParam("treeRootNodeId", currNodeId);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        QFilter qFilter;
        String nodeId = nodeEvent.getNodeId().toString();
        ORM orm = ORM.create();
        if (StringUtils.equals((CharSequence)this.getTreeModel().getRoot().getId(), (CharSequence)nodeId)) {
            return;
        }
        boolean isCloud = orm.exists(BOS_DEVPORTAL_BIZCLOUD, (Object)nodeId);
        if (isCloud) {
            ArrayList<String> cloudIds = new ArrayList<String>(2);
            cloudIds.add(nodeId);
            DynamicObjectCollection allBizAppsByCloudID = BizAppServiceHelp.getAllBizAppsByCloudID(cloudIds);
            ArrayList<Object> ids = new ArrayList<Object>(allBizAppsByCloudID.size());
            for (DynamicObject dynamicObject : allBizAppsByCloudID) {
                ids.add(dynamicObject.getPkValue());
            }
            qFilter = new QFilter("entitynumber.bizappid", "in", ids);
        } else {
            List<Object> appIds = this.geAllAppIdsByAppId(nodeId);
            qFilter = new QFilter("entitynumber.bizappid", "in", appIds);
        }
        nodeEvent.addQFilter(qFilter);
    }

    private List<TreeNode> getAllCloudAndAPP() {
        DynamicObjectCollection allBizClouds = BizCloudServiceHelp.getAllBizClouds();
        ArrayList<TreeNode> cloudNodes = new ArrayList<TreeNode>(allBizClouds.size());
        for (Object dynamicObject : allBizClouds) {
            TreeNode node = new TreeNode();
            node.setId(dynamicObject.getString("id"));
            node.setText(dynamicObject.getString("name"));
            node.setParentid("-1");
            cloudNodes.add(node);
        }
        ArrayList<String> cloudIds = new ArrayList<String>(cloudNodes.size());
        for (TreeNode treeNode : cloudNodes) {
            cloudIds.add(treeNode.getId());
        }
        List<TreeNode> appNodes = this.getAppNodesByCloudId(cloudIds);
        for (TreeNode treeNode : cloudNodes) {
            this.addChildNode(treeNode, appNodes);
        }
        return cloudNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    private List<TreeNode> getAppNodesByCloudId(List<String> cloudIds) {
        ArrayList<String> appIds = new ArrayList<String>(10);
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allBizApps) {
            appIds.add(app.getString("id"));
        }
        Map<String, Map<String, Object>> dictionaries = this.getDictionaries(appIds);
        DynamicObjectCollection allBizAppsByCloudID = BizAppServiceHelp.getAllBizAppsByCloudID(cloudIds);
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(allBizAppsByCloudID.size());
        for (DynamicObject dynamicObject : allBizAppsByCloudID) {
            String name = dynamicObject.getString("name");
            String type = dynamicObject.getString("type");
            if (!"0".equals(type)) continue;
            TreeNode node = new TreeNode();
            String nodeId = dynamicObject.getString("id");
            for (Map.Entry<String, Map<String, Object>> map : dictionaries.entrySet()) {
                if (!nodeId.equals(map.getKey())) continue;
                name = (String)map.getValue().get("name");
            }
            node.setId(nodeId);
            node.setText(name);
            node.setParentid(dynamicObject.getString("bizcloud"));
            appNodes.add(node);
        }
        return appNodes;
    }

    private Map<String, Map<String, Object>> getDictionaries(List<String> appIds) {
        String sql = "select b.fid, d.fname, d.fdescription from t_meta_bizapp b left join t_meta_appruntime_l d on b.fnumber = d.fappid where b.fid in (%s) and d.flocaleid = '%s'";
        sql = String.format(sql, LimitSchemeTreePlugin.changeSetToSqlStr(appIds), Lang.get().toString());
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Object>>>(){

            public Map<String, Map<String, Object>> handle(ResultSet resultSet) throws Exception {
                HashMap<String, Map<String, Object>> rs = new HashMap<String, Map<String, Object>>(16);
                while (resultSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String id = resultSet.getString(1);
                    map.put("name", resultSet.getString(2));
                    map.put("description", resultSet.getString(3));
                    rs.put(id, map);
                }
                return rs;
            }
        });
    }

    private static String changeSetToSqlStr(List<String> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : set) {
            if (item == null) continue;
            String val = null;
            if (item instanceof String) {
                val = item.toString();
            } else if (item instanceof Map.Entry) {
                Object tVal = ((Map.Entry)((Object)item)).getValue();
                String string = val = tVal == null ? null : tVal.toString();
            }
            if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
            sb.append('\'').append(val).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }

    private List<Object> geAllAppIdsByAppId(String appId) {
        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp", (String)"id, bizcloud");
        DynamicObject bizcloud = app.getDynamicObject("bizcloud");
        String cloudId = bizcloud.getString("id");
        DynamicObjectCollection appList = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        ArrayList<Object> appIds = new ArrayList<Object>(appList.size());
        for (DynamicObject obj : appList) {
            String bizAppId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            if (!StringUtils.equals((CharSequence)appId, (CharSequence)tMasterId)) continue;
            appIds.add(bizAppId);
        }
        appIds.add(appId);
        return appIds;
    }
}

