/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.MetaIsvCheck;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;

public class MetaIsvCheckResultPlugIn
extends AbstractFormPlugin {
    private static final String RESULTS = "results";
    private static final String ENTRY_RESULT = "entity_result";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String json = (String)parameter.getCustomParam(RESULTS);
        if (StringUtils.isEmpty((CharSequence)json)) {
            return;
        }
        List results = SerializationUtils.fromJsonStringToList((String)json, MetaIsvCheck.IsvCheckResult.class);
        if (null == results || results.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_RESULT, results.size());
        int index = 0;
        IDataModel model = this.getModel();
        for (MetaIsvCheck.IsvCheckResult result : results) {
            model.setValue("name", (Object)result.getName(), index);
            model.setValue("type", (Object)result.getMetaType().getName(), index);
            model.setValue("control_key", (Object)result.getControl(), index);
            model.setValue("table", (Object)result.getTable(), index);
            model.setValue("field", (Object)result.getField(), index);
            model.setValue("description", (Object)result.getDescriptions(), index);
            ++index;
        }
    }

    public static FormShowParameter show(Collection<MetaIsvCheck.IsvCheckResult> results) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_isv_check_result");
        parameter.setCustomParam(RESULTS, (Object)SerializationUtils.toJsonString(results));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        return parameter;
    }
}

