/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.QRCode;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.MobileListShowParameter;

public class MobilePreviewPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String MOBILE_CONFIG_ID = "mobileConfigId";
    private static final String BUSINESS_NUMBER = "businessNumber";
    private static final String BUSINESS_PK_ID = "businessPkId";

    public void initialize() {
        Button btn = (Button)this.getControl("btnopenurl");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnopenurl".equals(btn.getKey())) {
            String url = this.createOpenUrl();
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                proxy.addAction("openUrl", (Object)url);
            }
        }
    }

    public void afterBindData(EventObject e) {
        if (RequestContext.get().getLang() != Lang.zh_CN && RequestContext.get().getLang() != Lang.zh_TW) {
            Image image = (Image)this.getControl("imageap");
            image.setUrl("/images/pc/other/logo_mob_en.png");
        }
    }

    public void afterCreateNewData(EventObject e) {
        String number = (String)this.getView().getFormShowParameter().getCustomParams().get("number");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        if (number != null && modelType != null) {
            if ("MobileListModel".equals(modelType)) {
                String testappid;
                MobileListShowParameter showParameter = new MobileListShowParameter();
                showParameter.setBillFormId(number);
                showParameter.getOpenStyle().setShowType(ShowType.IFrame);
                showParameter.getOpenStyle().setTargetKey("fmobilepreview");
                showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
                showParameter.setClientParam("preview", (Object)true);
                FormConfig formConfig = FormMetadataCache.getMobListFormConfig((String)number);
                if (formConfig != null && StringUtils.isNotBlank((CharSequence)formConfig.getListFormId())) {
                    showParameter.setFormId(formConfig.getListFormId());
                }
                if (StringUtils.isNotBlank((CharSequence)(testappid = (String)this.getView().getFormShowParameter().getCustomParam("testappid")))) {
                    showParameter.setAppId(testappid);
                }
                this.getView().showForm((FormShowParameter)showParameter);
                String url = this.createOpenUrl();
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    QRCode qrCode = (QRCode)this.getView().getControl("imgqrcode");
                    qrCode.setUrl(url);
                }
                Label lb = (Label)this.getView().getControl("labellink");
                lb.setText(number);
            } else {
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("formId", number);
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object mobileConfigId = formShowParameter.getCustomParam(MOBILE_CONFIG_ID);
                Object businessNumber = formShowParameter.getCustomParam(BUSINESS_NUMBER);
                Object businessPkId = formShowParameter.getCustomParam(BUSINESS_PK_ID);
                String bizAppId = formShowParameter.getAppId();
                Object hasRight = formShowParameter.getCustomParam("hasright");
                Object isIgnoreLicense = formShowParameter.getCustomParam("isIgnoreLicense");
                Object scene = formShowParameter.getCustomParam("scene");
                if (mobileConfigId != null) {
                    para.put(MOBILE_CONFIG_ID, mobileConfigId);
                }
                if (businessNumber != null) {
                    para.put(BUSINESS_NUMBER, businessNumber);
                }
                if (businessPkId != null) {
                    para.put(BUSINESS_PK_ID, businessPkId);
                }
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
                showParameter.getOpenStyle().setShowType(ShowType.IFrame);
                showParameter.getOpenStyle().setTargetKey("fmobilepreview");
                showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
                showParameter.setClientParam("preview", (Object)true);
                if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
                    showParameter.setAppId(bizAppId);
                }
                if (StringUtils.isNotBlank((Object)hasRight)) {
                    showParameter.setHasRight(((Boolean)hasRight).booleanValue());
                }
                if (StringUtils.isNotBlank((Object)isIgnoreLicense)) {
                    showParameter.setCustomParam("isIgnoreLicense", isIgnoreLicense);
                }
                if (StringUtils.isNotBlank((Object)scene)) {
                    showParameter.setCustomParam("scene", scene);
                }
                showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                if (this.getView().getFormShowParameter().getStatus() != null) {
                    showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
                }
                this.getView().showForm(showParameter);
                String url = this.createOpenUrl();
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    QRCode qrCode = (QRCode)this.getView().getControl("imgqrcode");
                    qrCode.setUrl(url);
                }
                Label lb = (Label)this.getView().getControl("labellink");
                lb.setText(number);
            }
        }
    }

    private String createOpenUrl() {
        String number = (String)this.getView().getFormShowParameter().getCustomParams().get("number");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        String ip = this.getUrl();
        StringBuilder urlBuilder = new StringBuilder();
        if (ip != null) {
            urlBuilder.append(ip);
        }
        Long mobileConfig = (Long)this.getView().getFormShowParameter().getCustomParam(MOBILE_CONFIG_ID);
        Object businessNumber = this.getView().getFormShowParameter().getCustomParam(BUSINESS_NUMBER);
        Object businessPkId = this.getView().getFormShowParameter().getCustomParam(BUSINESS_PK_ID);
        if (number == null || ip == null) {
            return "";
        }
        urlBuilder.append("?form=");
        switch (modelType) {
            case "MobileBillFormModel": {
                urlBuilder.append(number);
                if (mobileConfig != null) {
                    urlBuilder.append("&mobileConfigId=").append(mobileConfig);
                    break;
                }
                if (businessNumber == null || businessPkId == null) break;
                urlBuilder.append("&businessNumber=").append(businessNumber).append("&businessPkId=").append(businessPkId);
                break;
            }
            case "MobileListModel": {
                String listFormId = "bos_moblist";
                FormConfig mobListFormConfig = FormMetadataCache.getMobListFormConfig((String)number);
                if (mobListFormConfig != null) {
                    listFormId = mobListFormConfig.getListFormId();
                }
                urlBuilder.append(listFormId).append("&billFormId=").append(number).append("&type=mobilelist");
                break;
            }
        }
        return urlBuilder.toString();
    }

    private String getUrl() {
        String sCurrntURL = RequestContext.get().getClientFullContextPath();
        String url = null;
        if (sCurrntURL != null) {
            url = sCurrntURL + "mobile.html";
        }
        return url;
    }
}

