/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.DesignerData;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class NewFormPlugin
extends AbstractFormPlugin {
    public static final String PARENT = "parent";
    public static final String MODEL_TYPE = "modeltype";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TextEdit edt = (TextEdit)this.getView().getControl(PARENT);
        edt.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            Object modelType = this.getModel().getValue(MODEL_TYPE);
            param.put("modelType", modelType == null ? "DynamicFormModel" : modelType);
            param.put("id", this.getModel().getValue("number"));
            param.put("name", this.getModel().getValue("name"));
            param.put("parentId", this.getModel().getValue("parentid"));
            Long subSystemId = (Long)this.getModel().getValue("subsystem_id");
            if (subSystemId <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewFormPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            param.put("subSystem", subSystemId);
            param.put("subFnumber", ((DynamicObject)this.getModel().getValue("subsystem")).get("number"));
            String name = (String)param.get("name");
            String number = (String)param.get("id");
            if (StringUtils.isEmpty((CharSequence)number) || StringUtils.isEmpty((CharSequence)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewFormPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (number.endsWith("_mob") || number.endsWith("_filter") || number.endsWith("_param")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4f7f\u7528_mob\u6216_filter\u540e\u7f00\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewFormPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            DesignerData designerData = new DesignerData();
            String regex = "[a-z0-9A-Z_]+";
            Boolean flag = Pattern.matches(regex, number);
            if (designerData.checkNumber(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewFormPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (!flag.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"NewFormPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (number.startsWith("_") || number.endsWith("_")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"NewFormPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (number.length() > 25) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e25\u3002", (String)"NewFormPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (designerData.checkName(name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewFormPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().returnDataToParent(param);
                this.getView().close();
            }
        } else if (PARENT.equalsIgnoreCase(c.getKey())) {
            this.selectParent();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    private void selectParent() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_formselector");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL_TYPE, this.getModel().getValue(MODEL_TYPE));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectParent");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("modelType", (Object)"DynamicFormModel");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret;
        if ("selectParent".equals(e.getActionId()) && (ret = (Map)e.getReturnData()) != null) {
            this.getModel().setValue(PARENT, ret.get("name"));
            this.getModel().setValue("parentid", ret.get("id"));
        }
    }
}

