/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.subsystem.query.SubSystemReader;

public class NewSubSystemPlugin
extends AbstractFormPlugin {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String FNUMBER = "fnumber";
    private static final String FNAME = "fname";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5c1a\u672a\u5b8c\u5584\uff0c\u8bf7\u5148\u624b\u52a8\u6dfb\u52a0\u3002", (String)"NewSubSystemPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        this.getView().close();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            Object numberOb = this.getModel().getValue(FNUMBER);
            Object fnameOb = this.getModel().getValue(FNAME);
            if (this.getModel().getValue("fvisible") == null) {
                this.getModel().setValue("fvisible", (Object)false);
            }
            if (this.getModel().getValue("fisdefault") == null) {
                this.getModel().setValue("fisdefault", (Object)false);
            }
            Map fnameMap = (Map)fnameOb;
            ArrayList<String> listLang = new ArrayList<String>();
            if (fnameMap.containsKey("zh_CN")) {
                String zhcnStr = fnameMap.get("zh_CN").toString();
                listLang.add(zhcnStr);
            }
            if (fnameMap.containsKey("en_US")) {
                String enusStr = fnameMap.get("en_US").toString();
                listLang.add(enusStr);
            }
            if (fnameMap.containsKey("zh_TW")) {
                String zhtwStr = fnameMap.get("zh_TW").toString();
                listLang.add(zhtwStr);
            }
            String number = (String)numberOb;
            SubSystemReader query = new SubSystemReader();
            for (int i = 0; i < listLang.size(); ++i) {
                if (!query.checkName((String)listLang.get(i))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewSubSystemPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String regex = "[a-z0-9A-Z_]+";
            Boolean flag = Pattern.matches(regex, number);
            if (this.getModel().getValue(FNUMBER) == null || this.getModel().getValue(FNUMBER).toString().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NewSubSystemPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (this.getModel().getValue(FNAME) == null || ((Map)this.getModel().getValue(FNAME)).size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NewSubSystemPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (query.checkNumber(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewSubSystemPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (!flag.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"NewSubSystemPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (number.startsWith("_") || number.endsWith("_")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"NewSubSystemPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (number.length() > 25) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"NewSubSystemPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else {
                try {
                    this.getView().invokeOperation("save");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"NewSubSystemPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u9519\u8bef\uff1a%s\u3002", (String)"NewSubSystemPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                }
                this.getView().close();
                evt.setCancel(true);
            }
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
        evt.setCancel(true);
    }
}

