/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.designer.AbstractFormDesignerPlugin;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.widget.WidgetContainerAp;

public class PersonConsoleDesignerPlugin
extends AbstractFormDesignerPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    @Override
    protected String getDesignerKey() {
        return "designer";
    }

    private Map<String, Object> createFormMetadata(Map<String, Object> srcFormmeta) {
        IFormTemplate template = FormTemplateFactory.createTemplate("DynamicFormModel");
        FormMetadata formMeta = null;
        if (srcFormmeta == null) {
            formMeta = template.getFormMetadata();
            formMeta.setId(Uuid16.create().toString());
            formMeta.setKey(this.getDesignerKey());
            WidgetContainerAp wc = new WidgetContainerAp();
            wc.setId(Uuid16.create().toString());
            wc.setParentId(formMeta.getId());
            wc.setName(new LocaleString("zh_CN", ResManager.loadKDString((String)"\u5c0f\u90e8\u4ef6\u5bb9\u5668", (String)"PersonConsoleDesignerPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0])));
            wc.setHeight(new LocaleString("zh_CN", "100%"));
            formMeta.getItems().add(wc);
        } else {
            formMeta = (FormMetadata)template.deserializeFromMap(srcFormmeta, null);
        }
        EntityMetadata entityMeta = template.getEntityMetadata();
        formMeta.createIndex(true);
        entityMeta.getRootEntity().setKey(this.getDesignerKey());
        HashMap<String, Object> tMap = new HashMap<String, Object>();
        tMap.put("entityreadonly", true);
        tMap.put("entitytree", entityMeta.buildDesgnerTree());
        tMap.put("id", formMeta.getId());
        tMap.put("entitymeta", template.serializeToMap(entityMeta));
        tMap.put("ui", formMeta.builderDesgnerControls());
        tMap.put("formmeta", template.serializeToMap(formMeta));
        tMap.put("islayout", true);
        tMap.put("isPC", true);
        return tMap;
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.returnData();
        }
    }

    private void returnData() {
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", designer.getContent().get("formmeta"));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    @Override
    protected void beforeShowPropertyEdit(PropertyEvent e, FormShowParameter showParameter) {
        if ("ide_listfieldid".equals(showParameter.getFormId())) {
            showParameter.setCustomParam("context", this.getView().getFormShowParameter().getCustomParam("context"));
            showParameter.setCustomParam("type", (Object)"billlist");
        }
        super.beforeShowPropertyEdit(e, showParameter);
    }
}

