/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;

public class PropertyEditHelper {
    private static final String PARAM_PROPEVENTARGS = "PropEventArgs";
    private static final String PARAM_ENTITYMETA = "entitymeta";
    private static final String PARAM_FORMMETA = "formmeta";
    private Map<String, Object> propEventArgs;
    private IFormView designView;

    public IFormView getDesignFormView(IFormView propEditView) {
        if (propEditView == null) {
            return null;
        }
        if (this.designView == null) {
            IFormView parentView;
            String designPageId = (String)propEditView.getFormShowParameter().getCustomParam("designerPageId");
            String parentPageId = propEditView.getFormShowParameter().getParentPageId();
            while (StringUtils.isBlank((CharSequence)designPageId) && StringUtils.isNotBlank((CharSequence)parentPageId) && (parentView = propEditView.getViewNoPlugin(parentPageId)) != null) {
                designPageId = (String)parentView.getFormShowParameter().getCustomParam("designerPageId");
                parentPageId = parentView.getFormShowParameter().getParentPageId();
            }
            if (StringUtils.isNotBlank((CharSequence)designPageId)) {
                this.designView = propEditView.getViewNoPlugin(designPageId);
            }
        }
        return this.designView;
    }

    public String getModelType(IFormView propEditView) {
        IFormView designView = this.getDesignFormView(propEditView);
        if (designView == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)designView.getService(IPageCache.class);
        return pageCache.get("modelType");
    }

    public String getBizAppId(IFormView propEditView) {
        IFormView designView = this.getDesignFormView(propEditView);
        if (designView == null) {
            return null;
        }
        return (String)designView.getFormShowParameter().getCustomParam("bizappid");
    }

    public String getSubDesignerName(IFormView propEditView) {
        IFormView designView = this.getDesignFormView(propEditView);
        if (designView == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)designView.getService(IPageCache.class);
        return pageCache.get("designer");
    }

    public boolean isFormDesigner(IFormView propEditView) {
        String designerName = this.getSubDesignerName(propEditView);
        return StringUtils.isBlank((CharSequence)designerName);
    }

    public boolean isListDesigner(IFormView propEditView) {
        String designerName = this.getSubDesignerName(propEditView);
        return StringUtils.equals((CharSequence)designerName, (CharSequence)"ListMeta");
    }

    public boolean isMobDesigner(IFormView propEditView) {
        String designerName = this.getSubDesignerName(propEditView);
        return StringUtils.equals((CharSequence)designerName, (CharSequence)"MobMeta");
    }

    public boolean isMobListDesigner(IFormView propEditView) {
        String designerName = this.getSubDesignerName(propEditView);
        return StringUtils.equals((CharSequence)designerName, (CharSequence)"MobListMeta");
    }

    public String getItemId(IFormView propEditView) {
        return (String)this.loadPropEventParamCache(propEditView).get("itemId");
    }

    public Map<String, Object> getItem(IFormView propEditView) {
        List items = (List)this.loadPropEventParamCache(propEditView).get("item");
        if (items != null && !items.isEmpty()) {
            return (Map)items.get(0);
        }
        return null;
    }

    public List<Map<String, Object>> getEntityMeta(IFormView propEditView) {
        if (this.isListDesigner(propEditView) || this.isMobListDesigner(propEditView)) {
            IFormView designView = this.getDesignFormView(propEditView);
            IPageCache pageCache = (IPageCache)designView.getService(IPageCache.class);
            return SerializationUtils.fromJsonStringToList((String)pageCache.get("listContext"), Map.class);
        }
        return (List)this.loadPropEventParamCache(propEditView).get(PARAM_ENTITYMETA);
    }

    public List<Map<String, Object>> getFormMeta(IFormView propEditView) {
        return (List)this.loadPropEventParamCache(propEditView).get(PARAM_FORMMETA);
    }

    public Object getParamValue(IFormView propEditView, String paramName) {
        return this.loadPropEventParamCache(propEditView).get(paramName);
    }

    public static Property getPropertyFromEvent(IFormView designFormView, PropertyEvent e) {
        IPageCache pageCache = (IPageCache)designFormView.getService(IPageCache.class);
        String modelTypeId = pageCache.get("modelType");
        Map propItem = (Map)e.getParam().get("item");
        List context = (List)e.getParam().get("context");
        if (propItem == null) {
            if (StringUtils.equals((CharSequence)e.getPropertName(), (CharSequence)"Features")) {
                propItem = (Map)((List)context.get(1)).get(0);
            } else if (StringUtils.equals((CharSequence)e.getPropertName(), (CharSequence)"Operations")) {
                propItem = (Map)((List)context.get(0)).get(0);
            } else if (StringUtils.equals((CharSequence)e.getPropertName(), (CharSequence)"Rules")) {
                propItem = (Map)((List)context.get(context.size() - 1)).get(0);
            }
        }
        Property property = null;
        if (propItem != null) {
            DomainModelType modelType = DomainModelType.getDomainModelType((String)modelTypeId);
            String elementTypeId = (String)propItem.get("_Type_");
            ElementType elementType = modelType.getElementType(elementTypeId);
            for (Property prop : elementType.getProperties()) {
                if (!StringUtils.equals((CharSequence)prop.getPropertyName(), (CharSequence)e.getPropertName())) continue;
                property = prop;
                break;
            }
        }
        return property;
    }

    public static void cachePropEventParam(IFormView designFormView, PropertyEvent e) {
        IPageCache pageCache = (IPageCache)designFormView.getService(IPageCache.class);
        String modelTypeId = pageCache.get("modelType");
        Map propItem = (Map)e.getParam().get("item");
        List context = (List)e.getParam().get("context");
        Object value = e.getParam().get("value");
        Map form = (Map)e.getParam().get("form");
        if (propItem == null) {
            if (StringUtils.equals((CharSequence)e.getPropertName(), (CharSequence)"Features")) {
                propItem = (Map)((List)context.get(1)).get(0);
            } else if (StringUtils.equals((CharSequence)e.getPropertName(), (CharSequence)"Operations")) {
                propItem = (Map)((List)context.get(0)).get(0);
            } else if (StringUtils.equals((CharSequence)e.getPropertName(), (CharSequence)"Rules")) {
                propItem = (Map)((List)context.get(context.size() - 1)).get(0);
            }
        }
        HashMap<String, Object> propEventArgs = new HashMap<String, Object>();
        propEventArgs.put("modelType", modelTypeId);
        propEventArgs.put("metaType", e.getMetaType());
        propEventArgs.put("itemId", e.getItemId());
        propEventArgs.put("propertyName", e.getPropertName());
        propEventArgs.put("formId", form);
        propEventArgs.put("value", value);
        propEventArgs.put("context", context);
        if (propItem != null) {
            DomainModelType modelType = DomainModelType.getDomainModelType((String)modelTypeId);
            String elementTypeId = (String)propItem.get("_Type_");
            ElementType elementType = modelType.getElementType(elementTypeId);
            Property property = null;
            for (Property prop : elementType.getProperties()) {
                if (!StringUtils.equals((CharSequence)prop.getPropertyName(), (CharSequence)e.getPropertName())) continue;
                property = prop;
                break;
            }
            if (property != null) {
                Map map;
                String type;
                Object extenddata = property.getEditor().get("extenddata");
                if (extenddata instanceof List) {
                    List list = (List)extenddata;
                    int i = 0;
                    for (Object extitem : list) {
                        String type2;
                        if (!(extitem instanceof Map) || !StringUtils.isNotBlank((CharSequence)(type2 = (String)((Map)extitem).get("type"))) || context.size() <= i) continue;
                        propEventArgs.put(type2, context.get(i));
                        ++i;
                    }
                } else if (extenddata instanceof Map && context.size() > 0 && StringUtils.isNotBlank((CharSequence)(type = (String)(map = (Map)extenddata).get("type")))) {
                    propEventArgs.put(type, context.get(0));
                }
            }
        }
        pageCache.put(PARAM_PROPEVENTARGS, SerializationUtils.toJsonString(propEventArgs));
    }

    public static void clearPropEventParamCache(IFormView designFormView) {
        IPageCache pageCache = (IPageCache)designFormView.getService(IPageCache.class);
        pageCache.remove(PARAM_PROPEVENTARGS);
    }

    private Map<String, Object> loadPropEventParamCache(IFormView propEditView) {
        if (this.propEventArgs != null) {
            return this.propEventArgs;
        }
        if (this.getDesignFormView(propEditView) == null) {
            return new HashMap<String, Object>();
        }
        IPageCache pageCache = (IPageCache)this.designView.getService(IPageCache.class);
        String string = pageCache.get(PARAM_PROPEVENTARGS);
        this.propEventArgs = StringUtils.isBlank((CharSequence)string) ? new HashMap<String, Object>() : (Map)SerializationUtils.fromJsonString((String)string, HashMap.class);
        return this.propEventArgs;
    }

    public static Object deserializeFromMap(String modelTypeId, Map<String, Object> item, Object baseObject) {
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelTypeId, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        return ser.deserializeFromMap(item, baseObject);
    }
}

