/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.alias.ToolbarItemsConverter;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;

public class RichTextEditPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_TIDY = "tidy";
    private static final String[] ITEMS = new String[]{"customprint", "custompreview", "ur", "restoredraft", "ccp", "pastetext", "biu", "strikethrough", "ss", "hr", "pagebreak", "removeformat", "fb", "formatselect", "fontselect", "fontsizeselect", "bn", "aaa", "alignjustify", "oi", "lineheight", "link", "image", "emoticons", "charmap", "media", "anchor", "searchreplace", "table", "codesample", "code", "fullscreen", "indent2em"};
    private static final String[] INIT_HIDEITEMS = new String[]{"customprint", "custompreview", "restoredraft", "ccp", "pastetext", "ss", "hr", "pagebreak", "removeformat", "bn", "alignjustify", "oi", "lineheight", "image", "emoticons", "charmap", "media", "anchor", "searchreplace", "code", "fullscreen", "indent2em"};
    private static final String[] INIT_ITEMS = new String[]{"formatselect", "biu", "fontselect", "fontsizeselect", "strikethrough", "fb", "link", "aaa", "codesample", "table", "ur"};
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String ALIAS = "alias";
    private static final boolean BOOLEAN_TRUE = true;
    private static final boolean BOOLEAN_FALSE = false;
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_TIDY});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String btnKey = btn.getKey();
        if (BTN_TIDY.equals(btnKey)) {
            this.tidyScheme();
        } else if (BTN_OK.equals(btnKey)) {
            this.returnDataToParentAndClose();
        }
    }

    private void tidyScheme() {
        int i;
        for (i = 0; i < INIT_ITEMS.length; ++i) {
            this.getModel().setValue(INIT_ITEMS[i], (Object)true);
        }
        for (i = 0; i < INIT_HIDEITEMS.length; ++i) {
            this.getModel().setValue(INIT_HIDEITEMS[i], (Object)false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map toolbarItems = null;
        Object value = this.getView().getFormShowParameter().getCustomParam(VALUE);
        if (StringUtils.isNotBlank((Object)value)) {
            Map map = toolbarItems = value instanceof Map ? (Map)value : (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
        }
        if (this.isRichTextField() && value == null) {
            this.tidyScheme();
            return;
        }
        if (toolbarItems != null && !toolbarItems.isEmpty()) {
            List list = (List)toolbarItems.get("toolbarItems");
            this.functionSetPageInit(list);
        }
    }

    public void afterBindData(EventObject e) {
        if (this.isRichTextField()) {
            HashMap<String, LocaleString> meta = new HashMap<String, LocaleString>();
            meta.put("text", new LocaleString(ResManager.loadKDString((String)"\u6062\u590d\u9ed8\u8ba4", (String)"RichTextEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
            this.getView().updateControlMetadata(BTN_TIDY, meta);
        }
    }

    private boolean isRichTextField() {
        PropertyEditHelper helper = new PropertyEditHelper();
        Object itemObj = helper.getParamValue(this.getView(), "item");
        if (itemObj instanceof Map) {
            Map itemMap = (Map)itemObj;
            String metaType = (String)itemMap.get("_Type_");
            return StringUtils.equals((CharSequence)metaType, (CharSequence)"FieldAp");
        }
        return false;
    }

    private void functionSetPageInit(List<String> list) {
        for (int i = 0; i < ITEMS.length; ++i) {
            if (list.contains(ITEMS[i])) {
                this.getModel().setValue(ITEMS[i], (Object)true);
                continue;
            }
            this.getModel().setValue(ITEMS[i], (Object)false);
        }
        if (list.contains("undo")) {
            this.getModel().setValue("ur", (Object)true);
        } else {
            this.getModel().setValue("ur", (Object)false);
        }
        if (list.contains("cut")) {
            this.getModel().setValue("ccp", (Object)true);
        } else {
            this.getModel().setValue("ccp", (Object)false);
        }
        if (list.contains("bold")) {
            this.getModel().setValue("biu", (Object)true);
        } else {
            this.getModel().setValue("biu", (Object)false);
        }
        if (list.contains("subscript")) {
            this.getModel().setValue("ss", (Object)true);
        } else {
            this.getModel().setValue("ss", (Object)false);
        }
        if (list.contains("forecolor")) {
            this.getModel().setValue("fb", (Object)true);
        } else {
            this.getModel().setValue("fb", (Object)false);
        }
        if (list.contains("bullist")) {
            this.getModel().setValue("bn", (Object)true);
        } else {
            this.getModel().setValue("bn", (Object)false);
        }
        if (list.contains("alignleft")) {
            this.getModel().setValue("aaa", (Object)true);
        } else {
            this.getModel().setValue("aaa", (Object)false);
        }
        if (list.contains("outdent")) {
            this.getModel().setValue("oi", (Object)true);
        } else {
            this.getModel().setValue("oi", (Object)false);
        }
    }

    private void returnDataToParentAndClose() {
        HashMap<String, Object> para = new HashMap<String, Object>(4);
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        Map<String, Object> selectValue = this.getSelectValue();
        para.put(VALUE, selectValue);
        para.put(ALIAS, new ToolbarItemsConverter().convert(selectValue));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private Map<String, Object> getSelectValue() {
        int i;
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        ArrayList<String> checkeds = new ArrayList<String>(10);
        for (i = 0; i < ITEMS.length; ++i) {
            boolean isCheck = (Boolean)this.getModel().getValue(ITEMS[i]);
            if (!isCheck) continue;
            checkeds.add(ITEMS[i]);
        }
        block21: for (i = 0; i < checkeds.size(); ++i) {
            String str;
            switch (str = (String)checkeds.get(i)) {
                case "ur": {
                    checkeds.set(i, "undo");
                    checkeds.add("redo");
                    continue block21;
                }
                case "ccp": {
                    checkeds.set(i, "cut");
                    checkeds.add("copy");
                    checkeds.add("paste");
                    continue block21;
                }
                case "biu": {
                    checkeds.set(i, "bold");
                    checkeds.add("italic");
                    checkeds.add("underline");
                    continue block21;
                }
                case "ss": {
                    checkeds.set(i, "subscript");
                    checkeds.add("superscript");
                    continue block21;
                }
                case "fb": {
                    checkeds.set(i, "forecolor");
                    checkeds.add("backcolor");
                    continue block21;
                }
                case "bn": {
                    checkeds.set(i, "bullist");
                    checkeds.add("numlist");
                    continue block21;
                }
                case "aaa": {
                    checkeds.set(i, "alignleft");
                    checkeds.add("aligncenter");
                    checkeds.add("alignright");
                    continue block21;
                }
                case "oi": {
                    checkeds.set(i, "outdent");
                    checkeds.add("indent");
                    continue block21;
                }
            }
        }
        data.put("toolbarItems", checkeds);
        return data;
    }
}

