/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.MetadataUtil;
import kd.bos.designer.dao.OperationInfo;
import kd.bos.designer.dao.SVNKitUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.subsystem.query.SMGConfigWriter;

public class SVNLoginPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String CACHE_REGIONINFO = "SVN_LOGININFO";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.newAccountFile();
                break;
            }
            case "btncancel": {
                this.cancel();
                break;
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void newAccountFile() {
        String username = (String)this.getModel().getValue(USERNAME);
        String password = (String)this.getModel().getValue(P);
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SVNLoginPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        password = Encrypters.encode((String)password);
        String subFNumber = (String)this.getView().getFormShowParameter().getCustomParam("subsystem");
        OperationInfo operationInfo = new OperationInfo();
        if (!SVNKitUtil.testSvnConnection(MetadataUtil.getSVNRoot(subFNumber), username, password, operationInfo)) {
            this.getView().showErrorNotification(operationInfo.getErrorMessageString());
            return;
        }
        SMGConfigWriter smgConfigWriter = new SMGConfigWriter();
        smgConfigWriter.deleteSMGConfig(subFNumber, RequestContext.get().getUserOpenId());
        smgConfigWriter.insertSMGConfig(subFNumber, username, password, RequestContext.get().getUserOpenId());
        SessionManager.getCurrent().put("smgusername", username);
        SessionManager.getCurrent().put("smgpassword", password);
        DistributeSessionlessCache loginInfoCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CACHE_REGIONINFO, new DistributeCacheHAPolicy());
        loginInfoCache.put(USERNAME, (Object)username);
        loginInfoCache.put(P, (Object)password);
        this.getView().returnDataToParent((Object)true);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.newAccountFile();
        this.getView().close();
    }
}

