/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.dao.DesignerData;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;

public class ScriptManagerPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String FORM_LIST = "formlist";
    private static final String SCRIPT_NAME = "scriptname";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";

    public void initialize() {
        this.addClickListeners(new String[]{"btn_edit", "btn_add", "btn_delete"});
        ((AbstractGrid)this.getView().getControl(FORM_LIST)).addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        List formList;
        String sql = "select FID,FTYPE, FSCRIPTNAME from t_meta_pluginscript";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        map.put("type", rs.getString(2));
                        map.put(ScriptManagerPlugin.SCRIPT_NAME, rs.getString(3));
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (!formList.isEmpty()) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(FORM_LIST, formList.size());
            int i = 0;
            for (Map form : formList) {
                model.setValue("fid", form.get("id"), i);
                model.setValue("type", form.get("type"), i);
                model.setValue(SCRIPT_NAME, form.get(SCRIPT_NAME), i);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_edit": {
                this.newFormForEdit();
                break;
            }
            case "btn_add": {
                this.newFormForAdd();
                break;
            }
            case "btn_delete": {
                this.deleteItem();
                break;
            }
        }
    }

    private void deleteItem() {
        Map<String, String> sel = this.getCurrentSelector();
        String sql = "delete from t_meta_pluginscript where fid=" + sel.get("fid");
        try {
            DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
                ArrayList list = new ArrayList(10);
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rs.getString(1));
                    map.put("type", rs.getString(2));
                    map.put(SCRIPT_NAME, rs.getString(3));
                    list.add(map);
                }
                return list;
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{MessageFormat.format("error:{0};  sql:{1}", e.getMessage(), sql)});
        }
        this.getView().updateView();
    }

    private void listForm() {
        Map<String, String> sel = this.getCurrentSelector();
        String id = sel.get("id");
        String number = DesignerData.getEntityNumberById(id);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(number);
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void newFormForAdd() {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(IDE_PLUGINSCRIPT);
        parameter.setParentFormId(IDE_PLUGINSCRIPT);
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)parameter);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "newformeditcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private Map<String, String> getCurrentSelector() {
        HashMap<String, String> sel = new HashMap<String, String>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FORM_LIST);
        int row = grid.getEntryState().getFocusRow();
        if (row >= 0) {
            sel.put("fid", (String)this.getModel().getValue("fid", row));
            sel.put("type", (String)this.getModel().getValue("type", row));
            sel.put(SCRIPT_NAME, (String)this.getModel().getValue(SCRIPT_NAME, row));
        }
        return sel;
    }

    private void newFormForEdit() {
        Map<String, String> sel = this.getCurrentSelector();
        String id = sel.get("fid");
        if (id != null && StringUtils.isNotBlank((CharSequence)id)) {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(IDE_PLUGINSCRIPT);
            parameter.setParentFormId(IDE_PLUGINSCRIPT);
            parameter.setPkId((Object)id);
            parameter.setStatus(OperationStatus.EDIT);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "newformeditcallback");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7f16\u8f91\u9879\u3002", (String)"ScriptManagerPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.newFormForEdit();
    }
}

