/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.DesignerMetas;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class XmlDesignerPlugin
extends AbstractFormPlugin {
    public static final String XML_EDIT = "xmledit";
    public static final String XML_TYPE = "xmltype";
    public static final String ENTITY = "entity";
    public static final String METAS = "metas";
    public static final String READONLY = "readonly";
    public static final String BUTTON_UPDATE = "btnupdate";

    public void initialize() {
        Boolean readOnly = (Boolean)this.getView().getFormShowParameter().getCustomParam(READONLY);
        if (readOnly != null && readOnly.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BUTTON_UPDATE});
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        String updatemetaPara;
        CodeEdit codeEdit = (CodeEdit)this.getControl(XML_EDIT);
        codeEdit.setText(this.getFormMetadata());
        this.getPageCache().put(XML_TYPE, "form");
        if (EnvTypeHelper.isProductEnv()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BUTTON_UPDATE});
        }
        if ("true".equals(updatemetaPara = System.getProperty("allowupdatemetadata", "true")) && PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()))) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BUTTON_UPDATE});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BUTTON_UPDATE});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        CodeEdit codeEdit = (CodeEdit)this.getControl(XML_EDIT);
        switch (evt.getItemKey()) {
            case "btnformmeta": {
                if ("form".equals(this.getPageCache().get(XML_TYPE))) break;
                this.postXml();
                codeEdit.setText(this.getFormMetadata());
                this.getPageCache().put(XML_TYPE, "form");
                break;
            }
            case "btnentitymeta": {
                if (ENTITY.equals(this.getPageCache().get(XML_TYPE))) break;
                this.postXml();
                codeEdit.setText(this.getEntityMetadata());
                this.getPageCache().put(XML_TYPE, ENTITY);
                break;
            }
            case "btnupdate": {
                this.getView().returnDataToParent((Object)this.postXml());
                this.getView().close();
                break;
            }
        }
    }

    private DesignerMetas postXml() {
        CodeEdit codeEdit = (CodeEdit)this.getControl(XML_EDIT);
        String xml = codeEdit.getText();
        String strMetas = (String)this.getView().getFormShowParameter().getCustomParam(METAS);
        DesignerMetas metas = DesignerMetas.fromJsonStringToObj((String)strMetas);
        if ("form".equals(this.getPageCache().get(XML_TYPE))) {
            for (AbstractDesignMeta m : metas.getItems()) {
                if (!(m instanceof DesignFormMeta)) continue;
                m.setDataXml(xml);
                break;
            }
        } else if (ENTITY.equals(this.getPageCache().get(XML_TYPE))) {
            for (AbstractDesignMeta m : metas.getItems()) {
                if (!(m instanceof DesignEntityMeta)) continue;
                m.setDataXml(xml);
                break;
            }
        }
        this.getView().getFormShowParameter().setCustomParam(METAS, (Object)metas.toJsonString());
        this.getView().cacheFormShowParameter();
        return metas;
    }

    private String getFormMetadata() {
        String strMetas = (String)this.getView().getFormShowParameter().getCustomParam(METAS);
        if (strMetas == null) {
            return "";
        }
        DesignerMetas metas = DesignerMetas.fromJsonStringToObj((String)strMetas);
        for (AbstractDesignMeta m : metas.getItems()) {
            if (!(m instanceof DesignFormMeta)) continue;
            return m.getDataXml();
        }
        return "";
    }

    private String getEntityMetadata() {
        String strMetas = (String)this.getView().getFormShowParameter().getCustomParam(METAS);
        DesignerMetas metas = DesignerMetas.fromJsonStringToObj((String)strMetas);
        for (AbstractDesignMeta m : metas.getItems()) {
            if (!(m instanceof DesignEntityMeta)) continue;
            return m.getDataXml();
        }
        return "";
    }
}

