/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.baserecordset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import kd.bos.baserecordset.exportandimport.BaseDataSetDao;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.designer.baserecordset.IDataSetOperater;
import kd.bos.designer.baserecordset.SVNUtil;
import kd.bos.designer.dao.OperationInfo;
import kd.bos.designer.dao.SVNKitUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.GroupField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.util.FileUtils;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class AbstractDataSetOperater
implements IDataSetOperater {
    public static final String DATA_PATH_NAME = "PreInsData/PluginJS";
    public static final String SQL_DATA_SUFFIX = "_pre_ins.SQL";
    public static final String FILE_DATA_SUFFIX = "_pre_ins.txt";
    public static final String XML_FILE_SUFFIX = "_pre_ins.xml";
    public static final String XML_FILE_SUFFIX_OLD = "_pre.xml";
    public static final String MAP_TABLE_NAME = "table";
    public static final String LOCAL_FIX_PATH = "";
    public static final String FILE_PREFFIX = "unittest_";
    public static final String PRIVATE_KEY_FIELD = "PrivateKeyField";
    private static final String SVN_PATH = "svnpath";
    private static final String NUMBER = "number";
    private static final String LOCAL_PATH = "localpath";
    private static final String SMGANNO = "smganno";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String LINE_SEPARATOR = "line.separator";
    private static final String FORMAT_STR = "%s%s%s";
    private static final String ERROR = "error";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String UTF_8 = "utf-8";
    private static final String ABSTRACT_DATASET_OPERATER_1 = "AbstractDataSetOperater_1";
    private static final String FORMAT_STR_2 = "%s/xml/%s";
    private String sNumber;
    private DBRoute dbRoute;
    private List<String> ids;
    protected JSONObject svnInfo;

    public AbstractDataSetOperater(String number) {
        this.sNumber = number;
    }

    public AbstractDataSetOperater(String number, JSONObject svnInfo) {
        this.sNumber = number;
        this.svnInfo = svnInfo;
        this.ids = (List)JSONArray.toJavaObject((JSON)this.svnInfo.getJSONArray("ids"), List.class);
    }

    protected String getSqlDataSuffix() {
        Object suf = null;
        if (this.svnInfo != null) {
            suf = this.svnInfo.get((Object)"suffix");
        }
        if (StringUtils.isBlank(suf)) {
            return SQL_DATA_SUFFIX;
        }
        return (String)suf;
    }

    protected String getFileDataSuffix() {
        return FILE_DATA_SUFFIX;
    }

    protected String getLocalFixPath() {
        return LOCAL_FIX_PATH;
    }

    protected String getPreffix() {
        Object pre = null;
        if (this.svnInfo != null) {
            pre = this.svnInfo.get((Object)"preffix");
        }
        if (StringUtils.isBlank(pre)) {
            return FILE_PREFFIX;
        }
        return (String)pre;
    }

    protected String getExportDataPath() {
        return LOCAL_FIX_PATH;
    }

    public static String getSvnRootPath(String number) {
        String bizAppId = BaseDataSetDao.getBizAppIdByFormId((String)number);
        QFilter q = new QFilter("id", "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,svnpath,number";
        ORM orm = ORM.create();
        DynamicObject ds = orm.queryOne("bos_devportal_bizapp", selectFields, filters);
        return ds.getString(SVN_PATH);
    }

    private void toGetGroupTables(EntityItem<?> item, Map<String, Map<String, Object>> mapTables) {
        String sFieldName;
        DbMetadataColumnCollection cols;
        HashMap<String, String> mapFields;
        String tableName = ((GroupField)item).getGroupTableName();
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)DBRoute.basedata.getRouteKey(), (String)tableName);
        if (tableSchema != null) {
            mapFields = new HashMap<String, String>();
            mapTables.put(tableName, mapFields);
            cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if ("FID".equalsIgnoreCase(sFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, LOCAL_FIX_PATH);
            }
        }
        tableName = tableName + "_L";
        tableSchema = AlterTableUtil.getTableSchema((String)DBRoute.basedata.getRouteKey(), (String)tableName);
        if (tableSchema != null) {
            mapFields = new HashMap();
            mapTables.put(tableName, mapFields);
            cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if ("FID".equalsIgnoreCase(sFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, LOCAL_FIX_PATH);
            }
        }
    }

    private void toGetMulLangTable(Entity<?, ?> entity, Map<String, Map<String, Object>> mapTables) {
        String pkFieldName = "FPKID";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        String tableName = entity.getTableName() + "_L";
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)DBRoute.basedata.getRouteKey(), (String)tableName);
        if (null != tableSchema) {
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, mapFields);
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, LOCAL_FIX_PATH);
            }
        }
    }

    private void toGetMulBaseDateTable(Entity<?, ?> entity, List<MulBasedataField> mulBasedataFields, Map<String, Map<String, Object>> mapTables) {
        String pkFieldName = "FPKID";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (MulBasedataField mulBsdfield : mulBasedataFields) {
            String tableName = mulBsdfield.getTableName();
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)DBRoute.basedata.getRouteKey(), (String)tableName);
            if (null == tableSchema) continue;
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, mapFields);
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, LOCAL_FIX_PATH);
            }
        }
    }

    private void toGetEntityTables(EntityMetadata entityMetadata, Entity<?, ?> entity, Map<String, Map<String, Object>> mapTables) {
        List splitTables = entity.getSplitTables();
        if (splitTables == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)entity.getTableName())) {
            return;
        }
        String pkFieldName = "FID";
        if (entity instanceof BillEntity) {
            pkFieldName = ((BillEntity)entity).getPkFieldName();
        } else if (entity instanceof SubEntryEntity) {
            EntryEntity parentEntry = entityMetadata.getEntryById(((SubEntryEntity)entity).getParentId());
            pkFieldName = parentEntry.getEntryPkFieldName();
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            pkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        }
        ArrayList<String> suffixList = new ArrayList<String>();
        String suffix = null;
        for (SplitTable s : splitTables) {
            suffix = s.getSuffix();
            if (suffix == null || !StringUtils.isNotEmpty((CharSequence)suffix)) continue;
            suffixList.add(suffix);
        }
        ArrayList<String> tableNameSuffix = new ArrayList<String>();
        tableNameSuffix.add(LOCAL_FIX_PATH);
        tableNameSuffix.addAll(suffixList);
        ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>();
        ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>();
        for (String t_suffix : tableNameSuffix) {
            DbMetadataTable tableSchema;
            String tableName = entity.getTableName();
            if (StringUtils.isNotBlank((CharSequence)t_suffix)) {
                tableName = String.format("%s_%s", tableName, t_suffix);
            }
            if ((tableSchema = AlterTableUtil.getTableSchema((String)DBRoute.basedata.getRouteKey(), (String)tableName)) == null) break;
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, mapFields);
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName.toUpperCase(), PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName.toUpperCase(), LOCAL_FIX_PATH);
            }
            List entityItem = entity.getItems();
            for (EntityItem item : entityItem) {
                String sFieldName;
                if (!(item instanceof Field)) continue;
                if (item instanceof MuliLangTextField) {
                    mulLangFields.add((MuliLangTextField)(item instanceof MuliLangTextField ? item : null));
                    continue;
                }
                if (item instanceof MulBasedataField) {
                    mulBDFields.add((MulBasedataField)(item instanceof MulBasedataField ? item : null));
                    continue;
                }
                Field itemField = (Field)item;
                if (!itemField.getTableName(entity).equalsIgnoreCase(tableName) || !StringUtils.isNotBlank((CharSequence)(sFieldName = itemField.getFieldName()))) continue;
                mapFields.put(itemField.getFieldName().toUpperCase(), item.getClass().getSimpleName());
            }
            if (!mulLangFields.isEmpty() && tableName.equalsIgnoreCase(entity.getTableName())) {
                this.toGetMulLangTable(entity, mapTables);
            }
            if (!mulBDFields.isEmpty() && tableName.equalsIgnoreCase(entity.getTableName())) {
                this.toGetMulBaseDateTable(entity, mulBDFields, mapTables);
            }
            mulLangFields.clear();
            mulBDFields.clear();
        }
    }

    private Map<String, Map<String, Object>> getTableInfo(String number) {
        HashMap<String, Map<String, Object>> tableFieldMap = new HashMap<String, Map<String, Object>>();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String entityid = formMeta.getEntityId();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityid, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return tableFieldMap;
        }
        String dbRoueKey = entityMetadata.getRootEntity().buildDataEntityType().getDBRouteKey();
        this.dbRoute = new DBRoute(dbRoueKey);
        if (!(entityMetadata.getRootEntity() instanceof BillEntity)) {
            return tableFieldMap;
        }
        List entityList = entityMetadata.getEntitys();
        for (Entity entity : entityList) {
            this.toGetEntityTables(entityMetadata, entity, tableFieldMap);
            if (!(entity instanceof MainEntity)) continue;
            for (EntityItem item : entity.getItems()) {
                if (!(item instanceof GroupField)) continue;
                this.toGetGroupTables(item, tableFieldMap);
            }
        }
        return tableFieldMap;
    }

    protected String getPrimaryKey() {
        return "FID";
    }

    public String getNumber() {
        return this.sNumber;
    }

    protected List<String> getFields() {
        return new ArrayList<String>();
    }

    protected List<String> getFileFields() {
        return new ArrayList<String>();
    }

    protected String getItemNumberField() {
        return "FNUMBER";
    }

    protected JSONObject getSvnMapInfo() {
        JSONObject tempSvnInfo = new JSONObject();
        String number = this.getNumber();
        String bizAppId = BaseDataSetDao.getBizAppIdByFormId((String)number);
        QFilter q = new QFilter("id", "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,svnpath,number";
        ORM orm = ORM.create();
        DynamicObject ds = orm.queryOne("bos_devportal_bizapp", selectFields, filters);
        tempSvnInfo.put(SVN_PATH, (Object)ds.getString(SVN_PATH));
        String appNumber = ds.getString(NUMBER);
        String property = System.getProperty("user.home");
        String localPath = property + File.separator + "metadata" + File.separator + appNumber;
        tempSvnInfo.put(LOCAL_PATH, (Object)localPath);
        String username = SessionManager.getCurrent().get("smgusername");
        String password = SessionManager.getCurrent().get("smgpassword");
        String annotation = SessionManager.getCurrent().get(SMGANNO);
        tempSvnInfo.put(USERNAME, (Object)username);
        tempSvnInfo.put(P, (Object)password);
        tempSvnInfo.put(SMGANNO, (Object)annotation);
        return tempSvnInfo;
    }

    private void getOneTableSetSqlAndContext(String tableName, Map<String, Object> tableFields, Map<String, Object> mapContext) {
        ArrayList<String> lstFields = new ArrayList<String>(10);
        ArrayList<String> lstFileFields = new ArrayList<String>(10);
        String sPKey = "FID";
        for (Map.Entry<String, Object> feildName : tableFields.entrySet()) {
            if (feildName.getValue().equals(PRIVATE_KEY_FIELD)) {
                sPKey = feildName.getKey();
            }
            lstFields.add(feildName.getKey());
            if (!"LargeTextField".equals(feildName.getValue())) continue;
            lstFields.add(feildName.getKey() + "_tag");
            lstFileFields.add(feildName.getKey() + "_tag");
        }
        List lstItems = BaseDataSetDao.getAllItems((DBRoute)this.dbRoute, (String)tableName, lstFields);
        StringBuilder sbSql = new StringBuilder();
        Object obSql = mapContext.get("sql");
        if (obSql != null) {
            sbSql.append(obSql.toString());
        }
        List lstMapExpData = new ArrayList();
        Object obExp = mapContext.get("exp");
        if (obExp != null) {
            lstMapExpData = (List)SerializationUtils.fromJsonString((String)obExp.toString(), List.class);
        }
        for (Object item : lstItems) {
            Map mapItem = (Map)item;
            StringBuilder sqlFields = new StringBuilder();
            StringBuilder sqlFieldValues = new StringBuilder();
            HashMap mapExpData = new HashMap();
            for (int i = 0; i < lstFields.size(); ++i) {
                String sTempField = (String)lstFields.get(i);
                Object obItemValue = mapItem.get(sTempField);
                String sTempValue = obItemValue == null ? LOCAL_FIX_PATH : obItemValue.toString();
                if (lstFileFields.contains(sTempField)) {
                    mapExpData.put(sPKey, mapItem.get(sPKey));
                    mapExpData.put(sTempField, mapItem.get(sTempField));
                    mapExpData.put(MAP_TABLE_NAME, tableName);
                    continue;
                }
                sqlFields.append(String.format(" %s,", lstFields.get(i)));
                sqlFieldValues.append(String.format(" '%s',", sTempValue));
            }
            if (!lstFileFields.isEmpty()) {
                lstMapExpData.add(mapExpData);
            }
            sqlFields.deleteCharAt(sqlFields.length() - 1);
            sqlFieldValues.deleteCharAt(sqlFieldValues.length() - 1);
            sbSql.append(String.format("insert into %s (%s) values (%s);", tableName, sqlFields.toString(), sqlFieldValues.toString()));
            sbSql.append(System.getProperty(LINE_SEPARATOR));
        }
        mapContext.put("sql", sbSql.toString());
        mapContext.put("exp", SerializationUtils.toJsonString(lstMapExpData));
    }

    private void getOneTableSetSqlAndContextWithIds(String tableName, Map<String, Object> tableFields, Map<String, Object> mapContext, List<String> ids) {
        ArrayList<String> lstFields = new ArrayList<String>(10);
        ArrayList<String> lstFileFields = new ArrayList<String>(10);
        String sPKey = "FID";
        HashMap xmlMap = new HashMap();
        for (Map.Entry<String, Object> feildName : tableFields.entrySet()) {
            if (feildName.getValue().equals(PRIVATE_KEY_FIELD)) {
                sPKey = feildName.getKey();
            }
            lstFields.add(feildName.getKey());
            if (!"LargeTextField".equals(feildName.getValue())) continue;
            lstFields.add(feildName.getKey() + "_tag");
            lstFileFields.add(feildName.getKey() + "_tag");
        }
        List lstItems = BaseDataSetDao.getItemsByIds((DBRoute)this.dbRoute, (String)tableName, lstFields, ids, (String)"FID");
        Object obNumber = mapContext.get(NUMBER);
        if (obNumber == null && !lstItems.isEmpty()) {
            Map mapItem = (Map)lstItems.get(0);
            obNumber = mapItem.get(this.getItemNumberField());
        }
        StringBuilder sbSql = new StringBuilder();
        Object obSql = mapContext.get("sql");
        if (obSql != null) {
            sbSql.append(obSql.toString());
        }
        List lstMapExpData = new ArrayList();
        Object obExp = mapContext.get("exp");
        if (obExp != null) {
            lstMapExpData = (List)SerializationUtils.fromJsonString((String)obExp.toString(), List.class);
        }
        for (Object item : lstItems) {
            Map mapItem = (Map)item;
            String sPKeyValue = (String)mapItem.get(sPKey);
            StringBuilder sqlFields = new StringBuilder();
            StringBuilder sqlFieldValues = new StringBuilder();
            HashMap mapExpData = new HashMap();
            for (int i = 0; i < lstFields.size(); ++i) {
                if ("fjmxcontext".equalsIgnoreCase((String)lstFields.get(i)) || "FDATASOURCECONTENT".equalsIgnoreCase((String)lstFields.get(i)) || "t_bas_unittestdetail_A".equals(tableName) && "fid".equalsIgnoreCase((String)lstFields.get(i))) continue;
                String sTempField = (String)lstFields.get(i);
                Object obItemValue = mapItem.get(sTempField);
                String sTempValue = obItemValue == null ? LOCAL_FIX_PATH : obItemValue.toString();
                if (lstFileFields.contains(sTempField)) {
                    mapExpData.put(sPKey, mapItem.get(sPKey));
                    mapExpData.put(sTempField, mapItem.get(sTempField));
                    mapExpData.put(MAP_TABLE_NAME, tableName);
                    continue;
                }
                sqlFields.append(String.format(" %s,", lstFields.get(i)));
                if (sTempValue.isEmpty()) {
                    sqlFieldValues.append(" ' ',");
                    continue;
                }
                sqlFieldValues.append(String.format(" '%s',", sTempValue));
            }
            if (!lstFileFields.isEmpty()) {
                lstMapExpData.add(mapExpData);
            }
            sqlFields.deleteCharAt(sqlFields.length() - 1);
            sqlFieldValues.deleteCharAt(sqlFieldValues.length() - 1);
            if ("t_bas_unittestdetail_A".equals(tableName)) {
                PreInsDataScriptBuilder preInsDataBuilder = new PreInsDataScriptBuilder();
                Map tempMap = preInsDataBuilder.genInsertSQLScript(DBRoute.basedata, tableName, "FJMXCONTEXT,FDATASOURCECONTENT,FJMXLOCATION,FPREPAREINDEX,FDATASOURCENAME", "fid='" + sPKeyValue + "'", " ", " ");
                if (tempMap.get("xml") instanceof Map) {
                    xmlMap.putAll((Map)tempMap.get("xml"));
                }
                if (tempMap.get("sql") == null) continue;
                sbSql.append(tempMap.get("sql"));
                continue;
            }
            String lineSeperator = System.getProperty(LINE_SEPARATOR);
            sbSql.append(String.format("delete from %s where %s = '%s';", tableName, sPKey, sPKeyValue));
            sbSql.append(lineSeperator);
            sbSql.append(String.format("insert into %s (%s) values (%s);", tableName, sqlFields.toString(), sqlFieldValues.toString()));
            sbSql.append(lineSeperator);
        }
        mapContext.put("sql", sbSql.toString());
        mapContext.put("exp", SerializationUtils.toJsonString(lstMapExpData));
        mapContext.put(NUMBER, obNumber);
        mapContext.put("xml", xmlMap);
    }

    private void splitStringByLength(String content, StringBuilder sbSql, String sPkey) {
        String mess = "update t_bas_unittestdetail_a set FJMXCONTEXT = concat(FJMXCONTEXT,'%s') where fid= '%s';";
        String mess2 = "update t_bas_unittestdetail_a set FJMXCONTEXT = concat(FJMXCONTEXT,'%s) where fid= '%s';";
        String lineSeperator = System.getProperty(LINE_SEPARATOR);
        if (content.length() >= 4000) {
            String left = content.substring(3999, content.length());
            String update1 = content.substring(0, 999);
            String update2 = content.substring(999, 1999);
            String update3 = content.substring(1999, 2999);
            String update4 = content.substring(2999, 3999);
            sbSql.append(String.format(mess, update1, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess, update2, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess, update3, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess, update4, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            sbSql.append(lineSeperator);
            this.splitStringByLength(left, sbSql, sPkey);
        } else if (content.length() <= 999) {
            String update1 = content.substring(0, content.length());
            sbSql.append(String.format(mess2, update1, sPkey));
            sbSql.append(lineSeperator);
        } else if (content.length() >= 999 && content.length() < 1999) {
            String update1 = content.substring(0, 999);
            String update2 = content.substring(999, content.length());
            sbSql.append(String.format(mess, update1, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess2, update2, sPkey));
            sbSql.append(lineSeperator);
        } else if (content.length() >= 1999 && content.length() < 2999) {
            String update1 = content.substring(0, 999);
            String update2 = content.substring(999, 1999);
            String update3 = content.substring(1999, content.length());
            sbSql.append(String.format(mess, update1, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess, update2, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess2, update3, sPkey));
            sbSql.append(lineSeperator);
        } else if (content.length() >= 2999) {
            String update1 = content.substring(0, 999);
            String update2 = content.substring(999, 1999);
            String update3 = content.substring(1999, 2999);
            String update4 = content.substring(2999, content.length());
            sbSql.append(String.format(mess, update1, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess, update2, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess, update3, sPkey));
            sbSql.append(lineSeperator);
            sbSql.append(String.format(mess2, update4, sPkey));
            sbSql.append(lineSeperator);
        }
    }

    protected Map<String, Object> getExpDataSetSql() {
        HashMap<String, Object> mapRet = new HashMap<String, Object>();
        Map<String, Map<String, Object>> tableFieldMap = this.getTableInfo(this.getNumber());
        for (Map.Entry<String, Map<String, Object>> tableName : tableFieldMap.entrySet()) {
            this.getOneTableSetSqlAndContext(tableName.getKey(), tableName.getValue(), mapRet);
        }
        return mapRet;
    }

    public List<Map<String, Object>> getExpDataSetSqlWithIds(List<String> ids) {
        ArrayList<Map<String, Object>> lstMapRet = new ArrayList<Map<String, Object>>(10);
        Map<String, Map<String, Object>> tableFieldMap = this.getTableInfo(this.getNumber());
        for (String id : ids) {
            HashMap<String, Object> mapRet = new HashMap<String, Object>();
            ArrayList<String> lstQueryIds = new ArrayList<String>();
            lstQueryIds.add(id);
            for (Map.Entry<String, Map<String, Object>> tableName : tableFieldMap.entrySet()) {
                this.getOneTableSetSqlAndContextWithIds(tableName.getKey(), tableName.getValue(), mapRet, lstQueryIds);
            }
            lstMapRet.add(mapRet);
        }
        return lstMapRet;
    }

    private String getDbSchemaPath(String prePath, String filename) {
        return prePath + File.separator + filename;
    }

    protected void saveFile(String doc, String filename, OperationInfo operationInfo, String prePath) {
        String fullPath = this.getDbSchemaPath(prePath, filename);
        String[] abovePath = fullPath.split(filename);
        File fileAbovePath = new File(FileUtils.cleanString((String)abovePath[0]));
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        File file = new File(FileUtils.cleanString((String)fullPath));
        try (FileOutputStream out = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            if (file.exists() || file.createNewFile()) {
                writer.write(doc);
                operationInfo.addFilePath(fullPath);
            }
        }
        catch (IOException e) {
            operationInfo.addErrorMessage(e.getMessage());
        }
    }

    protected String getSqlFileName(String filenamemain) {
        return String.format(FORMAT_STR, this.getPreffix(), filenamemain, this.getSqlDataSuffix());
    }

    protected String getExpFileName(String filenamemain) {
        return String.format(FORMAT_STR, this.getPreffix(), filenamemain, this.getFileDataSuffix());
    }

    protected String getXmlFileName(String filenamemain) {
        return String.format(FORMAT_STR, this.getPreffix(), filenamemain, XML_FILE_SUFFIX);
    }

    protected String getXmlFileNameOld(String filenamemain) {
        return String.format(FORMAT_STR, this.getPreffix(), filenamemain, XML_FILE_SUFFIX_OLD);
    }

    protected OperationInfo expDataSet(String prePath) {
        OperationInfo operationInfo = new OperationInfo();
        Map<String, Object> map = this.getExpDataSetSql();
        if (map.isEmpty()) {
            return null;
        }
        String sqlFileName = this.getSqlFileName(this.getNumber());
        String sql = (String)map.get("sql");
        this.saveFile(sql, sqlFileName, operationInfo, prePath);
        String sExpFileName = this.getExpFileName(this.getNumber());
        String sExp = map.get("exp").toString();
        this.saveFile(sExp, sExpFileName, operationInfo, prePath);
        return operationInfo;
    }

    protected OperationInfo expDataSetWithIds(String prePath, List<String> ids) {
        OperationInfo operationInfo = new OperationInfo();
        List<Map<String, Object>> lstMap = this.getExpDataSetSqlWithIds(ids);
        if (lstMap.isEmpty()) {
            return null;
        }
        for (Map<String, Object> map : lstMap) {
            String fileNameMain = LOCAL_FIX_PATH;
            if (map.get(NUMBER) != null) {
                fileNameMain = map.get(NUMBER).toString();
            }
            String sqlFileName = this.getSqlFileName(fileNameMain);
            String sql = (String)map.get("sql");
            this.saveFile(sql, sqlFileName, operationInfo, prePath);
            String sExpFileName = this.getExpFileName(fileNameMain);
            String sExp = map.get("exp").toString();
            this.saveXml(operationInfo, (Map)map.get("xml"), prePath, fileNameMain);
            if (sExp.isEmpty() || "[]".equals(sExp)) continue;
            this.saveFile(sExp, sExpFileName, operationInfo, prePath);
        }
        return operationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXml(OperationInfo operationInfo, Map<String, Object> data, String prePath, String number) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            boolean isCreated;
            String fileName = FILE_PREFFIX + number + XML_FILE_SUFFIX;
            String fullPath = this.getDbSchemaPath(prePath + File.separator + "xml", fileName);
            String[] abovePath = fullPath.split(fileName);
            String xmlDirectory = abovePath[0];
            File fileAbovePath = new File(FileUtils.cleanString((String)xmlDirectory));
            if (!fileAbovePath.exists() && !(isCreated = fileAbovePath.mkdirs())) {
                operationInfo.addErrorMessage("create directory failed");
            }
            XMLWriter xmlWriter = null;
            try {
                FileWriter fileWriter = new FileWriter(fullPath);
                Throwable throwable = null;
                try {
                    StringWriter docWriter = (StringWriter)entry.getValue();
                    Document document = SAXReaderUtil.parseText((String)docWriter.toString());
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setEncoding(UTF_8);
                    xmlWriter = new XMLWriter((Writer)fileWriter);
                    xmlWriter.write(document);
                    operationInfo.addFilePath(fullPath);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileWriter == null) continue;
                    if (throwable != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileWriter.close();
                }
            }
            catch (Exception e) {
                operationInfo.addErrorMessage(e.getMessage());
            }
            finally {
                try {
                    if (xmlWriter == null) continue;
                    xmlWriter.close();
                }
                catch (Exception e2) {
                    operationInfo.addErrorMessage(e2.getMessage());
                }
            }
        }
    }

    @Override
    public JSONObject expBaseData(String path) {
        JSONObject jsonRet = new JSONObject();
        ArrayList<String> fileList = new ArrayList<String>();
        ArrayList<String> messageList = new ArrayList<String>();
        OperationInfo operationInfo = null;
        operationInfo = this.ids == null || this.ids.isEmpty() ? this.expDataSet(path) : this.expDataSetWithIds(path, this.ids);
        if (operationInfo != null) {
            messageList.addAll(operationInfo.getErrorMessage());
            fileList.addAll(operationInfo.getFilePath());
        }
        String filePathString = StringUtils.join((Object[])fileList.toArray(new String[0]), (String)"\r\n");
        String errorMessageString = StringUtils.join((Object[])messageList.toArray(new String[0]), (String)"\r\n");
        if (!messageList.isEmpty()) {
            jsonRet.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u5bfc\u51fa\u6210\u529f\u6709\u6587\u4ef6\u6709\uff1a%1$s\uff0c\r\n\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a%2$s\u3002", (String)"AbstractDataSetOperater_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), filePathString, errorMessageString));
        }
        jsonRet.put("flist", fileList);
        return jsonRet;
    }

    private void setExpSql(String fileName, List<SqlObject> list) {
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 InputStreamReader read = new InputStreamReader((InputStream)fileInputStream, UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(read);){
                StringBuilder expData = new StringBuilder();
                String sLine = null;
                while ((sLine = bufferedReader.readLine()) != null) {
                    expData.append(System.lineSeparator()).append(sLine);
                }
                List lstMapExpData = (List)SerializationUtils.fromJsonString((String)expData.toString(), List.class);
                for (Map mapItem : lstMapExpData) {
                    kd.bos.dataentity.SqlParameter[] params = new kd.bos.dataentity.SqlParameter[mapItem.size() - 1];
                    String pkFieldName = (String)mapItem.entrySet().iterator().next().getKey();
                    params[mapItem.size() - 2] = new kd.bos.dataentity.SqlParameter(":" + pkFieldName, 12, mapItem.get(pkFieldName));
                    int i = 0;
                    StringBuilder sqlFields = new StringBuilder();
                    for (Map.Entry kv : mapItem.entrySet()) {
                        if (((String)kv.getKey()).equalsIgnoreCase(pkFieldName) || ((String)kv.getKey()).equalsIgnoreCase(MAP_TABLE_NAME)) continue;
                        params[i] = new kd.bos.dataentity.SqlParameter(":" + (String)kv.getKey(), 12, kv.getValue());
                        sqlFields.append(String.format(" %s = ?", kv.getKey()));
                        ++i;
                    }
                    String sql = String.format("update %s set %s where %s = ? ", mapItem.get(MAP_TABLE_NAME), sqlFields, this.getPrimaryKey());
                    if (!StringUtils.isNotEmpty((CharSequence)sql)) continue;
                    list.add(new SqlObject(sql, (SqlParameter[])params));
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"AbstractDataSetOperater_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)ABSTRACT_DATASET_OPERATER_1, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage())});
            }
        }
    }

    @Override
    public JSONObject impBaseData(String number, String path) {
        JSONObject mapRet = new JSONObject();
        ArrayList<SqlObject> lstSQL = new ArrayList<SqlObject>();
        ArrayList<String> lstXML = new ArrayList<String>();
        File file = new File(path);
        if (file.exists()) {
            if (file.isFile()) {
                this.collectExecuteFile(file, lstSQL, lstXML, mapRet);
            } else {
                File[] files = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && (pathname.getName().endsWith(".sql") || pathname.getName().endsWith(".SQL") || pathname.getName().endsWith(".xml") || pathname.getName().endsWith(".XML"));
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    this.collectExecuteFile(files[i], lstSQL, lstXML, mapRet);
                }
            }
        } else {
            mapRet.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c%s\u4e0d\u5b58\u5728\u3002", (String)"AbstractDataSetOperater_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), path));
            return mapRet;
        }
        MetadataReader mreader = new MetadataReader(false);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String entityid = formMeta.getEntityId();
        EntityMetadata entityMetadata = (EntityMetadata)mreader.readEntityMetaByFormId(entityid);
        String dbRoueKey = entityMetadata.getRootEntity().buildDataEntityType().getDBRouteKey();
        this.dbRoute = new DBRoute(dbRoueKey);
        for (SqlObject sqlObject : lstSQL) {
            try {
                DB.execute((DBRoute)this.dbRoute, (String)sqlObject.getSql(), (Object[])sqlObject.getParams());
            }
            catch (Exception e) {
                if (e.getMessage().contains("Duplicate entry")) continue;
                mapRet.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5185\u5bb9\u4e0d\u5408\u6cd5\uff1a%s\u3002", (String)"AbstractDataSetOperater_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                return mapRet;
            }
        }
        PreInsDataScriptWriter write = new PreInsDataScriptWriter();
        for (String content : lstXML) {
            try {
                write.insertPreInsData(content);
            }
            catch (JAXBException e) {
                mapRet.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5185\u5bb9\u4e0d\u5408\u6cd5\uff1a%s\u3002", (String)"AbstractDataSetOperater_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                return mapRet;
            }
        }
        return mapRet;
    }

    private void collectExecuteFile(File file, List<SqlObject> lstSQL, List<String> lstXML, JSONObject mapRet) {
        String filename = file.getName();
        if (filename.endsWith(".sql") || filename.endsWith(".SQL")) {
            this.collectSqlFromFile(file, lstSQL, mapRet);
        } else if (filename.endsWith(".xml") || filename.endsWith(".XML")) {
            this.collectXmlFromFile(file, lstXML, mapRet);
        }
    }

    private void collectXmlFromFile(File file, List<String> list, JSONObject mapRet) {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader read = new InputStreamReader((InputStream)fileInputStream, UTF_8);
             BufferedReader bufferedReader = new BufferedReader(read);){
            String xml = null;
            StringBuilder xmlBuffer = new StringBuilder();
            while ((xml = bufferedReader.readLine()) != null) {
                xmlBuffer.append(xml);
            }
            list.add(xmlBuffer.toString());
        }
        catch (IOException e) {
            mapRet.put(ERROR, (Object)String.format(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"AbstractDataSetOperater_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)ABSTRACT_DATASET_OPERATER_1, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void collectSqlFromFile(File file, List<SqlObject> list, JSONObject mapRet) {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader read = new InputStreamReader((InputStream)fileInputStream, UTF_8);
             BufferedReader bufferedReader = new BufferedReader(read);){
            String sql = null;
            while ((sql = bufferedReader.readLine()) != null) {
                list.add(new SqlObject(sql, null));
            }
        }
        catch (IOException e) {
            mapRet.put(ERROR, (Object)String.format(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"AbstractDataSetOperater_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)ABSTRACT_DATASET_OPERATER_1, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private Map<String, String> getFolderMap(String preLocalPath, String preSvnPath) {
        HashMap<String, String> folderMap = new HashMap<String, String>();
        folderMap.put(preLocalPath + "\\DbSchema", preSvnPath + "/DbSchema");
        return folderMap;
    }

    private List<String> getFileNames(String fNumber) {
        ArrayList<String> fileList = new ArrayList<String>();
        String sqlFileName = this.getSqlFileName(fNumber);
        String expFileName = this.getExpFileName(fNumber);
        fileList.add(sqlFileName);
        fileList.add(expFileName);
        return fileList;
    }

    private Map<String, String> getSVNFileMap(String prePath, String fNumber) {
        HashMap<String, String> filePathMap = new HashMap<String, String>(16);
        ArrayList<String> fileList = new ArrayList<String>(10);
        fileList.addAll(this.getFileNames(fNumber));
        for (String fileName : fileList) {
            filePathMap.put(this.getDbSchemaPath(prePath, fileName), this.getDbSchemaPath(prePath, fileName));
        }
        return filePathMap;
    }

    public void checkOutFiles(JSONObject svnInfo, OperationInfo operationInfo) {
        String svnRoot;
        String username = svnInfo.getString(USERNAME);
        String password = svnInfo.getString(P);
        String localpath = svnInfo.getString(LOCAL_PATH);
        String svnpath = svnInfo.getString(SVN_PATH);
        Map<String, String> folderMap = this.getFolderMap(localpath, svnpath);
        for (Map.Entry<String, String> fileName : folderMap.entrySet()) {
            SVNClientManager clientManager = SVNKitUtil.getClientManager(fileName.getValue(), username, password);
            SVNKitUtil.checkRootFolder(fileName.getKey(), fileName.getValue(), clientManager, operationInfo);
        }
        Map<String, String> fileMap = this.getSVNFileMap(localpath + this.getLocalFixPath(), this.getNumber());
        ArrayList<File> files = new ArrayList<File>(10);
        for (String fileName : fileMap.keySet()) {
            File file = new File(fileName);
            if (!file.exists()) {
                operationInfo.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"AbstractDataSetOperater_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), fileName));
                continue;
            }
            files.add(file);
        }
        if (!files.isEmpty() && !StringUtils.isEmpty((CharSequence)(svnRoot = folderMap.get(((File)files.get(0)).getParent().replace("\\", "/"))))) {
            SVNClientManager clientManager = SVNKitUtil.getClientManager(svnRoot, username, password);
            SVNKitUtil.update(files.toArray(new File[0]), SVNRevision.HEAD, SVNDepth.INFINITY, clientManager);
        }
    }

    public OperationInfo commitToSVN(List<String> urlList, JSONObject svnInfo) {
        OperationInfo operationInfo = new OperationInfo();
        ArrayList<File> files = new ArrayList<File>(10);
        for (String url : urlList) {
            File file = new File(url);
            files.add(file);
        }
        String parentPath = ((File)files.get(0)).getParent();
        Map<String, String> folderMap = this.getFolderMap(svnInfo.getString(LOCAL_PATH), svnInfo.getString(SVN_PATH));
        String svnPath = folderMap.get(parentPath);
        SVNClientManager clientManager = SVNKitUtil.getClientManager(svnPath, svnInfo.getString(USERNAME), svnInfo.getString(P));
        File[] filetocommit = files.toArray(new File[0]);
        String svnMessage = svnInfo.getString(SMGANNO);
        SVNKitUtil.commit(clientManager, filetocommit, svnMessage, operationInfo);
        return operationInfo;
    }

    @Override
    public JSONObject commitBaseDataToSvn() {
        return this.commitBaseDataToSvnBySvnInfo(this.svnInfo);
    }

    private JSONObject commitBaseDataToSvnBySvnInfo(JSONObject svnInfo) {
        JSONObject jsonRet = new JSONObject();
        String svnPath = svnInfo.getString(SVN_PATH);
        String localPath = svnInfo.getString(LOCAL_PATH);
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            jsonRet.put(ERROR, (Object)ResManager.loadKDString((String)"\u8868\u5355\u6240\u5c5e\u5e94\u7528\u7684SVN\u8def\u5f84\u4e0d\u5b58\u5728\u3002", (String)"AbstractDataSetOperater_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return jsonRet;
        }
        SVNUtil svnUtil = new SVNUtil();
        svnUtil.checkOutFiles(svnInfo, jsonRet);
        if (jsonRet.get((Object)ERROR) != null) {
            return jsonRet;
        }
        String expPath = localPath + this.getExportDataPath();
        jsonRet = this.expBaseData(expPath);
        if (jsonRet.get((Object)ERROR) != null) {
            return jsonRet;
        }
        List filePathList = (List)jsonRet.get((Object)"flist");
        if (filePathList.isEmpty()) {
            jsonRet.put(ERROR, (Object)ResManager.loadKDString((String)"\u7b7e\u5165\u5931\u8d25\uff0c\u6ca1\u6709\u6b63\u786e\u5bfc\u51fa\u9700\u8981\u7b7e\u5165\u7684\u672c\u5730\u6587\u4ef6\u3002", (String)"AbstractDataSetOperater_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return jsonRet;
        }
        jsonRet = svnUtil.commitToSVN(filePathList, svnInfo);
        if (jsonRet.get((Object)ERROR) == null) {
            HashMap<String, String> mapSqlAndXml = new HashMap<String, String>();
            HashSet<String> delFiles = new HashSet<String>();
            for (String filePath : filePathList) {
                String value;
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf("."));
                if (filePath.endsWith(".SQL")) {
                    mapSqlAndXml.put(fileName, null);
                    String xmlName = fileName + ".xml";
                    String xmlNameOld = xmlName.replace(XML_FILE_SUFFIX, XML_FILE_SUFFIX_OLD);
                    delFiles.add(String.format(FORMAT_STR_2, svnPath, xmlNameOld));
                    continue;
                }
                if (!filePath.endsWith(".xml") || (value = (String)mapSqlAndXml.get(filePath)) != null) continue;
                mapSqlAndXml.put(fileName, filePath);
                String xmlName = fileName + ".xml";
                String xmlNameOld = xmlName.replace(XML_FILE_SUFFIX, XML_FILE_SUFFIX_OLD);
                delFiles.add(String.format(FORMAT_STR_2, svnPath, xmlNameOld));
            }
            this.deleteFilesFromSvn(svnInfo, delFiles);
        }
        return jsonRet;
    }

    @Override
    public JSONObject expBaseDataWithIds(String path, JSONArray ids) {
        return null;
    }

    @Override
    public JSONObject commitBaseDataToSvnWithIds(JSONArray ids) {
        return this.commitBaseDataToSvn();
    }

    @Override
    public JSONObject deleteBaseDataFromSvnWithIds() {
        return this.deleteFromSvn(this.svnInfo, this.ids);
    }

    public JSONObject deleteFromSvn(JSONObject svnMsg, List<String> sIds) {
        SVNUtil svnUtil = new SVNUtil();
        String svnPath = svnMsg.getString(SVN_PATH);
        String username = svnMsg.getString(USERNAME);
        String password = svnMsg.getString(P);
        String annotation = svnMsg.getString("annotation");
        svnUtil.setupLibrary();
        SVNRepository repository = null;
        SVNURL repositoryURL = null;
        JSONObject commitSVNMsg = new JSONObject();
        ArrayList<String> list = new ArrayList<String>(3);
        for (int i = 0; i < sIds.size(); ++i) {
            String sId = sIds.get(i);
            svnUtil.getClientManager(svnPath, svnMsg, commitSVNMsg);
            try {
                password = Encrypters.decode((String)password);
                repositoryURL = SVNURL.parseURIEncoded((String)svnPath);
                repository = SVNRepositoryFactory.create((SVNURL)repositoryURL);
                BasicAuthenticationManager authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(username, password, false, repositoryURL, false)});
                repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
            }
            catch (Exception e1) {
                commitSVNMsg.put(ERROR, (Object)e1.toString());
            }
            list.add(String.format("%s/%s", svnPath, this.getSqlFileName(this.getNumberById(sId))));
            list.add(String.format(FORMAT_STR_2, svnPath, this.getXmlFileName(this.getNumberById(sId))));
            list.add(String.format(FORMAT_STR_2, svnPath, this.getXmlFileNameOld(this.getNumberById(sId))));
            boolean index = false;
            for (int j = 0; j < list.size(); ++j) {
                String svnUrl = (String)list.get(j);
                try {
                    String root;
                    String concreteRoot;
                    SVNNodeKind nodeKind;
                    if (repository == null || (nodeKind = repository.checkPath(concreteRoot = svnUrl.split(root = String.valueOf(repository.getRepositoryRoot(true)))[1], -1L)) != SVNNodeKind.NONE) continue;
                    list.remove(j);
                    --j;
                    continue;
                }
                catch (Exception e) {
                    commitSVNMsg.put(ERROR, (Object)e.toString());
                }
            }
            SVNURL[] deleteUrls = new SVNURL[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                String svnUrl = (String)list.get(j);
                try {
                    SVNURL repositoryOptUrl;
                    deleteUrls[j] = repositoryOptUrl = SVNURL.parseURIEncoded((String)svnUrl);
                    continue;
                }
                catch (Exception e) {
                    commitSVNMsg.put(ERROR, (Object)e.toString());
                }
            }
            try {
                if (deleteUrls.length > 0) {
                    SVNUtil.getClientManager().getCommitClient().doDelete(deleteUrls, annotation);
                }
                commitSVNMsg.put(ERROR, null);
            }
            catch (SVNException e) {
                commitSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u6821\u9a8c\u7528\u6237\u540d\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"AbstractDataSetOperater_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            list.clear();
        }
        return commitSVNMsg;
    }

    private JSONObject deleteFilesFromSvn(JSONObject svnMsg, Set<String> files) {
        SVNUtil svnUtil = new SVNUtil();
        String svnPath = svnMsg.getString(SVN_PATH);
        String username = svnMsg.getString(USERNAME);
        String password = svnMsg.getString(P);
        String annotation = svnMsg.getString("annotation");
        svnUtil.setupLibrary();
        SVNRepository repository = null;
        SVNURL repositoryURL = null;
        JSONObject commitSVNMsg = new JSONObject();
        svnUtil.getClientManager(svnPath, svnMsg, commitSVNMsg);
        try {
            password = Encrypters.decode((String)password);
            repositoryURL = SVNURL.parseURIEncoded((String)svnPath);
            repository = SVNRepositoryFactory.create((SVNURL)repositoryURL);
            BasicAuthenticationManager authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(username, password, false, repositoryURL, false)});
            repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        }
        catch (Exception e1) {
            commitSVNMsg.put(ERROR, (Object)e1.toString());
        }
        Iterator<String> it = files.iterator();
        while (it.hasNext()) {
            String svnUrl = it.next();
            try {
                String root;
                Object concreteRoot;
                SVNNodeKind nodeKind;
                if (repository == null || (nodeKind = repository.checkPath((String)(concreteRoot = svnUrl.split(root = String.valueOf(repository.getRepositoryRoot(true)))[1]), -1L)) != SVNNodeKind.NONE) continue;
                it.remove();
            }
            catch (Exception e) {
                commitSVNMsg.put(ERROR, (Object)e.toString());
            }
        }
        SVNURL[] deleteUrls = new SVNURL[files.size()];
        int j = 0;
        for (String svnUrl : files) {
            try {
                SVNURL repositoryOptUrl = SVNURL.parseURIEncoded((String)svnUrl);
                deleteUrls[j++] = repositoryOptUrl;
            }
            catch (Exception e) {
                commitSVNMsg.put(ERROR, (Object)e.toString());
            }
        }
        try {
            if (deleteUrls.length > 0) {
                SVNUtil.getClientManager().getCommitClient().doDelete(deleteUrls, annotation);
            }
        }
        catch (SVNException e) {
            commitSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u6821\u9a8c\u7528\u6237\u540d\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"AbstractDataSetOperater_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        return commitSVNMsg;
    }

    private String getNumberById(String scriptId) {
        String number = this.svnInfo.getString(NUMBER);
        String numbername = this.svnInfo.getString("numbername");
        ORM orm = ORM.create();
        String selectFields = "id," + numbername;
        QFilter[] filter = new QFilter[]{new QFilter("id", "=", (Object)scriptId)};
        DynamicObject queryOne = orm.queryOne(number, selectFields, filter);
        return queryOne.getString(numbername);
    }
}

