/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.baserecordset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNUtil {
    private static final Log log = LogFactory.getLog(SVNUtil.class);
    private static SVNClientManager clientManager;
    private static SVNCommitClient commitClient;
    public static SVNURL repositoryURL;
    private static SVNRepository repository;
    public static ISVNAuthenticationManager authManager;
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String SVN_PATH = "svnpath";
    private static final String NUMBER = "number";
    private static final String USER_HOME = "user.home";
    private static final String LOCAL_PATH = "localpath";
    private static final String ERROR = "error";
    private static final String USERNAME = "username";
    private static final String P = "password";
    private static final String IS_SAVE = "issave";

    public static SVNClientManager getClientManager() {
        return clientManager;
    }

    public static void setClientManager(SVNClientManager clientManager) {
        SVNUtil.clientManager = clientManager;
    }

    public JSONObject getSVNMsgByAppId(String bizAppId) {
        JSONObject svnMsg = new JSONObject();
        ORM orm = ORM.create();
        QFilter q = new QFilter("id", "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,svnpath,number";
        DynamicObject ds = orm.queryOne("bos_devportal_bizapp", selectFields, filters);
        svnMsg.put(SVN_PATH, (Object)ds.getString(SVN_PATH));
        String appNumber = ds.getString(NUMBER);
        String property = System.getProperty(USER_HOME);
        String localPath = property + File.separator + "unittest" + File.separator + appNumber;
        svnMsg.put(LOCAL_PATH, (Object)localPath);
        if (svnMsg.get((Object)SVN_PATH) == null || svnMsg.get((Object)SVN_PATH).toString().trim().length() == 0) {
            svnMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u4e2d\u7684SVN\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SVNUtil_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        return svnMsg;
    }

    @Deprecated
    public static String getUnitTestSvnPath(DynamicObject ds) {
        String svnPath = ds.getString(SVN_PATH);
        String cloud = ds.getString("bizcloud.number").toLowerCase();
        if (cloud.equals("dev") || cloud.equals("sys")) {
            cloud = "bos";
        }
        String app = ds.getString(NUMBER).toLowerCase();
        String findStr = "/datamodel/";
        int endIndex = svnPath.indexOf(findStr);
        svnPath = svnPath.substring(0, endIndex + findStr.length());
        svnPath = svnPath + "unittest/" + SVNUtil.getUnitTestAppVersion() + "/" + cloud + "/" + app + "/preinsdata";
        return svnPath;
    }

    public static String getUnitTestSvnPathByAppId(String bizAppId) {
        DynamicObject ds = BizAppServiceHelp.getBizAppByID((String)bizAppId);
        String svnPath = BizAppServiceHelp.getSVNPathByAppId((String)bizAppId);
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            return svnPath;
        }
        String cloud = ds.getString("bizcloud.number").toLowerCase();
        if (cloud.equals("dev") || cloud.equals("sys")) {
            cloud = "bos";
        }
        String app = ds.getString(NUMBER).toLowerCase();
        String findStr = "/datamodel/";
        int endIndex = svnPath.indexOf(findStr);
        svnPath = svnPath.substring(0, endIndex + findStr.length());
        svnPath = svnPath + "unittest/" + SVNUtil.getUnitTestAppVersion() + "/" + cloud + "/" + app + "/preinsdata";
        return svnPath;
    }

    public static String getUnitTestAppVersion() {
        ORM orm = ORM.create();
        QFilter q = new QFilter(NUMBER, "=", (Object)"unit");
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id,version";
        DynamicObject ds = orm.queryOne("bos_devportal_bizapp", selectFields, filters);
        String version = ds.getString("version");
        return version;
    }

    public JSONObject getUnitTestSVNMsgByAppId(String bizAppId) {
        JSONObject svnMsg = new JSONObject();
        String svnPath = SVNUtil.getUnitTestSvnPathByAppId(bizAppId);
        svnMsg.put(SVN_PATH, (Object)svnPath);
        DynamicObject ds = BizAppServiceHelp.getBizAppByID((String)bizAppId);
        String appNumber = ds.getString(NUMBER);
        String property = System.getProperty(USER_HOME);
        String localPath = property + File.separator + "unittest" + File.separator + appNumber;
        svnMsg.put(LOCAL_PATH, (Object)localPath);
        if (svnMsg.get((Object)SVN_PATH) == null || svnMsg.get((Object)SVN_PATH).toString().trim().length() == 0) {
            svnMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u4e2d\u7684SVN\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SVNUtil_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        return svnMsg;
    }

    public JSONObject getUnitTestSVNMsgByAppId(String svnPath, String appNumber) {
        JSONObject svnMsg = new JSONObject();
        svnMsg.put(SVN_PATH, (Object)svnPath);
        String property = System.getProperty(USER_HOME);
        String localPath = property + "\\unittest\\" + UUID.randomUUID() + "\\" + appNumber;
        svnMsg.put(LOCAL_PATH, (Object)localPath);
        return svnMsg;
    }

    public void delUnittestFile(File file) {
        boolean delete;
        String[] files;
        if (file.isDirectory() && (files = file.list()) != null) {
            for (String s : files) {
                this.delUnittestFile(new File(file, s));
            }
        }
        if (delete = file.delete()) {
            log.debug("delete file success");
        }
    }

    public JSONObject authorize(JSONObject svnMsg) {
        JSONObject checkSVNMsg = new JSONObject();
        String svnUsername = svnMsg.getString(USERNAME);
        String svnPassword = svnMsg.getString(P);
        if (StringUtils.isEmpty((CharSequence)svnUsername)) {
            checkSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"svn\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SVNUtil_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else if (StringUtils.isEmpty((CharSequence)svnPassword)) {
            checkSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"svn\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SVNUtil_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else {
            try {
                svnPassword = Encrypters.decode((String)svnPassword);
                String svnPath = svnMsg.getString(SVN_PATH);
                DAVRepositoryFactory.setup();
                SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)svnPath));
                ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)svnUsername, (String)svnPassword);
                repository.setAuthenticationManager(authManager);
                repository.setAuthenticationManager(authManager);
                DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
                SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
                repository.testConnection();
            }
            catch (Exception e) {
                checkSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u4e2d\u7684SVN\u5730\u5740\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SVNUtil_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
        return checkSVNMsg;
    }

    public void showSVNLoginForm(String bizAppId, JSONArray forms, IFormView iFormView, String capName, JSONObject svnMsg) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devportal_svn_login");
        parameter.setCustomParam("forms", (Object)forms.toJSONString());
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam("deletePageFlag", (Object)false);
        if ("PAGE".equals(capName)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u9875\u9762\u5143\u6570\u636e\u7b7e\u5165", (String)"SVNUtil_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            parameter.setCustomParam("capName", (Object)"PAGE");
        } else if ("APP".equals(capName)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u5143\u6570\u636e\u7b7e\u5165", (String)"SVNUtil_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            parameter.setCustomParam("capName", (Object)"APP");
        }
        if (svnMsg != null) {
            String username = svnMsg.getString(USERNAME);
            String password = svnMsg.getString(P);
            boolean issave = (Boolean)svnMsg.get((Object)IS_SAVE);
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password) && StringUtils.isNotBlank((Object)issave)) {
                parameter.setCustomParam(USERNAME, (Object)username);
                parameter.setCustomParam(P, (Object)password);
                parameter.setCustomParam(IS_SAVE, (Object)issave);
            }
        } else {
            parameter.setCustomParam(IS_SAVE, (Object)true);
        }
        iFormView.showForm(parameter);
    }

    public JSONObject checkOutFiles(JSONObject svnMsg, JSONObject checkInMsg) {
        String svnPath = svnMsg.getString(SVN_PATH);
        String localPath = svnMsg.getString(LOCAL_PATH);
        Map<String, String> folderMap = this.getFolderMap(svnPath, localPath);
        for (Map.Entry<String, String> entry : folderMap.entrySet()) {
            String fileName = entry.getKey();
            this.getClientManager(folderMap.get(fileName), svnMsg, checkInMsg);
            if (StringUtils.isNotBlank((Object)checkInMsg.get((Object)ERROR)) || StringUtils.isNotBlank((Object)checkInMsg.get((Object)"NOPATH"))) {
                return checkInMsg;
            }
            this.checkRootFolder(fileName, entry.getValue(), clientManager, checkInMsg);
            if (!StringUtils.isNotBlank((Object)checkInMsg.get((Object)ERROR))) continue;
            return checkInMsg;
        }
        return checkInMsg;
    }

    private Map<String, String> getFolderMap(String svnRoot, String localPath) {
        HashMap<String, String> folderMap = new HashMap<String, String>();
        folderMap.put(localPath, svnRoot);
        return folderMap;
    }

    public void getClientManager(String svnPath, JSONObject svnMsg, JSONObject checkOutMsg) {
        this.setupLibrary();
        try {
            String userName = svnMsg.get((Object)USERNAME).toString();
            String password = svnMsg.get((Object)P).toString();
            password = Encrypters.decode((String)password);
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            repository = SVNRepositoryFactory.create((SVNURL)url);
            authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(userName, password, false, url, false)});
            repository.setAuthenticationManager(authManager);
            SVNNodeKind nodeKind = repository.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                checkOutMsg.put("NOPATH", (Object)ResManager.loadKDString((String)"SVN\u8def\u5f84\u4e0d\u5b58\u5728\u3002", (String)"SVNUtil_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        catch (SVNException e) {
            checkOutMsg.put(ERROR, (Object)e.getMessage());
            return;
        }
        catch (Exception e) {
            checkOutMsg.put(ERROR, (Object)ResManager.loadKDString((String)"svn\u8fde\u63a5\u51fa\u9519,\u8bf7\u68c0\u67e5svn\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u8def\u5f84\u662f\u5426\u6b63\u786e\u3002", (String)"SVNUtil_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        commitClient = clientManager.getCommitClient();
        checkOutMsg.put("clientManager", (Object)clientManager);
        checkOutMsg.put("commitClient", (Object)commitClient);
        checkOutMsg.put("repository", (Object)repository);
    }

    public void setAuthenticationManager(String svnPath, String userName, String password) {
        try {
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)url);
            BasicAuthenticationManager authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(userName, password, false, url, false)});
            repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        }
        catch (SVNException e) {
            log.error((Throwable)e);
        }
    }

    public void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public void checkRootFolder(String filePath, String svnPath, SVNClientManager clientManager, JSONObject checkoutMsg) {
        File checkOutFile = new File(filePath);
        checkOutFile.deleteOnExit();
        try {
            boolean flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
            if (!flag) {
                this.checkedOut(checkOutFile, svnPath, clientManager, checkoutMsg);
                flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
                if (!flag) {
                    checkoutMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u76ee\u5f55\u4e0d\u662fsvn\u7ba1\u7406\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\uff1a%s\u3002", (String)"SVNUtil_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), checkOutFile));
                }
            }
            clientManager.getWCClient().doCleanup(checkOutFile);
            clientManager.getWCClient().doRevert(new File[]{checkOutFile}, SVNDepth.INFINITY, null);
            clientManager.getUpdateClient().doUpdate(checkOutFile, SVNRevision.HEAD, SVNDepth.INFINITY, false, true);
        }
        catch (SVNException e) {
            try {
                clientManager.getWCClient().doCleanup(checkOutFile);
                clientManager.getUpdateClient().doUpdate(checkOutFile, SVNRevision.HEAD, false);
                clientManager.getWCClient().doRevert(checkOutFile, false);
                clientManager.getWCClient().doResolve(checkOutFile, false);
            }
            catch (SVNException e1) {
                checkoutMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u672c\u5730\u6587\u4ef6svn\u8def\u5f84\uff1a%s\u51fa\u9519\u3002\u89e3\u51b3\u529e\u6cd5\uff1a1\u3001\u8bf7\u5230\u672c\u5730\u8be5\u8def\u5f84\u4e0b\uff0c\u6267\u884csvn\u7684revert\u3001update\u3001cleanup\u540e\u518d\u8bd5\uff1b2\u3001\u5220\u9664\u8be5\u6587\u4ef6\u5939\u540e\u518d\u8bd5\u3002", (String)"SVNUtil_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), checkOutFile));
            }
        }
    }

    private void checkedOut(File checkOutFile, String svnPath, SVNClientManager clientManager, JSONObject checkoutMsg) {
        try {
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            updateClient.doCheckout(url, checkOutFile, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
        }
        catch (SVNException e) {
            checkoutMsg.put(ERROR, (Object)e.getMessage());
        }
    }

    public JSONObject commitToSVN(List<String> fileList, JSONObject svnMsg) {
        JSONObject commitSVNMsg = new JSONObject();
        ArrayList<File> files = new ArrayList<File>(10);
        for (String url : fileList) {
            File file = new File(url);
            files.add(file);
        }
        String localPath = svnMsg.getString(LOCAL_PATH);
        String svnMessage = svnMsg.getString("annotation");
        File[] filetocommit = files.toArray(new File[0]);
        this.commit(clientManager, filetocommit, commitSVNMsg, localPath, svnMessage);
        return commitSVNMsg;
    }

    private void commit(SVNClientManager clientManager, File[] files, JSONObject commitSVNMsg, String localPath, String svnMessage) {
        try {
            clientManager.getWCClient().doAdd(files, true, false, false, SVNDepth.INFINITY, false, true, true);
            SVNCommitInfo info = clientManager.getCommitClient().doCommit(files, true, svnMessage, null, null, false, false, SVNDepth.INFINITY);
            if (info.equals(SVNCommitInfo.NULL)) {
                commitSVNMsg.put("notification", (Object)ResManager.loadKDString((String)"\u5143\u6570\u636e\u65e0\u53d8\u5316\uff0c\u65e0\u9700\u63d0\u4ea4\u3002", (String)"SVNUtil_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
        catch (SVNException e) {
            if (e.getMessage().contains("Authentication required for ")) {
                commitSVNMsg.put(ERROR, (Object)ResManager.loadKDString((String)"SVN\u8ba4\u8bc1\u5931\u8d25\uff0c\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"SVNUtil_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            commitSVNMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4svn\u5931\u8d25\u3002\u8bf7\u5c1d\u8bd5\u66f4\u65b0\u6216\u5220\u9664\u670d\u52a1\u5668svn\u6587\u4ef6\u3002%1$s%2$s\u3002", (String)"SVNUtil_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage(), localPath));
        }
    }

    public JSONObject delete(JSONObject svnMsg, JSONArray forms) {
        String svnPath = svnMsg.getString(SVN_PATH);
        String localPath = svnMsg.getString(LOCAL_PATH);
        String username = svnMsg.getString(USERNAME);
        String password = svnMsg.getString(P);
        String annotation = svnMsg.getString("annotation");
        this.setupLibrary();
        JSONObject commitSVNMsg = new JSONObject();
        this.getClientManager(svnPath, svnMsg, commitSVNMsg);
        SVNCommitClient commitClient = clientManager.getCommitClient();
        commitClient.setIgnoreExternals(false);
        return commitSVNMsg;
    }
}

