/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizextplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.bizextplugin.BizExtPluginEdit;
import kd.bos.designer.bizextplugin.UploadBizCaseToDataLake;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.isv.ISVService;
import kd.bos.servicehelper.TimeServiceHelper;

public class BizExtCaseEdit
extends AbstractBasePlugIn {
    private static final String FORMID_BIZEXTCASE = "bos_bizextcase";
    private static final String FORMID_BIZEXTPLUG_BIND = "bos_bizextpluginbind";
    private static final String OPTYPE_SAVE = "save";
    private static final String OPTYPE_DEL_ENTRY = "deleteentry";
    private static final String KEY_ISV = "isv";
    private static final String KEY_VERSION = "version";
    private static final String KEY_MD_SAPMLE = "md_sample";
    private static final String KEY_SAMPLE_TAG = "sample_tag";
    private static final String KEY_PLUGIN_ENABLE_CHECK = "pluginenable_checkbox";
    private static final String KEY_PLUGIN_ENABLE = "pluginenable";
    private static final String KEY_PLUGIN_ISV = "pluginisv";
    private static final String KEY_PLUGIN_CREATOR = "plugincreator";
    private static final String KEY_PLUGIN_CREATETIME = "plugincreatetime";
    private static final String KEY_PLUGIN_VERSION = "pluginversion";
    private static final String KEY_SAMPLE_TEXT = "text";
    private static final String KEY_ENTRY = "entryentity";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void afterCreateNewData(EventObject e) {
        String currentIsv = ISVService.getISVInfo().getId();
        this.getModel().setValue(KEY_ISV, (Object)currentIsv);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String currentIsv = ISVService.getISVInfo().getId();
        for (RowDataEntity row : e.getRowDataEntities()) {
            this.getModel().setValue(KEY_PLUGIN_ISV, (Object)currentIsv, row.getRowIndex());
            this.getModel().setValue(KEY_PLUGIN_CREATOR, (Object)RequestContext.get().getCurrUserId(), row.getRowIndex());
            this.getModel().setValue(KEY_PLUGIN_CREATETIME, (Object)TimeServiceHelper.now(), row.getRowIndex());
            this.getModel().setValue(KEY_PLUGIN_VERSION, (Object)TimeServiceHelper.now().getTime());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)OPTYPE_SAVE, (CharSequence)op.getType())) {
            this.updateValBeforeSave();
        } else if (StringUtils.equals((CharSequence)OPTYPE_DEL_ENTRY, (CharSequence)op.getType()) && !this.delEntryRowValidate()) {
            args.setCancel(true);
        }
    }

    public void beforeBindData(EventObject e) {
        if (StringUtils.equals((CharSequence)FORMID_BIZEXTPLUG_BIND, (CharSequence)this.getView().getEntityId())) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY);
            for (DynamicObject row : rows) {
                String enable = row.getString(KEY_PLUGIN_ENABLE);
                if (StringUtils.equals((CharSequence)enable, (CharSequence)"0")) {
                    row.set(KEY_PLUGIN_ENABLE_CHECK, (Object)false);
                    continue;
                }
                row.set(KEY_PLUGIN_ENABLE_CHECK, (Object)true);
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sampleJson = (String)this.getModel().getValue(KEY_SAMPLE_TAG);
        String sampleText = null;
        if (StringUtils.isNotBlank((CharSequence)sampleJson)) {
            Map sampleContext = (Map)SerializationUtils.fromJsonString((String)sampleJson, Map.class);
            sampleText = (String)sampleContext.get(KEY_SAMPLE_TEXT);
        }
        if (sampleText == null) {
            sampleText = "";
        }
        Markdown md = (Markdown)this.getView().getControl(KEY_MD_SAPMLE);
        md.setText(sampleText);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)OPTYPE_SAVE, (CharSequence)op.getType())) {
            UploadBizCaseToDataLake uploader = new UploadBizCaseToDataLake(this.getView().getFormShowParameter().getRootPageId());
            if (args.getOperationResult() != null && args.getOperationResult().getSuccessPkIds() != null && !args.getOperationResult().getSuccessPkIds().isEmpty()) {
                uploader.upload(args.getOperationResult().getSuccessPkIds().toArray());
                String opName = ResManager.loadKDString((String)"\u7ed1\u5b9a\u63d2\u4ef6", (String)"BizExtCaseEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                String number = (String)this.getModel().getValue("number");
                String desc = String.format("%1$s\uff0c%2$s", number, ResManager.loadKDString((String)"\u7ed1\u5b9a\u63d2\u4ef6\u6210\u529f", (String)"BizExtCaseEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                BizExtPluginEdit.writeLog(opName, desc, FORMID_BIZEXTCASE);
            }
        }
    }

    private void updateValBeforeSave() {
        this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)FORMID_BIZEXTCASE, (CharSequence)this.getView().getEntityId())) {
            this.getModel().setValue(KEY_VERSION, (Object)TimeServiceHelper.now().getTime());
            Markdown md = (Markdown)this.getView().getControl(KEY_MD_SAPMLE);
            String sampleText = md.getText();
            HashMap<String, String> sampleContext = new HashMap<String, String>();
            sampleContext.put(KEY_SAMPLE_TEXT, sampleText);
            this.getModel().setValue(KEY_SAMPLE_TAG, (Object)SerializationUtils.toJsonString(sampleContext));
        } else if (StringUtils.equals((CharSequence)FORMID_BIZEXTPLUG_BIND, (CharSequence)this.getView().getEntityId())) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY);
            for (DynamicObject row : rows) {
                Boolean enable = row.getBoolean(KEY_PLUGIN_ENABLE_CHECK);
                if (enable.booleanValue()) {
                    row.set(KEY_PLUGIN_ENABLE, (Object)"1");
                    continue;
                }
                row.set(KEY_PLUGIN_ENABLE, (Object)"0");
            }
        }
    }

    private boolean delEntryRowValidate() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            return true;
        }
        String currentIsv = ISVService.getISVInfo().getId();
        for (int row : rows) {
            String isv = (String)this.getModel().getValue(KEY_PLUGIN_ISV, row);
            if (StringUtils.equals((CharSequence)isv, (CharSequence)currentIsv)) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u52ff\u5220\u9664\u975e\u672c\u5f00\u53d1\u5546\u6ce8\u518c\u7684\u63d2\u4ef6\uff0c\u5982\u4e0d\u9700\u8981\u53ef\u5173\u95ed\u3010\u542f\u7528\u3011\u9009\u9879\u3002", (String)"BizExtCaseEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

