/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizextplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BizExtCaseTScriptEdit
extends AbstractBillPlugIn {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String OPTYPE_SELECT_TS = "selectts";
    private static final String MODELTYPE_BIZEXTPLUGIN = "BizExtPlugin";
    private static final String RETURN_PLUGIN_CLASS_NAME = "ClassName";
    private static final String RETURN_PLUGIN_DESCRIPTION_NAME = "Description";
    private static final String KEY_INTERFACE = "interface";
    private static final String KEY_INTERFACE_TS = "interface_ts";
    private static final String KEY_INTERFACE_TYPE = "interfacetype";
    private static final String DEF_EXTPLUGIN_INTERFACE = "kd.bos.extplugin.StdExtPlugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit interfaceEdit = (TextEdit)this.getView().getControl(KEY_INTERFACE_TS);
        interfaceEdit.addClickListener((ClickListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String interfaceType = (String)this.getModel().getValue(KEY_INTERFACE_TYPE);
        if (StringUtils.isBlank((CharSequence)interfaceType)) {
            this.getModel().setValue(KEY_INTERFACE_TYPE, (Object)"J");
        } else if (StringUtils.equals((CharSequence)interfaceType, (CharSequence)"S")) {
            this.getModel().setValue(KEY_INTERFACE_TS, this.getModel().getValue(KEY_INTERFACE));
            TextEdit textEdit = (TextEdit)this.getView().getControl(KEY_INTERFACE_TS);
            textEdit.setMustInput(true);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Plugin.enableRegisterKingScript()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_INTERFACE_TYPE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INTERFACE_TYPE});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String status;
        super.beforeFieldPostBack(e);
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)KEY_INTERFACE_TS) && !StringUtils.equals((CharSequence)"A", (CharSequence)(status = (String)this.getModel().getValue("status")))) {
            e.setCancel(true);
            this.getView().updateView(e.getKey());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_INTERFACE_TYPE)) {
            this.getModel().setValue(KEY_INTERFACE, (Object)"");
            this.getModel().setValue(KEY_INTERFACE_TS, (Object)"");
            String interfaceType = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)"S", (CharSequence)interfaceType)) {
                TextEdit textEdit = (TextEdit)this.getView().getControl(KEY_INTERFACE_TS);
                textEdit.setMustInput(StringUtils.equals((CharSequence)"S", (CharSequence)((String)e.getChangeSet()[0].getNewValue())));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"E", (CharSequence)interfaceType)) {
                this.setExtPluginClassName();
            }
        }
    }

    public void click(EventObject event) {
        super.click(event);
        Control source = (Control)event.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_INTERFACE_TS)) {
            this.doClickInterface();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals(OPTYPE_SELECT_TS)) {
            List plugins = (List)event.getReturnData();
            this.afterSelectTs(plugins);
        }
    }

    private void doClickInterface() {
        String interfaceType = (String)this.getModel().getValue(KEY_INTERFACE_TYPE);
        if (!StringUtils.equals((CharSequence)interfaceType, (CharSequence)"S")) {
            ComboProp prop = (ComboProp)this.getModel().getProperty(KEY_INTERFACE_TYPE);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6269\u5c55\u63a5\u53e3\u7c7b\u578b\u4e3a\u3010%s\u3011\uff0c\u7136\u540e\u518d\u9009\u62e9\u63a5\u53e3\u5b9a\u4e49\u811a\u672c\u3002", (String)"BizExtCaseTScriptEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), prop.getItemByName("S")));
            return;
        }
        String className = (String)this.getModel().getValue(KEY_INTERFACE_TS);
        if (StringUtils.isBlank((CharSequence)className)) {
            this.openSelectTSForm("");
            return;
        }
        QFilter filter = new QFilter("classname", "=", (Object)className);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"id", (QFilter[])new QFilter[]{filter});
        if (objs == null || objs.length == 0) {
            this.openSelectTSForm("");
        } else {
            String status = (String)this.getModel().getValue("status");
            if (StringUtils.equals((CharSequence)"A", (CharSequence)status)) {
                this.openSelectTSForm((String)objs[0].getPkValue());
            } else {
                this.openViewTSForm((String)objs[0].getPkValue());
            }
        }
    }

    private void openViewTSForm(String scriptId) {
        String bizAppId;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_register_ts_plugin");
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("bizscriptid", (Object)scriptId);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        String string = bizAppId = bizApp == null ? "" : (String)bizApp.getPkValue();
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)bizAppId, null);
            parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
        }
        this.getView().showForm(parameter);
    }

    private void openSelectTSForm(String scriptId) {
        String bizAppId;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"PluginsPlugin_10", (String)BOS_DESIGNER_PLUGIN).getLocaleValue());
        parameter.setFormId("ide_select_ts_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPTYPE_SELECT_TS));
        parameter.setCustomParam("engineType", (Object)"1");
        parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(this.packagePlugins(scriptId)));
        parameter.setCustomParam("modelType", (Object)MODELTYPE_BIZEXTPLUGIN);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        String string = bizAppId = bizApp == null ? "" : (String)bizApp.getPkValue();
        if (!StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u4e1a\u52a1\u573a\u666f\u672a\u6302\u5728\u4e1a\u52a1\u5e94\u7528\u4e0b\uff0c\u4e0d\u80fd\u6dfb\u52a0\u811a\u672c\u63d2\u4ef6", (String)"RegisterTSPluginEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        this.getView().showForm(parameter);
    }

    private void afterSelectTs(List<Map<String, Object>> plugins) {
        if (plugins == null || plugins.isEmpty()) {
            return;
        }
        for (Map<String, Object> plugin : plugins) {
            String className = (String)plugin.get(RETURN_PLUGIN_CLASS_NAME);
            if (!StringUtils.isNotBlank((CharSequence)className)) continue;
            this.getModel().setValue(KEY_INTERFACE_TS, (Object)className);
            this.getModel().setValue(KEY_INTERFACE, (Object)className);
            break;
        }
    }

    private List<Map<String, Object>> packagePlugins(String scriptId) {
        ArrayList<Map<String, Object>> newPlugins = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> mapPlugin = new HashMap<String, Object>(16);
        mapPlugin.put("rowKey", 0);
        mapPlugin.put("FPK", scriptId);
        mapPlugin.put(RETURN_PLUGIN_CLASS_NAME, this.getModel().getValue(KEY_INTERFACE_TS));
        mapPlugin.put(RETURN_PLUGIN_DESCRIPTION_NAME, "");
        mapPlugin.put("DisplayName", "");
        newPlugins.add(mapPlugin);
        return newPlugins;
    }

    private void setExtPluginClassName() {
        this.getModel().setValue(KEY_INTERFACE, (Object)DEF_EXTPLUGIN_INTERFACE);
        this.getModel().setValue(KEY_INTERFACE_TS, (Object)"");
    }
}

