/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizextplugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.ExceptionUtils;

public class BizExtPluginEdit
extends AbstractBillPlugIn {
    private static final String KEY_PLUGIN_TYPE = "plugintype";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final Log LOG = LogFactory.getLog(BizExtPluginEdit.class);

    public void afterCreateNewData(EventObject e) {
        String currentIsv = ISVService.getISVInfo().getId();
        this.getModel().setValue("isv", (Object)currentIsv);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String type = (String)this.getModel().getValue(KEY_PLUGIN_TYPE);
        if (StringUtils.isBlank((CharSequence)type)) {
            this.getModel().setValue(KEY_PLUGIN_TYPE, (Object)"0");
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)op.getType())) {
            this.getModel().setValue("version", (Object)TimeServiceHelper.now().getTime());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String value = (String)this.getModel().getValue("billno");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            FormOperate op = (FormOperate)args.getSource();
            if (StringUtils.equals((CharSequence)"enable", (CharSequence)op.getOperateKey())) {
                String opName = ResManager.loadKDString((String)"\u542f\u7528", (String)"BizExtPluginEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                String desc = String.format("%1$s\uff0c%2$s", value, ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"BizExtPluginEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                BizExtPluginEdit.writeLog(opName, desc, "bos_bizextplugin");
            } else if (StringUtils.equals((CharSequence)"disable", (CharSequence)op.getOperateKey())) {
                String opName = ResManager.loadKDString((String)"\u7981\u7528", (String)"BizExtPluginEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                String desc = String.format("%1$s\uff0c%2$s", value, ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"BizExtPluginEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                BizExtPluginEdit.writeLog(opName, desc, "bos_bizextplugin");
            }
        }
    }

    protected static void writeLog(String opType, String desc, String objId) {
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            AppLogInfo logInfo = BizExtPluginEdit.doBuildLogInfo(opType, desc, objId);
            logService.addLog(logInfo);
        }
        catch (Exception e) {
            LOG.info("Log failure to enable and disable the business extension plugin\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private static AppLogInfo doBuildLogInfo(String opName, String desc, String objId) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"sysext"));
        logInfo.setBizObjID(objId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(desc);
        return logInfo;
    }
}

