/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizextplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;

public class BizExtPluginEnableOpPlug
extends AbstractOperationServicePlugIn {
    private static final String FORMID_BIZEXTPLUGIN = "bos_bizextplugin";
    private static final String FORMID_BIZEXTPLUGIN_BIND = "bos_bizextpluginbind";
    private static final String KEY_BIND_ENTRY_PLUGIN = "entryentity";
    private static final String KEY_BIND_ENABLE = "pluginenable";
    private static final String KEY_PLUG_BIZEXTCASE = "bizextcase";
    private static final String KEY_PLUG_BIZEXTCASE_ID = "bizextcase_id";
    private static final String KEY_PLUG_ENABLE = "enable";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        if (StringUtils.equals((CharSequence)this.billEntityType.getName(), (CharSequence)FORMID_BIZEXTPLUGIN)) {
            e.getFieldKeys().add(KEY_PLUG_BIZEXTCASE);
            e.getFieldKeys().add(KEY_PLUG_ENABLE);
        } else if (StringUtils.equals((CharSequence)this.billEntityType.getName(), (CharSequence)FORMID_BIZEXTPLUGIN_BIND)) {
            e.getFieldKeys().add(KEY_BIND_ENABLE);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<PlugStatus> plugStatusList = new ArrayList<PlugStatus>(e.getDataEntities().length);
        if (StringUtils.equals((CharSequence)this.billEntityType.getName(), (CharSequence)FORMID_BIZEXTPLUGIN)) {
            for (DynamicObject obj : e.getDataEntities()) {
                if (!obj.getDataEntityState().getFromDatabase()) continue;
                Long entryid = (Long)obj.getPkValue();
                Long id = obj.getLong(KEY_PLUG_BIZEXTCASE_ID);
                String enable = obj.getString(KEY_PLUG_ENABLE);
                plugStatusList.add(new PlugStatus(entryid, id, enable));
            }
        } else if (StringUtils.equals((CharSequence)this.billEntityType.getName(), (CharSequence)FORMID_BIZEXTPLUGIN_BIND)) {
            for (DynamicObject obj : e.getDataEntities()) {
                Long id = (Long)obj.getPkValue();
                DynamicObjectCollection rows = obj.getDynamicObjectCollection(KEY_BIND_ENTRY_PLUGIN);
                for (DynamicObject row : rows) {
                    if (!row.getDataEntityState().getFromDatabase()) continue;
                    Long entryid = (Long)row.getPkValue();
                    String enable = row.getString(KEY_BIND_ENABLE);
                    plugStatusList.add(new PlugStatus(entryid, id, enable));
                }
            }
        }
        this.insertPlugStatus(plugStatusList);
    }

    private void insertPlugStatus(List<PlugStatus> plugStatusList) {
        if (plugStatusList.isEmpty()) {
            return;
        }
        String sqlExists = "select FEntryId from T_Meta_Bizextplugin_S where FEntryId in (%s) ";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[plugStatusList.size()];
        int i = 0;
        for (PlugStatus plugStatus : plugStatusList) {
            list.add("?");
            params[i] = new SqlParameter(":FEntryId" + String.valueOf(i), -5, (Object)plugStatus.getEntryid());
            ++i;
        }
        sqlExists = String.format(sqlExists, StringUtils.join((Object[])list.toArray(), (String)","));
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> idSet = new HashSet<Long>(16);
                while (rs.next()) {
                    idSet.add(rs.getLong(1));
                }
                return idSet;
            }
        };
        Set existsPlugIds = (Set)DB.query((DBRoute)DBRoute.meta, (String)sqlExists, (Object[])params, (ResultSetHandler)action);
        ArrayList<SqlParameter[]> insertParamList = new ArrayList<SqlParameter[]>();
        for (PlugStatus plugStatus : plugStatusList) {
            if (existsPlugIds.contains(plugStatus.getEntryid())) continue;
            SqlParameter[] insertParams = new SqlParameter[]{new SqlParameter("FEntryId", -5, (Object)plugStatus.getEntryid()), new SqlParameter("FId", -5, (Object)plugStatus.getId()), new SqlParameter("FEnable", 1, (Object)plugStatus.getEnable())};
            insertParamList.add(insertParams);
        }
        if (!insertParamList.isEmpty()) {
            String strInsertSQL = "INSERT INTO T_Meta_Bizextplugin_S (FEntryId, FId, FEnable) VALUES (?, ?, ?) ";
            DB.executeBatch((DBRoute)DBRoute.meta, (String)strInsertSQL, insertParamList);
        }
    }

    static class PlugStatus {
        private Long entryid;
        private Long id;
        private String enable;

        public PlugStatus(Long entryid, Long id, String enable) {
            this.entryid = entryid;
            this.id = id;
            this.enable = enable;
        }

        public Long getEntryid() {
            return this.entryid;
        }

        public void setEntryid(Long entryid) {
            this.entryid = entryid;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getEnable() {
            return this.enable;
        }

        public void setEnable(String enable) {
            this.enable = enable;
        }
    }
}

