/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizextplugin;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.datamanager.DataEntityCacheManager;

public class BizExtPluginList
extends AbstractListPlugin {
    private static final String ENTITY_BIZEXT_PLUGIN_BIND = "bos_bizextpluginbind";
    private static final Set<String> CLEAR_CACHE_OPTYPES = new HashSet<String>();

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (CLEAR_CACHE_OPTYPES.contains(op.getType())) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)ENTITY_BIZEXT_PLUGIN_BIND);
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)mainType);
            cacheManager.removeByDt();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BizExtPluginListProvider());
    }

    static {
        CLEAR_CACHE_OPTYPES.add("save");
        CLEAR_CACHE_OPTYPES.add("delete");
        CLEAR_CACHE_OPTYPES.add("enable");
        CLEAR_CACHE_OPTYPES.add("disable");
        CLEAR_CACHE_OPTYPES.add("statusconvert");
    }

    static class BizExtPluginListProvider
    extends ListDataProvider {
        BizExtPluginListProvider() {
        }

        public DynamicObjectCollection getData(int start, int count) {
            DynamicObjectCollection rows = super.getData(start, count);
            String k = "enable";
            if (rows.getDynamicObjectType().getProperties().containsKey((Object)k)) {
                for (DynamicObject row : rows) {
                    String enable = row.getString(k);
                    if (!StringUtils.isBlank((CharSequence)enable)) continue;
                    row.set(k, (Object)"1");
                }
            }
            return rows;
        }
    }
}

