/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizextplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RegisterTSPluginEdit
extends AbstractBillPlugIn {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BARITEM_ADD_JAVA = "btnaddjava";
    private static final String BARITEM_TS = "btnts";
    private static final String OPTYPE_ADD_TS = "addts";
    private static final String OPTYPE_SELECT_TS = "selectts";
    private static final String OPTYPE_EDIT_TS = "editts";
    private static final String ENTRY_KEY = "EntryEntity";
    private static final String PLUGIN_CLASS = "pluginclass";
    private static final String PLUGIN_REMARK = "pluginremark";
    private static final String PLUGIN_TYPE = "plugintype";
    private static final String MODELTYPE_BIZEXTPLUGIN = "BizExtPlugin";
    public static final String RETURN_PLUGIN_CLASS_NAME = "ClassName";
    public static final String RETURN_PLUGIN_DESCRIPTION_NAME = "Description";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Plugin.enableRegisterKingScript()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BARITEM_TS});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEM_TS});
        }
        String interfaceType = (String)this.getModel().getValue("interfacetype");
        if (StringUtils.equals((CharSequence)"S", (CharSequence)interfaceType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEM_ADD_JAVA});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BARITEM_ADD_JAVA});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(ENTRY_KEY);
        boolean chagned = false;
        for (DynamicObject entryRow : entryRows) {
            String type = entryRow.getString(PLUGIN_TYPE);
            if (!StringUtils.isBlank((CharSequence)type)) continue;
            entryRow.set(PLUGIN_TYPE, (Object)"0");
            chagned = true;
        }
        if (chagned) {
            this.getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            FormOperate op = (FormOperate)args.getSource();
            if (StringUtils.equals((CharSequence)OPTYPE_ADD_TS, (CharSequence)op.getOperateKey())) {
                this.openCreateTSForm();
            } else if (StringUtils.equals((CharSequence)OPTYPE_SELECT_TS, (CharSequence)op.getOperateKey())) {
                this.openSelectTSForm();
            } else if (StringUtils.equals((CharSequence)OPTYPE_EDIT_TS, (CharSequence)op.getOperateKey())) {
                this.openModifyTSForm();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (OPTYPE_ADD_TS.equalsIgnoreCase(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            this.afterAddNewTs(plugin);
        } else if (e.getActionId().equals(OPTYPE_SELECT_TS)) {
            List plugins = (List)e.getReturnData();
            this.afterSelectTs(plugins);
        } else if (OPTYPE_EDIT_TS.equals(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            this.afterModifyTs(plugin);
        }
    }

    private void openCreateTSForm() {
        String bizAppId;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_ts_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPTYPE_ADD_TS));
        parameter.setCustomParam("modelType", (Object)MODELTYPE_BIZEXTPLUGIN);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        String string = bizAppId = bizApp == null ? "" : (String)bizApp.getPkValue();
        if (!StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u4e1a\u52a1\u573a\u666f\u672a\u6302\u5728\u4e1a\u52a1\u5e94\u7528\u4e0b\uff0c\u4e0d\u80fd\u6dfb\u52a0\u811a\u672c\u63d2\u4ef6", (String)"RegisterTSPluginEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)bizAppId, null);
        parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
        this.getView().showForm(parameter);
    }

    private void afterAddNewTs(Map<String, Object> plugin) {
        plugin.put("_Type_", "Plugin");
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
        this.getModel().setValue(PLUGIN_CLASS, plugin.get(RETURN_PLUGIN_CLASS_NAME), rowIndex);
        this.getModel().setValue(PLUGIN_REMARK, plugin.get(RETURN_PLUGIN_DESCRIPTION_NAME), rowIndex);
        this.getModel().setValue(PLUGIN_TYPE, (Object)"2", rowIndex);
    }

    private void openSelectTSForm() {
        String bizAppId;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"PluginsPlugin_10", (String)BOS_DESIGNER_PLUGIN).getLocaleValue());
        parameter.setFormId("ide_select_ts_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPTYPE_SELECT_TS));
        parameter.setCustomParam("engineType", (Object)"1");
        parameter.setCustomParam("value", (Object)"[]");
        parameter.setCustomParam("modelType", (Object)MODELTYPE_BIZEXTPLUGIN);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        String string = bizAppId = bizApp == null ? "" : (String)bizApp.getPkValue();
        if (!StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u4e1a\u52a1\u573a\u666f\u672a\u6302\u5728\u4e1a\u52a1\u5e94\u7528\u4e0b\uff0c\u4e0d\u80fd\u6dfb\u52a0\u811a\u672c\u63d2\u4ef6", (String)"RegisterTSPluginEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        this.getView().showForm(parameter);
    }

    private void afterSelectTs(List<Map<String, Object>> plugins) {
        String className;
        if (plugins == null || plugins.isEmpty()) {
            return;
        }
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(ENTRY_KEY);
        HashSet<String> currentTs = new HashSet<String>(entryRows.size());
        for (DynamicObject row : entryRows) {
            className = row.getString(PLUGIN_CLASS);
            if (!StringUtils.isNotBlank((CharSequence)className)) continue;
            currentTs.add(className);
        }
        for (Map<String, Object> plugin : plugins) {
            className = (String)plugin.get(RETURN_PLUGIN_CLASS_NAME);
            if (!StringUtils.isNotBlank((CharSequence)className) || currentTs.contains(className)) continue;
            this.afterAddNewTs(plugin);
        }
    }

    private void openModifyTSForm() {
        String bizAppId;
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        int rowCount = this.getModel().getEntryRowCount(ENTRY_KEY);
        if (rowIndex < 0 || rowIndex >= rowCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u63d2\u4ef6\u3002", (String)"RegisterTSPluginEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String type = (String)this.getModel().getValue(PLUGIN_TYPE, rowIndex);
        if (!StringUtils.equals((CharSequence)type, (CharSequence)"2")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9TS\u811a\u672c\u63d2\u4ef6", (String)"RegisterTSPluginEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String className = (String)this.getModel().getValue(PLUGIN_CLASS, rowIndex);
        QFilter filter = new QFilter("classname", "=", (Object)className);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"id", (QFilter[])new QFilter[]{filter});
        if (objs == null || objs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u636e\u811a\u672c\u63d2\u4ef6\u8def\u5f84\u672a\u80fd\u627e\u5230\u63d2\u4ef6\u5b9a\u4e49\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86\u3002", (String)"RegisterTSPluginEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_register_ts_plugin");
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPTYPE_EDIT_TS));
        parameter.setCustomParam("bizscriptid", objs[0].getPkValue());
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        String string = bizAppId = bizApp == null ? "" : (String)bizApp.getPkValue();
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam("bizappid", (Object)bizAppId);
            String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)bizAppId, null);
            parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
        }
        this.getView().showForm(parameter);
    }

    private void afterModifyTs(Map<String, Object> plugin) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        this.getModel().setValue(PLUGIN_CLASS, plugin.get(RETURN_PLUGIN_CLASS_NAME), rowIndex);
        this.getModel().setValue(PLUGIN_REMARK, plugin.get(RETURN_PLUGIN_DESCRIPTION_NAME), rowIndex);
    }

    private List<Map<String, Object>> getAllPlugins() {
        ArrayList<Map<String, Object>> newPlugins = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        int rowIndex = 0;
        for (DynamicObject obj : doc) {
            HashMap<String, Object> mapPlugin = new HashMap<String, Object>(16);
            mapPlugin.put("rowKey", rowIndex++);
            mapPlugin.put(RETURN_PLUGIN_CLASS_NAME, obj.getString(PLUGIN_CLASS));
            mapPlugin.put(RETURN_PLUGIN_DESCRIPTION_NAME, obj.getString(PLUGIN_REMARK));
            mapPlugin.put("DisplayName", obj.getString(PLUGIN_REMARK));
            newPlugins.add(mapPlugin);
        }
        return newPlugins;
    }
}

