/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizextplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.IDService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

class UploadBizCaseToDataLake {
    private static final Log log = LogFactory.getLog(UploadBizCaseToDataLake.class);
    private static final String FORM_BIZ_EXT_CASE = "bos_bizextcase";
    private static final String FORM_BIZ_EXT_PLUGIN = "bos_bizextplugin";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NAME = "name";
    private static final String KEY_CASE_INTERFACE = "interface";
    private static final String KEY_CASE_ISV = "isv";
    private static final String KEY_CASE_CREATETIME = "createtime";
    private static final String KEY_CASE_APPID = "appid";
    private static final String KEY_CASE_BIZAPP = "bizapp";
    private static final String KEY_CASE_APPNAME = "appname";
    private static final String KEY_CASE_OBJECTTYPE = "objecttype";
    private static final String KEY_CASE_OBJECTTYPENAME = "objecttypename";
    private static final String KEY_PLUGIN_BILLNO = "billno";
    private static final String KEY_PLUGIN_BIZEXTCASE = "bizextcase";
    private static final String KEY_PLUGIN_BIZCASENUMBER = "bizcasenumber";
    private static final String KEY_PLUGIN_BIZCASENAME = "bizcasename";
    private static final String KEY_PLUGIN_PLUGINCLASS = "pluginclass";
    private static final String KEY_PLUGIN_PLUGINSEQ = "pluginseq";
    private static final String KEY_PLUGIN_SEQ = "seq";
    private static final String KEY_PLUGIN_ISV = "isv";
    private static final String KEY_PLUGIN_CREATETIME = "createtime";
    private static final String DATA_COLLECT_STOREID = "server_beacon";
    private static final String DATA_COLLECT_PROJECT = "cosmic";
    private static final String DATA_COLLECT_PROJECT_TEST = "cosmic_test";
    private static final String DATA_COLLECT_EVENTNAME_CASE = "business_extend_case";
    private static final String DATA_COLLECT_EVENTNAME_PLUGIN = "business_extend_plug_in";
    private static int batchSize = 20;
    private String rootPageId;
    private boolean isLoadInstanceCode = false;
    private String instanceCode = null;

    public UploadBizCaseToDataLake(String rootPageId) {
        this.rootPageId = rootPageId;
    }

    public void upload(Object[] bizCaseIds) {
        try {
            this.uploadBizCase(bizCaseIds);
            this.uploadBizExtPlugin(bizCaseIds);
        }
        catch (RuntimeException exp) {
            log.error((Throwable)exp);
        }
    }

    private void uploadBizCase(Object[] bizCaseIds) {
        List<Map<String, String>> bizCases = this.loadBizCases(bizCaseIds);
        this.prepareAndSend(DATA_COLLECT_EVENTNAME_CASE, bizCases);
    }

    private void uploadBizExtPlugin(Object[] bizCaseIds) {
        List<Map<String, String>> extPlugins = this.loadExtPlugins(bizCaseIds);
        this.prepareAndSend(DATA_COLLECT_EVENTNAME_PLUGIN, extPlugins);
    }

    private List<Map<String, String>> loadBizCases(Object[] bizCaseIds) {
        Map objs = bizCaseIds == null || bizCaseIds.length == 0 ? BusinessDataServiceHelper.loadFromCache((String)FORM_BIZ_EXT_CASE, (QFilter[])new QFilter[0]) : BusinessDataServiceHelper.loadFromCache((Object[])bizCaseIds, (String)FORM_BIZ_EXT_CASE);
        ArrayList<Map<String, String>> bizCases = new ArrayList<Map<String, String>>(objs.size());
        for (Map.Entry entry : objs.entrySet()) {
            bizCases.add(this.packBizCase((DynamicObject)entry.getValue()));
        }
        return bizCases;
    }

    private Map<String, String> packBizCase(DynamicObject bizCaseObj) {
        DynamicObject entityObj;
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put(KEY_NUMBER, bizCaseObj.getString(KEY_NUMBER));
        map.put(KEY_NAME, bizCaseObj.getString(KEY_NAME));
        map.put(KEY_CASE_INTERFACE, bizCaseObj.getString(KEY_CASE_INTERFACE));
        map.put("isv", bizCaseObj.getString("isv"));
        map.put("createtime", bizCaseObj.getString("createtime"));
        DynamicObject appObj = bizCaseObj.getDynamicObject(KEY_CASE_BIZAPP);
        if (appObj != null) {
            map.put(KEY_CASE_APPID, appObj.getString(KEY_NUMBER));
            map.put(KEY_CASE_APPNAME, appObj.getString(KEY_NAME));
        }
        if ((entityObj = bizCaseObj.getDynamicObject(KEY_CASE_OBJECTTYPE)) != null) {
            map.put(KEY_CASE_OBJECTTYPE, entityObj.getString(KEY_NUMBER));
            map.put(KEY_CASE_OBJECTTYPENAME, entityObj.getString(KEY_NAME));
        }
        map.put("from", "form");
        return map;
    }

    private List<Map<String, String>> loadExtPlugins(Object[] bizCaseIds) {
        Map objs;
        if (bizCaseIds == null || bizCaseIds.length == 0) {
            objs = BusinessDataServiceHelper.loadFromCache((String)FORM_BIZ_EXT_PLUGIN, (QFilter[])new QFilter[0]);
        } else {
            QFilter qFilter = new QFilter(KEY_PLUGIN_BIZEXTCASE, "in", (Object)bizCaseIds);
            objs = BusinessDataServiceHelper.loadFromCache((String)FORM_BIZ_EXT_PLUGIN, (QFilter[])new QFilter[]{qFilter});
        }
        ArrayList<Map<String, String>> extPlugs = new ArrayList<Map<String, String>>(objs.size());
        for (Map.Entry entry : objs.entrySet()) {
            extPlugs.add(this.packExtPlugin((DynamicObject)entry.getValue()));
        }
        return extPlugs;
    }

    private Map<String, String> packExtPlugin(DynamicObject extPluginObj) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        DynamicObject bizCase = extPluginObj.getDynamicObject(KEY_PLUGIN_BIZEXTCASE);
        if (bizCase != null) {
            map.put(KEY_PLUGIN_BIZCASENUMBER, bizCase.getString(KEY_NUMBER));
            map.put(KEY_PLUGIN_BIZCASENAME, bizCase.getString(KEY_NAME));
            map.put(KEY_CASE_INTERFACE, bizCase.getString(KEY_CASE_INTERFACE));
        }
        map.put(KEY_PLUGIN_PLUGINCLASS, extPluginObj.getString(KEY_PLUGIN_BILLNO));
        map.put(KEY_PLUGIN_SEQ, extPluginObj.getString(KEY_PLUGIN_PLUGINSEQ));
        map.put("isv", extPluginObj.getString("isv"));
        map.put("createtime", extPluginObj.getString("createtime"));
        map.put("from", "form");
        return map;
    }

    private void prepareAndSend(String eventName, List<Map<String, String>> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        Long groupId = IDService.get().genLongId();
        int i = 0;
        boolean isOk = true;
        while (isOk) {
            List<Map<String, String>> needList = null;
            needList = this.copyList(dataList, i * batchSize, batchSize);
            Map<String, Object> sendDatas = this.buildSendDatas(eventName, groupId, needList);
            this.sendMessage(sendDatas);
            if (++i * batchSize < dataList.size()) continue;
            isOk = false;
        }
    }

    private Map<String, Object> buildSendDatas(String eventName, Long groupId, List<Map<String, String>> custDatas) {
        HashMap<String, Object> sendDatas = new HashMap<String, Object>();
        ArrayList dataList = new ArrayList(custDatas.size());
        for (Map<String, String> custData : custDatas) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("uid", RequestContext.get().getCurrUserId());
            config.put("event_id", Instance.getClusterName() + IDService.get().genLongId());
            config.put("dc_id", RequestContext.get().getAccountId());
            config.put("tenant_id", RequestContext.get().getTenantId());
            config.put("tenant_code", RequestContext.get().getTenantId());
            config.put("app_id", "bos");
            config.put("form_id", this.getFormId(eventName));
            config.put("bill_form_id", this.getFormId(eventName));
            config.put("event_name", eventName);
            config.put("var", custData);
            config.put("time", System.currentTimeMillis());
            config.put("instance_number", this.getInstanceCode());
            dataList.add(config);
        }
        sendDatas.put("project", this.getProjectId());
        sendDatas.put("store", this.getStoreId());
        sendDatas.put("groupid", groupId);
        sendDatas.put("data", dataList);
        return sendDatas;
    }

    private void sendMessage(Map<String, Object> datas) {
        String msg = this.buildWebSocketAction("sendKDBussinessData", datas);
        List<String> webSocketIds = this.getWebStockId();
        for (String webSocketId : webSocketIds) {
            if (log.isInfoEnabled()) {
                log.info("upload biz ext case by webSocket.");
            }
            MsgSendFactory.getSender().send(webSocketId, msg);
        }
    }

    private String buildWebSocketAction(String actionName, Object param) {
        ArrayList acts = new ArrayList(10);
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>();
        action.put("p", paras);
        if (param instanceof List) {
            List p = (List)param;
            paras.addAll(p);
        } else {
            paras.add(param);
        }
        acts.add(action);
        return SerializationUtils.toJsonString(acts);
    }

    private List<String> getWebStockId() {
        RequestContext rc = RequestContext.get();
        String curSessionId = rc.getGlobalSessionId();
        List webSocketIds = WebSocketIdReader.getWebSocketIds((String)rc.getAccountId(), (String)curSessionId);
        HashSet set = new HashSet(webSocketIds);
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.rootPageId) && set.contains(this.rootPageId)) {
            list.add(this.rootPageId);
            return list;
        }
        return webSocketIds;
    }

    private String getProjectId() {
        if (this.isProductEnv()) {
            return DATA_COLLECT_PROJECT;
        }
        return DATA_COLLECT_PROJECT_TEST;
    }

    private String getStoreId() {
        return DATA_COLLECT_STOREID;
    }

    private String getInstanceCode() {
        if (this.isLoadInstanceCode) {
            return this.instanceCode;
        }
        Map map = LicenseServiceHelper.getProductInfo();
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                if (!StringUtils.isEmpty((CharSequence)this.instanceCode)) continue;
                this.instanceCode = (String)entry.getValue();
                break;
            }
        }
        this.isLoadInstanceCode = true;
        return this.instanceCode;
    }

    private List<Map<String, String>> copyList(List<Map<String, String>> src, int start, int length) {
        ArrayList<Map<String, String>> reutrnList = new ArrayList<Map<String, String>>(length);
        if (src != null && src.size() > start) {
            for (int i = 0; i < length && i + start < src.size(); ++i) {
                reutrnList.add(src.get(i + start));
            }
        }
        return reutrnList;
    }

    private boolean isProductEnv() {
        return true;
    }

    private String getFormId(String eventName) {
        if (DATA_COLLECT_EVENTNAME_CASE.equals(eventName)) {
            return FORM_BIZ_EXT_CASE;
        }
        return FORM_BIZ_EXT_PLUGIN;
    }
}

