/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizobjext;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.bizobjext.DesignerDataUtil;
import kd.bos.designer.dao.DesignerData;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;

public class BizobjectExtPreviewPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BizobjectExtPreviewPlugin.class);
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String MODE_TYPE = "modelType";
    private static final String DESIGNER = "designer";
    private static final String LIST_META = "ListMeta";
    private static final String MOB_META = "MobMeta";
    private static final String MOB_LIST_META = "MobListMeta";
    private static final String PREFIX_MOB = "Mob";
    private static final String FORM_ID = "formId";
    private static final String SHOW_FORM_LANG_PARAM = "formConfigShowLang";
    private static final String BOS_MOBILEPREVIEW = "bos_mobilepreview";
    private static final String PREVIEWLANG = "preview_lang";
    private static final String MOCK_TEST_SUFFIX = "_qkzmt";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_bizextmeta");
        String id = (String)this.getCustomParam("id");
        DynamicObject data = (DynamicObject)BusinessDataReader.read((Object)id, (IDataEntityType)type, (Boolean)false);
        String status = data.getString("status");
        this.getView().setVisible(Boolean.FALSE, new String[]{"labelap1"});
        if ("2".equals(status) || "3".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok", "labelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap1"});
        }
        this.doTestPreview();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if (source.getKey().equals("btncancel")) {
            this.getView().close();
        } else {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_bizextmeta");
            String id = (String)this.getCustomParam("id");
            DesignerDataUtil.updateStatus(id, "2");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("btnok", "ok");
            map.put("fid", id);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(map));
            this.getView().close();
        }
    }

    private void doTestPreview() {
        String designerName;
        switch (designerName = this.getCustomParam(DESIGNER) == null ? "" : (String)this.getCustomParam(DESIGNER)) {
            case "ListMeta": {
                this.pcListPreview();
                break;
            }
            case "MobListMeta": {
                this.mobListPreview();
                break;
            }
            case "MobMeta": {
                this.mobPreview();
                break;
            }
            default: {
                this.pcFormPreview();
            }
        }
    }

    private <T> T getCustomParam(String name) {
        return (T)this.getView().getFormShowParameter().getCustomParam(name);
    }

    private void showFormInContainer(FormShowParameter fsp) {
        fsp.getOpenStyle().setTargetKey("flexpanelap");
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm(fsp);
        if (StringUtils.isNotBlank((CharSequence)fsp.getCaption())) {
            this.getView().setFormTitle(new LocaleString(fsp.getCaption()));
        } else {
            fsp.initFormConfig();
            this.getView().setFormTitle(fsp.getFormConfig().getCaption());
        }
    }

    private void mobPreview() {
        String id = (String)this.getCustomParam("id");
        String masterId = DesignerData.getMasterId(id);
        String key = DesignerData.getNumberById(masterId);
        this.mobilePreview(key + "_qkzmt_mob", "MobileBillFormModel", "");
    }

    private void mobListPreview() {
        String id = (String)this.getCustomParam("id");
        String masterId = DesignerData.getMasterId(id);
        String key = DesignerData.getNumberById(masterId);
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        String bizAppId = bizAppService.getAppNumberByAppId(bizAppService.getAppIdByFormNum(key));
        this.mobilePreview(key + MOCK_TEST_SUFFIX, "MobileListModel", bizAppId);
    }

    protected void mobilePreview(String formId, String modelType, String bizAppId) {
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            HashMap<String, String> para = new HashMap<String, String>();
            String tempNumber = formId;
            if (modelType.startsWith(PREFIX_MOB)) {
                tempNumber = BOS_MOBILEPREVIEW;
            }
            para.put(FORM_ID, tempNumber);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
                showParameter.setCustomParam("testappid", (Object)bizAppId);
            }
            if (modelType.startsWith(PREFIX_MOB)) {
                showParameter.setCustomParam("number", (Object)formId);
                showParameter.setCustomParam(MODE_TYPE, (Object)modelType);
                showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
                showParameter.setClientParam("preview", (Object)"true");
            } else {
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
            }
            showParameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
            this.showFormInContainer(showParameter);
        }
    }

    private void pcFormPreview() {
        String id = (String)this.getCustomParam("id");
        String masterId = DesignerData.getMasterId(id);
        String number = DesignerData.getNumberById(masterId);
        if (StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        number = number + MOCK_TEST_SUFFIX;
        HashMap<String, String> para = new HashMap<String, String>();
        para.put(FORM_ID, number);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
        this.showFormInContainer(showParameter);
    }

    private void pcListPreview() {
        String id = (String)this.getCustomParam("id");
        String masterId = DesignerData.getMasterId(id);
        String key = DesignerData.getNumberById(masterId);
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        String bizAppId = bizAppService.getAppNumberByAppId(bizAppService.getAppIdByFormNum(key));
        key = key + MOCK_TEST_SUFFIX;
        String modelType = (String)this.getCustomParam(MODE_TYPE);
        if (modelType == null || modelType.equalsIgnoreCase("WidgetFormModel") || modelType.equalsIgnoreCase("DynamicFormModel")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u4e0d\u5b58\u5728\u5217\u8868\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"FormDesignerPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(key);
        parameter.setAppId(bizAppId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
        Object newpagevalue = this.getView().getFormShowParameter().getCustomParam("newpage");
        if (newpagevalue != null) {
            parameter.setCustomParam("newpage", newpagevalue);
        }
        this.showFormInContainer((FormShowParameter)parameter);
    }

    protected String getPreviewLang() {
        Object lang = this.getCustomParam(PREVIEWLANG);
        return lang == null ? RequestContext.get().getLang().toString() : lang.toString();
    }
}

