/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizobjext;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.extensible.BizObjExtMeta;
import kd.bos.metadata.extensible.BizObjExtPreviewService;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class DesignerDataUtil {
    private static final Log LOG = LogFactory.getLog(DesignerDataUtil.class);

    public static FormShowParameter createTestViewShowParameter(String id, String showType, String previewLang) {
        BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(BizObjExtMeta.class), (Boolean)false);
        BizObjExtPreviewService.buildTestRuntimeMeta((String)id);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_bizextpreview");
        formShowParameter.setCustomParam("designer", (Object)showType);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("modelType", (Object)bizObjExtMeta.getModelType());
        formShowParameter.setCustomParam("preview_lang", (Object)previewLang);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if ("MobListMeta".equals(showType) || "MobMeta".equals(showType)) {
            formShowParameter.setShowTitle(false);
        }
        return formShowParameter;
    }

    public static void createDeployShowParameter(AbstractFormPlugin formPlugin, String id, String callBackId) {
        BizObjExtMeta meta = (BizObjExtMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(BizObjExtMeta.class), (Boolean)false);
        if (meta.getStatus().equals("3")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u4fee\u6539\u5df2\u53d1\u5e03\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03\u3002", (String)"DesignerDataUtil_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        if (meta.getStatus().equals("1") || meta.getStatus().equals("0")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u6a21\u62df\u6d4b\u8bd5\uff0c\u518d\u6267\u884c\u53d1\u5e03\u3002", (String)"DesignerDataUtil_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        if (!meta.getStatus().equals("2")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f7b\u6269\u5c55\u6570\u636e\u672a\u77e5\u72b6\u6001\u3002", (String)"DesignerDataUtil_2", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_bizobjext_publishtip");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, callBackId));
        formPlugin.getView().showForm(formShowParameter);
    }

    public static Map<String, Object> extDeploy(String id) {
        Map result;
        BizObjExtPreviewService.startTestMode((String)id);
        BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(BizObjExtMeta.class), (Boolean)false);
        MetadataReader metadataReader = new MetadataReader();
        FormMetadata formMetadata = (FormMetadata)metadataReader.readMeta(id, OrmUtils.getDataEntityType(DesignFormMeta.class), true);
        MetadataWriter metadataWriter = new MetadataWriter(bizObjExtMeta.getModelType());
        if (formMetadata.getId().equals(formMetadata.getEntityId())) {
            EntityMetadata entityMetadata = (EntityMetadata)metadataReader.readMeta(id, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
            result = metadataWriter.save(new AbstractMetadata[]{formMetadata, entityMetadata});
        } else {
            result = metadataWriter.save(new AbstractMetadata[]{formMetadata});
        }
        BizObjExtPreviewService.endTestMode();
        DesignerDataUtil.updatePublishStatus(id);
        return result;
    }

    static void updatePublishStatus(String id) {
        String sql = "update t_meta_bizobj_ext set fstatus = '3',fispublished = '1', fmodifydate = ? ,fmodifier = ?   where fid = ? ";
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{new Date(), RequestContext.get().getCurrUserId(), id});
        DesignerDataUtil.clearBizExtCache(id);
    }

    static void updateStatus(String id, String status) {
        String sql = "update t_meta_bizobj_ext set fstatus =  ?  ,fmodifydate = ? ,fmodifier = ? where fid = ? ";
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{status, new Date(), RequestContext.get().getCurrUserId(), id});
        DesignerDataUtil.clearBizExtCache(id);
    }

    public static void clearBizExtCache(Object id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_bizextmeta");
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        cacheManager.removeByFilterDt();
        cacheManager.removeByPrimaryKey(new Object[]{id});
    }

    public static List<AbstractDesignMeta> rollbackExtBillMetadataToBegin(String billId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)billId, (MetaCategory)MetaCategory.Form);
        FormMetadata parentFormMetadata = (FormMetadata)MetadataDao.readMeta((String)formMetadata.getParentId(), (MetaCategory)MetaCategory.Form);
        formMetadata.getItems().removeIf(o -> !(o instanceof BillFormAp));
        parentFormMetadata.getItems().removeIf(o -> o instanceof BillFormAp);
        formMetadata.getItems().addAll(parentFormMetadata.getItems());
        formMetadata.getRootAp().getItems().removeIf(o -> !(o instanceof BillFormAp));
        parentFormMetadata.getRootAp().getItems().removeIf(o -> o instanceof BillFormAp);
        formMetadata.getRootAp().getItems().addAll(parentFormMetadata.getRootAp().getItems());
        ((BillFormAp)formMetadata.getRootAp()).setListMeta(((BillFormAp)parentFormMetadata.getRootAp()).getListMeta());
        ((BillFormAp)formMetadata.getRootAp()).setMobMeta(((BillFormAp)parentFormMetadata.getRootAp()).getMobMeta());
        ((BillFormAp)formMetadata.getRootAp()).setMobListMeta(((BillFormAp)parentFormMetadata.getRootAp()).getMobListMeta());
        formMetadata.setModifyDate(new Date());
        formMetadata.setModifierId(String.valueOf(RequestContext.get().getCurrUserId()));
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)billId, (MetaCategory)MetaCategory.Entity);
        EntityMetadata parentEntityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formMetadata.getParentId(), (MetaCategory)MetaCategory.Entity);
        entityMetadata.getItems().removeIf(o -> !(o instanceof BillEntity));
        parentEntityMetadata.getItems().removeIf(o -> o instanceof BillEntity);
        entityMetadata.getItems().addAll(parentEntityMetadata.getItems());
        entityMetadata.getRootEntity().getItems().removeIf(o -> !(o instanceof BillEntity));
        parentEntityMetadata.getRootEntity().getItems().removeIf(o -> o instanceof BillEntity);
        entityMetadata.getRootEntity().getItems().addAll(parentEntityMetadata.getRootEntity().getItems());
        entityMetadata.setModifyDate(new Date());
        entityMetadata.setModifierId(String.valueOf(RequestContext.get().getCurrUserId()));
        MetadataWriter formWriter = new MetadataWriter(formMetadata.getModelType());
        return formWriter.convertToDesignMeta(new AbstractMetadata[]{formMetadata, entityMetadata});
    }

    public static boolean isLightExtOperationPermission(String appId, String permItem) {
        long userId = RequestContext.get().getCurrUserId();
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, (String)appId, (String)"bos_bizobjext", (String)permItem);
        return flag == 1;
    }
}

