/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.bizobjext;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.designer.bizobjext.DesignerDataUtil;
import kd.bos.designer.dao.DesignerData;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.extensible.BizObjExtMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.param.ParameterReader;

public class TempSaveDesignerData
extends DesignerData {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    @Override
    public Map<String, Object> save(Map<String, Object> content, Map<String, Object> oldContent) {
        Map<String, Object> result = this.checkBasedataProperty(content, oldContent);
        if (((Boolean)result.get("success")).booleanValue() && ((Boolean)(result = super.save(content, oldContent)).get("success")).booleanValue()) {
            String message = (String)result.get("message");
            String s = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MetadataWriter_7", (String)"bos-metadata", (Object[])new Object[0]);
            result.put("message", message.replace(s, ResManager.loadKDString((String)"\u6682\u5b58\u6210\u529f\u3002\u5982\u9700\u53d1\u5e03\u8bf7\u8fdb\u884c\u6a21\u62df\u6d4b\u8bd5\uff0c\u6d4b\u8bd5\u5b8c\u6210\u540e\u53ef\u53d1\u5e03\u3002", (String)"TempSaveDesignerData_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        }
        return result;
    }

    private Map<String, Object> checkBasedataProperty(Map<String, Object> content, Map<String, Object> oldContent) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", true);
        Map formMeta = (Map)content.get("formmeta");
        String id = (String)formMeta.get("Id");
        String entityId = (String)formMeta.get("EntityId");
        if (!StringUtils.equals((CharSequence)id, (CharSequence)entityId)) {
            return result;
        }
        String modelType = (String)formMeta.get("ModelType");
        AbstractMetadata metadata = this.convertTo(content, modelType);
        EntityMetadata entityMetadata = ((FormMetadata)metadata).getEntityMetadata();
        AbstractMetadata oldMetadata = this.convertTo(oldContent, modelType);
        EntityMetadata oldEntityMetadata = ((FormMetadata)oldMetadata).getEntityMetadata();
        HashMap<String, String> tables = new HashMap<String, String>(16);
        if (oldEntityMetadata != null) {
            List entityList = oldEntityMetadata.getItems();
            for (EntityItem entity : entityList) {
                String mulTb;
                if (!(entity instanceof MulBasedataField) || entity.isInherit() || !StringUtils.isNotBlank((CharSequence)(mulTb = ((MulBasedataField)entity).getTableName()))) continue;
                tables.put(((MulBasedataField)entity).getId(), mulTb);
            }
        }
        if (entityMetadata != null) {
            String dbKey = entityMetadata.getDBRouteKey();
            List entityList = entityMetadata.getItems();
            for (EntityItem entity : entityList) {
                String isv;
                String msg;
                String msg2;
                if (entity.isInherit()) continue;
                if (entity instanceof BasedataField) {
                    BasedataField basedataField = (BasedataField)entity;
                    String basedataType = basedataField.getBaseEntityId();
                    if (!StringUtils.isBlank((CharSequence)basedataType)) continue;
                    msg2 = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u7684\u201c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201d\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TempSaveDesignerData_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), basedataField.getName().toString(), basedataField.getKey());
                    this.addBuildError(2, "BaseEntityId", msg2, entityMetadata);
                    continue;
                }
                if (entity instanceof BasedataPropField) {
                    BasedataPropField basedataPropField = (BasedataPropField)entity;
                    String refBaseId = basedataPropField.getRefBaseFieldId();
                    if (!StringUtils.isBlank((CharSequence)refBaseId)) continue;
                    msg2 = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u7684\u201c\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u201d\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TempSaveDesignerData_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), basedataPropField.getName().toString(), basedataPropField.getKey());
                    this.addBuildError(2, "BaseEntityId", msg2, entityMetadata);
                    continue;
                }
                if (!(entity instanceof MulBasedataField)) continue;
                MulBasedataField mulBasedataField = (MulBasedataField)entity;
                String mulBasedataId = mulBasedataField.getId();
                String mulBasedataTb = mulBasedataField.getTableName();
                String mulBaseEntityId = mulBasedataField.getBaseEntityId();
                if (StringUtils.isBlank((CharSequence)mulBaseEntityId)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u7684\u201c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201d\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TempSaveDesignerData_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mulBasedataField.getName().toString(), mulBasedataField.getKey());
                    this.addBuildError(2, "BaseEntityId", msg, entityMetadata);
                }
                if (StringUtils.isBlank((CharSequence)mulBasedataTb)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u7684\u201c\u8868\u540d\u201d\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TempSaveDesignerData_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mulBasedataField.getName().toString(), mulBasedataField.getKey());
                    this.addBuildError(2, "TableName", msg, entityMetadata);
                }
                if (!StringUtils.isNotBlank((CharSequence)mulBasedataTb) || mulBasedataTb.equals(tables.get(mulBasedataId))) continue;
                if (DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)mulBasedataField.getTableName())) {
                    msg = String.format(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u3010%s\u3011\u7684\u8868\u540d\u4e0d\u53ef\u914d\u7f6e\u5df2\u6709\u8868\u3002", (String)"TempSaveDesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mulBasedataField.getName().toString());
                    this.addBuildError(2, "TableName", msg, entityMetadata);
                }
                if ("kingdee".equalsIgnoreCase(isv = ISVService.getISVInfo().getId())) {
                    return result;
                }
                if (!TempSaveDesignerData.isNeedCheckIsv()) {
                    return result;
                }
                if (this.isStartWithNumber(isv)) {
                    return result;
                }
                String tablePrefixCheck = "tk_" + isv + "_";
                if (StringUtils.startsWithIgnoreCase((CharSequence)mulBasedataTb, (CharSequence)tablePrefixCheck)) continue;
                String msg3 = String.format(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u3010%1$s\u3011\u7684\u8868\u540d\u201c%2$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff1a\u524d\u7f00\u5fc5\u987b\u4e3a\u201c%3$s\u201d\u3002", (String)"TempSaveDesignerData_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mulBasedataField.getName().toString(), mulBasedataField.getTableName(), tablePrefixCheck);
                this.addBuildError(2, "TableName", msg3, entityMetadata);
            }
        }
        if (entityMetadata != null && !entityMetadata.getBuildErrors().isEmpty() && entityMetadata.getBuildErrors().stream().allMatch(error -> error.getLevel() == 2)) {
            List errors = entityMetadata.getBuildErrors().stream().filter(error -> error.getLevel() == 2).collect(Collectors.toList());
            result.put("success", false);
            result.put("errors", errors);
        }
        return result;
    }

    private static boolean isNeedCheckIsv() {
        Map cache = ParameterReader.loadPublicParameterFromCache();
        if (null == cache || cache.isEmpty()) {
            return true;
        }
        Object needIsvCheck = cache.get("designer_isv_check");
        if (null == needIsvCheck) {
            return true;
        }
        return (Boolean)needIsvCheck;
    }

    private boolean isStartWithNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        char first = str.trim().charAt(0);
        return first >= '0' && first <= '9';
    }

    @Override
    protected MetadataWriter getMetadataWriter(String modelType) {
        MetadataWriter metadataWriter = new MetadataWriter(modelType){

            protected List<AbstractDesignMeta> saveMeta(boolean isDraft, AbstractMetadata ... metadatas) {
                List designDatas = this.convertToDesignMeta(metadatas);
                IDataEntityType dataEntityType = OrmUtils.getDataEntityType(BizObjExtMeta.class);
                BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)metadatas[0].getId(), (IDataEntityType)dataEntityType, (Boolean)false);
                for (AbstractDesignMeta designData : designDatas) {
                    if (designData instanceof DesignFormMeta) {
                        bizObjExtMeta.setFormdata(designData.getDataXml());
                        continue;
                    }
                    if (!(designData instanceof DesignEntityMeta)) continue;
                    bizObjExtMeta.setEntitydata(designData.getDataXml());
                }
                try {
                    this.saveFlowReference(metadatas);
                }
                catch (KDException e) {
                    e.printStackTrace();
                }
                String sql = "update t_meta_bizobj_ext set fformdata_tag = ? ,fentitydata_tag = ? ,fstatus = ?,fmodifydate = ? ,fmodifier = ? where fid = ? ";
                DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{bizObjExtMeta.getFormdata(), bizObjExtMeta.getEntitydata(), "1", new Date(), RequestContext.get().getCurrUserId(), bizObjExtMeta.getId()});
                DesignerDataUtil.clearBizExtCache(bizObjExtMeta.getId());
                return designDatas;
            }
        };
        return metadataWriter;
    }

    @Override
    protected Map<String, Object> checkIsv(Map<String, Object> content, AbstractMetadata metadata, String currentIsv) {
        return null;
    }
}

