/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.botp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormulaEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public static final String FormId_Formula = "botp_formula";
    public static final String FormId_Condition = "botp_condition";
    public static final String CustParamKey_Formula = "formula";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    public static final String CustParamKey_FunctionTypes = "functiontypes";
    public static final String CustParamKey_OnlyHeadField = "onlyheadfield";
    public static final String Key_FExpression = "fexpression";
    public static final String Key_FDescription = "fdescription";
    public static final String Key_FTranExpr = "ftranexpr";
    public static final String Key_FFilterGrid = "ffiltergrid";
    public static final String Key_TreeView = "tv_fields";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_btnFunction = "btnfunction";
    public static final String Key_btnClr = "clr";
    public static final String Key_btnBackSpace = "backspace";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        this.addClickListeners(new String[]{Key_btnFunction, Key_btnClr, Key_btnBackSpace});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright"});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_Formula);
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.setFormulaObj(formulaObj);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_Formula);
            CRFormula formulaObj = this.deserialize(conditonJson);
            this.getFormulaObj(formulaObj);
            try {
                String tranExpr = this.tranFormula(formulaObj);
                formulaObj.setExprTran(tranExpr);
            }
            catch (FormulaException exp) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"FormulaEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
                return;
            }
            catch (Exception exp) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"FormulaEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), exp.getMessage()));
                return;
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)Key_btnFunction)) {
            this.showFuncSetting();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)Key_btnClr)) {
            this.getModel().setValue(Key_FExpression, (Object)"");
            FormulaEditHelper.setCursorIndex(this.getView(), Key_FExpression, 0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)Key_btnBackSpace)) {
            FormulaEditHelper.backSpaceExpression(this.getView(), Key_btnBackSpace, Key_FExpression);
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        FormulaEditHelper.insertExpression(this.getView(), Key_TreeView, Key_FExpression, e.getNodeId().toString());
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(Key_FExpression)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            catch (Exception exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"FormulaEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_btnFunction)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.receiveFuncSetting((String)closedCallBackEvent.getReturnData());
        }
    }

    protected CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        this.getModel().setValue(Key_FExpression, (Object)formulaObj.getExpression());
        this.getModel().setValue(Key_FDescription, (Object)formulaObj.getDescription().toString());
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
    }

    protected void getFormulaObj(CRFormula formulaObj) {
        String expression = (String)this.getModel().getValue(Key_FExpression);
        formulaObj.setExpression(expression);
        String desc = (String)this.getModel().getValue(Key_FDescription);
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
    }

    private void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(node);
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"FormulaEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression(this.getView(), compareKey, Key_FExpression, compareValue);
        }
    }

    protected String tranFormula(CRFormula formulaObj) {
        String expressionDesc = this.tranExpression(formulaObj.getExpression());
        return expressionDesc;
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    private void showFuncSetting() {
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_FunctionTypes);
        if (StringUtils.isBlank((CharSequence)funcsXML) && StringUtils.isBlank((CharSequence)(funcsXML = this.getPageCache().get(CustParamKey_FunctionTypes)))) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put(CustParamKey_FunctionTypes, funcsXML);
        }
        String jsonNode = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Key_btnFunction);
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void receiveFuncSetting(String funcSetting) {
        FormulaEditHelper.insertExpression(this.getView(), Key_btnFunction, Key_FExpression, funcSetting);
    }
}

