/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DynamicComponentAssemble;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.designer.dao.PrintFormTemplate;
import kd.bos.devportal.common.extplugin.IDesignerDataExtPlugin;
import kd.bos.devportal.common.extplugin.PluginProxyImpl;
import kd.bos.devportal.common.extplugin.event.DesignerDataCheckEvent;
import kd.bos.entity.SummaryToField;
import kd.bos.entity.datamodel.DefaultValueCalculator;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.control.UrlUtil;
import kd.bos.isv.ISVService;
import kd.bos.kflow.api.IFlowDesignService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.balance.checker.BalanceTbChecker;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.dao.converter.IMetadataConverter;
import kd.bos.metadata.dao.converter.PrintMetadataConverter;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.GroupField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.ItemClassTypeField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.GeoPointField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.entity.operation.KFlowOpParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.filter.CommonFilterColumnAp;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.MobileBillFormAp;
import kd.bos.metadata.form.MobileFormAp;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.ExchangeRateGroupCheckUtil;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.FlatFieldAp;
import kd.bos.metadata.form.control.HtmlAp;
import kd.bos.metadata.form.control.HyperlinkAp;
import kd.bos.metadata.form.mcontrol.MobCommonBaseDataFilterColumnAp;
import kd.bos.metadata.form.mcontrol.MobCommonCheckBoxFilterColumnAp;
import kd.bos.metadata.form.mcontrol.MobCommonDateFilterColumnAp;
import kd.bos.metadata.form.mcontrol.MobCommonFilterColumnAp;
import kd.bos.metadata.form.mcontrol.mobtable.MobTableAp;
import kd.bos.metadata.form.mcontrol.mobtable.tablecolumn.MobTableColumnAp;
import kd.bos.metadata.form.rule.FormRule;
import kd.bos.metadata.kflow.enums.RuleType;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.MobileListAp;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.metadata.report.ReportFilterAp;
import kd.bos.metadata.report.ReportListAp;
import kd.bos.mservice.svc.attach.IAttachmentCountField;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

@SdkPublic
public class DesignerData {
    private String localeId = "zh_CN";
    private static final String UPDATE_SQL = "update %s set  fbizappid = ? where fformid = ?";
    private static final String TABLENAME = "t_meta_bizunitrelform";
    private static final String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    protected static final String MODEL_TYPE = "modelType";
    private static final String BIZ_APPID = "bizappid";
    private static final String ENTITY_ID = "entityId";
    private static final String DB_ROUTE = "dbroute";
    protected static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    protected static final String FORM_META = "formmeta";
    private static final String MODEL_TYPE_1 = "ModelType";
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String TABLE_NAME = "TableName";
    protected static final String FIELD_KEY = "FieldKey";
    private static final String BOS_METADATA = "bos-metadata";
    private static final String BASE_FORM_MODEL = "BaseFormModel";
    private static final String FIELD_NAME = "FieldName";
    protected static ExecutorService es = ThreadPools.newCachedExecutorService((String)"DesignerData-Thread", (int)3, (int)100);
    private static final Log log = LogFactory.getLog(DesignerData.class);
    private IFlowDesignService flowService = null;
    private static final List<String> SYS_TPL_LIST = new ArrayList<String>();
    static final Interner<String> METALOCK;
    private static String checkNumber;
    private static boolean ignoreCheckNumber;

    private IMetadataConverter getMetadataConverter(String modeType) {
        if (modeType.equals("PrintModel")) {
            return new PrintMetadataConverter();
        }
        return new FormMetadataConverter();
    }

    private IFlowDesignService getKFlowService() {
        if (this.flowService == null) {
            this.flowService = (IFlowDesignService)ServiceFactory.getService(IFlowDesignService.class);
        }
        return this.flowService;
    }

    public Map<String, Object> copyMeta(Map<String, Object> parameters) {
        BillListAp billListAp;
        String modelType = (String)parameters.get(MODEL_TYPE);
        String key = (String)parameters.get("id");
        Object objName = parameters.get("name");
        LocaleString name = null;
        if (objName instanceof LocaleString) {
            name = (LocaleString)objName;
        } else if (objName instanceof OrmLocaleValue) {
            HashMap<String, String> localNameMap = new HashMap<String, String>(16);
            for (String loId : ((OrmLocaleValue)objName).keySet()) {
                localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
            }
            name = LocaleString.fromMap(localNameMap);
        } else {
            name = new LocaleString(this.localeId, (String)objName);
        }
        String srcFormId = (String)parameters.get("srcFormId");
        String bizappid = (String)parameters.get(BIZ_APPID);
        String parentId = (String)parameters.get("parentId");
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)srcFormId, (MetaCategory)MetaCategory.Form);
        if (!StringUtils.equals((CharSequence)formMeta.getId(), (CharSequence)formMeta.getEntityId())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u8be5\u7c7b\u578b\u5355\u636e\u4e0d\u652f\u6301\u590d\u5236\u3002", (String)"DesignerData_89", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
        formMeta.setId(DBServiceHelper.genStringId());
        formMeta.setModelType(modelType);
        formMeta.setParentId(parentId);
        formMeta.setKey(key);
        formMeta.setName(name);
        this.repairJsPluginForCopyMeta(formMeta, bizappid);
        String entityId = formMeta.getEntityId();
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        entityMeta.setId(formMeta.getId());
        entityMeta.setModelType(modelType);
        entityMeta.getRootEntity().setTemplate(false);
        if (entityMeta.getRootEntity() instanceof BillEntity) {
            ((BillEntity)entityMeta.getRootEntity()).setDefaultPageSetting("{\"mblist\":\"\",\"pclist\":\"\",\"pcbill\":\"\",\"mbbill\":\"\"}");
        }
        entityId = formMeta.getId();
        String mobListEntityId = (String)parameters.get("mobListEntityId");
        if (StringUtils.isNotBlank((CharSequence)mobListEntityId) && (billListAp = (BillListAp)formMeta.getItem("1DRUs1sCNW")) != null) {
            billListAp.setEntityId(mobListEntityId);
        }
        DynamicObject bizappObj = null;
        if (StringUtils.isNotBlank((CharSequence)bizappid)) {
            bizappObj = BusinessDataServiceHelper.loadSingle((Object)bizappid, (String)"bos_devportal_bizapp", (String)"industry,dbroute");
        }
        entityMeta.setKey(key);
        entityMeta.setName(name);
        entityMeta.getRootEntity().setKey(key);
        if (bizappObj == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"bizappid\u4e3a\u7a7a\u3002", (String)"DesignerData_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
        String dbRoute = bizappObj.getString(DB_ROUTE);
        entityMeta.getRootEntity().setdbRoute(dbRoute);
        formMeta.setBizappId(bizappid);
        entityMeta.setBizappId(bizappid);
        formMeta.bindEntityMetadata(entityMeta);
        formMeta.setEntityId(entityId);
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"DesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])});
        }
        entityMeta.setIsv(currentIsv);
        formMeta.setIsv(currentIsv);
        String envRegion = DevportalCommonUtil.genEnvRegion();
        entityMeta.setEnvRegion(envRegion);
        formMeta.setEnvRegion(envRegion);
        return formMeta.buildDesignMeta(this.localeId);
    }

    private void repairJsPluginForCopyMeta(FormMetadata formMetadata, String bizAppId) {
        BillFormAp billFormAp;
        FormMetadata mobMeta;
        FormAp rootAp = formMetadata.getRootAp();
        String formId = formMetadata.getId();
        String formNumber = formMetadata.getKey();
        LocaleString formName = formMetadata.getName();
        this.checkJsPlugin(rootAp, formId, formNumber, formName, bizAppId);
        if (rootAp instanceof BillFormAp && (mobMeta = (billFormAp = (BillFormAp)rootAp).getMobMeta()) != null) {
            FormAp mobFormAp = mobMeta.getRootAp();
            this.checkJsPlugin(mobFormAp, formId, formNumber + "_mob", formName, bizAppId);
        }
    }

    private void checkJsPlugin(FormAp formAp, String formId, String formNumber, LocaleString formName, String bizAppId) {
        List jsPlugins = formAp.getJsPlugins();
        boolean hasSelfJsPlugin = false;
        if (!CollectionUtils.isEmpty((Collection)jsPlugins)) {
            for (Plugin jsPlugin : jsPlugins) {
                if (jsPlugin.isInherit()) continue;
                hasSelfJsPlugin = true;
                String sourcePk = jsPlugin.getFpk();
                String targetPk = Uuid8.generateShortUuid();
                jsPlugin.setFpk(targetPk);
                String className = formId + "_" + targetPk;
                jsPlugin.setClassName(className);
                jsPlugin.setSourceName(formName);
                jsPlugin.setSourceNumber(formNumber);
                DynamicObject sourceJsPlugin = BusinessDataServiceHelper.loadSingleFromCache((Object)sourcePk, (String)"ide_pluginscript");
                if (sourceJsPlugin == null) break;
                this.copyJsPlugin(targetPk, sourceJsPlugin, formNumber, bizAppId);
                break;
            }
        }
        if (!hasSelfJsPlugin) {
            Plugin initialJsPlugin = new Plugin();
            initialJsPlugin.setRowKey(formAp.getJsPlugins().size());
            initialJsPlugin.setEnabled(true);
            initialJsPlugin.setFpk(Uuid8.generateShortUuid());
            String className = formId + "_" + initialJsPlugin.getFpk();
            initialJsPlugin.setClassName(className);
            initialJsPlugin.setSourceNumber(formNumber);
            initialJsPlugin.setSourceName(formName);
            formAp.getJsPlugins().add(initialJsPlugin);
        }
    }

    private void copyJsPlugin(String jsPluginPk, DynamicObject sourceJsPlugin, String formNumber, String bizAppId) {
        DynamicObject scriptDynamicObj = BusinessDataServiceHelper.newDynamicObject((String)"ide_pluginscript");
        scriptDynamicObj.set("id", (Object)jsPluginPk);
        String name = String.format("%s_JSScript_%s", formNumber, jsPluginPk);
        scriptDynamicObj.set("txt_scriptname", (Object)name);
        scriptDynamicObj.set("txt_scriptnumber", (Object)name);
        scriptDynamicObj.set("cmb_ftype", (Object)"1");
        scriptDynamicObj.set("cbox_script_type", (Object)"14");
        scriptDynamicObj.set("txt_scriptcontext_tag", (Object)sourceJsPlugin.getString("txt_scriptcontext_tag"));
        scriptDynamicObj.set(BIZ_APPID, (Object)bizAppId);
        scriptDynamicObj.set("bizunitid", (Object)"");
        scriptDynamicObj.set("creater", (Object)RequestContext.get().getCurrUserId());
        scriptDynamicObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        String formatStr = "yyyy-MM-dd HH:mm:ss";
        Timestamp timestamp = Timestamp.valueOf(new SimpleDateFormat(formatStr).format(new Date()));
        scriptDynamicObj.set("createdate", (Object)timestamp);
        scriptDynamicObj.set("modifydate", (Object)timestamp);
        scriptDynamicObj.set("isv", (Object)ISVService.getISVInfo().getId());
        scriptDynamicObj.set("classname", (Object)"");
        scriptDynamicObj.set("enginetype", (Object)"2");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scriptDynamicObj});
    }

    private void changeHiddenToInvisible(String parentId, FormMetadata formMeta) {
        if (StringUtils.isBlank((CharSequence)parentId) || formMeta == null) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)parentId)};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"number", (QFilter[])qFilters);
        if (map.isEmpty()) {
            return;
        }
        DynamicObject tplInfo = (DynamicObject)new ArrayList(map.values()).get(0);
        String number = tplInfo.getString("number");
        if (StringUtils.isNotBlank((CharSequence)number) && SYS_TPL_LIST.contains(number)) {
            this.changeHiddenToInvisibleHandler(formMeta.getItems());
        }
    }

    private void changeHiddenToInvisibleHandler(List<ControlAp<?>> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ControlAp<?> item : items) {
            if (item.isHidden()) {
                item.setHidden(false);
                item.setInvisible(true);
            }
            if (!(item instanceof ContainerAp)) continue;
            this.changeHiddenToInvisibleHandler(((ContainerAp)item).getItems());
        }
    }

    public FormMetadata createBlankMetadata(Map<String, Object> parameters) {
        Boolean forceGen;
        EntityMetadata entityMeta;
        FormMetadata formMeta;
        String modelType = (String)parameters.get(MODEL_TYPE);
        String key = (String)parameters.get("id");
        Object objName = parameters.get("name");
        LocaleString name = null;
        if (objName instanceof LocaleString) {
            name = (LocaleString)objName;
        } else if (objName instanceof OrmLocaleValue) {
            HashMap<String, String> localNameMap = new HashMap<String, String>(16);
            for (String loId : ((OrmLocaleValue)objName).keySet()) {
                localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
            }
            name = LocaleString.fromMap(localNameMap);
        } else {
            name = new LocaleString(this.localeId, (String)objName);
        }
        String parentId = (String)parameters.get("parentId");
        Object layoutObj = parameters.get("islayout");
        String bizappid = (String)parameters.get(BIZ_APPID);
        String devType = (String)parameters.get("devType");
        devType = StringUtils.isBlank((CharSequence)devType) ? "0" : devType;
        boolean isExt = "2".equals(devType);
        boolean isLayout = false;
        if (layoutObj != null) {
            isLayout = (Boolean)layoutObj;
        }
        if (StringUtils.isBlank((CharSequence)parentId)) {
            if ("MobileListModel".equals(modelType)) {
                parentId = "766c473d000001ac";
                isLayout = false;
            } else if ("ReportFormModel".equals(modelType)) {
                parentId = "1b760aa100003bac";
            }
        }
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        if (StringUtils.isBlank((CharSequence)parentId)) {
            formMeta = template.getFormMetadata();
        } else {
            formMeta = isExt ? (FormMetadata)MetadataDao.readBaseMeta((String)parentId, (MetaCategory)MetaCategory.Form) : (FormMetadata)MetadataDao.readRuntimeMeta((String)parentId, (MetaCategory)MetaCategory.Form);
            formMeta.setId(DBServiceHelper.genStringId());
            String inheritPath = formMeta.getInheritPath();
            formMeta.setModelType(modelType);
            formMeta.setParentId(parentId);
            if ("2".equals(devType) && !"2".equals(formMeta.getDevType())) {
                formMeta.setMasterId(parentId);
            }
            formMeta.setDevType(devType);
            if (!StringUtils.isEmpty((CharSequence)parentId)) {
                inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? parentId : inheritPath + ',' + parentId;
                formMeta.setInheritPath(inheritPath);
                this.setInheritFlag(formMeta.getItems());
            }
        }
        if ("ReportFormModel".equals(modelType) && !StringUtils.equals((CharSequence)formMeta.getDevType(), (CharSequence)"2")) {
            List controlApList = formMeta.getItems();
            for (ControlAp ap : controlApList) {
                if (ap instanceof ReportListAp) {
                    ((ReportListAp)ap).setColFilter(true);
                    ((ReportListAp)ap).setColSort(true);
                }
                if (!(ap instanceof ReportFilterAp)) continue;
                ((ReportFilterAp)ap).setFilterMustInput(true);
            }
        }
        if (StringUtils.isNotBlank((Object)parameters.get("srcBizObjId"))) {
            formMeta.setSrcBizObjId(parameters.get("srcBizObjId").toString());
        }
        formMeta.setKey(key);
        formMeta.setName(name);
        String entityId = (String)parameters.get(ENTITY_ID);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            entityMeta = isLayout ? (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity) : (!isExt ? (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity) : (EntityMetadata)MetadataDao.readBaseMeta((String)entityId, (MetaCategory)MetaCategory.Entity));
            if ("QueryListModel".equals(modelType)) {
                QueryEntity queryEntity = (QueryEntity)entityMeta.getRootEntity();
                if (parameters.get("entityName") != null) {
                    queryEntity.setEntityName((String)parameters.get("entityName"));
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)parentId)) {
            BillListAp billListAp;
            entityMeta = isLayout ? (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity) : (!isExt ? (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity) : (EntityMetadata)MetadataDao.readBaseMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity));
            entityMeta.setParentId(parentId);
            entityMeta.setId(formMeta.getId());
            entityMeta.setModelType(modelType);
            entityMeta.getRootEntity().setTemplate(false);
            if (entityMeta.getRootEntity() instanceof BillEntity && !isExt) {
                FormMetadata mobListMeta;
                ((BillEntity)entityMeta.getRootEntity()).setDefaultPageSetting("{\"mblist\":\"\",\"pclist\":\"\",\"pcbill\":\"\",\"mbbill\":\"\"}");
                FormMetadata listMeta = ((BillFormAp)formMeta.getRootAp()).getListMeta();
                if (listMeta != null) {
                    listMeta.getRootAp().setListOpenLayoutBill(null);
                }
                if ((mobListMeta = ((BillFormAp)formMeta.getRootAp()).getMobListMeta()) != null) {
                    mobListMeta.getRootAp().setListOpenLayoutBill(null);
                }
            }
            this.setInheritFlag(entityMeta.getItems());
            entityId = formMeta.getId();
            String mobListEntityId = (String)parameters.get("mobListEntityId");
            if (StringUtils.isNotBlank((CharSequence)mobListEntityId) && (billListAp = (BillListAp)formMeta.getItem("1DRUs1sCNW")) != null) {
                billListAp.setEntityId(mobListEntityId);
            }
        } else {
            entityMeta = template.getEntityMetadata();
            entityId = formMeta.getId();
            entityMeta.setId(entityId);
        }
        DynamicObject bizappObj = null;
        if (StringUtils.isNotBlank((CharSequence)bizappid)) {
            bizappObj = BusinessDataServiceHelper.loadSingle((Object)bizappid, (String)"bos_devportal_bizapp", (String)"industry,dbroute");
        }
        if (!isLayout) {
            entityMeta.setKey(key);
            entityMeta.setName(name);
            entityMeta.getRootEntity().setKey(key);
            if (bizappObj != null) {
                String dbRoute = bizappObj.getString(DB_ROUTE);
                entityMeta.getRootEntity().setdbRoute(dbRoute);
            } else {
                throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"bizappid\u4e3a\u7a7a\u3002", (String)"DesignerData_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
            }
        }
        formMeta.setBizappId(bizappid);
        entityMeta.setBizappId(bizappid);
        Boolean bl = forceGen = parameters.get("forceGen") == null ? Boolean.FALSE : (Boolean)parameters.get("forceGen");
        if (!isLayout && !isExt || forceGen.booleanValue()) {
            DynamicComponentAssemble.genNewBillTemplate(formMeta, entityMeta, modelType, parentId);
            DynamicComponentAssemble.genNewBaseTemplate(formMeta, entityMeta, modelType, parentId);
        }
        formMeta.bindEntityMetadata(entityMeta);
        formMeta.setEntityId(entityId);
        this.createMetaBuildContext(formMeta);
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"DesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])});
        }
        entityMeta.setIsv(currentIsv);
        formMeta.setIsv(currentIsv);
        String envRegion = DevportalCommonUtil.genEnvRegion();
        formMeta.setEnvRegion(envRegion);
        entityMeta.setEnvRegion(envRegion);
        this.changeHiddenToInvisible(parentId, formMeta);
        if (parameters.get("enableGlobalExtLimits") != null) {
            entityMeta.setEnableGlobalExtLimits(Boolean.TRUE.booleanValue());
            formMeta.setEnableGlobalExtLimits(Boolean.TRUE.booleanValue());
        }
        if (parameters.get("subSysId") != null) {
            entityMeta.setSubSysId((Integer)parameters.get("subSysId"));
            formMeta.setSubSysId((Integer)parameters.get("subSysId"));
        }
        return formMeta;
    }

    public Map<String, Object> createBlankModel(Map<String, Object> parameters) {
        boolean isCopy;
        boolean bl = isCopy = parameters.get("isCopy") instanceof Boolean ? (Boolean)parameters.get("isCopy") : Boolean.parseBoolean(String.valueOf(parameters.get("isCopy")));
        if (isCopy) {
            return this.copyMeta(parameters);
        }
        FormMetadata formMeta = this.createBlankMetadata(parameters);
        this.initializeJsPlugin(formMeta);
        return formMeta.buildDesignMeta(this.localeId);
    }

    private void initializeJsPlugin(FormMetadata formMetadata) {
        if (formMetadata.getItems().size() > 0 && formMetadata.getItems().get(0) instanceof FormAp) {
            FormAp rootAp = (FormAp)formMetadata.getItems().get(0);
            rootAp.initializeJsPlugin();
        }
    }

    private void createMetaBuildContext(FormMetadata formMeta) {
        MetaBuildContext context = new MetaBuildContext();
        context.setNewPage(true);
        formMeta.setBuildContext(context);
    }

    public Map<String, Object> createOriginalLayout(Map<String, Object> parameters) {
        EntityMetadata entityMeta;
        String modelType = (String)parameters.get(MODEL_TYPE);
        String key = (String)parameters.get("id");
        Object objName = parameters.get("name");
        boolean isRuntime = Boolean.parseBoolean(String.valueOf(parameters.get("isRuntime")));
        LocaleString name = null;
        if (objName instanceof LocaleString) {
            name = (LocaleString)objName;
        } else if (objName instanceof OrmLocaleValue) {
            HashMap<String, String> localNameMap = new HashMap<String, String>(16);
            for (String loId : ((OrmLocaleValue)objName).keySet()) {
                localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
            }
            name = LocaleString.fromMap(localNameMap);
        } else {
            name = new LocaleString(this.localeId, (String)objName);
        }
        String parentId = (String)parameters.get("parentId");
        Object layoutObj = parameters.get("islayout");
        String bizappid = (String)parameters.get(BIZ_APPID);
        String devType = (String)parameters.get("devType");
        devType = StringUtils.isBlank((CharSequence)devType) ? "0" : devType;
        boolean isLayout = false;
        boolean isPc = true;
        if (layoutObj != null) {
            isLayout = (Boolean)layoutObj;
        }
        if (StringUtils.isBlank((CharSequence)parentId)) {
            if ("MobileListModel".equals(modelType)) {
                parentId = "766c473d000001ac";
                isLayout = false;
                isPc = false;
            } else if ("ReportFormModel".equals(modelType)) {
                parentId = "1b760aa100003bac";
            } else if ("MobileFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType)) {
                isPc = false;
            }
        }
        String entityId = (String)parameters.get(ENTITY_ID);
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        FormMetadata formMeta = null;
        if (StringUtils.isBlank((CharSequence)parentId)) {
            if (isLayout && isPc) {
                formMeta = (FormMetadata)MetadataDao.readDefaultLayout((String)entityId, (boolean)isRuntime);
            }
            if (formMeta == null) {
                formMeta = template.getFormMetadata();
            } else {
                String id = DBServiceHelper.genStringId();
                formMeta.setParentId(formMeta.getId());
                formMeta.setInheritPath(formMeta.getInheritPath() + "," + formMeta.getId());
                formMeta.setId(id);
                formMeta.setModelType(modelType);
                formMeta.setDevType(devType);
            }
        } else {
            formMeta = (FormMetadata)MetadataDao.readDefaultLayout((String)parentId, (boolean)isRuntime);
            formMeta.setId(DBServiceHelper.genStringId());
            String inheritPath = formMeta.getInheritPath();
            formMeta.setModelType(modelType);
            formMeta.setParentId(parentId);
            if ("2".equals(devType) && !"2".equals(formMeta.getDevType())) {
                formMeta.setMasterId(parentId);
            }
            formMeta.setDevType(devType);
            if (!StringUtils.isEmpty((CharSequence)parentId)) {
                inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? parentId : inheritPath + ',' + parentId;
                formMeta.setInheritPath(inheritPath);
                this.setInheritFlag(formMeta.getItems());
            }
        }
        formMeta.setKey(key);
        formMeta.setName(new LocaleString(this.localeId, (Object)name));
        this.initializeJsPlugin(formMeta);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            entityMeta = isLayout ? (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity) : (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        } else if (StringUtils.isNotBlank((CharSequence)parentId)) {
            BillListAp billListAp;
            entityMeta = isLayout ? (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity) : (EntityMetadata)MetadataDao.readMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
            entityMeta.setParentId(parentId);
            entityMeta.setId(formMeta.getId());
            entityMeta.setModelType(modelType);
            entityMeta.getRootEntity().setTemplate(false);
            this.setInheritFlag(entityMeta.getItems());
            entityId = formMeta.getId();
            String mobListEntityId = (String)parameters.get("mobListEntityId");
            if (StringUtils.isNotBlank((CharSequence)mobListEntityId) && (billListAp = (BillListAp)formMeta.getItem("1DRUs1sCNW")) != null) {
                billListAp.setEntityId(mobListEntityId);
            }
        } else {
            entityMeta = template.getEntityMetadata();
            entityId = formMeta.getId();
            entityMeta.setId(entityId);
        }
        if (!isLayout) {
            entityMeta.setKey(key);
            entityMeta.setName(new LocaleString(this.localeId, (Object)name));
            entityMeta.getRootEntity().setKey(key);
            if (StringUtils.isNotBlank((CharSequence)bizappid)) {
                DynamicObject bizapp = BusinessDataServiceHelper.loadSingle((Object)bizappid, (String)"bos_devportal_bizapp", (String)DB_ROUTE);
                String dbRoute = bizapp.getString(DB_ROUTE);
                entityMeta.getRootEntity().setdbRoute(dbRoute);
            } else {
                throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"bizappid\u4e3a\u7a7a\u3002", (String)"DesignerData_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
            }
        }
        if (StringUtils.isNotBlank((Object)parameters.get("srcBizObjId"))) {
            formMeta.setSrcBizObjId(parameters.get("srcBizObjId").toString());
        }
        this.createMetaBuildContext(formMeta);
        formMeta.setBizappId(bizappid);
        entityMeta.setBizappId(bizappid);
        formMeta.bindEntityMetadata(entityMeta);
        formMeta.setEntityId(entityId);
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"DesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])});
        }
        formMeta.setIsv(currentIsv);
        formMeta.setEnvRegion(DevportalCommonUtil.genEnvRegion());
        return formMeta.buildDesignMeta(this.localeId);
    }

    private void checkMetaMapping(FormMetadata formMetadata, EntityMetadata entityMetadata) {
        if (formMetadata.getModelType() != BASE_FORM_MODEL && formMetadata.getModelType() != "BillFormModel" && formMetadata.getModelType() != "MobileBillFormModel") {
            return;
        }
        if (Boolean.getBoolean("ide.formdesigner.metamappingcheck.ignore")) {
            return;
        }
        BiFunction<EntityItem, EntityMetadata, Entity> getParentEntryFunc = (it, meta) -> {
            if (it == null) {
                return null;
            }
            String parentId = it.getParentId();
            Entity parent = null;
            while (StringUtils.isNotBlank((CharSequence)parentId) && parent == null) {
                EntityItem p = meta.getItemById(parentId);
                if (p instanceof Entity) {
                    parent = (Entity)p;
                    break;
                }
                if (p == null) break;
                parentId = p.getParentId();
            }
            return parent;
        };
        this.validateEntityItemMapping((Entity)entityMetadata.getRootEntity(), entityMetadata, getParentEntryFunc);
        this.validateControlMapping((ContainerAp)formMetadata.getRootAp(), entityMetadata.getRootEntity().getKey(), formMetadata, entityMetadata, getParentEntryFunc);
    }

    private void checkParentEntryAp(FormMetadata formMetadata, EntityMetadata entityMetadata) {
        for (Entity it : entityMetadata.getEntitys()) {
            if (!(it instanceof SubEntryEntity)) continue;
        }
        HashMap<String, ArrayList<EntryAp>> subEntryMap = new HashMap<String, ArrayList<EntryAp>>();
        HashMap<String, ArrayList<EntryAp>> allEntryApMap = new HashMap<String, ArrayList<EntryAp>>(10);
        for (ControlAp controlAp : formMetadata.getItems()) {
            String parentEntityId;
            EntryEntity entity;
            EntryAp entryAp;
            EntryEntity entry;
            if (!(controlAp instanceof EntryAp) || (entry = entityMetadata.getEntryById((entryAp = (EntryAp)controlAp).getEntryId())) == null) continue;
            ArrayList<EntryAp> entryApList = (ArrayList<EntryAp>)allEntryApMap.get(entry.getKey());
            if (entryApList == null) {
                entryApList = new ArrayList<EntryAp>(2);
                allEntryApMap.put(entry.getKey(), entryApList);
            }
            entryApList.add((EntryAp)controlAp);
            if (!(entry instanceof SubEntryEntity) || (entity = entityMetadata.getEntryById(parentEntityId = ((SubEntryEntity)entry).getParentId())) == null) continue;
            ArrayList<EntryAp> subList = (ArrayList<EntryAp>)subEntryMap.get(entity.getKey());
            if (subList == null) {
                subList = new ArrayList<EntryAp>();
                subEntryMap.put(entity.getKey(), subList);
            }
            subList.add(entryAp);
        }
        for (Map.Entry entry : subEntryMap.entrySet()) {
            String parentEntryKey = (String)entry.getKey();
            if (allEntryApMap.get(parentEntryKey) != null) continue;
            for (EntryAp subAp : (List)entry.getValue()) {
                this.addBuildError(1, subAp.getName().getLocaleValue(), MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5b50\u5355\u636e\u4f53{0}\u5bf9\u5e94\u7684\u7236\u5355\u636e\u4f53\uff0c\u4ee5\u786e\u4fdd\u6570\u636e\u7684\u6b63\u5e38\u5f55\u5165\u53ca\u5c55\u793a\u3002", (String)"DesignerData_83", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), subAp.getName().getLocaleValue()), entityMetadata);
            }
        }
    }

    private void validateControlMapping(ContainerAp entryAp, String currenEntryKey, FormMetadata formMetadata, EntityMetadata entityMetadata, BiFunction<EntityItem, EntityMetadata, Entity> getParentFunc) {
        List items = entryAp.getItems();
        for (ControlAp ctl : items) {
            if (ctl instanceof FieldAp) {
                Entity entry = getParentFunc.apply((EntityItem)((FieldAp)ctl).getField(), entityMetadata);
                if (entry == null || StringUtils.equalsIgnoreCase((CharSequence)entry.getKey(), (CharSequence)currenEntryKey)) continue;
                this.addBuildError(2, ctl.getName().getLocaleValue(), MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d{1}\u7684\u63a7\u5236\u5b57\u6bb5\u4e0d\u5728\u7b26\u5408\u8981\u6c42\u7684\u5b9e\u4f53\u4e0a\u3002", (String)"DesignerData_127", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ctl.getName().getLocaleValue(), ctl.getKey()), entityMetadata);
                continue;
            }
            if (!(ctl instanceof EntryAp)) continue;
            if (((EntryAp)ctl).getEntry() == null) {
                this.addBuildError(2, ctl.getName().getLocaleValue(), MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d{1}\u672a\u7ed1\u5b9a\u5b9e\u4f53\u3002", (String)"DesignerData_84", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ctl.getName().getLocaleValue(), ctl.getKey()), entityMetadata);
                continue;
            }
            this.validateControlMapping((ContainerAp)ctl, ((EntryAp)ctl).getEntry().getKey(), formMetadata, entityMetadata, getParentFunc);
        }
    }

    private void validateEntityItemMapping(Entity entity, EntityMetadata entityMetadata, BiFunction<EntityItem, EntityMetadata, Entity> getParentFunc) {
        CaseInsensitiveMap acceptedEntityKeys = new CaseInsensitiveMap(3);
        LinkedHashMap<EntityItem, Field> controlFields = new LinkedHashMap<EntityItem, Field>(10);
        acceptedEntityKeys.put(entityMetadata.getRootEntity().getKey(), entityMetadata.getRootEntity().getKey());
        if (entity instanceof EntryEntity) {
            acceptedEntityKeys.put(entity.getKey(), entity.getKey());
            Entity p = getParentFunc.apply((EntityItem)entity, entityMetadata);
            while (p != null) {
                acceptedEntityKeys.put(p.getKey(), p.getKey());
                p = getParentFunc.apply((EntityItem)p, entityMetadata);
            }
        }
        List items = entity.getItems();
        for (EntityItem entityItem : items) {
            if (entityItem instanceof BasedataPropField) {
                Field controlField = ((Field)entityItem).getControlField();
                if (controlField == null) continue;
                controlFields.put(entityItem, controlField);
                continue;
            }
            if (!(entityItem instanceof EntryEntity)) continue;
            this.validateEntityItemMapping((Entity)entityItem, entityMetadata, getParentFunc);
        }
        for (Map.Entry entry : controlFields.entrySet()) {
            Entity entry2 = getParentFunc.apply((EntityItem)entry.getValue(), entityMetadata);
            boolean isBasePropField = entry.getKey() instanceof BasedataPropField;
            Entity basePropEntry = null;
            if (isBasePropField) {
                basePropEntry = getParentFunc.apply((EntityItem)entry.getKey(), entityMetadata);
            }
            if (entry2 == null || acceptedEntityKeys.get(entry2.getKey()) == null) {
                this.addBuildError(2, ((Field)entry.getValue()).getName().getLocaleValue(), MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d{1}\u7684\u63a7\u5236\u5b57\u6bb5\u4e0d\u5728\u5f53\u524d\u5b9e\u4f53\u6216\u4e0a\u5c42\u5b9e\u4f53\u4e0a\u3002", (String)"DesignerData_85", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ((EntityItem)entry.getKey()).getName().getLocaleValue(), ((EntityItem)entry.getKey()).getKey()), entityMetadata);
                continue;
            }
            if (!isBasePropField || basePropEntry != null && StringUtils.equalsIgnoreCase((CharSequence)entry2.getKey(), (CharSequence)basePropEntry.getKey())) continue;
            this.addBuildError(2, ((Field)entry.getValue()).getName().getLocaleValue(), MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u5b57\u6bb5\u201c{0}\u201d{1}\u7684\u7ed1\u5b9a\u7684\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u4e0d\u5728\u5f53\u524d\u5b9e\u4f53\u4e0a\u3002", (String)"DesignerData_87", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ((EntityItem)entry.getKey()).getName().getLocaleValue(), ((EntityItem)entry.getKey()).getKey()), entityMetadata);
        }
    }

    public Map<String, Object> createPrintModel(Map<String, Object> parameters) {
        EntityMetadata entityMeta;
        Map<String, Object> tMap = new HashMap();
        String modelType = (String)parameters.get(MODEL_TYPE);
        String key = (String)parameters.get("id");
        String bizappid = (String)parameters.get(BIZ_APPID);
        Integer subSystemId = (Integer)parameters.get("subSystem");
        Object objName = parameters.get("name");
        LocaleString name = null;
        if (objName instanceof LocaleString) {
            name = (LocaleString)objName;
        } else if (objName instanceof OrmLocaleValue) {
            HashMap<String, String> localNameMap = new HashMap<String, String>(16);
            for (String loId : ((OrmLocaleValue)objName).keySet()) {
                localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
            }
            name = LocaleString.fromMap(localNameMap);
        } else {
            name = new LocaleString(this.localeId, (String)objName);
        }
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        PrintMetadata formMeta = ((PrintFormTemplate)template).getPrintMetadata();
        formMeta.setIsv(ISVService.getISVInfo().getId());
        formMeta.setKey(key);
        formMeta.setName(name);
        String entityId = (String)parameters.get(ENTITY_ID);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        } else {
            entityMeta = template.getEntityMetadata();
            entityId = formMeta.getId();
            entityMeta.setId(entityId);
        }
        formMeta.setEntityId(entityId);
        tMap = formMeta.buildDesignMeta(this.localeId);
        tMap.put(MODEL_TYPE, modelType);
        tMap.put(BIZ_APPID, bizappid == null ? "" : bizappid);
        tMap.put("subSystem", subSystemId == null ? Integer.valueOf(1) : subSystemId);
        return tMap;
    }

    private void setInheritFlag(List<? extends AbstractElement> els) {
        for (AbstractElement abstractElement : els) {
            abstractElement.setInherit(true);
        }
    }

    public boolean checkNumber(String number) {
        return MetadataDao.checkNumber((String)number);
    }

    public static String getMasterId(String id) {
        return MetadataDao.getMasterId((String)id);
    }

    public static String getNumberById(String id) {
        return MetadataDao.getNumberById((String)id);
    }

    public static String getEntityNumberById(String id) {
        return MetadataDao.getEntityNumberById((String)id);
    }

    public boolean checkName(String name) {
        return MetadataDao.checkName((String)name);
    }

    public Map<String, Object> save(Map<String, Object> content) {
        return this.saveDesignMetadata(content, false);
    }

    public Map<String, Object> save(Map<String, Object> content, Map<String, Object> oldContent) {
        return this.saveDesignMetadata(content, oldContent, false);
    }

    public Map<String, Object> save(Map<String, Object> content, boolean isDraft) {
        return this.saveDesignMetadata(content, isDraft);
    }

    public List<AbstractDesignMeta> getDesignerMeatadata(Map<String, Object> content) {
        Map formMeta = (Map)content.get(FORM_META);
        String modelType = (String)formMeta.get(MODEL_TYPE_1);
        AbstractMetadata metadata = this.convertTo(content, modelType);
        MetadataWriter writer = new MetadataWriter(metadata.getModelType());
        if (metadata instanceof FormMetadata) {
            EntityMetadata entityMetadata = ((FormMetadata)metadata).getEntityMetadata();
            FormMetadata formMetadata = (FormMetadata)metadata;
            if (!formMetadata.getId().equals(formMetadata.getEntityId())) {
                return writer.convertToDesignMeta(new AbstractMetadata[]{metadata});
            }
            return writer.convertToDesignMeta(new AbstractMetadata[]{metadata, entityMetadata});
        }
        return writer.convertToDesignMeta(new AbstractMetadata[]{metadata});
    }

    public Map<String, Object> getMeatadata(Map<String, Object> content, String lang) {
        Map formMeta = (Map)content.get(FORM_META);
        String modelType = (String)formMeta.get(MODEL_TYPE_1);
        AbstractMetadata metadata = this.convertTo(content, modelType);
        return metadata.buildDesignMeta(lang);
    }

    public Map<String, Object> saveDesignMetadata(Map<String, Object> content, boolean isDraft) {
        return this.saveDesignMetadata(content, null, isDraft);
    }

    protected Map<String, Object> saveDesignMetadata(Map<String, Object> content, Map<String, Object> oldContent, boolean isDraft) {
        AbstractMetadata metadata;
        Map formMeta = (Map)content.get(FORM_META);
        String modelType = (String)formMeta.get(MODEL_TYPE_1);
        AbstractMetadata oldMetadata = metadata = this.convertTo(content, modelType);
        if (oldContent != null) {
            oldMetadata = this.convertTo(oldContent, modelType);
        }
        MetadataWriter writer = this.getMetadataWriter(modelType);
        Map<Object, Object> result = null;
        ArrayList<String> warnInfo = new ArrayList<String>();
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            result = new HashMap<String, Boolean>();
            result.put(SUCCESS, false);
            ArrayList<ErrorInfo> errors = new ArrayList<ErrorInfo>();
            ErrorInfo errInfo = new ErrorInfo();
            errInfo.setError(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"DesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            errors.add(errInfo);
            result.put(ERRORS, errors);
            return result;
        }
        String metadataIsv = metadata.getIsv();
        if ("kingdee".equalsIgnoreCase(currentIsv) && StringUtils.isBlank((CharSequence)metadataIsv)) {
            metadata.setIsv(currentIsv);
        }
        if (metadata instanceof FormMetadata && !"2".equals(metadata.getDevType())) {
            metadata.setIsvSign(ISVService.getIsvSign((String)((FormMetadata)metadata).getKey()));
        }
        if ((result = this.checkIsv(content, metadata, currentIsv)) != null) {
            return result;
        }
        if (metadata instanceof FormMetadata) {
            FormMetadata formMetadata;
            if (!this.checkNumber((FormMetadata)metadata)) {
                result = new HashMap();
                result.put(SUCCESS, false);
                result.put(ERRORS, metadata.getBuildErrors());
                return result;
            }
            if (!this.checkUrl((FormMetadata)metadata)) {
                result = new HashMap();
                result.put(SUCCESS, false);
                result.put(ERRORS, metadata.getBuildErrors());
                return result;
            }
            if (!this.checkHtml((FormMetadata)metadata)) {
                result = new HashMap();
                result.put(SUCCESS, false);
                result.put(ERRORS, metadata.getBuildErrors());
                return result;
            }
            result = this.extPluginCheck(metadata, oldMetadata, modelType, warnInfo);
            if (result != null) {
                return result;
            }
            EntityMetadata entityMetadata = ((FormMetadata)metadata).getEntityMetadata();
            EntityMetadata oldentityMetadata = ((FormMetadata)oldMetadata).getEntityMetadata();
            if (entityMetadata != null) {
                entityMetadata.setIsvSign(metadata.getIsvSign());
                if (!isDraft) {
                    this.checkFormName((FormMetadata)metadata);
                    this.checkEntityId(metadata);
                    this.checkFieldKey(metadata);
                    this.checkEmptyFieldId(metadata, entityMetadata, new ArrayList<Predicate<MobTableAp>>());
                    FormAp rootAp = ((FormMetadata)metadata).getRootAp();
                    if (rootAp instanceof BillFormAp) {
                        FormMetadata listMeta = ((BillFormAp)rootAp).getListMeta();
                        this.checkEmptyFieldId((AbstractMetadata)listMeta, entityMetadata, new ArrayList<Predicate<MobTableAp>>());
                    }
                    this.checkExtIsChangeTemplate(entityMetadata, oldentityMetadata);
                    this.checkBillType(entityMetadata);
                    this.checkNameVersionControl(entityMetadata, (FormMetadata)metadata);
                    this.checkFieldName(entityMetadata, modelType);
                    this.checkForm(entityMetadata, oldentityMetadata, modelType);
                    this.checkEncryptField(entityMetadata, oldentityMetadata);
                    this.checkInShardingOrIndicesField(entityMetadata, oldentityMetadata, modelType);
                    this.checkItemClassType(entityMetadata);
                    this.checkGroupField(entityMetadata);
                    this.checkAmountSummaryField(entityMetadata);
                    this.checkRepeatFieldName(entityMetadata);
                    this.checkParentEntryAp((FormMetadata)metadata, entityMetadata);
                    this.checkNumberConstraint((FormMetadata)metadata, entityMetadata, ResManager.getLocaleString((String)"\u8868\u5355", (String)"MetaIsvCheck_0", (String)BOS_DESIGNER_PLUGIN), MetaType.Form);
                    this.checkControlStrategyConstraint(entityMetadata);
                    this.checkDateRangeStartEndName(entityMetadata);
                    this.checkTimeRangeStartEndName(entityMetadata);
                    this.checkDateTimeRangeStartEndKey(entityMetadata);
                    this.checkDateRangeTimeRangeKey(entityMetadata);
                    if ("BalanceModel".equals(modelType)) {
                        new BalanceTbChecker(entityMetadata).checkMetadata();
                    }
                    this.checkDataDimension(entityMetadata);
                    this.checkExchangeRateGroupField((FormMetadata)metadata, entityMetadata);
                    this.checkTableAndFieldChange(entityMetadata, oldentityMetadata, modelType);
                    this.checkPkTypeChange(entityMetadata, oldentityMetadata, modelType);
                    this.checkEntryPageRow((FormMetadata)metadata);
                    this.checkEcomboProperties(entityMetadata);
                }
                if (!entityMetadata.getBuildErrors().isEmpty()) {
                    if (entityMetadata.getBuildErrors().stream().allMatch(error -> error.getLevel() == 1)) {
                        entityMetadata.getBuildErrors().stream().forEach(e -> warnInfo.add(e.getError()));
                    } else {
                        List errors = entityMetadata.getBuildErrors().stream().filter(error -> error.getLevel() == 2).collect(Collectors.toList());
                        result = new HashMap();
                        result.put(SUCCESS, false);
                        result.put(ERRORS, errors);
                        return result;
                    }
                }
            }
            result = !(formMetadata = (FormMetadata)metadata).getId().equals(formMetadata.getEntityId()) ? writer.save(Boolean.valueOf(isDraft), new AbstractMetadata[]{metadata}) : writer.save(Boolean.valueOf(isDraft), new AbstractMetadata[]{metadata, entityMetadata});
        } else if (metadata instanceof PrintMetadata) {
            String key = (String)formMeta.get("Key");
            boolean isExistNumber = MetadataDao.checkNumber((String)key, (String)metadata.getId());
            if (isExistNumber) {
                ErrorInfo info = new ErrorInfo();
                info.setItemId(metadata.getId());
                info.setPropertyName("Key");
                info.setType(FORM_META);
                info.setLevel(2);
                info.setError(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u5df2\u5b58\u5728\u3002", (String)"DesignerData_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                metadata.addError(info);
                result = new HashMap();
                result.put(SUCCESS, false);
                result.put(ERRORS, metadata.getBuildErrors());
                return result;
            }
            if (StringUtils.isBlank((CharSequence)metadata.getBizappId())) {
                String entityId = ((PrintMetadata)metadata).getEntityId();
                DynamicObject appInfo = BizAppServiceHelp.getBizAppByFormID((String)entityId);
                String appId = (String)appInfo.getPkValue();
                metadata.setBizappId(appId);
                String formId = metadata.getId();
                String sql = String.format(UPDATE_SQL, TABLENAME);
                Object[] params = new SqlParameter[]{new SqlParameter("fbizappid", 12, (Object)appId), new SqlParameter("fformid", 12, (Object)formId)};
                try (TXHandle h = TX.required();){
                    DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
                }
                catch (Exception e2) {
                    if (e2 instanceof KDException) {
                        throw (KDException)((Object)e2);
                    }
                    if (e2 instanceof OrmException) {
                        throw (OrmException)((Object)e2);
                    }
                    throw new KDException((Throwable)e2, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", e2.getMessage())});
                }
            }
            result = writer.save(Boolean.valueOf(isDraft), new AbstractMetadata[]{metadata});
        } else {
            result = writer.save(Boolean.valueOf(isDraft), new AbstractMetadata[]{metadata});
        }
        this.clearSubRuntimeMeta(metadata);
        try {
            List saveError = (List)result.get(ERRORS);
            if (saveError != null) {
                for (ErrorInfo errorInfo : saveError) {
                    if (errorInfo.getLevel() != 1) continue;
                    warnInfo.add(errorInfo.getError());
                }
            }
        }
        catch (Exception e3) {
            log.error("DesignerData.save err, msg: " + e3.getMessage(), (Throwable)e3);
        }
        if (!warnInfo.isEmpty()) {
            result.put("id", metadata.getId());
            result.put("warning", true);
            result.put("message", result.get("message") + String.join((CharSequence)" ", warnInfo));
        }
        return result;
    }

    private void checkEcomboProperties(EntityMetadata entityMetadata) {
        List entityList = entityMetadata.getItems();
        for (EntityItem entity : entityList) {
            Field field;
            if (entity instanceof ItemClassField) {
                ItemClassField itemClassField = (ItemClassField)entity;
                String typeFieldId = itemClassField.getTypeFieldId();
                field = entityMetadata.getFieldById(typeFieldId);
                if (!StringUtils.isBlank((CharSequence)typeFieldId) && field != null) continue;
                this.addBuildError(2, "TypeFieldId", String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u3010%s\u3011\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u672a\u8bbe\u7f6e\u3002", (String)"ItemClassField_2", (String)BOS_METADATA, (Object[])new Object[0]), itemClassField.getName()), entityMetadata);
                continue;
            }
            if (!(entity instanceof FlexField)) continue;
            FlexField flexField = (FlexField)entity;
            String refBaseFieldId = flexField.getRefBaseFieldId();
            field = entityMetadata.getFieldById(refBaseFieldId);
            if (!StringUtils.isBlank((CharSequence)refBaseFieldId) && field != null) continue;
            this.addBuildError(2, "RefBaseFieldId", String.format(ResManager.loadKDString((String)"%s\uff1a\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FlexField_2", (String)BOS_METADATA, (Object[])new Object[0]), flexField.getName()), entityMetadata);
        }
    }

    protected Map<String, Object> checkIsv(Map<String, Object> content, AbstractMetadata metadata, String currentIsv) {
        if (!(content.get("isDeveloper") != null && ((Boolean)content.get("isDeveloper")).booleanValue() || currentIsv.equalsIgnoreCase(metadata.getIsv()))) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(SUCCESS, false);
            ArrayList<ErrorInfo> errors = new ArrayList<ErrorInfo>();
            ErrorInfo errInfo = new ErrorInfo();
            String message = "";
            message = metadata.getModelType().equals("PrintModel") ? String.format(ResManager.loadKDString((String)"\u4fee\u6539\u7684\u6253\u5370\u6a21\u677f\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546%s\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002\u8bf7\u590d\u5236\u8be5\u5143\u6570\u636e\u540e\u518d\u8fdb\u884c\u4fee\u6539\u3002", (String)"DesignerData_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), currentIsv) : String.format(ResManager.loadKDString((String)"\u4fee\u6539\u7684\u5143\u6570\u636e\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546%s\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002\u8bf7\u6269\u5c55\u8be5\u5143\u6570\u636e\u540e\u518d\u8fdb\u884c\u4fee\u6539\u3002", (String)"DesignerData_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), currentIsv);
            errInfo.setError(message);
            errors.add(errInfo);
            result.put(ERRORS, errors);
            return result;
        }
        return null;
    }

    protected MetadataWriter getMetadataWriter(String modelType) {
        return new MetadataWriter(modelType);
    }

    private void checkKFlowRule(FormMetadata formMetadata) {
        String masterId = formMetadata.getMasterId();
        if (StringUtils.isNotBlank((CharSequence)masterId)) {
            return;
        }
        FormAp formAp = formMetadata.getRootAp();
        if (formAp == null) {
            return;
        }
        String formId = formMetadata.getId();
        IFlowDesignService flowService = this.getKFlowService();
        List rules = formAp.getRules();
        for (FormRule rule : rules) {
            Map extProps;
            if (!RuleType.KFlowRule.name().equals(rule.getRuleType()) || (extProps = rule.getExtProps()) == null || StringUtils.equals((CharSequence)((String)extProps.get("ObjectId")), (CharSequence)formId)) continue;
            extProps.put("ObjectId", formId);
            extProps.put("RefId", flowService.genReferenceId());
        }
        if (formAp instanceof BillFormAp && ((BillFormAp)formAp).getMobMeta() != null && ((BillFormAp)formAp).getMobMeta().getRootAp() != null) {
            List mobileFormRules = ((BillFormAp)formAp).getMobMeta().getRootAp().getRules();
            for (FormRule mFormRule : mobileFormRules) {
                Map extProps;
                if (!RuleType.KFlowRule.name().equals(mFormRule.getRuleType()) || (extProps = mFormRule.getExtProps()) == null || StringUtils.equals((CharSequence)((String)extProps.get("ObjectId")), (CharSequence)formId)) continue;
                extProps.put("ObjectId", formId);
                extProps.put("RefId", flowService.genReferenceId());
            }
        }
    }

    private void checkKFlowOp(EntityMetadata entityMetadata) {
        String masterId = entityMetadata.getMasterId();
        if (StringUtils.isNotBlank((CharSequence)masterId)) {
            return;
        }
        if (entityMetadata.getRootEntity() != null && !CollectionUtils.isEmpty((Collection)entityMetadata.getRootEntity().getOperations())) {
            List ops = entityMetadata.getRootEntity().getOperations();
            HashMap<Long, KFlowOpParameter> refParaMap = new HashMap<Long, KFlowOpParameter>(16);
            for (Operation op : ops) {
                KFlowOpParameter parameter;
                Map opParam;
                if (!"kflow".equalsIgnoreCase(op.getOperationType()) || !(op.getParameter() instanceof KFlowOpParameter) || !((opParam = (parameter = (KFlowOpParameter)op.getParameter()).createEntityOperateParameter(entityMetadata)).get("refId") instanceof String)) continue;
                String refId = (String)opParam.get("refId");
                refParaMap.put(Long.parseLong(refId), parameter);
            }
            ArrayList<Long> refList = new ArrayList<Long>(refParaMap.keySet());
            DynamicObjectCollection col = this.queryByRefId(refList);
            if (col != null) {
                String entityId = entityMetadata.getId();
                IFlowDesignService service = this.getKFlowService();
                for (DynamicObject obj : col) {
                    DynamicObject resource;
                    if (obj == null || (resource = obj.getDynamicObject("resourceid")) == null || StringUtils.equals((CharSequence)entityId, (CharSequence)resource.getString("id"))) continue;
                    KFlowOpParameter parameter = (KFlowOpParameter)refParaMap.get(obj.getLong("id"));
                    parameter.setRefId(service.genReferenceId());
                }
            }
        }
    }

    private DynamicObjectCollection queryByRefId(List<Long> refList) {
        if (CollectionUtils.isEmpty(refList)) {
            return null;
        }
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)refList.toArray(new Object[refList.size()]))};
        return orm.query("kf_reference", filters);
    }

    private Map<String, Object> extPluginCheck(AbstractMetadata metadata, AbstractMetadata oldMetadata, String modelType, List<String> warnInfo) {
        PluginProxy extPluginPluginProxy = new PluginProxyImpl().create(null, IDesignerDataExtPlugin.class);
        DesignerDataCheckEvent event = new DesignerDataCheckEvent((FormMetadata)metadata, (FormMetadata)oldMetadata, modelType);
        extPluginPluginProxy.callReplace(o -> {
            o.check(event);
            return null;
        });
        List errorInfoList = metadata.getBuildErrors().stream().filter(error -> error.getLevel() == 2).collect(Collectors.toList());
        if (!errorInfoList.isEmpty()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(SUCCESS, false);
            result.put(ERRORS, errorInfoList);
            return result;
        }
        metadata.getBuildErrors().stream().forEach(e -> warnInfo.add(e.getError()));
        return null;
    }

    private void checkPkTypeChange(EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata, String modelType) {
        int oldPkType;
        int pkType;
        if (oldEntityMetadata != null && ("BillFormModel".equals(modelType) || BASE_FORM_MODEL.equals(modelType)) && (pkType = entityMetadata.getRootEntity().getPkType()) != (oldPkType = oldEntityMetadata.getRootEntity().getPkType())) {
            this.addBuildError(1, "PkType", ResManager.loadKDString((String)"\u4e3b\u952e\u7c7b\u578b\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u548c\u6570\u636e\u8868\u4e00\u81f4\u3002", (String)"DesignerData_96", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
        }
    }

    private void checkEntryPageRow(FormMetadata formMetadata) {
        List controlAps = formMetadata.getItems();
        for (ControlAp ap : controlAps) {
            if (!(ap instanceof EntryAp)) continue;
            EntryAp entryAp = (EntryAp)ap;
            boolean isSplitPage = entryAp.isSplitPage();
            int pageRow = entryAp.getPageRow();
            String maxPageRow = entryAp.getMaxPageRow();
            if (!isSplitPage || StringUtils.isBlank((CharSequence)maxPageRow)) continue;
            int maxPageRowInt = Integer.parseInt(maxPageRow);
            if ((pageRow != 0 || 5000 <= maxPageRowInt) && (pageRow == 0 || pageRow <= maxPageRowInt)) continue;
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7684\u9ed8\u8ba4\u5206\u9875\u6761\u6570\u503c\uff0c\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6700\u5927\u5206\u9875\u6761\u6570\u3002", (String)"DesignerData_131", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entryAp.getName());
            this.addBuildError(2, "MaxPageRow", msg, formMetadata.getEntityMetadata());
        }
    }

    private void checkBillType(EntityMetadata entityMetadata) {
        Map map;
        String defaultPageSetting;
        BillEntity billEntity;
        if (entityMetadata.getRootEntity() instanceof BillEntity && (billEntity = (BillEntity)entityMetadata.getRootEntity()).getBusinessControl().isBillType() && StringUtils.isNotBlank((CharSequence)(defaultPageSetting = billEntity.getDefaultPageSetting())) && (map = (Map)SerializationUtils.fromJsonString((String)defaultPageSetting, Map.class)).values().stream().anyMatch(StringUtils::isNotBlank)) {
            this.addBuildError(2, "DefaultPageSetting", ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6e\u5355\u636e\u7c7b\u578b\uff08\u4e1a\u52a1\u63a7\u5236\uff09\u548c\u9ed8\u8ba4\u5e03\u5c40\uff08\u5b9e\u4f53\u5c5e\u6027\uff09", (String)"DesignerData_95", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
        }
    }

    private void checkNameVersionControl(EntityMetadata entityMetadata, FormMetadata formMetadata) {
        BillEntity billEntity;
        String versionControlId;
        if (entityMetadata.getRootEntity() instanceof BillEntity && (versionControlId = (String)(billEntity = (BillEntity)entityMetadata.getRootEntity()).getCustomProperties().get("VersionControl")) != null) {
            for (ControlAp item : formMetadata.getItems()) {
                FieldAp fieldAp;
                if (!(item instanceof FieldAp) || !(fieldAp = (FieldAp)item).getFieldId().equals(versionControlId) || fieldAp.isFireUpdEvt()) continue;
                this.addBuildError(1, "FireUpdEvt", String.format(ResManager.loadKDString((String)"\u540d\u79f0\u5386\u53f2\u63a7\u5236\u5b57\u6bb5\u914d\u7f6e\u65e5\u671f\u5b57\u6bb5\u540e\uff0c\u5efa\u8bae\u5f00\u542f\u3010%s\u3011\u7684\u3010\u5373\u65f6\u89e6\u53d1\u503c\u66f4\u65b0\u3011\u5c5e\u6027\u3002", (String)"DesignerData_97", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), fieldAp.getName()), entityMetadata);
                return;
            }
        }
    }

    private boolean checkUrl(FormMetadata metadata) {
        for (ControlAp item : metadata.getItems()) {
            String url;
            if (!(item instanceof HyperlinkAp) || UrlUtil.checkUrl((String)(url = ((HyperlinkAp)item).getLinkUrl()))) continue;
            ErrorInfo info = new ErrorInfo();
            info.setItemId(metadata.getId());
            info.setPropertyName(item.getKey());
            info.setType(FORM_META);
            info.setLevel(2);
            String name = item.getName() == null ? item.getKey() : item.getName().getLocaleValue();
            info.setError(String.format(ResManager.loadKDString((String)"\u8d85\u94fe\u63a5:%s \u7684\u94fe\u63a5\u5730\u5740\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DesignerData_78", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name));
            metadata.addError(info);
            return false;
        }
        return true;
    }

    private boolean checkHtml(FormMetadata metadata) {
        int level = 1;
        Map<String, Object> sysParam = DesignerData.getSystemParam();
        String htmlxsswltag = null;
        if (sysParam != null) {
            Boolean htmlxsscheck = (Boolean)sysParam.get("htmlxsscheck");
            if (htmlxsscheck != null && htmlxsscheck.booleanValue()) {
                level = 2;
            }
            htmlxsswltag = (String)sysParam.get("htmlxsswhitelist");
        }
        for (ControlAp item : metadata.getItems()) {
            boolean checkForHtmlXSS;
            String htmlContent;
            if (!(item instanceof HtmlAp) || !StringUtils.isNotEmpty((CharSequence)(htmlContent = ((HtmlAp)item).getHtmlContent())) || (checkForHtmlXSS = DesignerData.checkForHtmlXSS(htmlContent, htmlxsswltag))) continue;
            ErrorInfo info = new ErrorInfo();
            info.setItemId(metadata.getId());
            info.setPropertyName(item.getKey());
            info.setType(FORM_META);
            info.setLevel(level);
            String name = item.getName() == null ? item.getKey() : item.getName().getLocaleValue();
            info.setError(String.format(ResManager.loadKDString((String)"HTML\u63a7\u4ef6:%s \u5185\u5bb9\u5b58\u5728\u767d\u540d\u5355\u5916\u7684\u5143\u7d20\uff0c\u5b58\u5728XSS\u6ce8\u5165\u98ce\u9669\u3002", (String)"DesignerData_134", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name));
            metadata.addError(info);
            if (2 != level) continue;
            return false;
        }
        return true;
    }

    private static boolean checkForHtmlXSS(String html, String customTags) {
        try {
            Document parse;
            String body;
            boolean ret;
            Safelist safelist = Safelist.relaxed();
            safelist.addAttributes("iframe", new String[]{"width", "height", "name", "style", "id"});
            safelist.addTags(new String[]{"style", "hr"});
            safelist.addAttributes(":all", new String[]{"class", "style"});
            if (StringUtils.isNotEmpty((CharSequence)customTags)) {
                safelist.addTags(customTags.split(","));
            }
            if (!(ret = Jsoup.isValid((String)(body = (parse = Jsoup.parse((String)html)).body().html()), (Safelist)safelist)) && log.isDebugEnabled()) {
                log.debug("html:{},body:{},result", new Object[]{html, body, Jsoup.clean((String)body, (Safelist)safelist)});
            }
            return ret;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return true;
        }
    }

    private void checkFormName(FormMetadata metadata) {
        LocaleString name = metadata.getName();
        if (null == name || StringUtils.isBlank((CharSequence)name.getLocaleValue())) {
            this.addBuildError(2, "Name", ResManager.loadKDString((String)"\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_106", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), metadata.getEntityMetadata());
        }
    }

    private void checkInShardingOrIndicesField(EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata, String modelType) {
        String mainTableName = "";
        List entitys = entityMetadata.getEntitys();
        for (Entity entity : entitys) {
            if (!(entity instanceof BillEntity)) continue;
            mainTableName = entity.getTableName();
            break;
        }
        if (StringUtils.isEmpty((CharSequence)mainTableName)) {
            return;
        }
        ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(mainTableName);
        if (config != null && config.isEnabled()) {
            while (config instanceof ChildrenTableConfig) {
                config = ((ChildrenTableConfig)config).getParent();
            }
            HashSet<String> shardingSet = new HashSet<String>(6);
            shardingSet.addAll(Arrays.asList(config.getShardingFields()));
            shardingSet.addAll(config.getOptions().getIndexNameSet());
            HashSet keySet = new HashSet(shardingSet.size());
            List items = oldEntityMetadata.getItems();
            items.forEach(item -> {
                String fieldName;
                if (item instanceof Field && shardingSet.contains(fieldName = ((Field)item).getFieldName())) {
                    keySet.add(item.getKey());
                }
            });
            for (String key : keySet) {
                Field fieldByKey = entityMetadata.getFieldByKey(key);
                if (fieldByKey != null) continue;
                this.addBuildError(2, FIELD_KEY, ResManager.loadKDString((String)"%s\u4f5c\u4e3a\u5206\u7247\u5c5e\u6027\u6216\u5206\u7247\u5feb\u901f\u7d22\u5f15\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5b57\u6bb5\u6807\u8bc6\u6216\u5220\u9664\u5b57\u6bb5\u3002", (String)"DesignerData_56", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[]{key}), entityMetadata);
                return;
            }
            for (String key : keySet) {
                Field oldFieldByKey = oldEntityMetadata.getFieldByKey(key);
                String oldId = oldFieldByKey.getId();
                String fieldName = oldFieldByKey.getFieldName();
                EntityItem itemById = entityMetadata.getItemById(oldId);
                String newFieldKey = itemById.getKey();
                if (!key.equals(newFieldKey)) {
                    this.addBuildError(2, FIELD_KEY, ResManager.loadKDString((String)"%s\u4f5c\u4e3a\u5206\u7247\u5c5e\u6027\u6216\u5206\u7247\u5feb\u901f\u7d22\u5f15\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6807\u8bc6\u3002", (String)"DesignerData_57", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[]{key}), entityMetadata);
                    return;
                }
                Field fieldByKey = entityMetadata.getFieldByKey(newFieldKey);
                if (fieldName.equals(fieldByKey.getFieldName())) continue;
                this.addBuildError(2, FIELD_KEY, ResManager.loadKDString((String)"%s\u4f5c\u4e3a\u5206\u7247\u5c5e\u6027\u6216\u5206\u7247\u5feb\u901f\u7d22\u5f15\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5b57\u6bb5\u540d\u3002", (String)"DesignerData_58", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[]{key}), entityMetadata);
                return;
            }
        }
    }

    private void checkControlStrategyConstraint(EntityMetadata entityMetadata) {
        List entityItems = entityMetadata.getItems();
        for (EntityItem item : entityItems) {
            String tableName = null;
            if (item instanceof Field) {
                if (item instanceof MulBasedataField) {
                    tableName = ((MulBasedataField)item).getTableName();
                }
            } else if (item instanceof Entity) {
                tableName = ((Entity)item).getTableName();
            }
            if (tableName == null) {
                return;
            }
            if (!StringUtils.isNotBlank((CharSequence)tableName) || !StringUtils.endsWithIgnoreCase((CharSequence)tableName.trim(), (CharSequence)"_u")) continue;
            String msg = ResManager.loadKDString((String)"\u7531\u4e8e\u7ba1\u63a7\u7b56\u7565\u9650\u5236\uff0c\u8868\u540d\u201c%s\u201d\u4e0d\u80fd\u4ee5\u201c_u\u201d\u7ed3\u5c3e\u3002", (String)"DesignerData_46", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            msg = String.format(msg, tableName);
            this.addBuildError(2, TABLE_NAME, msg, entityMetadata);
        }
    }

    private void checkDateRangeStartEndName(EntityMetadata entityMetadata) {
        List entityList = entityMetadata.getItems();
        for (EntityItem entity : entityList) {
            DateRangeField dateRangeField;
            if (!(entity instanceof DateRangeField) || !StringUtils.isBlank((CharSequence)(dateRangeField = (DateRangeField)entity).getEndDateFieldName()) && !StringUtils.isBlank((CharSequence)dateRangeField.getStartDateFieldName())) continue;
            LocaleString localeString = dateRangeField.getName();
            String name = localeString == null ? "" : localeString.getLocaleValue();
            this.addBuildError(1, "startDateFieldName", String.format(ResManager.loadKDString((String)"\u201c\u65e5\u671f\u8303\u56f4\u201d:\u201c%s\u201d\u7684\u201c\u5f00\u59cb\u5b57\u6bb5\u540d\u201d\u548c\u201c\u7ed3\u675f\u5b57\u6bb5\u540d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_90", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name), entityMetadata);
        }
    }

    private void checkTimeRangeStartEndName(EntityMetadata entityMetadata) {
        List entityList = entityMetadata.getItems();
        for (EntityItem entity : entityList) {
            TimeRangeField timeRangeField;
            if (!(entity instanceof TimeRangeField) || !StringUtils.isBlank((CharSequence)(timeRangeField = (TimeRangeField)entity).getEndDateFieldName()) && !StringUtils.isBlank((CharSequence)timeRangeField.getStartDateFieldName())) continue;
            LocaleString localeString = timeRangeField.getName();
            String name = localeString == null ? "" : localeString.getLocaleValue();
            this.addBuildError(1, "startDateFieldName", String.format(ResManager.loadKDString((String)"\u201c\u65f6\u95f4\u8303\u56f4\u201d:\u201c%s\u201d\u7684\u201c\u5f00\u59cb\u5b57\u6bb5\u540d\u201d\u548c\u201c\u7ed3\u675f\u5b57\u6bb5\u540d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_91", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name), entityMetadata);
        }
    }

    private void checkNumberConstraint(FormMetadata formMeta, EntityMetadata entityMeta, LocaleString type, MetaType metaType) {
        if (null == formMeta) {
            return;
        }
        String isv = ISVService.getISVInfo().getId();
        List controlAps = formMeta.getItems();
        BillFormAp billFormAp = null;
        String msgStartWithIsv = ResManager.loadKDString((String)"\u63a7\u4ef6\u201c%1$s\u201d\u7684\u6807\u8bc6\u201c%2$s\u201d\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u53ef\u80fd\u4f1a\u9020\u6210oql\u3001algo\u53d6\u6570\u5f02\u5e38\uff0c\u8bf7\u7559\u610f\u3002", (String)"DesignerData_47", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        String msgStartWithNum = ResManager.loadKDString((String)"\u6807\u8bc6\uff1a%3$s\u4e0d\u80fd\u4ee50-9\u6570\u5b57\u5f00\u5934\uff08\u63a7\u4ef6\uff1a%1$s\uff0c\u6807\u8bc6\uff1a%2$s\uff09\u3002", (String)"DesignerData_42", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        for (Object controlAp : controlAps) {
            String msg;
            if (controlAp instanceof BillFormAp) {
                billFormAp = (BillFormAp)controlAp;
            }
            String fieldKey = controlAp.getKey();
            if (this.judgeControlApType((ControlAp<?>)controlAp) || !this.startWithNumber(fieldKey)) continue;
            if (this.startWithNumber(isv) && StringUtils.startsWithIgnoreCase((CharSequence)fieldKey, (CharSequence)isv)) {
                msg = type.getLocaleValue() + String.format(msgStartWithIsv, controlAp.getName(), controlAp.getKey());
                this.addBuildError(1, FIELD_KEY, msg, entityMeta);
                continue;
            }
            msg = type.getLocaleValue() + String.format(msgStartWithNum, controlAp.getName(), controlAp.getKey(), fieldKey);
            this.addBuildError(2, FIELD_KEY, msg, entityMeta);
        }
        if (null == entityMeta) {
            return;
        }
        List entityItems = entityMeta.getItems();
        for (EntityItem item : entityItems) {
            String tableName;
            String msg;
            String name;
            LocaleString nameLocale;
            String tpl;
            StringBuilder msgList = new StringBuilder();
            if (item instanceof Field) {
                String tableName2;
                DateRangeField rangeField;
                String field = ((Field)item).getFieldName();
                if (this.startWithNumber(field)) {
                    tpl = ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\uff1a%3$s\u4e0d\u80fd\u4ee50-9\u6570\u5b57\u5f00\u5934\uff08\u5b9e\u4f53\uff1a%1$s\uff0c\u6807\u8bc6\uff1a%2$s\uff09\u3002", (String)"DesignerData_43", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                    nameLocale = item.getName();
                    name = nameLocale == null ? "" : nameLocale.getLocaleValue();
                    msg = type.getLocaleValue() + String.format(tpl, name, item.getKey(), field);
                    msgList.append(msg).append("\uff0c");
                }
                if (item instanceof DateRangeField && metaType == MetaType.Form) {
                    rangeField = (DateRangeField)item;
                    nameLocale = item.getName();
                    String string = name = nameLocale == null ? "" : nameLocale.getLocaleValue();
                    if (this.startWithNumber(rangeField.getStartDateFieldKey())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u201c%1$s\u201d\u7684\u5f00\u59cb\u6807\u8bc6\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_48", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getStartDateFieldKey());
                        msgList.append(msg).append("\uff0c");
                    }
                    if (this.startWithNumber(rangeField.getStartDateFieldName())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u201c%1$s\u201d\u7684\u5f00\u59cb\u5b57\u6bb5\u540d\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_49", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getStartDateFieldName());
                        msgList.append(msg).append("\uff0c");
                    }
                    if (this.startWithNumber(rangeField.getEndDateFieldKey())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u201c%1$s\u201d\u7684\u7ed3\u675f\u6807\u8bc6\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_50", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getEndDateFieldKey());
                        msgList.append(msg).append("\uff0c");
                    }
                    if (this.startWithNumber(rangeField.getEndDateFieldName())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u201c%1$s\u201d\u7684\u7ed3\u675f\u5b57\u6bb5\u540d\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_51", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getEndDateFieldName());
                        msgList.append(msg).append("\uff0c");
                    }
                }
                if (item instanceof TimeRangeField && metaType == MetaType.Form) {
                    rangeField = (TimeRangeField)item;
                    nameLocale = item.getName();
                    String string = name = nameLocale == null ? "" : nameLocale.getLocaleValue();
                    if (this.startWithNumber(rangeField.getStartDateFieldKey())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u201c%1$s\u201d\u7684\u5f00\u59cb\u6807\u8bc6\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_52", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getStartDateFieldKey());
                        msgList.append(msg).append("\uff0c");
                    }
                    if (this.startWithNumber(rangeField.getStartDateFieldName())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u201c%1$s\u201d\u7684\u5f00\u59cb\u5b57\u6bb5\u540d\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_53", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getStartDateFieldName());
                        msgList.append(msg).append("\uff0c");
                    }
                    if (this.startWithNumber(rangeField.getEndDateFieldKey())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u201c%1$s\u201d\u7684\u7ed3\u675f\u6807\u8bc6\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_54", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getEndDateFieldKey());
                        msgList.append(msg).append("\uff0c");
                    }
                    if (this.startWithNumber(rangeField.getEndDateFieldName())) {
                        msg = type.getLocaleValue() + String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u201c%1$s\u201d\u7684\u7ed3\u675f\u5b57\u6bb5\u540d\uff1a\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\uff5e9\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_55", (String)BOS_METADATA, (Object[])new Object[0]), name, rangeField.getEndDateFieldName());
                        msgList.append(msg).append("\uff0c");
                    }
                }
                if (item instanceof MulBasedataField && this.startWithNumber(tableName2 = ((MulBasedataField)item).getTableName())) {
                    String tpl2 = ResManager.loadKDString((String)"\u8868\u540d\uff1a%3$s\u4e0d\u80fd\u4ee50-9\u6570\u5b57\u5f00\u5934\uff08\u591a\u9009\u57fa\u7840\u8d44\u6599\uff1a\u201c%1$s\u201d\uff0c\u6807\u8bc6\uff1a%2$s\uff09\u3002", (String)"DesignerData_44", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                    LocaleString nameLocale2 = item.getName();
                    String name2 = nameLocale2 == null ? "" : nameLocale2.getLocaleValue();
                    String msg2 = type.getLocaleValue() + String.format(tpl2, name2, item.getKey(), tableName2);
                    msgList.append(msg2).append("\uff0c");
                }
            }
            if (item instanceof Entity && this.startWithNumber(tableName = ((Entity)item).getTableName())) {
                tpl = ResManager.loadKDString((String)"\u8868\u540d\uff1a%3$s\u4e0d\u80fd\u4ee50-9\u6570\u5b57\u5f00\u5934\uff08\u5b9e\u4f53\uff1a%1$s\uff0c\u6807\u8bc6\uff1a%2$s\uff09\u3002", (String)"DesignerData_45", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                nameLocale = item.getName();
                name = nameLocale == null ? "" : nameLocale.getLocaleValue();
                msg = type.getLocaleValue() + String.format(tpl, name, item.getKey(), tableName);
                msgList.append(msg).append("\uff0c");
            }
            if (msgList == null || msgList.length() == 0) continue;
            if (msgList.charAt(msgList.length() - 1) == '\uff0c') {
                msgList.setCharAt(msgList.length() - 1, '\u3002');
            }
            this.addBuildError(2, FIELD_KEY, msgList.toString(), entityMeta);
        }
        FormMetadata listMeta = null == billFormAp ? null : billFormAp.getListMeta();
        this.checkNumberConstraint(listMeta, entityMeta, ResManager.getLocaleString((String)"\u5217\u8868", (String)"MetaIsvCheck_1", (String)BOS_DESIGNER_PLUGIN), MetaType.List);
        FormMetadata mobMeta = null == billFormAp ? null : billFormAp.getMobMeta();
        this.checkNumberConstraint(mobMeta, entityMeta, ResManager.getLocaleString((String)"\u79fb\u52a8\u8868\u5355", (String)"MetaIsvCheck_2", (String)BOS_DESIGNER_PLUGIN), MetaType.MobForm);
        FormMetadata mobListMeta = null == billFormAp ? null : billFormAp.getMobListMeta();
        this.checkNumberConstraint(mobListMeta, entityMeta, ResManager.getLocaleString((String)"\u79fb\u52a8\u5217\u8868", (String)"MetaIsvCheck_3", (String)BOS_DESIGNER_PLUGIN), MetaType.MobList);
    }

    private boolean judgeControlApType(ControlAp<?> controlAp) {
        return controlAp instanceof FormAp || controlAp instanceof BillFormAp || controlAp instanceof BillListAp || controlAp instanceof MobileFormAp || controlAp instanceof MobileListAp;
    }

    private boolean isCheckNumber() {
        return !ignoreCheckNumber;
    }

    private boolean checkNumber(FormMetadata metadata) {
        String key = metadata.getRootAp().getKey().toLowerCase(Locale.ENGLISH);
        if (key.endsWith("_mob") && this.isCheckNumber()) {
            ErrorInfo info = new ErrorInfo();
            info.setItemId(metadata.getId());
            info.setPropertyName("Key");
            info.setType(FORM_META);
            info.setLevel(2);
            info.setError(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u4e0d\u80fd\u7528'_mob'\u505a\u4e3a\u540e\u7f00\u3002", (String)"DesignerData_39", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            metadata.addError(info);
            return false;
        }
        return true;
    }

    private void clearSubRuntimeMeta(AbstractMetadata formMeta) {
        ArrayList<String> formIds = new ArrayList<String>();
        if ("2".equals(formMeta.getDevType())) {
            formIds.add(formMeta.getMasterId());
            if (StringUtils.isNotBlank((CharSequence)formMeta.getId())) {
                MetadataDao.clearExtendCache(Collections.singletonList(formMeta.getId()));
            }
        } else {
            formIds.add(formMeta.getId());
        }
        es.execute(new ClearSubRuntimeMetaRunnable(RequestContext.get(), formIds));
    }

    public AbstractMetadata convertTo(Map<String, Object> content, String modelType) {
        return this.getMetadataConverter(modelType).convertTo(content);
    }

    protected void checkEntityId(AbstractMetadata metadata) {
        if (metadata instanceof FormMetadata) {
            EntityMetadata entityMetadata = ((FormMetadata)metadata).getEntityMetadata();
            List entityItems = entityMetadata.getItems();
            List entityIdList = entityItems.stream().map(AbstractElement::getId).collect(Collectors.toList());
            List aps = ((FormMetadata)metadata).getItems();
            for (ControlAp ap : aps) {
                boolean entityExist = false;
                if (ap instanceof ReportListAp || ap instanceof FlatFieldAp) continue;
                if (ap instanceof FieldAp) {
                    if (StringUtils.isBlank((CharSequence)((FieldAp)ap).getFieldId())) continue;
                    if (entityIdList.contains(ap.getId()) || entityIdList.contains(((FieldAp)ap).getFieldId())) {
                        entityExist = true;
                    }
                } else {
                    if (!(ap instanceof EntryAp)) continue;
                    if (entityIdList.contains(ap.getId()) || entityIdList.contains(((EntryAp)ap).getEntryId())) {
                        entityExist = true;
                    }
                }
                if (entityExist) continue;
                this.addBuildError(2, FIELD_KEY, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684ID\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"DesignerData_107", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getName().toString(), ap.getId()), entityMetadata);
                break;
            }
        }
    }

    private void checkEncryptField(EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata) {
        if (StringUtils.equals((CharSequence)"false", (CharSequence)System.getProperty("idecheck.encryptfieldchange", "true"))) {
            return;
        }
        if (entityMetadata == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)entityMetadata.getDBRouteKey()) && StringUtils.isBlank((CharSequence)entityMetadata.getRootEntity().getTableName())) {
            return;
        }
        for (Entity entity : entityMetadata.getEntitys()) {
            this.checkEncryptFieldInEntry(entity, entityMetadata, oldEntityMetadata);
        }
    }

    private void checkEncryptFieldInEntry(Entity<?, ?> entity, EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata) {
        String dbrouteKey = entityMetadata.getDBRouteKey();
        ArrayList<Field> cols = new ArrayList<Field>(16);
        for (EntityItem ap : entity.getItems()) {
            Field f;
            if (ap == null || !Field.class.isAssignableFrom(ap.getClass()) || StringUtils.isBlank((CharSequence)(f = (Field)ap).getFieldName()) || !this.isFieldEncryptChanged((Field)ap, oldEntityMetadata)) continue;
            cols.add((Field)ap);
        }
        if (cols.isEmpty()) {
            return;
        }
        DbMetadataTable table = AlterTableUtil.getTableSchema((String)dbrouteKey, (String)entity.getTableName(), (boolean)false);
        if (table == null || table.getColumns().isEmpty()) {
            return;
        }
        String sql = String.format("select top 1 %s from %s ;", ((DbMetadataColumn)table.getColumns().get(0)).getName(), entity.getTableName());
        boolean existData = (Boolean)DB.query((DBRoute)new DBRoute(dbrouteKey), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (!existData) {
            return;
        }
        for (Field ap : cols) {
            Object value = null;
            boolean existedColumn = table.getColumns().TryGetValue(ap.getFieldName(), new RefObject(value));
            if (!existedColumn) continue;
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\"{0}\"\u5b57\u6bb5\uff1a\u4e0d\u5141\u8bb8\u5728\u6570\u636e\u8868\u5df2\u6709\u6570\u636e\u7684\u60c5\u51b5\u4e0b\uff0c\u4fee\u6539\u3010\u52a0\u5bc6\u5b58\u50a8\u3011\u5c5e\u6027\u3002", (String)"DesignerData_73", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getName().toString());
            this.addBuildError(2, FIELD_KEY, msg, entityMetadata);
        }
    }

    private boolean isFieldEncryptChanged(Field<?> currentField, EntityMetadata oldEntityMetadata) {
        if (oldEntityMetadata == null) {
            return false;
        }
        Field oldfield = oldEntityMetadata.getFieldByKey(currentField.getKey());
        if (oldfield == null) {
            return false;
        }
        return !oldfield.isEncrypt() == currentField.isEncrypt();
    }

    protected void checkFieldKey(AbstractMetadata metadata) {
        if (metadata instanceof FormMetadata) {
            FormMetadata formMetadata = (FormMetadata)metadata;
            List controlAps = formMetadata.getItems();
            HashSet<String> fieldKeys = new HashSet<String>();
            for (ControlAp ap : controlAps) {
                if (ap instanceof FormAp || ap instanceof ListColumnAp) continue;
                String fieldKey = ap.getKey();
                if (fieldKeys.contains(fieldKey)) {
                    this.addBuildError(2, FIELD_KEY, String.format(ResManager.loadKDString((String)"%s \u6807\u8bc6\u91cd\u590d\u3002", (String)"DesignerData_108", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getKey()), formMetadata.getEntityMetadata());
                    continue;
                }
                if (StringUtils.endsWithIgnoreCase((CharSequence)ap.getKey(), (CharSequence)"_id")) {
                    this.addBuildError(1, FIELD_KEY, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5e94\u4f7f\u7528\u7279\u6b8a\u5b57\u7b26\u201c_id\u201d\u7ed3\u5c3e\u3002", (String)"DesignerData_40", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getKey()), formMetadata.getEntityMetadata());
                }
                fieldKeys.add(ap.getKey());
            }
        }
    }

    protected boolean startWithNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return StringUtils.startsWithAny((CharSequence)str.trim(), (CharSequence[])NUMBERS);
    }

    private void checkFieldName(EntityMetadata entityMetadata, String modelType) {
        if (!"BillFormModel".equals(modelType) && !BASE_FORM_MODEL.equals(modelType)) {
            return;
        }
        MainEntity mainEntity = entityMetadata.getRootEntity();
        String mainOrgId = mainEntity.getMainOrg();
        List entityList = entityMetadata.getItems();
        Pattern pt = Pattern.compile("^[f]+[a-z0-9_]+$");
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (EntityItem entity : entityList) {
            if (!this.judgeEntityItemType(entity)) continue;
            String fieldName = ((Field)entity).getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                if (entity instanceof OrgField && entity.getId().equals(mainOrgId)) {
                    this.addBuildError(2, FIELD_NAME, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7ed1\u5b9a\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u5b57\u6bb5\uff1a%2$s\u7684\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_109", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mainEntity.getName().getLocaleValue(), entity.getName().getLocaleValue()), entityMetadata);
                }
                this.addBuildError(1, FIELD_NAME, String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().getLocaleValue()), entityMetadata);
                continue;
            }
            if (fieldName.endsWith("_pr")) {
                this.addBuildError(1, FIELD_NAME, String.format(ResManager.loadKDString((String)"\u201c%s_pr\u201d\u4e3a\u9690\u79c1\u5b57\u6bb5\u4fdd\u7559\u540e\u7f00\u3002", (String)"DesignerData_110", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().getLocaleValue()), entityMetadata);
                continue;
            }
            if (pt.matcher(fieldName.toLowerCase()).matches()) continue;
            fieldNames.add(entity.getName().getLocaleValue());
        }
        if (!fieldNames.isEmpty()) {
            this.addBuildError(1, FIELD_NAME, String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u540d\u5fc5\u987b\u4ee5f\u5f00\u5934\uff0c\u4e14\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"DesignerData_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", fieldNames)), entityMetadata);
        }
    }

    private void checkAmountSummaryField(EntityMetadata entityMetadata) {
        if (StringUtils.isBlank((CharSequence)entityMetadata.getDBRouteKey()) && StringUtils.isBlank((CharSequence)entityMetadata.getRootEntity().getTableName())) {
            return;
        }
        HashMap<String, EntityItem> map = new HashMap<String, EntityItem>(16);
        ArrayList<DecimalField> decimalFields = new ArrayList<DecimalField>();
        block0: for (Entity entity : entityMetadata.getEntitys()) {
            for (EntityItem item : entity.getItems()) {
                if (!(item instanceof DecimalField)) continue;
                DecimalField decimalField = (DecimalField)item;
                SummaryToField summaryToField = decimalField.getSummaryToField();
                if (summaryToField != null) {
                    String fieldKey = summaryToField.getFieldKey();
                    if (StringUtils.isNotBlank((CharSequence)fieldKey) && map.containsKey(fieldKey)) {
                        Field existField = (Field)map.get(fieldKey);
                        String msg = String.format(ResManager.loadKDString((String)"%1$s:%2$s(%3$s)\u548c%4$s(%5$s)\u7684\u6c47\u603b\u81f3\u5b57\u6bb5\u5c5e\u6027\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u3002", (String)"DesignerData_102", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), item.getKey(), existField.getName().toString(), existField.getKey());
                        this.addBuildError(2, item.getKey(), msg, entityMetadata);
                        continue block0;
                    }
                    map.put(fieldKey, item);
                }
                decimalFields.add((DecimalField)item);
            }
        }
        ArrayList<String> existItem = new ArrayList<String>();
        for (EntityItem entityItem : decimalFields) {
            if (!map.containsKey(entityItem.getKey())) continue;
            existItem.add(entityItem.getKey());
        }
        for (Map.Entry entry : map.entrySet()) {
            EntityItem item;
            if (entry.getKey() == null || existItem.contains(entry.getKey())) continue;
            item = (EntityItem)entry.getValue();
            String msg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u7684\u201c\u6c47\u603b\u81f3\u5b57\u6bb5\u201d\u5c5e\u6027\u5bf9\u5e94\u7684\u76ee\u6807\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DesignerData_103", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), item.getName().toString(), item.getKey());
            this.addBuildError(2, item.getKey(), msg, entityMetadata);
        }
    }

    private void checkRepeatFieldName(EntityMetadata entityMetadata) {
        if (StringUtils.isBlank((CharSequence)entityMetadata.getDBRouteKey()) && StringUtils.isBlank((CharSequence)entityMetadata.getRootEntity().getTableName())) {
            return;
        }
        block0: for (Entity entity : entityMetadata.getEntitys()) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            for (EntityItem item : entity.getItems()) {
                String errmsg;
                String existFieldTip;
                String rangeTip;
                Field field;
                String endName;
                String startName;
                DateRangeField rangeField;
                if (!(item instanceof Field)) continue;
                String key = ((Field)item).getFieldName();
                if (StringUtils.isNotBlank((CharSequence)key) && map.containsKey(key)) {
                    Field field2 = (Field)map.get(key);
                    this.addRepeatFieldNameErrMsg(entityMetadata, entity, (Field)item, field2);
                    continue block0;
                }
                map.put(key, item);
                if (item instanceof DateRangeField) {
                    rangeField = (DateRangeField)item;
                    startName = rangeField.getStartDateFieldName();
                    endName = rangeField.getEndDateFieldName();
                    if (StringUtils.isNotBlank((CharSequence)startName) && map.containsKey(startName)) {
                        field = (Field)map.get(startName);
                        rangeTip = this.getRepeatFieldMessage(startName, (Field<?>)rangeField, true);
                        existFieldTip = this.getRepeatFieldMessage(startName, field, false);
                        errmsg = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u91cd\u590d\uff1a\u201c{0}\u201d\uff0c\u201c{1}\u201d\uff0c\u201c{2}\u201d\u3002", (String)"DesignerData_77", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), rangeTip, existFieldTip);
                        this.addBuildError(2, item.getKey(), errmsg, entityMetadata);
                        continue block0;
                    }
                    map.put(startName, item);
                    if (StringUtils.isNotBlank((CharSequence)endName) && map.containsKey(endName)) {
                        field = (Field)map.get(endName);
                        rangeTip = this.getRepeatFieldMessage(endName, (Field<?>)rangeField, true);
                        existFieldTip = this.getRepeatFieldMessage(endName, field, false);
                        errmsg = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u91cd\u590d\uff1a\u201c{0}\u201d\uff0c\u201c{1}\u201d\uff0c\u201c{2}\u201d\u3002", (String)"DesignerData_77", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), rangeTip, existFieldTip);
                        this.addBuildError(2, item.getKey(), errmsg, entityMetadata);
                        continue block0;
                    }
                    map.put(endName, item);
                }
                if (item instanceof TimeRangeField) {
                    rangeField = (TimeRangeField)item;
                    startName = rangeField.getStartDateFieldName();
                    endName = rangeField.getEndDateFieldName();
                    if (StringUtils.isNotBlank((CharSequence)startName) && map.containsKey(startName)) {
                        field = (Field)map.get(startName);
                        rangeTip = this.getRepeatFieldMessage(startName, (Field<?>)rangeField, true);
                        existFieldTip = this.getRepeatFieldMessage(startName, field, false);
                        errmsg = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u91cd\u590d\uff1a\u201c{0}\u201d\uff0c\u201c{1}\u201d\uff0c\u201c{2}\u201d\u3002", (String)"DesignerData_77", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), rangeTip, existFieldTip);
                        this.addBuildError(2, item.getKey(), errmsg, entityMetadata);
                        continue block0;
                    }
                    map.put(startName, item);
                    if (StringUtils.isNotBlank((CharSequence)endName) && map.containsKey(endName)) {
                        field = (Field)map.get(endName);
                        rangeTip = this.getRepeatFieldMessage(endName, (Field<?>)rangeField, true);
                        existFieldTip = this.getRepeatFieldMessage(endName, field, false);
                        errmsg = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u91cd\u590d\uff1a\u201c{0}\u201d\uff0c\u201c{1}\u201d\uff0c\u201c{2}\u201d\u3002", (String)"DesignerData_77", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), rangeTip, existFieldTip);
                        this.addBuildError(2, item.getKey(), errmsg, entityMetadata);
                        continue block0;
                    }
                    map.put(endName, item);
                }
                if (!(item instanceof GeoPointField)) continue;
                GeoPointField geoPointField = (GeoPointField)item;
                String fieldKey = geoPointField.getLongitudeFieldName();
                if (StringUtils.isNotBlank((CharSequence)fieldKey) && map.containsKey(fieldKey)) {
                    this.addGeoRepeatFieldNameErrMsg(entityMetadata, entity, item, fieldKey, ResManager.loadKDString((String)"\u7ecf\u5ea6\u5b57\u6bb5\u540d", (String)"DesignerData_111", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), map);
                    continue block0;
                }
                map.put(fieldKey, item);
                fieldKey = geoPointField.getLatitudeFieldName();
                if (StringUtils.isNotBlank((CharSequence)fieldKey) && map.containsKey(fieldKey)) {
                    this.addGeoRepeatFieldNameErrMsg(entityMetadata, entity, item, fieldKey, ResManager.loadKDString((String)"\u7eac\u5ea6\u5b57\u6bb5\u540d", (String)"DesignerData_112", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), map);
                    continue block0;
                }
                map.put(fieldKey, item);
                fieldKey = geoPointField.getAddressFieldName();
                if (StringUtils.isNotBlank((CharSequence)fieldKey) && map.containsKey(fieldKey)) {
                    this.addGeoRepeatFieldNameErrMsg(entityMetadata, entity, item, fieldKey, ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5\u540d", (String)"DesignerData_113", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), map);
                    continue block0;
                }
                map.put(fieldKey, item);
            }
        }
    }

    private void checkDateTimeRangeStartEndKey(EntityMetadata entityMetadata) {
        block0: for (Entity entity : entityMetadata.getEntitys()) {
            HashMap<String, EntityItem> map = new HashMap<String, EntityItem>(16);
            for (EntityItem item : entity.getItems()) {
                Field field;
                String key;
                String msg;
                Field existField;
                String endDateFieldKey;
                String msg2;
                Field existField2;
                String startDateFieldKey;
                DateRangeField rangeField;
                if (item instanceof DateRangeField) {
                    rangeField = (DateRangeField)item;
                    startDateFieldKey = rangeField.getStartDateFieldKey();
                    if (StringUtils.isNotBlank((CharSequence)startDateFieldKey) && map.containsKey(startDateFieldKey)) {
                        existField2 = (Field)map.get(startDateFieldKey);
                        msg2 = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), startDateFieldKey, existField2.getName().toString(), existField2.getKey());
                        this.addBuildError(2, item.getKey(), msg2, entityMetadata);
                        continue block0;
                    }
                    map.put(startDateFieldKey, item);
                    endDateFieldKey = rangeField.getEndDateFieldKey();
                    if (StringUtils.isNotBlank((CharSequence)endDateFieldKey) && map.containsKey(endDateFieldKey)) {
                        existField = (Field)map.get(endDateFieldKey);
                        msg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), endDateFieldKey, existField.getName().toString(), existField.getKey());
                        this.addBuildError(2, item.getKey(), msg, entityMetadata);
                        continue block0;
                    }
                    map.put(endDateFieldKey, item);
                    key = ((Field)item).getFieldName();
                    if (StringUtils.isNotBlank((CharSequence)key) && map.containsKey(key)) {
                        field = (Field)map.get(key);
                        this.addRepeatFieldNameErrMsg(entityMetadata, entity, (Field)item, field);
                        continue block0;
                    }
                    map.put(key, item);
                    continue;
                }
                if (!(item instanceof TimeRangeField)) continue;
                rangeField = (TimeRangeField)item;
                startDateFieldKey = rangeField.getStartDateFieldKey();
                if (StringUtils.isNotBlank((CharSequence)startDateFieldKey) && map.containsKey(startDateFieldKey)) {
                    existField2 = (Field)map.get(startDateFieldKey);
                    msg2 = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), startDateFieldKey, existField2.getName().toString(), existField2.getKey());
                    this.addBuildError(2, item.getKey(), msg2, entityMetadata);
                    continue block0;
                }
                map.put(startDateFieldKey, item);
                endDateFieldKey = rangeField.getEndDateFieldKey();
                if (StringUtils.isNotBlank((CharSequence)endDateFieldKey) && map.containsKey(endDateFieldKey)) {
                    existField = (Field)map.get(endDateFieldKey);
                    msg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), endDateFieldKey, existField.getName().toString(), existField.getKey());
                    this.addBuildError(2, item.getKey(), msg, entityMetadata);
                    continue block0;
                }
                map.put(endDateFieldKey, item);
                key = ((Field)item).getFieldName();
                if (StringUtils.isNotBlank((CharSequence)key) && map.containsKey(key)) {
                    field = (Field)map.get(key);
                    this.addRepeatFieldNameErrMsg(entityMetadata, entity, (Field)item, field);
                    continue block0;
                }
                map.put(key, item);
            }
        }
    }

    private void checkDateRangeTimeRangeKey(EntityMetadata entityMetadata) {
        HashMap<String, EntityItem> map = new HashMap<String, EntityItem>(16);
        block0: for (Entity entity : entityMetadata.getEntitys()) {
            for (EntityItem item : entity.getItems()) {
                String msg;
                Field existField;
                String endDateFieldKey;
                String msg2;
                Field existField2;
                String startDateFieldKey;
                DateRangeField rangeField;
                if (item instanceof Field) {
                    map.put(item.getKey(), item);
                }
                if (item instanceof DateRangeField) {
                    rangeField = (DateRangeField)item;
                    startDateFieldKey = rangeField.getStartDateFieldKey();
                    if (StringUtils.isNotBlank((CharSequence)startDateFieldKey) && map.containsKey(startDateFieldKey)) {
                        existField2 = (Field)map.get(startDateFieldKey);
                        msg2 = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), startDateFieldKey, existField2.getName().toString(), existField2.getKey());
                        this.addBuildError(1, item.getKey(), msg2, entityMetadata);
                        continue block0;
                    }
                    map.put(startDateFieldKey, item);
                    endDateFieldKey = rangeField.getEndDateFieldKey();
                    if (StringUtils.isNotBlank((CharSequence)endDateFieldKey) && map.containsKey(endDateFieldKey)) {
                        existField = (Field)map.get(endDateFieldKey);
                        msg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), endDateFieldKey, existField.getName().toString(), existField.getKey());
                        this.addBuildError(1, item.getKey(), msg, entityMetadata);
                        continue block0;
                    }
                    map.put(endDateFieldKey, item);
                    continue;
                }
                if (!(item instanceof TimeRangeField)) continue;
                rangeField = (TimeRangeField)item;
                startDateFieldKey = rangeField.getStartDateFieldKey();
                if (StringUtils.isNotBlank((CharSequence)startDateFieldKey) && map.containsKey(startDateFieldKey)) {
                    existField2 = (Field)map.get(startDateFieldKey);
                    msg2 = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), startDateFieldKey, existField2.getName().toString(), existField2.getKey());
                    this.addBuildError(1, item.getKey(), msg2, entityMetadata);
                    continue block0;
                }
                map.put(startDateFieldKey, item);
                endDateFieldKey = rangeField.getEndDateFieldKey();
                if (StringUtils.isNotBlank((CharSequence)endDateFieldKey) && map.containsKey(endDateFieldKey)) {
                    existField = (Field)map.get(endDateFieldKey);
                    msg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6807\u8bc6\u6216\u7ed3\u675f\u6807\u8bc6\u91cd\u590d\uff1a\uff08%1$s\uff09%2$s(%3$s)\uff0c%4$s(%5$s)\u3002", (String)"DesignerData_114", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), endDateFieldKey, existField.getName().toString(), existField.getKey());
                    this.addBuildError(1, item.getKey(), msg, entityMetadata);
                    continue block0;
                }
                map.put(endDateFieldKey, item);
            }
        }
    }

    private void addRepeatFieldNameErrMsg(EntityMetadata entityMetadata, Entity<?, ?> entity, Field item, Field existField) {
        String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u540d\uff1a%2$s\u201c%3$s\u201d\uff0c%4$s\u201c%5$s\u201d\u3002", (String)"DesignerData_67", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), item.getName().toString(), item.getKey(), existField.getName().toString(), existField.getKey());
        this.addBuildError(2, item.getKey(), msg, entityMetadata);
    }

    private void addGeoRepeatFieldNameErrMsg(EntityMetadata entityMetadata, Entity<?, ?> entity, EntityItem<?> item, String fieldKey, String fieldName, Map<String, Object> map) {
        Field existField = (Field)map.get(fieldKey);
        String existFieldName = existField.getName().toString();
        if (existField instanceof GeoPointField) {
            GeoPointField geoPointField = (GeoPointField)existField;
            if (fieldKey.equals(geoPointField.getLongitudeFieldName()) && !ResManager.loadKDString((String)"\u7ecf\u5ea6\u5b57\u6bb5\u540d", (String)"DesignerData_111", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]).equals(fieldName)) {
                existFieldName = String.format("%s.%s", geoPointField.getName(), ResManager.loadKDString((String)"\u7ecf\u5ea6\u5b57\u6bb5\u540d", (String)"DesignerData_111", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            if (fieldKey.equals(geoPointField.getLatitudeFieldName()) && !ResManager.loadKDString((String)"\u7eac\u5ea6\u5b57\u6bb5\u540d", (String)"DesignerData_112", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]).equals(fieldName)) {
                existFieldName = String.format("%s.%s", geoPointField.getName(), ResManager.loadKDString((String)"\u7eac\u5ea6\u5b57\u6bb5\u540d", (String)"DesignerData_112", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            if (fieldKey.equals(geoPointField.getAddressFieldName()) && !ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5\u540d", (String)"DesignerData_113", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]).equals(fieldName)) {
                existFieldName = String.format("%s.%s", geoPointField.getName(), ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5\u540d", (String)"DesignerData_113", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u540d\uff1a%2$s\u201c%3$s\u201d\uff0c%4$s\u201c%5$s\u201d\u3002", (String)"DesignerData_67", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().toString(), String.format("%s.%s", item.getName().toString(), fieldName), item.getKey(), existFieldName, existField.getKey());
        this.addBuildError(2, item.getKey(), errorMsg, entityMetadata);
    }

    private String getRepeatFieldMessage(String existKey, Field<?> field, boolean startField) {
        TimeRangeField timeRangeField;
        String endDateFieldKey;
        DateRangeField dateRangeField;
        String startDateFieldKey;
        boolean fieldSame;
        String repeatTip = null;
        repeatTip = field instanceof DateRangeField ? ((fieldSame = StringUtils.containsIgnoreCase((CharSequence)(startDateFieldKey = (dateRangeField = (DateRangeField)field).getStartDateFieldName()), (CharSequence)(endDateFieldKey = dateRangeField.getEndDateFieldName()))) && startField || !fieldSame && StringUtils.equalsIgnoreCase((CharSequence)startDateFieldKey, (CharSequence)existKey) ? String.format("%s.%s\uff08%s\uff09", dateRangeField.getName(), ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5b57\u6bb5", (String)"DesignerData_115", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), dateRangeField.getStartDateFieldKey()) : String.format("%s.%s\uff08%s\uff09", dateRangeField.getName(), ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5b57\u6bb5", (String)"DesignerData_116", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), dateRangeField.getEndDateFieldKey())) : (field instanceof TimeRangeField ? ((fieldSame = StringUtils.containsIgnoreCase((CharSequence)(startDateFieldKey = (timeRangeField = (TimeRangeField)field).getStartDateFieldName()), (CharSequence)(endDateFieldKey = timeRangeField.getEndDateFieldName()))) && startField || !fieldSame && StringUtils.equalsIgnoreCase((CharSequence)startDateFieldKey, (CharSequence)existKey) ? String.format("%s.%s\uff08%s\uff09", timeRangeField.getName(), ResManager.loadKDString((String)"\u5f00\u59cb\u5b57\u6bb5\u540d", (String)"DesignerData_117", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), timeRangeField.getStartDateFieldKey()) : String.format("%s.%s\uff08%s\uff09", timeRangeField.getName(), ResManager.loadKDString((String)"\u7ed3\u675f\u5b57\u6bb5\u540d", (String)"DesignerData_118", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), timeRangeField.getEndDateFieldKey())) : String.format("%s\uff08%s\uff09", field.getName().getLocaleValue(), field.getFieldName()));
        return repeatTip;
    }

    private void checkDecimalScale(DecimalField field, EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata) {
        int newScale;
        Field oldField;
        if (field.getScale() >= field.getPrecision()) {
            this.addBuildError(2, FIELD_NAME, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5c0f\u6570\u7cbe\u5ea6\u4e0d\u5141\u8bb8\u5927\u4e8e\u7b49\u4e8e\u6574\u4f53\u7cbe\u5ea6\u3002", (String)"DesignerData_59", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue()), entityMetadata);
        }
        if (!((oldField = oldEntityMetadata.getFieldByKey(field.getKey())) instanceof DecimalField)) {
            return;
        }
        int oldScale = oldField instanceof AmountField ? ((AmountField)oldField).getScaleByPrecisionType() : ((DecimalField)oldField).getScale();
        int n = newScale = field instanceof AmountField ? ((AmountField)field).getScaleByPrecisionType() : field.getScale();
        if (oldScale != newScale) {
            this.addBuildError(1, FIELD_NAME, MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u7cbe\u5ea6\u53d8\u66f4\uff0c\u8bf7\u540c\u6b65\u4fee\u6539\u6570\u636e\u5e93\u7ed3\u6784\u3002", (String)"DesignerData_86", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue(), field.getKey()), entityMetadata);
        }
    }

    private void checkFieldLenthChange(Field field, EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata) {
        Field oldField = oldEntityMetadata.getFieldByKey(field.getKey());
        if (oldField == null) {
            return;
        }
        int oldLenth = 0;
        int newLenth = 0;
        if (field instanceof TextField) {
            if (oldField instanceof TextField) {
                oldLenth = ((TextField)oldField).getMaxLength();
                newLenth = ((TextField)field).getMaxLength();
            } else {
                this.addBuildError(1, FIELD_NAME, MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u5b57\u6bb5\u7c7b\u578b\u5df2\u53d8\u66f4\uff0c\u8bf7\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u8868\u7ed3\u6784\u3002", (String)"DesignerData_132", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue(), field.getKey()), entityMetadata);
            }
        } else if (field instanceof ComboField) {
            if (oldField instanceof ComboField) {
                oldLenth = ((ComboField)oldField).getMaxLength();
                newLenth = ((ComboField)field).getMaxLength();
            } else {
                this.addBuildError(1, FIELD_NAME, MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u5b57\u6bb5\u7c7b\u578b\u5df2\u53d8\u66f4\uff0c\u8bf7\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u8868\u7ed3\u6784\u3002", (String)"DesignerData_132", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue(), field.getKey()), entityMetadata);
            }
        }
        if (newLenth > oldLenth) {
            this.addBuildError(1, FIELD_NAME, MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u5b57\u6bb5\u6700\u5927\u957f\u5ea6\u5df2\u53d8\u66f4\uff0c\u8bf7\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u6784\u3002", (String)"DesignerData_104", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue(), field.getKey()), entityMetadata);
        }
    }

    private void checkFieldMaxLength(Field<?> field, EntityMetadata entityMetadata) {
        ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)field.getId(), (String)"MaxLength");
        if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
            EntityMetadata oriEntityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityMetadata.getMasterId(), (MetaCategory)MetaCategory.Entity);
            Field oriField = oriEntityMetadata.getFieldByKey(field.getKey());
            if (oriField == null) {
                return;
            }
            int oriLenth = 0;
            int newLenth = 0;
            if (field instanceof TextField) {
                if (oriField instanceof TextField) {
                    oriLenth = ((TextField)oriField).getMaxLength();
                    newLenth = ((TextField)field).getMaxLength();
                } else {
                    this.addBuildError(1, FIELD_NAME, MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u5b57\u6bb5\u7c7b\u578b\u5df2\u53d8\u66f4\uff0c\u8bf7\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u8868\u7ed3\u6784\u3002", (String)"DesignerData_132", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue(), field.getKey()), entityMetadata);
                }
            } else if (field instanceof ComboField) {
                if (oriField instanceof ComboField) {
                    oriLenth = ((ComboField)oriField).getMaxLength();
                    newLenth = ((ComboField)field).getMaxLength();
                } else {
                    this.addBuildError(1, FIELD_NAME, MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u5b57\u6bb5\u7c7b\u578b\u5df2\u53d8\u66f4\uff0c\u8bf7\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u8868\u7ed3\u6784\u3002", (String)"DesignerData_132", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue(), field.getKey()), entityMetadata);
                }
            }
            if (newLenth < oriLenth) {
                this.addBuildError(2, FIELD_NAME, String.format(ResManager.loadKDString((String)"\u57fa\u4e8e\u6e90\u9875\u9762\u7684\u4e1a\u52a1\u5bf9\u8c61\u6269\u5c55\u63a7\u5236\uff0c%1$s(%2$s) \u7684\u6700\u5927\u957f\u5ea6\u5c5e\u6027\u53ea\u80fd\u4fee\u6539\u4e3a\u66f4\u5927\u503c\u3002", (String)"DesignerData_129", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().getLocaleValue(), field.getKey()), entityMetadata);
            }
        }
    }

    private boolean judgeEntityItemType(EntityItem<?> entity) {
        return entity instanceof Field && !(entity instanceof DateRangeField) && !(entity instanceof TimeRangeField) && !(entity instanceof RadioField) && !(entity instanceof BasedataPropField) && !(entity instanceof MulBasedataField);
    }

    private void checkItemClassType(EntityMetadata entityMetadata) {
        List entityList = entityMetadata.getItems();
        for (EntityItem entity : entityList) {
            ItemClassTypeField itemClassTypeField;
            if (!(entity instanceof ItemClassTypeField) || !(itemClassTypeField = (ItemClassTypeField)entity).getItemTypes().isEmpty()) continue;
            this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5173\u8054\u4efb\u4f55\u57fa\u7840\u8d44\u6599\u3002", (String)"DesignerData_133", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), itemClassTypeField.getName()), entityMetadata);
        }
    }

    private void checkAssistantField(AssistantField field, EntityMetadata entityMetadata) {
        if (field.getAsstTypeId() == null) {
            this.addBuildError(2, "asstTypeId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssistantField_0", (String)BOS_METADATA, (Object[])new Object[0]), field.getName()), entityMetadata);
        }
    }

    private void checkGroupField(EntityMetadata entityMetadata) {
        List entityList = entityMetadata.getItems();
        boolean isTemplate = false;
        for (EntityItem entity : entityList) {
            GroupField groupField;
            if (entity instanceof MainEntity) {
                isTemplate = ((MainEntity)entity).isTemplate();
                continue;
            }
            if (!(entity instanceof GroupField) || !"bos_group".equalsIgnoreCase(MetadataDao.getEntityNumberById((String)(groupField = (GroupField)entity).getBaseEntityId())) || isTemplate || !StringUtils.isBlank((CharSequence)groupField.getGroupTableName())) continue;
            this.addBuildError(2, "GroupTableName", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u5b57\u6bb5\uff1a\u201c%2$s\u201d\u5173\u8054\u7684\u201c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_119", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata.getName().toString(), groupField.getName().getDefaultItem()), entityMetadata);
        }
    }

    private void checkForm(EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata, String modelType) {
        List entityList = entityMetadata.getItems();
        ArrayList<String> emptyEntryTables = new ArrayList<String>();
        boolean isNeedCheckTable = this.isNeedCheckTable(entityMetadata, true, modelType);
        CaseInsensitiveMap allTables = new CaseInsensitiveMap();
        HashSet<String> entryTables = new HashSet<String>(10);
        for (EntityItem entity : entityList) {
            if (entity instanceof BillEntity) {
                String number = DesignerData.getEntityNumberById(entity.getId());
                String pkFieldName = ((BillEntity)entity).getPkFieldName();
                String tableName = ((BillEntity)entity).getTableName();
                String key = entity.getKey();
                if (key != null && !key.equals(number) && this.checkNumber(key)) {
                    this.addBuildError(2, "Key", ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u5df2\u5b58\u5728\u3002", (String)"DesignerData_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
                }
                if (BASE_FORM_MODEL.equals(modelType)) {
                    BaseEntity baseEntity = (BaseEntity)entity;
                    if (StringUtils.isEmpty((CharSequence)baseEntity.getNameFieldId())) {
                        this.addBuildError(1, "NameFieldId", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u540d\u79f0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
                    }
                    if (StringUtils.isEmpty((CharSequence)baseEntity.getNumberFieldId())) {
                        this.addBuildError(2, "numberFieldId", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7f16\u7801\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_18", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
                    }
                }
                this.checkRepeatTable((Map<String, String>)allTables, tableName, entity, entityMetadata);
                this.checkFormResult(pkFieldName, tableName, key, true, entityMetadata);
                continue;
            }
            if (entity instanceof SubEntryEntity) {
                EntryEntity parentEntity = entityMetadata.getEntryById(((SubEntryEntity)entity).getParentId());
                if (parentEntity == null) {
                    this.addBuildError(2, entity.getName() == null ? "" : entity.getName().getLocaleValue(), ResManager.loadKDString((String)"\u5b50\u5355\u636e\u4f53\u7684\u7236\u5355\u636e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_19", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
                }
                String entrytableName = ((EntryEntity)entity).getTableName();
                if (!isNeedCheckTable) continue;
                this.checkRepeatTable((Map<String, String>)allTables, entrytableName, entity, entityMetadata);
                if (StringUtils.isBlank((CharSequence)entrytableName)) {
                    emptyEntryTables.add(((EntryEntity)entity).getName().getLocaleValue());
                    continue;
                }
                entryTables.add(entrytableName);
                continue;
            }
            if (entity instanceof EntryEntity) {
                String entryPkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
                String entrytableName = ((EntryEntity)entity).getTableName();
                if (isNeedCheckTable) {
                    this.checkRepeatTable((Map<String, String>)allTables, entrytableName, entity, entityMetadata);
                    if (StringUtils.isBlank((CharSequence)entrytableName)) {
                        emptyEntryTables.add(((EntryEntity)entity).getName().getLocaleValue());
                    } else {
                        entryTables.add(entrytableName);
                    }
                }
                String entrykey = "entrykey";
                this.checkFormResult(entryPkFieldName, entrytableName, entrykey, false, entityMetadata);
                continue;
            }
            if (entity instanceof IAttachmentCountField) {
                if (!StringUtils.isBlank((CharSequence)((IAttachmentCountField)entity).getFieldName())) continue;
                this.addBuildError(2, entity.getName().getLocaleValue(), ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_20", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
                continue;
            }
            if (entity instanceof IAttachmentField && ("BillFormModel".equals(entityMetadata.getModelType()) || BASE_FORM_MODEL.equals(entityMetadata.getModelType()))) {
                String tableName = ((IAttachmentField)entity).getTableName();
                if (StringUtils.isBlank((CharSequence)tableName)) {
                    this.addBuildError(1, TABLE_NAME, String.format(ResManager.loadKDString((String)"%s\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_120", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().getLocaleValue()), entityMetadata);
                }
                this.checkRepeatTable((Map<String, String>)allTables, tableName, entity, entityMetadata);
                continue;
            }
            if (entity instanceof DecimalField) {
                this.checkDecimalDefValueAndScope((DecimalField)entity, entityMetadata);
                this.checkDecimalScale((DecimalField)entity, entityMetadata, oldEntityMetadata);
                continue;
            }
            if (entity instanceof TextField) {
                this.checkTextDefValueLengthAndMaxMin((TextField)entity, entityMetadata);
                this.checkFieldLenthChange((Field)((TextField)entity), entityMetadata, oldEntityMetadata);
                continue;
            }
            if (entity instanceof ComboField) {
                this.checkFieldLenthChange((Field)((ComboField)entity), entityMetadata, oldEntityMetadata);
                continue;
            }
            if (entity instanceof DateTimeField) {
                this.checkDateTimeDefValue((DateTimeField)entity, entityMetadata);
                continue;
            }
            if (entity instanceof BasedataField) {
                this.checkPermissionDimension((BasedataField)entity, entityMetadata);
                if (!(entity instanceof AssistantField)) continue;
                this.checkAssistantField((AssistantField)entity, entityMetadata);
                continue;
            }
            if (!(entity instanceof MulBasedataField)) continue;
            MulBasedataField mulBasedataField = (MulBasedataField)entity;
            boolean isNeedCheckTableName = true;
            if (mulBasedataField instanceof IAttachmentField) {
                return;
            }
            if ("ParameterFormModel_application".equals(modelType) || "ParameterFormModel_public".equals(modelType) || "ReportFormModel".equalsIgnoreCase(modelType)) {
                isNeedCheckTableName = false;
            }
            if (!isNeedCheckTableName || !StringUtils.isBlank((CharSequence)mulBasedataField.getTableName())) continue;
            this.addBuildError(1, TABLE_NAME, String.format(ResManager.loadKDString((String)"%s\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_120", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mulBasedataField.getName().getLocaleValue()), entityMetadata);
        }
        if (!emptyEntryTables.isEmpty()) {
            this.addBuildError(1, null, String.format(ResManager.loadKDString((String)"%s\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_120", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), String.join((CharSequence)"\u3001", emptyEntryTables)), entityMetadata);
        }
        if (!entryTables.isEmpty()) {
            try {
                SqlBuilder sqlbuilder = new SqlBuilder();
                sqlbuilder.append("select top 1 fid from t_meta_mainentityinfo where fid != ?", new Object[]{new SqlParameter(":fid", 12, (Object)entityMetadata.getId())}).append(" and ", new Object[0]).appendIn("ftablename", (Object[])entryTables.toArray(new String[entryTables.size()]));
                boolean exist = (Boolean)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlbuilder, rs -> {
                    if (rs.next()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                });
                if (exist) {
                    this.addBuildError(1, TABLE_NAME, ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\u5b58\u5728\u5355\u636e\u4f53\u8868\u540d\u548c\u5176\u5b83\u5355\u636e\u4e3b\u8868\u51b2\u7a81\u3002", (String)"DesignerData_88", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private void checkDateTimeDefValue(DateTimeField field, EntityMetadata meta) {
        boolean right;
        boolean left;
        FieldDefValue defValueDesign = field.buildDesignDefValue();
        Date minDate = field.getDesignMinDate();
        Date maxDate = field.getDesignMaxDate();
        if (defValueDesign == null || minDate == null && maxDate == null) {
            return;
        }
        DefaultValueCalculator calculator = new DefaultValueCalculator();
        Date def = (Date)calculator.getValue2(null, null, null, defValueDesign);
        if (def == null) {
            return;
        }
        Date defDate = (Date)ConvertUtils.convert((Object)def, Date.class);
        boolean bl = minDate == null ? true : (left = defDate.getTime() >= minDate.getTime());
        boolean bl2 = maxDate == null ? true : (right = defDate.getTime() <= maxDate.getTime());
        if (!left || !right) {
            this.addBuildError(2, field.getName().toString(), MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u5b57\u6bb5\uff1a\u5b57\u6bb5\u7684\u201c\u7f3a\u7701\u503c\u201d\u8d85\u51fa\u201c\u53ef\u9009\u8303\u56f4\u201d\u3002", (String)"DesignerData_74", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), field.getName().toString()), meta);
        }
    }

    private void checkRepeatTable(Map<String, String> tables, String tableName, EntityItem<?> entity, EntityMetadata entityMetadata) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        if (tables.containsKey(tableName)) {
            this.addBuildError(2, "Table", String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s\u8868\u540d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"DesignerData_128", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), tables.get(tableName), entity.getName() == null ? "" : entity.getName().getLocaleValue()), entityMetadata);
        } else {
            tables.put(tableName, entity.getName() == null ? "" : entity.getName().getLocaleValue());
        }
    }

    private void checkPermissionDimension(BasedataField basedataField, EntityMetadata entityMetadata) {
        if (entityMetadata.getRootEntity().getPermissionDimension() != null && !(basedataField instanceof OrgField)) {
            String fieldData = entityMetadata.getRootEntity().getPermissionDimension().getDataDimension();
            String fieldName = entityMetadata.getRootEntity().getPermissionDimension().getDataDimensionField();
            if (fieldData != null && fieldName != null && basedataField.getBaseEntityId() != null && StringUtils.equals((CharSequence)basedataField.getKey(), (CharSequence)fieldName) && !StringUtils.equals((CharSequence)basedataField.getBaseEntityId(), (CharSequence)fieldData)) {
                this.addBuildError(2, fieldName, String.format(ResManager.loadKDString((String)"%s\u4e0e\u6743\u9650\u63a7\u5236\u4e2d\u7684\u6743\u9650\u63a7\u5236\u4e3b\u5b57\u6bb5\u5173\u8054\u4e0d\u7b26\u3002", (String)"DesignerData_25", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), fieldName), entityMetadata);
            }
        }
    }

    private void checkTextDefValueLengthAndMaxMin(TextField entity, EntityMetadata entityMetadata) {
        int len;
        String defVal = entity.getDefValue();
        int minLen = entity.getMinLength();
        int maxLen = entity.getMaxLength();
        if (!(defVal == null || "".equals(defVal) || minLen <= (len = defVal.length()) && len <= maxLen)) {
            this.addBuildError(2, entity.getName().getLocaleValue(), String.format(ResManager.loadKDString((String)"%1$s%2$s\u7f3a\u7701\u503c\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u6700\u5c0f\u957f\u5ea6\u5c0f\u4e8e\u6700\u5927\u957f\u5ea6\u3002", (String)"DesignerData_26", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName(), entity.getKey()), entityMetadata);
        }
        if (minLen > maxLen) {
            this.addBuildError(2, FIELD_NAME, String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u7684\u201c\u6700\u5927\u957f\u5ea6\u201d\u5c0f\u4e8e\u201c\u6700\u5c0f\u957f\u5ea6\u201d\u3002", (String)"DesignerData_121", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entity.getName().getLocaleValue()), entityMetadata);
        }
    }

    private void checkDecimalDefValueAndScope(DecimalField decimalfield, EntityMetadata entityMetadata) {
        BigDecimal minVal;
        BigDecimal defVal = decimalfield.getDefValue();
        if (StringUtils.isBlank((Object)defVal)) {
            return;
        }
        int precision = decimalfield.getPrecision();
        int scale = decimalfield.getScale();
        if (decimalfield instanceof AmountField) {
            precision = ((AmountField)decimalfield).getPrecisionByPrecisionType();
            scale = ((AmountField)decimalfield).getScaleByPrecisionType();
        }
        if (defVal.precision() - defVal.scale() > precision - scale) {
            this.addBuildError(2, decimalfield.getName().getLocaleValue(), MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d{1}\uff1a\u7f3a\u7701\u503c\u8d85\u51fa\u7cbe\u5ea6\u8303\u56f4\uff08{2},{3}\uff09\u3002", (String)"DesignerData_82", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), decimalfield.getName().getLocaleValue(), decimalfield.getKey(), precision, scale), entityMetadata);
            return;
        }
        String min = decimalfield.getMinDataScope();
        String max = decimalfield.getMaxDataScope();
        boolean isMinExclude = "(".equals(decimalfield.getMinDataScopeMark());
        boolean isMaxExclude = ")".equals(decimalfield.getMaxDataScopeMark());
        boolean isBlankMin = StringUtils.isBlank((CharSequence)min);
        boolean isBlankMax = StringUtils.isBlank((CharSequence)max);
        if (isBlankMin && isBlankMax) {
            if (decimalfield instanceof IntegerField && defVal.precision() - defVal.scale() > decimalfield.getPrecision() - decimalfield.getScale()) {
                this.addBuildError(2, decimalfield.getName().getLocaleValue(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u7684\u201c\u7f3a\u7701\u503c\u201d\u8d85\u51fa\u6570\u503c\u8303\u56f4\u3002\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"DesignerData_60", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), decimalfield.getName().getLocaleValue()), entityMetadata);
            }
            return;
        }
        boolean validScope = true;
        if (!isBlankMin && (validScope = this.validScope(decimalfield, minVal = new BigDecimal(min), entityMetadata))) {
            if (!isBlankMax && minVal.compareTo(new BigDecimal(max)) > 0) {
                this.addBuildError(2, decimalfield.getName().getLocaleValue(), ResManager.loadKDString((String)"\u201c\u6570\u503c\u8303\u56f4\u201d\u7684\u6700\u5c0f\u503c\u5e94\u5c0f\u4e8e\u6700\u5927\u503c\u3002", (String)"DesignerData_27", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
            } else if (isMinExclude ? defVal.compareTo(minVal) <= 0 : defVal.compareTo(minVal) < 0) {
                this.addBuildError(2, decimalfield.getName().getLocaleValue(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u7f3a\u7701\u503c\u201d\u5c0f\u4e8e\u201c\u6570\u503c\u8303\u56f4\u201d\u7684\u6700\u5c0f\u503c\u3002", (String)"DesignerData_28", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), decimalfield.getName()), entityMetadata);
            }
        }
        if (!isBlankMax) {
            BigDecimal maxVal = new BigDecimal(max);
            if (validScope && this.validScope(decimalfield, maxVal, entityMetadata) && (isMaxExclude ? defVal.compareTo(maxVal) >= 0 : defVal.compareTo(maxVal) > 0)) {
                this.addBuildError(2, decimalfield.getName().getLocaleValue(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u7f3a\u7701\u503c\u201d\u5927\u4e8e\u201c\u6570\u503c\u8303\u56f4\u201d\u7684\u6700\u5927\u503c\u3002", (String)"DesignerData_29", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), decimalfield.getName()), entityMetadata);
            }
        }
    }

    private boolean validScope(DecimalField decimalfield, BigDecimal val, EntityMetadata entityMetadata) {
        boolean valid;
        BigDecimal[] scope = new BigDecimal[2];
        DecimalFormat df = new DecimalFormat("#");
        if (decimalfield instanceof BigIntField) {
            scope[0] = new BigDecimal(Long.MIN_VALUE);
            scope[1] = new BigDecimal(Long.MAX_VALUE);
        } else if (decimalfield instanceof IntegerField) {
            scope[0] = new BigDecimal(Integer.MIN_VALUE);
            scope[1] = new BigDecimal(Integer.MAX_VALUE);
        } else {
            return true;
        }
        boolean bl = valid = scope[0].compareTo(val) <= 0 && scope[1].compareTo(val) >= 0;
        if (!valid) {
            this.addBuildError(2, decimalfield.getName().getLocaleValue(), String.format(ResManager.loadKDString((String)"%1$s\u6570\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e[%2$s,%3$s]\u4e4b\u95f4\u3002", (String)"DesignerData_30", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), decimalfield.getName().getLocaleValue(), df.format(scope[0]), df.format(scope[1])), entityMetadata);
        }
        return valid;
    }

    protected void addBuildError(int level, String propertyName, String error, EntityMetadata entityMetadata) {
        ErrorInfo info = new ErrorInfo();
        info.setItemId(entityMetadata.getId());
        info.setPropertyName(propertyName);
        info.setType("entity");
        info.setLevel(level);
        info.setError(error);
        entityMetadata.addError(info);
    }

    private boolean isNeedCheckTable(EntityMetadata entityMetadata, boolean isEntry, String modelType) {
        if (!"BillFormModel".equals(modelType) && !BASE_FORM_MODEL.equals(modelType)) {
            return false;
        }
        return !entityMetadata.getRootEntity().isTemplate();
    }

    private void checkFormResult(String pkFieldName, String tableName, String key, boolean checkEmpty, EntityMetadata entityMetadata) {
        String regex = "[a-z0-9A-Z_]+";
        if (StringUtils.isBlank((CharSequence)tableName)) {
            if (checkEmpty) {
                this.addBuildError(1, TABLE_NAME, String.format(ResManager.loadKDString((String)"%s\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_120", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata.getRootEntity().getName().getLocaleValue()), entityMetadata);
            }
        } else {
            if (tableName.length() > 25) {
                this.addBuildError(2, TABLE_NAME, ResManager.loadKDString((String)"\u8868\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"DesignerData_33", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
            }
            if (!Pattern.matches(regex, tableName)) {
                this.addBuildError(2, TABLE_NAME, ResManager.loadKDString((String)"\u8868\u540d\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DesignerData_34", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)pkFieldName)) {
            if (pkFieldName.length() > 25) {
                this.addBuildError(2, "PkFieldName", ResManager.loadKDString((String)"\u4e3b\u952e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"DesignerData_35", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
            }
            if (!Pattern.matches(regex, pkFieldName)) {
                this.addBuildError(1, "PkFieldName", ResManager.loadKDString((String)"\u4e3b\u952e\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DesignerData_36", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
            }
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            this.addBuildError(2, "Key", ResManager.loadKDString((String)"\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerData_37", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
        }
        if (!Pattern.matches(regex, key)) {
            this.addBuildError(2, "Key", ResManager.loadKDString((String)"\u6807\u8bc6\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DesignerData_38", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
        }
    }

    private void checkEmptyFieldId(AbstractMetadata metadata, EntityMetadata entityMetadata, List<Predicate<MobTableAp>> predicates) {
        if (metadata instanceof FormMetadata) {
            FormMetadata formMetadata = (FormMetadata)metadata;
            List controlAps = formMetadata.getItems();
            ArrayList<MobTableAp> dataSourceMobTableList = new ArrayList<MobTableAp>();
            ArrayList<MobTableColumnAp> mobTableColumnApList = new ArrayList<MobTableColumnAp>();
            for (ControlAp ap : controlAps) {
                if (!(ap instanceof CardEntryAp) || formMetadata.getRootAp() instanceof MobileBillFormAp) continue;
                predicates.add(mobTableAp -> ap.getKey().equals(mobTableAp.getMobTableDataSource().get("Key")));
            }
            for (ControlAp ap : controlAps) {
                CommonFilterColumnAp filterColumnAp;
                if (ap instanceof BillFormAp) {
                    this.checkEmptyFieldId((AbstractMetadata)((BillFormAp)ap).getMobListMeta(), entityMetadata, predicates);
                    this.checkEmptyFieldId((AbstractMetadata)((BillFormAp)ap).getMobMeta(), entityMetadata, predicates);
                }
                if (ap instanceof ListColumnAp && StringUtils.isBlank((CharSequence)((ListColumnAp)ap).getListFieldId())) {
                    this.addBuildError(2, "ListFieldId", String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u7684\u5b57\u6bb5\u6620\u5c04\u3002", (String)"DesignerData_41", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getKey(), ap.getName()) + "\r\n", entityMetadata);
                }
                if (ap instanceof FieldAp && StringUtils.isBlank((CharSequence)((FieldAp)ap).getFieldId())) {
                    this.addBuildError(2, "FieldId", String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u7684\u5b57\u6bb5\u6620\u5c04\u3002", (String)"DesignerData_41", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getKey(), ap.getName()) + "\r\n", entityMetadata);
                }
                if (ap instanceof MobTableAp) {
                    dataSourceMobTableList.add((MobTableAp)ap);
                }
                if (ap instanceof MobTableColumnAp) {
                    mobTableColumnApList.add((MobTableColumnAp)ap);
                }
                if (!(ap instanceof MobCommonFilterColumnAp) && !(ap instanceof MobCommonDateFilterColumnAp) && !(ap instanceof MobCommonBaseDataFilterColumnAp) && !(ap instanceof MobCommonCheckBoxFilterColumnAp) || !(filterColumnAp = (CommonFilterColumnAp)ap).isMustInput() || !StringUtils.isBlank((CharSequence)filterColumnAp.getDefValue())) continue;
                this.addBuildError(1, "FieldId", String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5b57\u6bb5\u5df2\u5f00\u542f\u5fc5\u5f55\uff0c\u9700\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u3002", (String)"DesignerData_76", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), filterColumnAp.getFieldName(), ap.getName()), entityMetadata);
            }
            for (MobTableAp mobTableAp2 : dataSourceMobTableList) {
                Map mobTableDataSource = mobTableAp2.getMobTableDataSource();
                if (StringUtils.equals((CharSequence)"entryTable", (CharSequence)mobTableAp2.getMobTableType()) && mobTableDataSource == null) {
                    this.addBuildError(2, "MobTableField", String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e%1$s(%2$s)\u6570\u636e\u6e90\u3002", (String)"MobTableDesignerData_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mobTableAp2.getName(), mobTableAp2.getKey()), entityMetadata);
                    continue;
                }
                if (mobTableDataSource == null) continue;
                boolean isNotCardEntryMapping = true;
                for (Predicate<MobTableAp> predicate : predicates) {
                    if (!predicate.test(mobTableAp2)) continue;
                    this.addBuildError(2, "MobTableField", String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u6682\u4e0d\u652f\u6301\u6620\u5c04\u5361\u7247\u5206\u5f55\u3002", (String)"MobTableDesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mobTableAp2.getName(), mobTableAp2.getKey()), entityMetadata);
                    isNotCardEntryMapping = false;
                }
                for (MobTableColumnAp ap : mobTableColumnApList) {
                    if (!isNotCardEntryMapping || !StringUtils.equals((CharSequence)mobTableAp2.getId(), (CharSequence)ap.getParentId()) || !StringUtils.isBlank((CharSequence)ap.getMobTableField())) continue;
                    this.addBuildError(2, "MobTableField", String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u7684\u5b57\u6bb5\u6620\u5c04\u3002", (String)"DesignerData_41", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getKey(), ap.getName()), entityMetadata);
                }
            }
        }
    }

    private void checkDataDimension(EntityMetadata entityMetadata) {
        if (null == entityMetadata || null == entityMetadata.getRootEntity()) {
            return;
        }
        String mainOrgId = entityMetadata.getRootEntity().getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrgId)) {
            return;
        }
        EntityItem item = entityMetadata.getItemById(mainOrgId);
        PermissionDimension permissionDimension = entityMetadata.getRootEntity().getPermissionDimension();
        if (null == item || null == permissionDimension) {
            return;
        }
        String controllType = permissionDimension.getDimension();
        if (StringUtils.isNotBlank((CharSequence)controllType) && "DIM_ORG".equalsIgnoreCase(controllType)) {
            String dataDimension = permissionDimension.getDataDimension();
            String manOrgField = item.getKey();
            if (!mainOrgId.equals(dataDimension)) {
                permissionDimension.setDataDimension(mainOrgId);
                permissionDimension.setDataDimensionField(manOrgField);
                entityMetadata.getRootEntity().setPermissionDimension(permissionDimension);
            }
        }
    }

    private void checkExchangeRateGroupField(FormMetadata formMetadata, EntityMetadata entityMetadata) {
        FormMetadata mobMeta;
        ExchangeRateGroupCheckUtil.checkExchangeRateGroupField((FormMetadata)formMetadata, (EntityMetadata)entityMetadata);
        FormAp rootAp = formMetadata.getRootAp();
        if (rootAp instanceof BillFormAp && (mobMeta = ((BillFormAp)rootAp).getMobMeta()) != null) {
            ExchangeRateGroupCheckUtil.checkExchangeRateGroupField((FormMetadata)mobMeta, (EntityMetadata)entityMetadata);
        }
    }

    private void checkTableAndFieldChange(EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata, String modelType) {
        if (oldEntityMetadata != null && ("BillFormModel".equals(modelType) || BASE_FORM_MODEL.equals(modelType))) {
            List newItems = entityMetadata.getItems();
            List oldItems = oldEntityMetadata.getItems();
            HashMap<String, String> newMap = new HashMap<String, String>(16);
            HashMap<String, String> oldMap = new HashMap<String, String>(16);
            this.getTableAndFieldNameMap(newItems, newMap);
            this.getTableAndFieldNameMap(oldItems, oldMap);
            int i = 1;
            StringBuilder sbu = new StringBuilder();
            for (Map.Entry entry : newMap.entrySet()) {
                if (!((String)entry.getKey()).contains(TABLE_NAME)) continue;
                String newTableName = (String)entry.getValue();
                String oldTableName = (String)oldMap.get(entry.getKey());
                if (!StringUtils.isNotEmpty((CharSequence)oldTableName) || !StringUtils.isNotEmpty((CharSequence)newTableName) || StringUtils.equals((CharSequence)newTableName, (CharSequence)oldTableName)) continue;
                sbu.append("\n").append(i++).append("\u3001").append(String.format(ResManager.loadKDString((String)"\u8868\u540d%1$s\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5c06\u5df2\u6709\u6570\u636e\u8fc1\u79fb\u5230%2$s\u8868\u4e2d\u3002", (String)"DesignerData_92", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), oldTableName, newTableName));
            }
            for (Map.Entry entry : newMap.entrySet()) {
                if (((String)entry.getKey()).contains(TABLE_NAME)) continue;
                String newFieldName = (String)entry.getValue();
                String oldFieldName = (String)oldMap.get(entry.getKey());
                if (!StringUtils.isNotEmpty((CharSequence)oldFieldName) || !StringUtils.isNotEmpty((CharSequence)newFieldName) || StringUtils.equals((CharSequence)newFieldName, (CharSequence)oldFieldName)) continue;
                sbu.append("\n").append(i++).append("\u3001").append(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d%1$s\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5c06\u5df2\u6709\u6570\u636e\u8fc1\u79fb\u5230%2$s\u5b57\u6bb5\u4e2d\u3002", (String)"DesignerData_93", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), oldFieldName, newFieldName));
            }
            if (StringUtils.isNotEmpty((CharSequence)sbu)) {
                String str = ResManager.loadKDString((String)"\u8fd8\u6709\u5982\u4e0b\u95ee\u9898\u9700\u8981\u60a8\u5173\u6ce8\uff1a", (String)"DesignerData_94", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                this.addBuildError(1, "", str + sbu, entityMetadata);
            }
        }
    }

    private void getTableAndFieldNameMap(List<EntityItem<?>> items, Map<String, String> map) {
        if (!CollectionUtils.isEmpty(items)) {
            for (EntityItem<?> item : items) {
                String tableName;
                String id = item.getId();
                if (item instanceof BillEntity) {
                    id = id + TABLE_NAME;
                    tableName = ((BillEntity)item).getTableName();
                    map.put(id, tableName);
                    continue;
                }
                if (item instanceof EntryEntity) {
                    id = id + TABLE_NAME;
                    tableName = ((EntryEntity)item).getTableName();
                    map.put(id, tableName);
                    continue;
                }
                if (item instanceof MulBasedataField) {
                    id = id + TABLE_NAME;
                    tableName = ((MulBasedataField)item).getTableName();
                    map.put(id, tableName);
                    continue;
                }
                if (!(item instanceof Field)) continue;
                String fieldName = ((Field)item).getFieldName();
                map.put(id, fieldName);
            }
        }
    }

    private void checkExtIsChangeTemplate(EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata) {
        if (entityMetadata == null || oldEntityMetadata == null || StringUtils.isBlank((CharSequence)entityMetadata.getMasterId())) {
            return;
        }
        if (entityMetadata.getRootEntity().isTemplate() != oldEntityMetadata.getRootEntity().isTemplate()) {
            this.addBuildError(2, "", ResManager.loadKDString((String)"\u3010\u6a21\u677f\u3011\u5c5e\u6027\u4e0d\u652f\u6301\u6269\u5c55\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5\u5b9e\u4f53\u5c5e\u6027\u3002", (String)"DesignerData_122", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityMetadata);
        }
    }

    private static Map<String, Object> getSystemParam() {
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        param.setOrgId(Long.valueOf(rootOrgId));
        param.setViewType("15");
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param);
    }

    static {
        SYS_TPL_LIST.add("bos_basegrouporgtpl");
        SYS_TPL_LIST.add("bos_basegrouptpl");
        SYS_TPL_LIST.add("bos_baseorgtpl");
        SYS_TPL_LIST.add("bos_basetpl");
        SYS_TPL_LIST.add("bos_basetreeorgtpl");
        SYS_TPL_LIST.add("bos_basetreetpl");
        SYS_TPL_LIST.add("bos_billorgtpl");
        SYS_TPL_LIST.add("bos_billtpl");
        SYS_TPL_LIST.add("bos_appparametertpl");
        SYS_TPL_LIST.add("bos_billparametertpl");
        SYS_TPL_LIST.add("bos_billtypeparametertpl");
        SYS_TPL_LIST.add("bos_cloudparametertpl");
        SYS_TPL_LIST.add("bos_listoptiontpl");
        SYS_TPL_LIST.add("bos_orgoptiontpl");
        SYS_TPL_LIST.add("bos_useroptiontpl");
        SYS_TPL_LIST.add("bos_commfilterrpttpl");
        SYS_TPL_LIST.add("bos_grouprpttpl");
        SYS_TPL_LIST.add("bos_rptqingtpl");
        SYS_TPL_LIST.add("bos_rpttpl");
        SYS_TPL_LIST.add("bos_card_template_new");
        SYS_TPL_LIST.add("bos_dialogtpl");
        SYS_TPL_LIST.add("bos_dialogtpl_middle");
        SYS_TPL_LIST.add("bos_portal_apphome_grid");
        SYS_TPL_LIST.add("bos_portal_gridcontainer");
        SYS_TPL_LIST.add("bos_wizardtpl");
        SYS_TPL_LIST.add("bos_mobiletpl");
        SYS_TPL_LIST.add("bos_personalinfotpl");
        SYS_TPL_LIST.add("bos_reimbursetpl");
        SYS_TPL_LIST.add("bos_logbilltpl");
        METALOCK = Interners.newWeakInterner();
        checkNumber = "designer.save.ignorechecknumber";
        ignoreCheckNumber = false;
        ignoreCheckNumber = Boolean.parseBoolean(System.getProperty(checkNumber));
        ConfigurationUtil.observeChange((String)checkNumber, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                ignoreCheckNumber = Boolean.parseBoolean(System.getProperty(checkNumber));
            }
        });
    }

    static enum MetaType {
        Form(1),
        List(2),
        MobForm(3),
        MobList(4);

        private short nCode;

        private MetaType(int _nCode) {
            this.nCode = (short)_nCode;
        }

        public short getValue() {
            return this.nCode;
        }
    }

    public class ClearSubRuntimeMetaRunnable
    implements Runnable {
        private final Log logger = LogFactory.getLog(ClearSubRuntimeMetaRunnable.class);
        private List<String> formIds;
        private RequestContext ctx;

        public ClearSubRuntimeMetaRunnable(RequestContext ctx, List<String> formIds) {
            this.formIds = formIds;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            this.logger.debug("\u4fdd\u5b58\u5143\u6570\u636e\u5b8c\u6210\uff0c\u5f00\u59cb\u6e05\u9664\u5b50\u5355\u636e\u7684\u8fd0\u884c\u65f6\u7f13\u5b58\uff0c\u5e76\u91cd\u5efa");
            RequestContext.copyAndSet((RequestContext)this.ctx);
            try {
                MetadataDao.clearSubRuntimeMeta(this.formIds);
            }
            catch (Exception e) {
                String stack = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                this.logger.warn("\u4fdd\u5b58\u5143\u6570\u636e\u5df2\u6210\u529f\uff0c\u4f46\u662f\u91cd\u5efa\u5b50\u5355\u636e\u8fd0\u884c\u65f6\u51fa\u73b0\u4e86\u4e00\u4e9b\u5f02\u5e38\uff0cERR:" + stack);
            }
        }
    }
}

