/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.net.URL;
import java.util.Map;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.DBServiceHelper;

public class DynamicFormTemplate
implements IFormTemplate {
    private static final String FORM_RESOURCE = "/DynamicForm.xml";
    private static final String ENTITY_RESOURCE = "/DynamicEntity.xml";
    private final String modelType;
    final DomainModelBinder binder;

    public DynamicFormTemplate(String modelType) {
        this.modelType = modelType;
        this.binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)this.modelType, (boolean)false));
    }

    protected String getFormResource() {
        return FORM_RESOURCE;
    }

    protected String getEntityResource() {
        return ENTITY_RESOURCE;
    }

    public String getModelType() {
        return this.modelType;
    }

    @Override
    public DomainModelBinder getBinder() {
        return this.binder;
    }

    @Override
    public Map<String, Object> serializeToMap(Object el) {
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)this.binder);
        this.binder.setWriteInheritFlag(true);
        return ser.serializeToMap(el, null);
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        DcxmlSerializer serXml = new DcxmlSerializer((DcBinder)this.binder);
        URL entityUrl = DynamicFormTemplate.class.getResource(this.getEntityResource());
        EntityMetadata entityMeta = (EntityMetadata)serXml.deserialize(entityUrl, null);
        entityMeta.setModelType(this.modelType);
        return entityMeta;
    }

    @Override
    public FormMetadata getFormMetadata() {
        DcxmlSerializer serXml = new DcxmlSerializer((DcBinder)this.binder);
        URL formUrl = DynamicFormTemplate.class.getResource(this.getFormResource());
        FormMetadata formMeta = (FormMetadata)serXml.deserialize(formUrl, null);
        formMeta.setId(DBServiceHelper.genStringIds((String)"", (int)1)[0]);
        formMeta.setModelType(this.modelType);
        return formMeta;
    }

    @Override
    public Object deserializeFromMap(Map<String, Object> metaMap, Object baseObject) {
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)this.binder);
        return ser.deserializeFromMap(metaMap, baseObject);
    }
}

