/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;

public class EntityDesignerData
extends DesignerData {
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String NAME = "Name";
    private static final String KEY = "Key";
    private static final String CAPTION = "caption";
    private static final String ENABLE_INHERIT_PROPERTY = "EnableInheritProperty";
    private static final String ENABLE_EXTEND_PROPERTY = "EnableExtendProperty";

    @Override
    protected Map<String, Object> saveDesignMetadata(Map<String, Object> content, Map<String, Object> oldContent, boolean isDraft) {
        String mainEntityKey;
        Map formMeta = (Map)content.get("formmeta");
        if (formMeta == null) {
            String modelType = (String)content.get("modelType");
            FormMetadata formMetaData = null;
            if (oldContent != null) {
                AbstractMetadata oldMetadata = this.convertTo(oldContent, modelType);
                formMetaData = (FormMetadata)oldMetadata;
            } else {
                IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
                formMetaData = template.getFormMetadata();
                Map entityMeta = (Map)content.get(ENTITY_META);
                formMetaData.setName(new LocaleString((String)entityMeta.get(NAME)));
                String entityId = (String)entityMeta.get("Id");
                formMetaData.setId(entityId);
                formMetaData.setEntityId(entityId);
                String key = (String)((LinkedHashMap)((ArrayList)((Map)content.get(ENTITY_META)).get(ITEMS)).get(0)).get(KEY);
                formMetaData.setKey(key);
                String currentIsv = ISVService.getISVInfo().getId();
                formMetaData.setIsv(currentIsv);
                formMetaData.setBizappId((String)entityMeta.get("BizappId"));
            }
            DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType));
            DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
            formMeta = ser.serializeToMap((Object)formMetaData, null);
            content.put("formmeta", formMeta);
        }
        Map entityMeta = (Map)content.get(ENTITY_META);
        List entityItems = (List)entityMeta.get(ITEMS);
        Map mainEntity = (Map)entityItems.get(0);
        List formMetaItems = null;
        Map formAp = null;
        formMetaItems = (List)formMeta.get(ITEMS);
        formAp = (Map)formMetaItems.get(0);
        String mainEntityName = (String)mainEntity.get(NAME);
        if (StringUtils.isNotBlank((CharSequence)mainEntityName)) {
            String entityMetaName = (String)entityMeta.get(NAME);
            String formMetaName = (String)formMeta.get(NAME);
            String caption = (String)content.get(CAPTION);
            if (!StringUtils.equalsIgnoreCase((CharSequence)mainEntityName, (CharSequence)entityMetaName)) {
                entityMeta.put(NAME, mainEntityName);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)mainEntityName, (CharSequence)formMetaName)) {
                formMeta.put(NAME, mainEntityName);
                if (formAp != null) {
                    formAp.put(NAME, mainEntityName);
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)mainEntityName, (CharSequence)caption)) {
                content.put(CAPTION, mainEntityName);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(mainEntityKey = (String)mainEntity.get(KEY)))) {
            String entityMetaKey = (String)entityMeta.get(KEY);
            String formMetaKey = (String)formMeta.get(KEY);
            if (!StringUtils.equalsIgnoreCase((CharSequence)mainEntityKey, (CharSequence)entityMetaKey)) {
                entityMeta.put(KEY, mainEntityKey);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)mainEntityKey, (CharSequence)formMetaKey)) {
                formMeta.put(KEY, mainEntityKey);
                if (formAp != null) {
                    formAp.put(KEY, mainEntityKey);
                }
            }
        }
        if (formAp != null) {
            Object obj_Inherit = mainEntity.get(ENABLE_INHERIT_PROPERTY);
            formAp.put(ENABLE_INHERIT_PROPERTY, obj_Inherit == null || (Boolean)obj_Inherit != false);
            Object obj_extend = mainEntity.get(ENABLE_EXTEND_PROPERTY);
            formAp.put(ENABLE_EXTEND_PROPERTY, obj_extend == null || (Boolean)obj_extend != false);
        }
        return super.saveDesignMetadata(content, oldContent, isDraft);
    }

    @Override
    protected void checkFieldKey(AbstractMetadata metadata) {
        super.checkFieldKey(metadata);
        if (metadata instanceof FormMetadata) {
            FormMetadata formMetadata = (FormMetadata)metadata;
            EntityMetadata entityMetadata = formMetadata.getEntityMetadata();
            HashSet<String> entryfieldKeys = new HashSet<String>();
            for (EntityItem item : entityMetadata.getItems()) {
                String key = item.getKey();
                boolean isField = item instanceof Field;
                if (StringUtils.isBlank((CharSequence)key)) {
                    String sErrorFormat = ResManager.loadKDString((String)"%s\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DesignerData_79", (String)"bos-designer-plugin", (Object[])new Object[0]);
                    if (item instanceof Entity) {
                        this.addBuildError(2, KEY, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53[%s]\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DesignerData_79", (String)"bos-designer-plugin", (Object[])new Object[0]), item.getName()), entityMetadata);
                        continue;
                    }
                    this.addBuildError(2, KEY, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DesignerData_80", (String)"bos-designer-plugin", (Object[])new Object[0]), item.getName()), entityMetadata);
                    continue;
                }
                String entryfieldKey = item.getParentId() + key;
                if (entryfieldKeys.contains(entryfieldKey)) {
                    this.addBuildError(2, "FieldKey", String.format(ResManager.loadKDString((String)"%s \u6807\u8bc6\u91cd\u590d\u3002", (String)"DesignerData_11", (String)"bos-designer-plugin", (Object[])new Object[0]), key), formMetadata.getEntityMetadata());
                    continue;
                }
                if (StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)"_id")) {
                    this.addBuildError(1, "FieldKey", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5e94\u4f7f\u7528\u7279\u6b8a\u5b57\u7b26\u201c_id\u201d\u7ed3\u5c3e\u3002", (String)"DesignerData_40", (String)"bos-designer-plugin", (Object[])new Object[0]), key), formMetadata.getEntityMetadata());
                } else if (isField && this.startWithNumber(key)) {
                    this.addBuildError(2, "FieldKey", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6807\u8bc6\uff1a\u201c%s\u201d\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u3002", (String)"DesignerData_81", (String)"bos-designer-plugin", (Object[])new Object[0]), key), formMetadata.getEntityMetadata());
                } else {
                    String regex = "[a-z0-9A-Z_]+";
                    if (!Pattern.matches(regex, key)) {
                        this.addBuildError(2, KEY, ResManager.loadKDString((String)"\u6807\u8bc6\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DesignerData_38", (String)"bos-designer-plugin", (Object[])new Object[0]), entityMetadata);
                    }
                }
                entryfieldKeys.add(entryfieldKey);
            }
        }
    }

    public Map<String, Object> loadDesignerMetadata(String entityId, String lang) {
        Map content = MetadataDao.loadDesignerMetadata((String)entityId, (String)lang);
        Map formMeta = (Map)content.get("formmeta");
        Map entityMeta = (Map)content.get(ENTITY_META);
        List entityItems = (List)entityMeta.get(ITEMS);
        Map mainEntity = (Map)entityItems.get(0);
        List formMetaItems = (List)formMeta.get(ITEMS);
        Map formAp = (Map)formMetaItems.get(0);
        Object obj_Inherit = formAp.get(ENABLE_INHERIT_PROPERTY);
        mainEntity.put(ENABLE_INHERIT_PROPERTY, obj_Inherit == null || (Boolean)obj_Inherit != false);
        Object obj_extend = formAp.get(ENABLE_EXTEND_PROPERTY);
        mainEntity.put(ENABLE_EXTEND_PROPERTY, obj_extend == null || (Boolean)obj_extend != false);
        return content;
    }
}

