/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.DesignerData;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.RefProp;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class FieldsPromptBuilder {
    private static final Log logger = LogFactory.getLog(FieldsPromptBuilder.class);

    public static String getDesc(String pageId) {
        FormMetadata formMetadata = FieldsPromptBuilder.getFormMetadata(pageId);
        if (formMetadata == null) {
            return "";
        }
        return FieldsPromptBuilder.getDesc(formMetadata);
    }

    @Nullable
    private static FormMetadata getFormMetadata(String pageId) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        String allData = pageCache.get("cache_all_metadata");
        if (allData == null && (allData = pageCache.get("oldmetadata")) != null) {
            Map mapFormMeta = (Map)SerializationUtils.fromJsonString((String)allData, Map.class);
            FormMetadata formMetadata = (FormMetadata)new DesignerData().convertTo(mapFormMeta, "BillFormModel");
            return formMetadata;
        }
        if (StringUtils.isBlank((CharSequence)allData)) {
            logger.warn("pageid: {} form metadata not exists.", (Object)pageId);
            return null;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)allData, Map.class);
        Map mapFormMeta = (Map)map.get("formmeta");
        FormMetadata formMetadata = (FormMetadata)new DesignerData().convertTo(mapFormMeta, "BillFormModel");
        return formMetadata;
    }

    public static String getDesc(FormMetadata formMetadata) {
        StringBuilder s = new StringBuilder();
        for (EntityItem item : formMetadata.getEntityMetadata().getItems()) {
            String refPropInfo;
            if (!(item instanceof Field)) continue;
            s.append(item.getName()).append(":").append(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a", (String)"FieldsPromptBuilder_0", (String)"bos-designer-plugin", (Object[])new Object[0])).append(item.getKey());
            if (item instanceof AbstractBasedataField && StringUtils.isNotBlank((CharSequence)(refPropInfo = FieldsPromptBuilder.buildRefPropInfo((AbstractBasedataField)item)))) {
                s.append("\uff0c").append(ResManager.loadKDString((String)"\u6709\u4e0b\u7ea7\u5c5e\u6027", (String)"FieldsPromptBuilder_1", (String)"bos-designer-plugin", (Object[])new Object[0])).append(":").append(refPropInfo);
            }
            s.append("\r\n");
        }
        return s.toString();
    }

    private static String buildRefPropInfo(AbstractBasedataField basedataField) {
        List refProps = basedataField.getRefProps();
        if (CollectionUtils.isEmpty((Collection)refProps)) {
            return "";
        }
        String baseId = basedataField.getBaseEntityId();
        String number = MetadataDao.getEntityNumberById((String)baseId);
        if (number == null) {
            return "";
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)number);
        StringBuilder s = new StringBuilder();
        for (RefProp refProp : refProps) {
            String name = refProp.getName();
            String[] p = name.split("\\.");
            StringBuilder subPropDesc = FieldsPromptBuilder.fillPropDisplayName((DynamicObjectType)dt, p);
            if (subPropDesc == null || subPropDesc.length() <= 0) continue;
            s.append((CharSequence)subPropDesc).append(":").append(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a", (String)"FieldsPromptBuilder_0", (String)"bos-designer-plugin", (Object[])new Object[0])).append(name).append("\t");
        }
        return s.toString();
    }

    private static StringBuilder fillPropDisplayName(DynamicObjectType dt, String[] p) {
        StringBuilder subPropDesc = new StringBuilder();
        IDataEntityProperty property = null;
        for (int i = 0; i < p.length; ++i) {
            if (property == null) {
                property = (IDataEntityProperty)dt.getProperties().get((Object)p[i]);
            } else if (property instanceof IComplexProperty) {
                property = (IDataEntityProperty)((IComplexProperty)property).getComplexType().getProperties().get((Object)p[i]);
            } else {
                return null;
            }
            if (property == null) {
                return null;
            }
            if (subPropDesc.length() > 0) {
                subPropDesc.append(".");
            }
            subPropDesc.append(property.getDisplayName());
        }
        return subPropDesc;
    }

    public static String getDescWithMustInput(String pageId) {
        FormMetadata formMetadata = FieldsPromptBuilder.getFormMetadata(pageId);
        if (formMetadata == null) {
            return "";
        }
        return FieldsPromptBuilder.getDescWithMustInput(formMetadata);
    }

    public static String getDescWithMustInput(FormMetadata formMetadata) {
        StringBuilder s = new StringBuilder();
        for (EntityItem item : formMetadata.getEntityMetadata().getItems()) {
            if (!(item instanceof Field)) continue;
            s.append(item.getName()).append(":").append(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a", (String)"FieldsPromptBuilder_0", (String)"bos-designer-plugin", (Object[])new Object[0])).append(item.getKey());
            if (((Field)item).isMustInput()) {
                s.append(",").append(ResManager.loadKDString((String)"\u5fc5\u987b\u5f55\u5165", (String)"FieldsPromptBuilder_2", (String)"bos-designer-plugin", (Object[])new Object[0]));
            }
            s.append("\r\n");
        }
        return s.toString();
    }

    public static String getDescWithJson(String pageId) {
        FormMetadata formMetadata = FieldsPromptBuilder.getFormMetadata(pageId);
        if (formMetadata == null) {
            return "";
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        MainEntity rootEntity = formMetadata.getEntityMetadata().getRootEntity();
        map.put("name", formMetadata.getModelType());
        map.put("displayName", rootEntity.getName());
        HashMap<String, String> entityMap = new HashMap<String, String>(16);
        for (Entity entity : formMetadata.getEntityMetadata().getEntitys()) {
            if (!(entity instanceof EntryEntity)) continue;
            entityMap.put(entity.getId(), entity.getKey());
        }
        ArrayList headFieldList = new ArrayList(10);
        map.put("fields", headFieldList);
        for (EntityItem item : formMetadata.getEntityMetadata().getItems()) {
            if (!(item instanceof Field)) continue;
            HashMap<String, String> field = new HashMap<String, String>(16);
            field.put("name", item.getKey());
            field.put("displayName", (String)item.getName());
            String fieldType = "String";
            if (item instanceof AbstractBasedataField) {
                fieldType = "ref";
            } else {
                try {
                    int type = ((Field)item).getFieldDBType();
                    fieldType = FieldsPromptBuilder.getFieldType(type);
                }
                catch (Exception e) {
                    logger.warn("\u83b7\u53d6\u5b57\u6bb5\u7c7b\u578b\u5931\u8d25", (Throwable)e);
                }
            }
            field.put("type", fieldType);
            String parentId = item.getParentId();
            if (StringUtils.isNotBlank((CharSequence)parentId) && entityMap.containsKey(parentId)) {
                String entryKey = (String)entityMap.get(parentId);
                ArrayList entryList = (ArrayList)map.get(entryKey);
                if (entryList == null) {
                    entryList = new ArrayList(10);
                }
                entryList.add(field);
                map.put(entryKey, entryList);
                continue;
            }
            headFieldList.add(field);
        }
        return SerializationUtils.toJsonString(map);
    }

    private static String getFieldType(int type) {
        String fieldType = "String";
        switch (type) {
            case -5: {
                fieldType = "long";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                fieldType = "DateTime";
                break;
            }
            case 2: 
            case 3: {
                fieldType = "decimal";
                break;
            }
            default: {
                fieldType = "String";
            }
        }
        return fieldType;
    }
}

