/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.cardentry.CardEntryFlexPanelAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.cardentry.CardEntryViewAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.ListColumnAp;

public class FormMetadataUtil {
    private static final String FORM_METADATA_UTIL_0 = "FormMetadataUtil_0";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    IDataModel model;
    List<Map<String, Object>> formContext;
    String entryKey;
    String parentKey;
    String fieldIdKey;
    String fieldNameKey;
    String checkBoxKey;
    FormMetadata formMetadata;

    public FormMetadataUtil(IDataModel model, List<Map<String, Object>> formContext, String entryKey, String parentKey, String fieldIdKey, String fieldNameKey, String checkBoxKey) {
        this.model = model;
        this.formContext = formContext;
        this.entryKey = entryKey;
        this.parentKey = parentKey;
        this.fieldIdKey = fieldIdKey;
        this.fieldNameKey = fieldNameKey;
        this.checkBoxKey = checkBoxKey;
    }

    public FormMetadataUtil() {
    }

    public static FormMetadata getFormMetadata(List<Map<String, Object>> formContext) {
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        formMeta.put("Items", formContext);
        formMeta.put("_Type_", "FormMetadata");
        String type = formContext.get(0).get("_Type_").toString();
        String modelType = EntityMetadataUtil.getModelTypeByForm((String)type);
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        FormMetadata formMetadata = (FormMetadata)template.deserializeFromMap(formMeta, null);
        return formMetadata;
    }

    public static ControlAp<?> getControlAp(String modelType, Map<String, Object> item) {
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        ControlAp controlAp = (ControlAp)template.deserializeFromMap(item, null);
        return controlAp;
    }

    public static Map<String, Object> controlApToMap(String modelType, ControlAp<?> ctlAp) {
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        Map<String, Object> controlAp = template.serializeToMap(ctlAp);
        return controlAp;
    }

    private void addSimpleProperty(String parentKeyValue, String fieldName, String fieldKey, boolean isSelected) {
        int rowKey = this.model.createNewEntryRow(this.entryKey);
        this.model.setValue(this.parentKey, (Object)parentKeyValue, rowKey);
        this.model.setValue(this.fieldIdKey, (Object)fieldKey, rowKey);
        this.model.setValue(this.fieldNameKey, (Object)fieldName, rowKey);
        this.model.setValue(this.checkBoxKey, (Object)isSelected, rowKey);
    }

    private ControlAp<?> findTrueParent(String parentId) {
        ControlAp parentControl = this.formMetadata.getItem(parentId);
        if (parentControl instanceof EntryAp || parentControl instanceof FormAp) {
            return parentControl;
        }
        return this.findTrueParent(parentControl.getParentId());
    }

    private void addControl(Map<String, String> allMapFields, List<String> selectedFields, List<String> selectedFieldKeys, List<String> selectFieldsDesc, ControlAp<?> controlAp, boolean isOnlyHeader) {
        if (controlAp.getParentId() == null) {
            return;
        }
        ControlAp<?> parentControl = this.findTrueParent(controlAp.getParentId());
        if (parentControl instanceof EntryAp && isOnlyHeader) {
            return;
        }
        boolean isSelected = selectedFields.contains(controlAp.getId());
        if (isSelected) {
            selectedFieldKeys.add(controlAp.getKey());
            selectFieldsDesc.add(controlAp.getName().toString());
        }
        String fieldName = controlAp.getName().toString();
        String fieldKey = controlAp.getKey();
        allMapFields.put(fieldKey, fieldName);
        this.addSimpleProperty(parentControl.getName().toString(), fieldName, fieldKey, isSelected);
    }

    public void initFields(List<String> selectedFields, Map<String, String> allMapFields, List<String> selectedFieldKeys, List<String> selectFieldsDesc, boolean isOnlyHeader) {
        ArrayList<ControlAp> controlAps = new ArrayList<ControlAp>();
        ArrayList<ControlAp> entryControlAps = new ArrayList<ControlAp>();
        this.formMetadata = FormMetadataUtil.getFormMetadata(this.formContext);
        this.formMetadata.createIndex();
        for (ControlAp control : this.formMetadata.getItems()) {
            if (control instanceof FieldAp && !(control instanceof EntryFieldAp)) {
                controlAps.add(control);
                continue;
            }
            if (!(control instanceof EntryFieldAp)) continue;
            entryControlAps.add(control);
        }
        for (ControlAp controlAp : controlAps) {
            this.addControl(allMapFields, selectedFields, selectedFieldKeys, selectFieldsDesc, controlAp, isOnlyHeader);
        }
        for (ControlAp controlAp : entryControlAps) {
            this.addControl(allMapFields, selectedFields, selectedFieldKeys, selectFieldsDesc, controlAp, isOnlyHeader);
        }
    }

    public TreeNode initTreeField(List<Map<String, Object>> formContext) {
        TreeNode root = this.initRootAndHeadField(formContext);
        for (ControlAp control : this.formMetadata.getItems()) {
            if (!(control instanceof EntryAp) && !(control instanceof BillListAp)) continue;
            TreeNode entryNode = new TreeNode();
            entryNode.setParentid(root.getId());
            entryNode.setId(control.getKey());
            if (control.getName() == null) {
                entryNode.setText(control.getKey() + ResManager.loadKDString((String)ResManager.loadKDString((String)"(\u5355\u636e\u4f53)", (String)"FormMestadataUtil_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)FORM_METADATA_UTIL_0, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else {
                entryNode.setText(control.getName().toString() + ResManager.loadKDString((String)ResManager.loadKDString((String)"(\u5355\u636e\u4f53)", (String)"FormMestadataUtil_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)FORM_METADATA_UTIL_0, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            for (ControlAp controlAp : (control instanceof EntryAp ? (EntryAp)control : (BillListAp)control).getItems()) {
                if (controlAp instanceof FieldAp) {
                    TreeNode fieldNode = new TreeNode();
                    fieldNode.setParentid(control.getKey());
                    fieldNode.setId(controlAp.getKey());
                    fieldNode.setText(controlAp.getName() == null ? "" : controlAp.getName() + "(" + controlAp.getKey() + ")");
                    entryNode.addChild(fieldNode);
                    continue;
                }
                if (!(controlAp instanceof ContainerAp)) continue;
                this.getContainer(entryNode, (ContainerAp)controlAp);
            }
            root.addChild(entryNode);
        }
        return root;
    }

    public TreeNode initRootAndHeadField(List<Map<String, Object>> formContext) {
        this.formMetadata = FormMetadataUtil.getFormMetadata(formContext);
        this.formMetadata.createIndex();
        String rootId = this.formMetadata.getRootAp().getKey();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        if (this.formMetadata.getRootAp().getName() == null) {
            root.setText(rootId);
        } else {
            root.setText(this.formMetadata.getRootAp().getName().toString());
        }
        String headId = "_headNode_";
        TreeNode headNode = new TreeNode();
        headNode.setParentid(rootId);
        headNode.setId(headId);
        headNode.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"FormMetadataUtil_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        for (ControlAp control : this.formMetadata.getItems()) {
            if (!(control instanceof FieldAp) || control instanceof EntryFieldAp) continue;
            TreeNode fieldNode = new TreeNode();
            fieldNode.setParentid(headId);
            fieldNode.setId(control.getKey());
            fieldNode.setText(control.getName() == null ? "" : control.getName() + "(" + control.getKey() + ")");
            headNode.addChild(fieldNode);
        }
        if (headNode.getChildren() != null && !headNode.getChildren().isEmpty()) {
            root.addChild(headNode);
        }
        return root;
    }

    public TreeNode initTreeField(List<Map<String, Object>> formContext, String controlId) {
        TreeNode root = this.initRootAndHeadField(formContext);
        for (ControlAp control : this.formMetadata.getItems()) {
            if (!(control instanceof EntryAp) && !(control instanceof BillListAp) || !control.getId().equals(controlId)) continue;
            TreeNode entryNode = new TreeNode();
            entryNode.setParentid(root.getId());
            entryNode.setId(control.getKey());
            if (control.getName() == null) {
                entryNode.setText(control.getKey() + ResManager.loadKDString((String)ResManager.loadKDString((String)"(\u5355\u636e\u4f53)", (String)"FormMestadataUtil_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)FORM_METADATA_UTIL_0, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else {
                entryNode.setText(control.getName().toString() + ResManager.loadKDString((String)ResManager.loadKDString((String)"(\u5355\u636e\u4f53)", (String)"FormMestadataUtil_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)FORM_METADATA_UTIL_0, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            for (ControlAp controlAp : (control instanceof EntryAp ? (EntryAp)control : (BillListAp)control).getItems()) {
                if (controlAp instanceof FieldAp) {
                    TreeNode fieldNode = new TreeNode();
                    fieldNode.setParentid(control.getKey());
                    fieldNode.setId(controlAp.getKey());
                    fieldNode.setText(controlAp.getName() == null ? "" : controlAp.getName() + "(" + controlAp.getKey() + ")");
                    entryNode.addChild(fieldNode);
                    continue;
                }
                if (!(controlAp instanceof ContainerAp)) continue;
                this.getContainer(entryNode, (ContainerAp)controlAp);
            }
            root.addChild(entryNode);
        }
        return root;
    }

    public void getContainer(TreeNode entryNode, ContainerAp<?> control) {
        for (ControlAp controlAp : control.getItems()) {
            if (controlAp instanceof ListColumnAp || controlAp instanceof FieldAp) {
                TreeNode node = new TreeNode();
                node.setParentid(entryNode.getId());
                node.setId(controlAp.getKey());
                node.setText(controlAp.getName() == null ? "" : controlAp.getName() + "(" + controlAp.getKey() + ")");
                entryNode.addChild(node);
                continue;
            }
            if (!(controlAp instanceof ContainerAp)) continue;
            this.getContainer(entryNode, (ContainerAp)controlAp);
        }
    }

    public TreeNode initTreeControl(List<Map<String, Object>> formContext) {
        TreeNode node;
        HashMap<String, Class<CardEntryViewAp>> cardentry = new HashMap<String, Class<CardEntryViewAp>>();
        cardentry.put("CardEntryAp", CardEntryAp.class);
        cardentry.put("CardEntryFieldAp", CardEntryFieldAp.class);
        cardentry.put("CardEntryFlexPanelAp", CardEntryFlexPanelAp.class);
        cardentry.put("CardEntryRowAp", CardEntryRowAp.class);
        cardentry.put("CardEntryViewAp", CardEntryViewAp.class);
        this.formMetadata = FormMetadataUtil.getFormMetadata(formContext);
        this.formMetadata.createIndex();
        String headId = this.formMetadata.getRootAp().getKey();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(headId);
        String text = this.formMetadata.getRootAp().getName() == null ? this.formMetadata.getKey() : this.formMetadata.getRootAp().getName().toString();
        root.setText(text);
        HashMap mapLN = new HashMap();
        String key = "";
        String valueId = "";
        HashMap<String, String> mapId = new HashMap<String, String>();
        for (ControlAp controlAp : this.formMetadata.getItems()) {
            node = new TreeNode();
            if (controlAp instanceof FieldAp || controlAp instanceof TabPageAp || controlAp instanceof FormAp) continue;
            if (controlAp instanceof EntryAp) {
                key = ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7c7b", (String)"FormMetadataUtil_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                valueId = "ent_ry_001";
            } else if (controlAp instanceof FlexPanelAp) {
                key = ResManager.loadKDString((String)"\u9762\u677f\u7c7b", (String)"FormMetadataUtil_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                valueId = "fl_ex_001";
            } else if (controlAp instanceof TabAp) {
                key = ResManager.loadKDString((String)"\u9875\u7b7e\u7c7b", (String)"FormMetadataUtil_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                valueId = "ta_b_001";
                for (ControlAp control : ((TabAp)controlAp).getItems()) {
                    TreeNode entryControlNode = new TreeNode();
                    entryControlNode.setParentid(controlAp.getKey());
                    entryControlNode.setId(control.getKey());
                    entryControlNode.setText(control.getName() == null ? "" : control.getName() + "(" + control.getKey() + ")");
                    node.addChild(entryControlNode);
                }
            } else if (cardentry.containsValue(controlAp.getClass())) {
                key = ResManager.loadKDString((String)"\u5361\u7247\u7c7b", (String)"FormMetadataUtil_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                valueId = "ca_rd_001";
            } else {
                key = ResManager.loadKDString((String)"\u5176\u4ed6\u63a7\u4ef6\u7c7b", (String)"FormMetadataUtil_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                valueId = "oth_er_001";
            }
            node.setParentid(valueId);
            node.setId(controlAp.getKey());
            node.setText(controlAp.getName() == null ? "" : controlAp.getName() + "(" + controlAp.getKey() + ")");
            if (!mapLN.containsKey(key)) {
                ArrayList nodes = new ArrayList();
                mapLN.put(key, nodes);
                mapId.put(key, valueId);
            }
            ((List)mapLN.get(key)).add(node);
        }
        for (Map.Entry entry : mapLN.entrySet()) {
            node = new TreeNode();
            List listNode = (List)entry.getValue();
            for (TreeNode treeNode : listNode) {
                node.addChild(treeNode);
            }
            node.setParentid(headId);
            node.setId((String)mapId.get(entry.getKey()));
            node.setText((String)entry.getKey());
            root.addChild(node);
        }
        return root;
    }
}

