/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;

public class GitSaveMetadata {
    private static final Log log = LogFactory.getLog(GitSaveMetadata.class);
    private static final String APP = "app";
    private static final String PAGE = "page";

    public void saveMetadataToRepository(String sessionId, String bizAppId, String id, String type) {
        if (!DevportalCommonUtil.isGitManageType() || !DevportalCommonUtil.isExportMetaToLocal()) {
            return;
        }
        String userName = this.getUserName(sessionId);
        if (StringUtils.isBlank((CharSequence)userName)) {
            return;
        }
        String repositoryPath = this.getRepositoryPath(userName, bizAppId);
        if (StringUtils.isBlank((CharSequence)repositoryPath)) {
            return;
        }
        if (PAGE.equals(type)) {
            this.saveFormMetadata(id, repositoryPath);
        } else if (APP.equals(type)) {
            this.saveAppMetadata(bizAppId, repositoryPath);
        }
    }

    public void saveKsMetadataToRepository(String sessionId, String bizAppId, JSONArray jsonArray) {
        if (!DevportalCommonUtil.isGitManageType() || !DevportalCommonUtil.isExportMetaToLocal()) {
            return;
        }
        String userName = this.getUserName(sessionId);
        String repositoryPath = this.getRepositoryPath(userName, bizAppId);
        if (StringUtils.isBlank((CharSequence)repositoryPath)) {
            return;
        }
        String[] ids = new String[jsonArray.size()];
        for (int i = 0; i < ids.length; ++i) {
            String scriptId;
            JSONObject object = jsonArray.getJSONObject(i);
            ids[i] = scriptId = object.getString("id");
        }
        this.saveKsMetadata(repositoryPath, ids);
    }

    private String getUserName(String sessionId) {
        String userName;
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            log.debug("sessionId is null");
            return null;
        }
        try {
            userName = Encrypters.decode((String)sessionId);
        }
        catch (Exception e) {
            log.error("userName decode error", (Throwable)e);
            return null;
        }
        return userName;
    }

    private String getRepositoryPath(String userName, String bizAppId) {
        DynamicObject setting = this.getSetting(bizAppId, null, userName);
        if (setting == null) {
            log.debug("repositoryPath is bank");
            return null;
        }
        String repository = setting.getString("gitrepository");
        String metaPath = setting.getString("gitrootpath");
        String personalGitRepository = this.getPersonalGitRepository(repository, userName);
        String metadataRootPath = this.getMetadataRootPath(metaPath);
        return personalGitRepository + metadataRootPath;
    }

    private DynamicObject getSetting(String bizAppId, String bizUnitId, String userName) {
        QFilter qFilter = new QFilter("bizappid", "=", (Object)bizAppId);
        if (StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            QFilter qFilter1 = new QFilter("bizunitid", "=", (Object)bizUnitId);
            qFilter.and(qFilter1);
        }
        QFilter userFilter = new QFilter("gitusername", "=", (Object)userName);
        qFilter.and(userFilter);
        QFilter[] filters = new QFilter[]{qFilter};
        String selectFields = "id,giturl,gitrepository,gitbranch,gitrootpath,bizunitid,managetype,gitusername";
        DynamicObject[] settings = BusinessDataServiceHelper.load((String)"svnmanage", (String)selectFields, (QFilter[])filters);
        return settings == null || settings.length == 0 ? null : settings[0];
    }

    private Map<String, String> getAppIdAndUnitId(String formId) {
        String sql = String.format("select fbizappid, fbizunitid from %s where fformid = ? ", "t_meta_bizunitrelform");
        Object[] params = new SqlParameter[]{new SqlParameter(":fformid", 12, (Object)formId)};
        ResultSetHandler action = rs -> {
            HashMap<String, String> res = new HashMap<String, String>(2);
            if (rs.next()) {
                String bizAppId = rs.getString("fbizappid");
                String bizUnitId = rs.getString("fbizunitid");
                res.put("bizAppId", bizAppId);
                res.put("bizUnitId", bizUnitId);
                return res;
            }
            return null;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private String getPersonalGitRepository(String gitRepository, String username) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user", (String)"phone");
        String phoneNumber = dynamicObject.getString("phone");
        if (StringUtils.isBlank((CharSequence)phoneNumber)) {
            phoneNumber = username;
        }
        return gitRepository + File.separator + phoneNumber + File.separator + RequestContext.get().getAccountId() + File.separator + username;
    }

    private String getMetadataRootPath(String gitRootpath) {
        String result = "";
        String separator = Matcher.quoteReplacement(File.separator);
        if (!StringUtils.isBlank((CharSequence)gitRootpath)) {
            result = !(gitRootpath = gitRootpath.replaceAll("\\\\", separator).replaceAll("/", separator)).startsWith(File.separator) ? File.separator + gitRootpath : gitRootpath;
        }
        return result;
    }

    private void saveFormMetadata(String id, String path) {
        try {
            Map<String, String> map = this.getAppIdAndUnitId(id);
            String bizAppId = null;
            String bizUnitId = null;
            if (StringUtils.isNotBlank(map)) {
                bizAppId = map.get("bizAppId");
                bizUnitId = map.get("bizUnitId");
            }
            List formDeployFile = MetadataDao.getFormDeployFile((String)id, bizAppId, bizUnitId);
            formDeployFile = formDeployFile.stream().filter(deployFile -> !this.isIgnoreFile(deployFile.getFileName())).collect(Collectors.toList());
            for (DeployFile file : formDeployFile) {
                this.saveFile(file.getFileName(), file.getFileContent(), path);
            }
        }
        catch (Exception e) {
            log.info("save form metadata error", (Object)e);
        }
    }

    private void saveAppMetadata(String bizAppId, String path) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            log.info("bizAppId is blank");
            return;
        }
        try {
            List appDeployFile = MetadataDao.getAppDeployFile((String)bizAppId);
            appDeployFile = appDeployFile.stream().filter(deployFile -> !this.isIgnoreFile(deployFile.getFileName())).collect(Collectors.toList());
            for (DeployFile file : appDeployFile) {
                this.saveFile(file.getFileName(), file.getFileContent(), path);
            }
        }
        catch (Exception e) {
            log.info("save app metadata error", (Object)e);
        }
    }

    private void saveKsMetadata(String path, String ... ids) {
        if (ids.length < 1) {
            log.debug("ks length less 1");
            return;
        }
        try {
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])ids);
            for (DeployFile file : scriptDeployFile) {
                this.saveFile(file.getFileName(), file.getFileContent(), path);
            }
        }
        catch (Exception e) {
            log.debug("save ks metadata error", (Object)e);
        }
    }

    private void saveFile(String fileName, String content, String exportPath) {
        block30: {
            String checkGitRepository = exportPath + File.separator + fileName;
            try {
                File fileAbovePath = new File(exportPath);
                if (!fileAbovePath.exists()) {
                    fileAbovePath.mkdirs();
                }
                File file = new File(checkGitRepository);
                boolean isSuccess = false;
                if (file.exists()) {
                    boolean isDelete = file.delete();
                    if (isDelete) {
                        isSuccess = file.createNewFile();
                    }
                } else {
                    isSuccess = file.createNewFile();
                }
                if (!isSuccess) break block30;
                Path path = Paths.get(checkGitRepository, new String[0]);
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
                     OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    writer.write(content);
                }
            }
            catch (IOException e) {
                log.debug("export file error", (Object)e);
            }
        }
    }

    private boolean isIgnoreFile(String fileName) {
        if (fileName.endsWith(".dymx") && !fileName.endsWith(".zh_CN.dymx")) {
            return true;
        }
        if (fileName.endsWith(".appx") && !fileName.endsWith(".zh_CN.appx")) {
            return true;
        }
        if (fileName.endsWith(".crx") && !fileName.endsWith(".zh_CN.crx")) {
            return true;
        }
        if (fileName.endsWith(".wbx") && !fileName.endsWith(".zh_CN.wbx")) {
            return true;
        }
        return fileName.endsWith(".burx") && !fileName.endsWith(".zh_CN.burx");
    }
}

