/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.designer.dao.LibAddress;
import kd.bos.designer.dao.OperationInfo;
import kd.bos.designer.dao.PropertiesFileUtil;
import kd.bos.designer.dao.SVNKitUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.form.rule.FormRuleActionTypes;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.subsystem.query.SMGConfigReader;
import kd.bos.subsystem.query.SubSystemReader;
import kd.bos.util.FileUtils;
import kd.bos.util.SAXReaderUtil;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class MetadataUtil {
    private static final String FORMDESIGN_TABLE = "T_META_FORMDESIGN";
    private static final String ENTITYDESIGN_TABLE = "T_META_ENTITYDESIGN";
    private static final String FORMDESIGN_L_TABLE = "T_META_FORMDESIGN_L";
    private static final String ENTITYDESIGN_L_TABLE = "T_META_ENTITYDESIGN_L";
    public static final String SVNCONFIGRESOURCE = "SVNConfig.properties";
    public static final int LOGINWRONG = 1;
    public static final int COMMITERROR = 2;
    public static final int SUCCESS = 3;
    private static final String LIB_NAME = "libName";
    private static final String UTF_8 = "utf-8";
    private static final String LINE_SEPARATOR = "line.separator";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String SMG_USERNAME = "smgusername";
    private static final String SMG_PASS = "smgpassword";
    private String userPath = System.getProperty("user.dir");
    private static final Log LOG = LogFactory.getLog(MetadataUtil.class);

    public MetadataUtil() {
        String propValue = MetadataUtil.getProperty("path");
        if (!StringUtils.isEmpty((CharSequence)propValue)) {
            this.userPath = propValue;
        }
    }

    public static LibAddress getLibAddress(String subFnumber) {
        SubSystemReader query = new SubSystemReader();
        Map map = query.getSubSystem(subFnumber);
        if (map != null) {
            String libAddress = map.get("libAddress").toString();
            String libName = StringUtils.isBlank(map.get(LIB_NAME)) ? "" : map.get(LIB_NAME).toString();
            LibAddress libAddr = new LibAddress(libAddress, libName);
            return libAddr;
        }
        return null;
    }

    private static String getProperty(String propName) {
        Map<String, String> propMap;
        PropertiesFileUtil propertiesFileUtil = new PropertiesFileUtil();
        InputStream inputStream = FormRuleActionTypes.class.getResourceAsStream("/SVNConfig.properties");
        if (inputStream != null && (propMap = propertiesFileUtil.getProperties(inputStream)).containsKey(propName)) {
            return propMap.get(propName);
        }
        return null;
    }

    public static String getSCGAddress(String subFNumber) {
        LibAddress libAddress = MetadataUtil.getLibAddress(subFNumber);
        if (libAddress == null) {
            return MetadataUtil.getLibPath();
        }
        return MetadataUtil.getLibPath() + libAddress.getLibAddress();
    }

    public Map<String, Object> delFormMetadata(String id) {
        return MetadataDao.delFormMetadata((String)id);
    }

    private void getValidFile(String fileName, List<String> fileList) {
        File file = new File(FileUtils.cleanString((String)fileName));
        if (file.exists()) {
            fileList.add(fileName);
        }
    }

    private List<String> getFileNames(String fNumber) {
        ArrayList<String> fileList = new ArrayList<String>();
        String sqlFileName = String.format("%s.SQL", fNumber);
        String formFileName = String.format("%s_form.xml", fNumber);
        String entityFileName = String.format("%s_Entity.xml", fNumber);
        String formLangFileName = String.format("%s_form_l.xml", fNumber);
        String entityLangFileName = String.format("%s_Entity_l.xml", fNumber);
        fileList.add(sqlFileName);
        fileList.add(formFileName);
        fileList.add(entityFileName);
        fileList.add(formLangFileName);
        fileList.add(entityLangFileName);
        return fileList;
    }

    private List<String> getFilePaths(String prePath, String fNumber, LibAddress libAddress) {
        ArrayList<String> filePathList = new ArrayList<String>();
        List<String> fileList = this.getFileNames(fNumber);
        for (String fileName : fileList) {
            if (fileName.endsWith(".SQL")) {
                filePathList.add(this.getDbSchemaPath(prePath, fileName, libAddress.getLibAddress()));
                continue;
            }
            if (!fileName.endsWith(".xml")) continue;
            filePathList.add(this.getMetaXmlPath(prePath, fileName, libAddress));
        }
        return filePathList;
    }

    public List<String> getExePath(String fNumber, LibAddress libAddress) {
        ArrayList<String> exePathList = new ArrayList<String>();
        List<String> fileList = this.getFilePaths(this.userPath, fNumber, libAddress);
        for (String filePath : fileList) {
            this.getValidFile(filePath, exePathList);
        }
        return exePathList;
    }

    private Map<String, String> getSVNFileMap(String prePath, String subFNumber, String[] fNumbers, LibAddress libAddress) {
        HashMap<String, String> filePathMap = new HashMap<String, String>();
        ArrayList<String> fileList = new ArrayList<String>();
        for (String fNumber : fNumbers) {
            fileList.addAll(this.getFileNames(fNumber));
        }
        String libPath = MetadataUtil.getLibPath();
        for (String fileName : fileList) {
            if (fileName.endsWith(".SQL")) {
                filePathMap.put(this.getDbSchemaPath(prePath, fileName, libAddress.getLibAddress()), this.getDbSchemaPath(libPath, fileName, libAddress.getLibAddress()));
                continue;
            }
            if (!fileName.endsWith(".xml")) continue;
            filePathMap.put(this.getMetaXmlPath(prePath, fileName, libAddress), this.getMetaXmlPath(libPath, fileName, libAddress));
        }
        return filePathMap;
    }

    public String getMetaXmlPath(String prePath, String filename, LibAddress libAddress) {
        String appendPath = StringUtils.isEmpty((CharSequence)libAddress.getLibName()) ? filename : libAddress.getLibName() + "/" + filename;
        String fullPath = String.format("%s/%s/Metadata/%s", prePath, libAddress.getLibAddress(), appendPath);
        return fullPath;
    }

    public String getDbSchemaPath(String prePath, String filename, String libAddress) {
        String fullPath = String.format("%s/%s/DbSchema/%s", prePath, libAddress, filename);
        return fullPath;
    }

    private void saveFile(String doc, String filename, OperationInfo operationInfo, String libAddress) {
        try {
            boolean flag;
            File file;
            String fullPath = this.getDbSchemaPath(this.userPath, filename, libAddress);
            String[] abovePath = fullPath.split(filename);
            File fileAbovePath = new File(FileUtils.cleanString((String)abovePath[0]));
            if (!fileAbovePath.exists()) {
                fileAbovePath.mkdirs();
            }
            if (!(file = new File(FileUtils.cleanString((String)fullPath))).exists() && !(flag = file.createNewFile())) {
                LOG.debug(ResManager.loadKDString((String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (String)"CreateFileError_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file.getCanonicalFile());
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");){
                writer.write(doc);
                operationInfo.addFilePath(fullPath);
            }
        }
        catch (IOException e) {
            operationInfo.addErrorMessage(e.getMessage());
        }
    }

    private void saveXML(Document doc, String filename, OperationInfo operationInfo, LibAddress libAddress) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(UTF_8);
        try {
            boolean flag;
            File file;
            String fullPath = this.getMetaXmlPath(this.userPath, filename, libAddress);
            String[] abovePath = fullPath.split(filename);
            File fileAbovePath = new File(FileUtils.cleanString((String)abovePath[0]));
            if (!fileAbovePath.exists()) {
                fileAbovePath.mkdirs();
            }
            if (!(file = new File(FileUtils.cleanString((String)fullPath))).exists() && !(flag = file.createNewFile())) {
                LOG.debug(ResManager.loadKDString((String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (String)"CreateFileError_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            try (FileOutputStream out = new FileOutputStream(file.getCanonicalFile());){
                XMLWriter writer = new XMLWriter((OutputStream)out, format);
                writer.write(doc);
                writer.close();
                operationInfo.addFilePath(fullPath);
            }
        }
        catch (IOException e) {
            operationInfo.addErrorMessage(e.getMessage());
        }
    }

    private Map<String, Object> getExpFormMetadataSql(String id) {
        String masterId;
        String formIsv;
        String type;
        String formParentId;
        String subSysId;
        String localeId = "zh_CN";
        HashMap<String, String> fieldVals = new HashMap<String, String>();
        MetadataReader reader = new MetadataReader();
        List listFormLang = reader.readFormMetaLangValues(id);
        List listForm = reader.readMetaValues(id, MetaCategory.Form);
        if (listFormLang.isEmpty() || listForm.isEmpty()) {
            return null;
        }
        String name = (String)listFormLang.get(0);
        String number = (String)listForm.get(0);
        fieldVals.put("FNUMBER", number);
        String entityId = (String)listForm.get(1);
        String formModelType = (String)listForm.get(2);
        if (StringUtils.isNotBlank((CharSequence)formModelType)) {
            fieldVals.put("FMODELTYPE", formModelType);
        }
        if (StringUtils.isNotBlank((CharSequence)(subSysId = (String)listForm.get(3)))) {
            fieldVals.put("FSUBSYSID", subSysId);
        }
        if (StringUtils.isNotBlank((CharSequence)(formParentId = (String)listForm.get(4)))) {
            fieldVals.put("FPARENTID", formParentId);
        }
        if (StringUtils.isNotBlank((CharSequence)(type = (String)listForm.get(5)))) {
            fieldVals.put("FTYPE", type);
        }
        String formXml = (String)listForm.get(6);
        String formInheritPath = (String)listForm.get(7);
        if (StringUtils.isNotBlank((CharSequence)formInheritPath)) {
            fieldVals.put("FINHERITPATH", formInheritPath);
        }
        if (StringUtils.isNotBlank((CharSequence)(formIsv = (String)listForm.get(8)))) {
            fieldVals.put("FISV", formIsv);
        }
        long formVersion = (Long)listForm.get(9);
        String bizAppID = (String)listForm.get(10);
        if (StringUtils.isNotBlank((CharSequence)bizAppID)) {
            fieldVals.put("FBIZAPPID", bizAppID);
        }
        if (StringUtils.isNotBlank((CharSequence)(masterId = (String)listForm.get(11)))) {
            fieldVals.put("FMASTERID", masterId);
        }
        String formLangXml = (String)listFormLang.get(1);
        List listEntityLang = reader.readEntityMetaLangValues(entityId);
        List listEntity = reader.readMetaValues(entityId, MetaCategory.Entity);
        if (listEntityLang.isEmpty() || listEntity.isEmpty()) {
            return null;
        }
        String entityName = (String)listEntityLang.get(0);
        String entityXml = (String)listEntity.get(6);
        String entityLangXml = (String)listEntityLang.get(1);
        if (entityName == null || entityXml == null || formXml == null || formLangXml == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringBuffer formInsField = new StringBuffer();
        StringBuffer formInsVal = new StringBuffer();
        formInsField.append("FID, FENTITYID, FVERSION ");
        formInsVal.append(String.format("'%s', '%s', %s ", id, entityId, formVersion));
        StringBuffer entityInsField = new StringBuffer();
        StringBuffer entityInsVal = new StringBuffer();
        entityInsField.append("FID, FVERSION ");
        entityInsVal.append(String.format("'%s', %s ", id, formVersion));
        for (Map.Entry entry : fieldVals.entrySet()) {
            String fieldName = (String)entry.getKey();
            formInsField.append(String.format(", %s", fieldName));
            formInsVal.append(String.format(", '%s'", entry.getValue()));
            entityInsField.append(String.format(", %s", fieldName));
            entityInsVal.append(String.format(", '%s'", entry.getValue()));
        }
        sb.append(String.format("delete %s where FID = '%s';", FORMDESIGN_TABLE, id));
        sb.append(System.getProperty(LINE_SEPARATOR));
        sb.append(String.format("delete %s where FID = '%s' and FLOCALEID = '%s';", FORMDESIGN_L_TABLE, id, localeId));
        sb.append(System.getProperty(LINE_SEPARATOR));
        sb.append(String.format("insert into %s (%s) values (%s);", FORMDESIGN_TABLE, formInsField, formInsVal));
        sb.append(System.getProperty(LINE_SEPARATOR));
        sb.append(String.format("insert into %s (FPKID, FID, FLOCALEID, FNAME, FNUMBER) values('%s', '%s', '%s', '%s', '%s');", FORMDESIGN_L_TABLE, DBServiceHelper.genStringId(), id, localeId, name, number));
        sb.append(System.getProperty(LINE_SEPARATOR));
        sb.append(String.format("delete %s where FID = '%s';", ENTITYDESIGN_TABLE, id));
        sb.append(System.getProperty(LINE_SEPARATOR));
        sb.append(String.format("delete %s where FID = '%s' and FLOCALEID = '%s';", ENTITYDESIGN_L_TABLE, id, localeId));
        sb.append(System.getProperty(LINE_SEPARATOR));
        sb.append(String.format("insert into %s (%s) values (%s);", ENTITYDESIGN_TABLE, entityInsField, entityInsVal));
        sb.append(System.getProperty(LINE_SEPARATOR));
        sb.append(String.format("insert into %s (FPKID, FID, FLOCALEID, FNAME, FNUMBER) values('%s', '%s', '%s','%s', '%s');", ENTITYDESIGN_L_TABLE, DBServiceHelper.genStringId(), id, localeId, entityName, number));
        sb.append(System.getProperty(LINE_SEPARATOR));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sql", sb.toString());
        map.put("formMeta", formXml);
        map.put("entityMeta", entityXml);
        map.put("formLangMeta", formLangXml);
        map.put("entityLangMeta", entityLangXml);
        map.put("number", number);
        return map;
    }

    public boolean impFormMetadata(String number, String path) {
        String libName;
        String deleteSql = "delete %s where FNUMBER = ?";
        ArrayList<SqlObject> list = new ArrayList<SqlObject>();
        SubSystemReader reader = new SubSystemReader();
        Map map = reader.getLibName(number);
        String sqlPath = path + "\\DbSchema";
        String xmlPath = path + "\\Metadata";
        if (map != null && !map.isEmpty() && StringUtils.isNotBlank((CharSequence)(libName = (String)map.get(LIB_NAME)))) {
            xmlPath = xmlPath + "\\" + libName;
        }
        kd.bos.dataentity.SqlParameter[] params = new kd.bos.dataentity.SqlParameter[]{new kd.bos.dataentity.SqlParameter(":FNUMBER", 12, (Object)number)};
        String delFormLangSql = String.format(deleteSql, FORMDESIGN_L_TABLE);
        list.add(new SqlObject(delFormLangSql, (SqlParameter[])params));
        String delEntityLangSql = String.format(deleteSql, ENTITYDESIGN_L_TABLE);
        list.add(new SqlObject(delEntityLangSql, (SqlParameter[])params));
        String delFormSql = String.format(deleteSql, FORMDESIGN_TABLE);
        list.add(new SqlObject(delFormSql, (SqlParameter[])params));
        String delEntitySql = String.format(deleteSql, ENTITYDESIGN_TABLE);
        list.add(new SqlObject(delEntitySql, (SqlParameter[])params));
        String sqlFileName = String.format("%s/%s.SQL", sqlPath, number);
        File file = new File(FilenameUtils.getName((String)sqlFileName));
        if (file.isFile() && file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 InputStreamReader read = new InputStreamReader((InputStream)fileInputStream, UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(read);){
                String sql = null;
                while ((sql = bufferedReader.readLine()) != null) {
                    list.add(new SqlObject(sql, null));
                }
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"MetadataUtil_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage())});
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"MetadataUtil_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage())});
            }
        }
        String formFileName = String.format("%s/%s_form.xml", xmlPath, number);
        this.setXmlSql(formFileName, number, list);
        String entityFileName = String.format("%s/%s_Entity.xml", xmlPath, number);
        this.setXmlSql(entityFileName, number, list);
        String formLangFileName = String.format("%s/%s_form_l.xml", xmlPath, number);
        this.setXmlSql(formLangFileName, number, list);
        String entityLangFileName = String.format("%s/%s_Entity_l.xml", xmlPath, number);
        this.setXmlSql(entityLangFileName, number, list);
        for (SqlObject sqlObject : list) {
            DB.execute((DBRoute)DBRoute.meta, (String)sqlObject.getSql(), (Object[])sqlObject.getParams());
        }
        return true;
    }

    private void setXmlSql(String fileName, String number, List<SqlObject> list) {
        String updateSql = "update %s set FDATA = ? where FNUMBER = ? ";
        String xml = "";
        try {
            File file = new File(MetadataUtil.cleanString(fileName.replace("../", "#")));
            SAXReader reader = SAXReaderUtil.getSAXReader();
            reader.setEncoding(UTF_8);
            Document document = reader.read(file);
            xml = document.asXML();
        }
        catch (DocumentException e) {
            throw new KDException((Throwable)e, BosErrorCode.openFileFailed, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u5143\u6570\u636e\u6587\u4ef6%2$s\u8bfb\u53d6\u9519\u8bef\u3002", (String)"MetadataUtil_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), number, fileName)});
        }
        kd.bos.dataentity.SqlParameter[] params = new kd.bos.dataentity.SqlParameter[]{new kd.bos.dataentity.SqlParameter(":FDATA", 12, (Object)xml), new kd.bos.dataentity.SqlParameter(":FNUMBER", 12, (Object)number)};
        String sql = "";
        if (fileName.endsWith("_form.xml")) {
            sql = String.format(updateSql, FORMDESIGN_TABLE);
        } else if (fileName.endsWith("_Entity.xml")) {
            sql = String.format(updateSql, ENTITYDESIGN_TABLE);
        } else if (fileName.endsWith("_form_l.xml")) {
            sql = String.format(updateSql, FORMDESIGN_L_TABLE);
        } else if (fileName.endsWith("_Entity_l.xml")) {
            sql = String.format(updateSql, ENTITYDESIGN_L_TABLE);
        }
        if (StringUtils.isNotEmpty((CharSequence)sql)) {
            list.add(new SqlObject(sql, (SqlParameter[])params));
        }
    }

    public OperationInfo expMetadata(String id, LibAddress libAddress) {
        OperationInfo operationInfo = new OperationInfo();
        Map<String, Object> map = this.getExpFormMetadataSql(id);
        if (map == null || map.isEmpty()) {
            return null;
        }
        String formMeta = (String)map.get("formMeta");
        try {
            Document formDoc = SAXReaderUtil.parseText((String)formMeta);
            String formLangMeta = (String)map.get("formLangMeta");
            Document formLangDoc = SAXReaderUtil.parseText((String)formLangMeta);
            String entityMeta = (String)map.get("entityMeta");
            Document entityDoc = SAXReaderUtil.parseText((String)entityMeta);
            String entityLangMeta = (String)map.get("entityLangMeta");
            Document entityLangDoc = SAXReaderUtil.parseText((String)entityLangMeta);
            String number = (String)map.get("number");
            String formFileName = String.format("%s_form.xml", number);
            this.saveXML(formDoc, formFileName, operationInfo, libAddress);
            String entityFileName = String.format("%s_Entity.xml", number);
            this.saveXML(entityDoc, entityFileName, operationInfo, libAddress);
            String formLangFileName = String.format("%s_form_l.xml", number);
            this.saveXML(formLangDoc, formLangFileName, operationInfo, libAddress);
            String entityLangFileName = String.format("%s_Entity_l.xml", number);
            this.saveXML(entityLangDoc, entityLangFileName, operationInfo, libAddress);
            String sqlFileName = String.format("%s.SQL", number);
            String sql = (String)map.get("sql");
            this.saveFile(sql, sqlFileName, operationInfo, libAddress.getLibAddress());
        }
        catch (DocumentException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%s\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"MetadataUtil_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), id)});
        }
        return operationInfo;
    }

    public boolean authorize(String subFNumber, OperationInfo operationInfo) {
        String svnRoot = MetadataUtil.getSVNRoot(subFNumber);
        SMGConfigReader smgConfigReader = new SMGConfigReader();
        String userName = SessionManager.getCurrent().get(SMG_USERNAME);
        String password = SessionManager.getCurrent().get(SMG_PASS);
        if (StringUtils.isEmpty((CharSequence)userName) || StringUtils.isEmpty((CharSequence)password)) {
            return false;
        }
        return SVNKitUtil.testSvnConnection(svnRoot, userName, password, operationInfo);
    }

    private void initUserPassword(String subFNumber) {
        Map map;
        SMGConfigReader smgConfigReader = new SMGConfigReader();
        String userName = SessionManager.getCurrent().get(SMG_USERNAME);
        String password = SessionManager.getCurrent().get(SMG_PASS);
        if ((StringUtils.isEmpty((CharSequence)userName) || StringUtils.isEmpty((CharSequence)password)) && (map = smgConfigReader.getSMGConfig(subFNumber, RequestContext.get().getUserOpenId())) != null) {
            userName = map.get("username").toString();
            password = map.get("pwd").toString();
            SessionManager.getCurrent().put(SMG_USERNAME, userName);
            SessionManager.getCurrent().put(SMG_PASS, password);
        }
    }

    public OperationInfo commitToSVN(List<String> urlList, String subFNumber, LibAddress libAddress) {
        OperationInfo operationInfo = new OperationInfo();
        ArrayList<File> files = new ArrayList<File>(10);
        for (String url : urlList) {
            File file = new File(FileUtils.cleanString((String)url));
            files.add(file);
        }
        String parentPath = ((File)files.get(0)).getParent();
        Map<String, String> folderMap = this.getFolderMap(subFNumber, libAddress);
        this.initUserPassword(subFNumber);
        String userName = SessionManager.getCurrent().get(SMG_USERNAME);
        String password = SessionManager.getCurrent().get(SMG_PASS);
        SVNClientManager clientManager = SVNKitUtil.getClientManager(folderMap.get(parentPath.replace("\\", "/")), userName, password);
        File[] filetocommit = files.toArray(new File[0]);
        SVNKitUtil.commit(clientManager, filetocommit, "", operationInfo);
        return operationInfo;
    }

    public static String getLibPath() {
        String libPath = "http://192.168.16.99/svn/";
        String propValue = MetadataUtil.getProperty("lib");
        if (!StringUtils.isEmpty((CharSequence)propValue)) {
            return propValue;
        }
        return libPath;
    }

    public static String getSVNRoot(String subFNumber) {
        String svnAddress = MetadataUtil.getSCGAddress(subFNumber);
        return svnAddress;
    }

    private Map<String, String> getFolderMap(String subFNumber, LibAddress libAddress) {
        HashMap<String, String> folderMap = new HashMap<String, String>();
        String svnRoot = MetadataUtil.getSVNRoot(subFNumber);
        String appendPath = StringUtils.isEmpty((CharSequence)libAddress.getLibName()) ? "" : "/" + libAddress.getLibName();
        folderMap.put(this.userPath + libAddress.getLibAddress() + "/DbSchema", svnRoot + "/DbSchema");
        folderMap.put(this.userPath + libAddress.getLibAddress() + "/Metadata" + appendPath, svnRoot + "/Metadata" + appendPath);
        return folderMap;
    }

    public void checkOutFiles(String subFNumber, LibAddress libAddress, String[] fNumbers, OperationInfo operationInfo) {
        String svnRoot;
        Map<String, String> folderMap = this.getFolderMap(subFNumber, libAddress);
        for (Map.Entry<String, String> entry : folderMap.entrySet()) {
            String fileName = entry.getKey();
            String value = entry.getValue();
            this.initUserPassword(subFNumber);
            String userName = SessionManager.getCurrent().get(SMG_USERNAME);
            String password = SessionManager.getCurrent().get(SMG_PASS);
            SVNClientManager clientManager = SVNKitUtil.getClientManager(value, userName, password);
            SVNKitUtil.checkRootFolder(fileName, value, clientManager, operationInfo);
        }
        Map<String, String> fileMap = this.getSVNFileMap(this.userPath, subFNumber, fNumbers, libAddress);
        ArrayList<File> files = new ArrayList<File>(10);
        for (String fileName : fileMap.keySet()) {
            File file = new File(FileUtils.cleanString((String)fileName));
            if (!file.exists()) {
                operationInfo.addErrorMessage(String.format(ResManager.loadKDString((String)"%s\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"MetadataUtil_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), fileName));
                continue;
            }
            files.add(file);
        }
        if (files.size() > 0 && !StringUtils.isEmpty((CharSequence)(svnRoot = folderMap.get(((File)files.get(0)).getParent().replace("\\", "/"))))) {
            this.initUserPassword(subFNumber);
            String userName = SessionManager.getCurrent().get(SMG_USERNAME);
            String password = SessionManager.getCurrent().get(SMG_PASS);
            SVNClientManager clientManager = SVNKitUtil.getClientManager(svnRoot, userName, password);
            SVNKitUtil.update(files.toArray(new File[0]), SVNRevision.HEAD, SVNDepth.INFINITY, clientManager);
        }
    }

    public String savePageInDevportal(String sql, String sqlFileName, OperationInfo operationInfo, LibAddress libAddress) {
        this.saveFile(sql, sqlFileName, operationInfo, libAddress.getLibAddress());
        return this.getDbSchemaPath(this.userPath, sqlFileName, libAddress.getLibAddress());
    }

    private static String cleanString(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("../", "#");
        StringBuilder cleanString = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            cleanString.append(MetadataUtil.cleanChar(str.charAt(i)));
        }
        return cleanString.toString();
    }

    private static char cleanChar(char c) {
        int i;
        for (i = 48; i < 58; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 65; i < 91; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 97; i < 123; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        switch (c) {
            case 58: {
                return ':';
            }
            case 47: {
                return '/';
            }
            case 46: {
                return '.';
            }
            case 45: {
                return '-';
            }
            case 95: {
                return '_';
            }
            case 32: {
                return ' ';
            }
        }
        if (((char)c + "").equals("\\")) {
            return (char)c;
        }
        return '%';
    }
}

