/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;

public class OperationInfo {
    private static final String SUCCESS_MSG = "successMsg";
    private static final String ERROR_MSG = "errorMsg";
    private static final String FILE_PATH = "filePath";
    Map<String, List<String>> messages = new HashMap<String, List<String>>(){
        {
            this.put(OperationInfo.SUCCESS_MSG, new ArrayList());
            this.put(OperationInfo.ERROR_MSG, new ArrayList());
            this.put(OperationInfo.FILE_PATH, new ArrayList());
        }
    };

    public Map<String, List<String>> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<String, List<String>> messages) {
        this.messages = messages;
    }

    public void addMessage(String key, String message) {
        if (!this.messages.containsKey(key)) {
            throw new RuntimeException("not support key");
        }
        List<String> messageList = this.messages.get(key);
        messageList.add(message);
    }

    public void addSuccessMessage(String message) {
        List<String> messageList = this.messages.get(SUCCESS_MSG);
        messageList.add(message);
    }

    public List<String> getSuccessMessage() {
        return this.messages.get(SUCCESS_MSG);
    }

    public String getSuccessMessageString() {
        List<String> messageList = this.messages.get(SUCCESS_MSG);
        return StringUtils.join((Object[])messageList.toArray(new String[0]), (String)"\r\n");
    }

    public void addErrorMessage(String message) {
        List<String> messageList = this.messages.get(ERROR_MSG);
        messageList.add(message);
    }

    public List<String> getErrorMessage() {
        return this.messages.get(ERROR_MSG);
    }

    public String getErrorMessageString() {
        List<String> messageList = this.messages.get(ERROR_MSG);
        return StringUtils.join((Object[])messageList.toArray(new String[0]), (String)"\r\n");
    }

    public void addFilePath(String filePath) {
        List<String> messageList = this.messages.get(FILE_PATH);
        messageList.add(filePath);
    }

    public void addFilePath(File[] files) {
        List<String> messageList = this.messages.get(FILE_PATH);
        for (File file : files) {
            messageList.add(file.getPath());
        }
    }

    public List<String> getFilePath() {
        return this.messages.get(FILE_PATH);
    }

    public String getFilePathString() {
        List<String> messageList = this.messages.get(FILE_PATH);
        return StringUtils.join((Object[])messageList.toArray(new String[0]), (String)"\r\n");
    }
}

