/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FilenameUtils;

public class PropertiesFileUtil {
    private static final String PROJECT_NAME = "bos-designer-plugin";
    private static final String ERROR_MSG = "Error:%s";
    String resource;
    String userHomePath = System.getProperty("user.home");
    String path;
    private static final Log log = LogFactory.getLog(PropertiesFileUtil.class);

    public String getResource() {
        return this.resource;
    }

    public void seResource(String resource) {
        this.resource = resource;
    }

    public String getUserHomePath() {
        return this.userHomePath;
    }

    public void setUserHomePath(String userHomePath) {
        this.userHomePath = userHomePath;
    }

    public String getPath() {
        return this.path;
    }

    public PropertiesFileUtil() {
        this("account.properties");
    }

    public PropertiesFileUtil(String resource) {
        this.resource = resource;
        this.path = String.format("%s\\\\%s", this.userHomePath, resource);
    }

    public PropertiesFileUtil(String resource, String userHomePath) {
        this.resource = resource;
        this.userHomePath = userHomePath;
        this.path = String.format("%s\\\\%s", userHomePath, resource);
    }

    public boolean fileIsExist() {
        File file = new File(FilenameUtils.getName((String)this.path));
        return file.exists();
    }

    public boolean createFile() {
        File file = new File(FilenameUtils.getName((String)this.path));
        if (!file.exists()) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                log.info(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6587\u4ef6\u521b\u5efa\u5931\u8d25\u3002", (String)"PropertiesFileUtil_0", (String)PROJECT_NAME, (Object[])new Object[0]), file.getName()));
                return false;
            }
        }
        return true;
    }

    public Map<String, String> getProperties(InputStream inputStream) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(10);
        try (InputStream inputStm = inputStream;){
            Properties properties = new Properties();
            properties.load(inputStm);
            for (Object key : properties.keySet()) {
                propertiesMap.put(key.toString(), properties.getProperty(key.toString()));
            }
        }
        catch (FileNotFoundException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageFileNotExist, new Object[]{String.format(ERROR_MSG, e.getMessage())});
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ERROR_MSG, e.getMessage())});
        }
        return propertiesMap;
    }

    public Map<String, String> getProperties() {
        FileInputStream inputStream;
        this.createFile();
        try {
            inputStream = new FileInputStream(FilenameUtils.getName((String)this.path));
        }
        catch (FileNotFoundException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageFileNotExist, new Object[]{String.format(ERROR_MSG, e.getMessage())});
        }
        return this.getProperties(inputStream);
    }

    public void setProperties(Map<String, String> propertiesMap, String remark) {
        Properties pro = new Properties();
        try (FileOutputStream outputStream = new FileOutputStream(FilenameUtils.getName((String)this.path));){
            this.createFile();
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                pro.setProperty(entry.getKey(), entry.getValue());
            }
            if (!StringUtils.isEmpty((CharSequence)remark)) {
                pro.store(outputStream, remark);
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ERROR_MSG, e.getMessage())});
        }
    }

    public void setProperty(String key, String value) {
        Properties prop = new Properties();
        try (FileInputStream fis = new FileInputStream(FilenameUtils.getName((String)this.path));
             FileOutputStream outputStream = new FileOutputStream(FilenameUtils.getName((String)this.path));){
            this.createFile();
            prop.load(fis);
            prop.setProperty(key, value);
            prop.store(outputStream, "");
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{String.format(ERROR_MSG, e.getMessage())});
        }
    }
}

