/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.io.File;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.dao.CustomSVNAuthenticationProvider;
import kd.bos.designer.dao.OperationInfo;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FilenameUtils;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNKitUtil {
    private static String STRING_EMPTY = "";
    private static int NEGATIVE_ONE = -1;
    private static final Log log = LogFactory.getLog(SVNKitUtil.class);

    public static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static boolean testConnection(String svnUrl, String svnUser, String strPassword) throws Exception {
        strPassword = Encrypters.decode((String)strPassword);
        DAVRepositoryFactory.setup();
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)svnUrl));
        BasicAuthenticationManager authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(svnUser, strPassword, true, SVNURL.parseURIEncoded((String)svnUrl), true)});
        authManager.acknowledgeTrustManager(null);
        repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        SVNNodeKind nodeKind = repository.checkPath(STRING_EMPTY, (long)NEGATIVE_ONE);
        if (nodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"No project at URL");
            throw new SVNException(err);
        }
        authManager.setAuthenticationProvider((ISVNAuthenticationProvider)new CustomSVNAuthenticationProvider(svnUser, strPassword));
        repository.setTunnelProvider((ISVNTunnelProvider)SVNWCUtil.createDefaultOptions((boolean)true));
        repository.testConnection();
        return true;
    }

    public static boolean testSvnConnection(String svnUrl, String svnUser, String strPassword, OperationInfo operationInfo) {
        try {
            SVNKitUtil.testConnection(svnUrl, svnUser, strPassword);
        }
        catch (SVNException expection) {
            if (expection.getMessage().startsWith("svn: Authentication required for")) {
                operationInfo.addErrorMessage(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"SVNKitUtil_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return false;
            }
            operationInfo.addErrorMessage(expection.getMessage());
            return false;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return false;
        }
        return true;
    }

    public static SVNClientManager getClientManager(String svnRoot, String userName, String password) {
        BasicAuthenticationManager authManager;
        SVNKitUtil.setupLibrary();
        SVNRepository repository = null;
        try {
            password = Encrypters.decode((String)password);
            SVNURL url = SVNURL.parseURIEncoded((String)svnRoot);
            repository = SVNRepositoryFactory.create((SVNURL)url);
            authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(userName, password, false, url, false)});
            repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        }
        catch (SVNException e) {
            return null;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return null;
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        return clientManager;
    }

    public static void commit(SVNClientManager clientManager, File[] files, String anno, OperationInfo operationInfo) {
        try {
            clientManager.getWCClient().doAdd(files, true, false, false, SVNDepth.INFINITY, false, true, true);
            clientManager.getCommitClient().doCommit(files, true, anno, null, null, true, false, SVNDepth.INFINITY);
            operationInfo.addFilePath(files);
        }
        catch (SVNException e) {
            log.info(e.getMessage());
            operationInfo.addErrorMessage(e.getMessage());
        }
    }

    public static SVNCommitInfo makeDirectory(SVNClientManager clientManager, SVNURL url, String commitMessage) {
        try {
            return clientManager.getCommitClient().doMkDir(new SVNURL[]{url}, commitMessage);
        }
        catch (SVNException e) {
            log.info(e.getMessage());
            return null;
        }
    }

    public static OperationInfo checkRootFolder(String filePath, String svnRoot, SVNClientManager clientManager, OperationInfo operationInfo) {
        File checkOutFile = new File(FilenameUtils.getName((String)filePath));
        try {
            Boolean flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
            if (!flag.booleanValue()) {
                SVNKitUtil.checkedOut(checkOutFile, svnRoot, clientManager, operationInfo);
                flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
                if (!flag.booleanValue()) {
                    operationInfo.addErrorMessage(String.format(ResManager.loadKDString((String)"\u76ee\u5f55\u4e0d\u662fsvn\u7ba1\u7406\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\uff1a%s\u3002", (String)"SVNKitUtil_1", (String)"bos-designer-plugin", (Object[])new Object[0]), checkOutFile));
                }
                return operationInfo;
            }
        }
        catch (SVNException e) {
            operationInfo.addErrorMessage(e.getMessage());
            throw new RuntimeException(e);
        }
        return operationInfo;
    }

    public static void checkedOut(File checkOutFile, String svnRoot, SVNClientManager clientManager, OperationInfo operationInfo) {
        try {
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            SVNURL url = SVNURL.parseURIEncoded((String)svnRoot);
            long l = updateClient.doCheckout(url, checkOutFile, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
        }
        catch (SVNException e) {
            operationInfo.addErrorMessage(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static long[] update(File[] wcPath, SVNRevision updateToRevision, SVNDepth depth, SVNClientManager clientManager) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doUpdate(wcPath, updateToRevision, depth, false, false);
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
    }
}

