/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dynplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta;

public class DynPluginBindClearCacheOpPlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String key = e.getOperationKey();
        if (this.isSupportClearCache(key)) {
            this.clearCacheByDynPluginBindIds(e.getValidExtDataEntities());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        if (this.isSupportClearCache(key)) {
            this.clearCacheByDynPluginBindIds(e.getSelectedRows());
        }
    }

    private void clearCacheByDynPluginBindIds(List<ExtendedDataEntity> selectedRows) {
        if (selectedRows != null) {
            ArrayList<Object> dynPluginIds = new ArrayList<Object>(10);
            for (ExtendedDataEntity dataEntity : selectedRows) {
                dynPluginIds.add(dataEntity.getBillPkId());
            }
            DynamicPluginBindDesignMeta.clearCacheByBindIds(dynPluginIds);
        }
    }

    private boolean isSupportClearCache(String key) {
        return StringUtils.equals((CharSequence)"delete", (CharSequence)key) || StringUtils.equals((CharSequence)"enable", (CharSequence)key) || StringUtils.equals((CharSequence)"disable", (CharSequence)key) || StringUtils.equals((CharSequence)"save", (CharSequence)key);
    }
}

