/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dynplugin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dynplugin.BillTreeBuildParameter;
import kd.bos.designer.dynplugin.DynPluginEdit;
import kd.bos.designer.dynplugin.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.dynplugin.EntityDynamicProxyPluginFactory;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.dynplugin.FormDynamicProxyPluginFactory;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.annotations.BillPluginMethod;
import kd.bos.form.plugin.annotations.FormPluginMethod;
import kd.bos.form.plugin.annotations.MobBillPluginMethod;
import kd.bos.form.plugin.annotations.MobFormPluginMethod;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class DynPluginBindEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(DynPluginBindEdit.class);
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String OPTYPE_SAVE = "save";
    private static final String OPTYPE_NEW = "new";
    private static final String OPTYPE_COPY = "copy";
    private static final String OPTYPE_DELETE = "delete";
    private static final String BAR_DELETE = "bar_delete";
    private static final String BAR_SAVE = "bar_save";
    private static final String KEY_DYNPLUGIN = "dynplugin";
    private static final String KEY_OBJECTTYPEID = "objecttype";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NUMBER_PK = "number_pk";
    private static final String KEY_INTERFACETYPE = "interfacetype";
    private static final String KEY_OPERATIONKEY = "operationkey";
    private static final String KEY_EVENTMETHOD = "eventmethod";
    private static final String KEY_ISV = "isv";
    private static final String KEY_CLIENT = "client";
    private static final String KEY_CLASSNAME = "number";
    private static final String KEY_RUNCONDITIONDESC = "runconditiondesc";
    private static final String KEY_RUNCONDITION = "runcondition_tag";
    private static final String KEY_EFFECTFIELDS = "effectfields";
    private static final String SELOPERATEPAGE_FORMID = "bos_seloperatepage";
    private static final String MODELTYPE = "modeltype";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_RUNCONDITIONDESC, KEY_OPERATIONKEY});
        BasedataEdit objecttype = (BasedataEdit)this.getView().getControl(KEY_OBJECTTYPEID);
        if (objecttype != null) {
            objecttype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setCurrentIsv();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if ((StringUtils.equals((CharSequence)OPTYPE_SAVE, (CharSequence)op.getType()) || StringUtils.equals((CharSequence)OPTYPE_DELETE, (CharSequence)op.getType())) && !this.doOperationValidate()) {
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)OPTYPE_SAVE, (CharSequence)op.getType())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Object objecttypeid = this.getModel().getValue(KEY_OBJECTTYPEID);
            if (objecttypeid instanceof DynamicObject) {
                Object number = ((DynamicObject)objecttypeid).get("number");
                Object dynplugin = this.getModel().getValue(KEY_DYNPLUGIN);
                if (dynplugin instanceof DynamicObject) {
                    long id;
                    long l = id = dataEntity.getPkValue() == null ? 0L : (Long)dataEntity.getPkValue();
                    if (id == 0L) {
                        id = ID.genLongId();
                        dataEntity.set("id", (Object)id);
                    }
                    Object eventmethod = ((DynamicObject)dynplugin).get(KEY_EVENTMETHOD);
                    String classname = ((DynamicObject)dynplugin).get("number") == null ? "" : (String)((DynamicObject)dynplugin).get("number");
                    classname = DynPluginEdit.getNumberByClassName(classname);
                    this.getModel().setValue("number", (Object)(number + "_" + classname + "_" + eventmethod + "_" + id));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)OPTYPE_NEW, (CharSequence)op.getType()) || StringUtils.equals((CharSequence)OPTYPE_COPY, (CharSequence)op.getType())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BAR_DELETE, BAR_SAVE});
        }
    }

    public void afterCopyData(EventObject e) {
        this.setCurrentIsv();
        this.setPageInfo();
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        if (!this.isCurrentIsv()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BAR_DELETE, BAR_SAVE});
        }
        this.setPageInfo();
        String conditionJson = (String)this.getModel().getValue(KEY_RUNCONDITION);
        this.receiveCondition(conditionJson, KEY_RUNCONDITION, KEY_RUNCONDITIONDESC);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String conditionJsondesc;
        String key = e.getProperty().getName();
        if (KEY_DYNPLUGIN.equalsIgnoreCase(key)) {
            this.getModel().setValue(KEY_OBJECTTYPEID, (Object)"");
            this.setPageInfo();
        } else if (KEY_OBJECTTYPEID.equalsIgnoreCase(key)) {
            this.getModel().setValue(KEY_OPERATIONKEY, (Object)"");
            this.getModel().setValue(KEY_RUNCONDITION, (Object)"");
            this.getModel().setValue(KEY_RUNCONDITIONDESC, (Object)"");
            this.getModel().setValue(KEY_EFFECTFIELDS, (Object)"");
        } else if (KEY_RUNCONDITIONDESC.equalsIgnoreCase(key) && StringUtils.isEmpty((CharSequence)(conditionJsondesc = (String)this.getModel().getValue(KEY_RUNCONDITIONDESC)))) {
            this.getModel().setValue(KEY_RUNCONDITION, (Object)"");
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "runconditiondesc": {
                this.ruleCondition(KEY_RUNCONDITIONDESC);
                break;
            }
            case "operationkey": {
                Object objecttype = this.getModel().getValue(KEY_OBJECTTYPEID);
                if (!(objecttype instanceof DynamicObject)) break;
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId(SELOPERATEPAGE_FORMID);
                parameter.setCustomParam("entityId", (Object)this.getEntityNumber((DynamicObject)objecttype));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELOPERATEPAGE_FORMID));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataEntityProperty prop = e.getProperty();
        if (KEY_OBJECTTYPEID.equalsIgnoreCase(prop.getName())) {
            Object dynplugin = this.getModel().getValue(KEY_DYNPLUGIN);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            if (dynplugin instanceof DynamicObject) {
                String client;
                String interfacetype = ((DynamicObject)dynplugin).get(KEY_INTERFACETYPE) == null ? "" : (String)((DynamicObject)dynplugin).get(KEY_INTERFACETYPE);
                String string = client = ((DynamicObject)dynplugin).get(KEY_CLIENT) == null ? "" : (String)((DynamicObject)dynplugin).get(KEY_CLIENT);
                if (StringUtils.equalsIgnoreCase((CharSequence)"4", (CharSequence)interfacetype)) {
                    qFilterList.add(QFilter.of((String)"id = basedatafield", (Object[])new Object[0]));
                    qFilterList.add(new QFilter(MODELTYPE, "in", (Object)new String[]{"MobileBillFormModel", "BillFormModel", "BaseFormModel"}));
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)interfacetype)) {
                    if ("2".equals(client)) {
                        qFilterList.add(new QFilter(MODELTYPE, "in", (Object)new String[]{"MobileFormModel"}));
                    } else {
                        qFilterList.add(new QFilter(MODELTYPE, "in", (Object)new String[]{"DynamicFormModel"}));
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)interfacetype)) {
                    if ("2".equals(client)) {
                        qFilterList.add(new QFilter(MODELTYPE, "in", (Object)new String[]{"MobileBillFormModel", "BillFormModel", "BaseFormModel"}));
                    } else {
                        qFilterList.add(new QFilter(MODELTYPE, "in", (Object)new String[]{"BillFormModel", "BaseFormModel"}));
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"3", (CharSequence)interfacetype)) {
                    if ("2".equals(client)) {
                        qFilterList.add(new QFilter(MODELTYPE, "in", (Object)new String[]{"MobileListModel", "BillFormModel", "BaseFormModel"}));
                    } else {
                        qFilterList.add(new QFilter(MODELTYPE, "in", (Object)new String[]{"BillFormModel", "BaseFormModel"}));
                    }
                }
            }
            if (CollectionUtils.isEmpty(qFilterList)) {
                qFilterList.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            } else {
                ArrayList<Object> noCodeAppIds = null;
                Map appsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizcloud", "=", (Object)"2HGKCE94QELW")});
                if (appsMap != null) {
                    noCodeAppIds = new ArrayList(appsMap.size() + 1);
                    for (DynamicObject obj : appsMap.values()) {
                        noCodeAppIds.add(obj.getPkValue());
                    }
                } else {
                    noCodeAppIds = new ArrayList<Object>(1);
                }
                noCodeAppIds.add("2HGKTA7HH43C");
                qFilterList.add(new QFilter("bizappid", "not in", (Object)noCodeAppIds.toArray()));
                qFilterList.add(new QFilter(KEY_ISV, "=", (Object)ISVService.getISVInfo().getId()));
            }
            ListShowParameter lsp = (ListShowParameter)e.getFormShowParameter();
            lsp.getListFilterParameter().getQFilters().addAll(qFilterList);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ruleMap;
        if (e.getReturnData() == null) {
            return;
        }
        if (KEY_RUNCONDITIONDESC.equals(e.getActionId())) {
            String conditionJson = (String)e.getReturnData();
            this.receiveCondition(conditionJson, KEY_RUNCONDITION, KEY_RUNCONDITIONDESC);
        } else if (SELOPERATEPAGE_FORMID.equals(e.getActionId()) && (ruleMap = (Map)e.getReturnData()).get("returnDataSelectedOperation") != null) {
            this.getModel().setValue(KEY_OPERATIONKEY, ruleMap.get("returnDataSelectedOperation"));
        }
    }

    private boolean doOperationValidate() {
        if (!this.isCurrentIsv()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u64cd\u4f5c\u975e\u672c\u5f00\u53d1\u5546\u7684\u63d2\u4ef6\u3002", (String)"DynPluginEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCurrentIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        String isv = (String)this.getModel().getValue(KEY_ISV);
        return StringUtils.equals((CharSequence)isv, (CharSequence)currentIsv);
    }

    private void setCurrentIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        this.getModel().setValue(KEY_ISV, (Object)currentIsv);
    }

    private void setPageInfo() {
        Object dynplugin = this.getModel().getValue(KEY_DYNPLUGIN);
        if (dynplugin instanceof DynamicObject) {
            String interfacetype = ((DynamicObject)dynplugin).getString(KEY_INTERFACETYPE);
            if (StringUtils.equalsIgnoreCase((CharSequence)"4", (CharSequence)interfacetype)) {
                TextEdit textEdit = (TextEdit)this.getView().getControl(KEY_OPERATIONKEY);
                textEdit.setMustInput(StringUtils.equals((CharSequence)"4", (CharSequence)interfacetype));
            }
            String eventmethod = ((DynamicObject)dynplugin).getLocaleString("name").getLocaleValue();
            String client = ((DynamicObject)dynplugin).getString(KEY_CLIENT);
            if (this.isSupportConditionValid(interfacetype, client, eventmethod)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_RUNCONDITIONDESC});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_RUNCONDITIONDESC});
            }
        }
    }

    private void ruleCondition(String condition) {
        String conditionJson = (String)this.getModel().getValue(KEY_RUNCONDITION);
        String entitynumber = "";
        Object objecttype = this.getModel().getValue(KEY_OBJECTTYPEID);
        if (!(objecttype instanceof DynamicObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9875\u9762\u3002", (String)"DynPluginEdit_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        entitynumber = this.getEntityNumber((DynamicObject)objecttype);
        if (StringUtils.isBlank((CharSequence)entitynumber)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u5355\u201c%1$s\u201d\u7684\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DynPluginEdit_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ((DynamicObject)objecttype).getString("id")));
            return;
        }
        try {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entitynumber);
            HashSet<String> selectedEntity = new HashSet<String>();
            selectedEntity.add(mainType.getName());
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.getForbidClassTypes().add(AttachmentProp.class);
            parameter.getForbidClassTypes().add(PictureProp.class);
            parameter.getSelectedEntity().addAll(selectedEntity);
            TreeNode billTreeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_condition");
            showParameter.getCustomParams().put("formula", conditionJson);
            showParameter.getCustomParams().put("entitynumber", entitynumber);
            showParameter.getCustomParams().put("onlyheadfield", String.valueOf(true));
            showParameter.getCustomParams().put("treenodes", fldNodes);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, condition));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            log.error("\u6253\u5f00\u542f\u7528\u6761\u4ef6\u9875\u9762\u5931\u8d25\u3002", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u542f\u7528\u6761\u4ef6\u9875\u9762\u5931\u8d25\u3002", (String)"DynPluginEdit_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private String getEntityNumber(DynamicObject objecttype) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)objecttype.getString("id"), (String)"bos_formmeta");
        if (dynamicObject != null) {
            String formEntityNumber;
            String masterid = dynamicObject.getString("masterid");
            String type = dynamicObject.getString("type");
            if ("2".equals(type) && StringUtils.isNotEmpty((CharSequence)masterid)) {
                dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)masterid, (String)"bos_formmeta");
            }
            if (dynamicObject != null && StringUtils.isNotEmpty((CharSequence)(formEntityNumber = dynamicObject.getString("basedatafield.number")))) {
                return formEntityNumber;
            }
        }
        return "";
    }

    private void receiveCondition(String conditionJson, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            this.getModel().setValue(conditionFldKey, (Object)conditionJson);
            this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
        }
    }

    private boolean isSupportConditionValid(String interfacetype, String client, String eventmethod) {
        if (StringUtils.isEmpty((CharSequence)interfacetype) || StringUtils.isEmpty((CharSequence)client) || StringUtils.isEmpty((CharSequence)eventmethod)) {
            return false;
        }
        Annotation annotation = null;
        Method method = FormDynamicProxyPluginFactory.getEventmethod((String)interfacetype, (String)client, (String)eventmethod);
        if (method != null) {
            Annotation[] annotations = method.getAnnotations();
            FormDynamicProxyPluginFactory.ProxyPluginInfo proxyPluginInfo_f = FormDynamicProxyPluginFactory.getProxyPluginInfo((String)interfacetype, (String)client);
            EntityDynamicProxyPluginFactory.ProxyPluginInfo proxyPluginInfo_e = EntityDynamicProxyPluginFactory.getProxyPluginInfo((String)interfacetype);
            for (Annotation an : annotations) {
                if (proxyPluginInfo_f != null && an.annotationType().getName().equals(proxyPluginInfo_f.getAnnotationType())) {
                    annotation = an;
                    continue;
                }
                if (proxyPluginInfo_e == null || !an.annotationType().getName().equals(proxyPluginInfo_e.getAnnotationType())) continue;
                annotation = an;
            }
        }
        if (annotation instanceof FormPluginMethod) {
            return ((FormPluginMethod)annotation).isSupportConditionValid();
        }
        if (annotation instanceof BillPluginMethod) {
            return ((BillPluginMethod)annotation).isSupportConditionValid();
        }
        if (annotation instanceof MobFormPluginMethod) {
            return ((MobFormPluginMethod)annotation).isSupportConditionValid();
        }
        if (annotation instanceof MobBillPluginMethod) {
            return ((MobBillPluginMethod)annotation).isSupportConditionValid();
        }
        return false;
    }
}

