/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dynplugin;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.dynplugin.FormDynamicProxyPluginFactory;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

public class DynPluginEdit
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(DynPluginEdit.class);
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    public static final String LAYOUT_ROLE = "1";
    public static final String ENTITY_ROLE = "2";
    private static final String OPTYPE_SAVE = "save";
    private static final String OPTYPE_NEW = "new";
    private static final String OPTYPE_COPY = "copy";
    private static final String OPTYPE_DELETE = "delete";
    private static final String BAR_DELETE = "bar_delete";
    private static final String BAR_SAVE = "bar_save";
    private static final String KEY_CLASSNAME = "number";
    private static final String KEY_CLASSNAME_TS = "number_ts";
    private static final String KEY_NUMBER = "number_pk";
    private static final String KEY_NAME = "name";
    private static final String KEY_ROLE = "role";
    private static final String KEY_INTERFACETYPE = "interfacetype";
    private static final String KEY_CLIENT = "client";
    private static final String KEY_ISV = "isv";
    private static final String KEY_EVENTMETHOD = "eventmethod";
    private static final String KEY_PLUGINDESC_TAG = "plugindesc_tag";
    private static final String KEY_PLUGINDESC_MD = "plugindesc_md";
    private static final String KEY_PLUGINCODE_TAG = "plugincode_tag";
    private static final String KEY_PLUGINCODE_JS = "plugincode_js";
    private static final String KEY_TEXT = "text";

    public void afterCreateNewData(EventObject e) {
        this.setCurrentIsv();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if ((StringUtils.equals((CharSequence)OPTYPE_SAVE, (CharSequence)op.getType()) || StringUtils.equals((CharSequence)OPTYPE_DELETE, (CharSequence)op.getType())) && !this.doOperationValidate()) {
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)OPTYPE_SAVE, (CharSequence)op.getType())) {
            this.updateValBeforeSave();
        }
    }

    public void afterCopyData(EventObject e) {
        this.setCurrentIsv();
        this.getModel().setDataChanged(false);
        this.setClientVal();
    }

    public void afterBindData(EventObject e) {
        String eventmethod;
        super.afterBindData(e);
        String sampleJson = (String)this.getModel().getValue(KEY_PLUGINDESC_TAG);
        String sampleText = null;
        if (StringUtils.isNotBlank((CharSequence)sampleJson)) {
            Map sampleContext = (Map)SerializationUtils.fromJsonString((String)sampleJson, Map.class);
            sampleText = (String)sampleContext.get(KEY_TEXT);
        }
        if (sampleText == null) {
            sampleText = "";
        }
        Markdown md = (Markdown)this.getView().getControl(KEY_PLUGINDESC_MD);
        md.setText(sampleText);
        String codeJson = (String)this.getModel().getValue(KEY_PLUGINCODE_TAG);
        String codeText = null;
        if (StringUtils.isNotBlank((CharSequence)codeJson)) {
            Map sampleContext = (Map)SerializationUtils.fromJsonString((String)codeJson, Map.class);
            codeText = (String)sampleContext.get(KEY_TEXT);
        }
        if (codeText == null) {
            codeText = "";
        }
        CodeEdit code = (CodeEdit)this.getView().getControl(KEY_PLUGINCODE_JS);
        code.setText(codeText);
        String role = this.getModel().getValue(KEY_ROLE) == null ? "" : (String)this.getModel().getValue(KEY_ROLE);
        this.setInterfacetypeComboItems(role);
        String interfacetype = this.getModel().getValue(KEY_INTERFACETYPE) == null ? "" : (String)this.getModel().getValue(KEY_INTERFACETYPE);
        String client = this.getModel().getValue(KEY_CLIENT) == null ? "" : (String)this.getModel().getValue(KEY_CLIENT);
        this.setEventmethodComboItems(interfacetype, client);
        String string = eventmethod = this.getModel().getValue(KEY_EVENTMETHOD) == null ? "" : (String)this.getModel().getValue(KEY_EVENTMETHOD);
        if ("ALL".equals(eventmethod)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new", BAR_DELETE, BAR_SAVE});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)OPTYPE_NEW, (CharSequence)op.getType()) || StringUtils.equals((CharSequence)OPTYPE_COPY, (CharSequence)op.getType())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_ROLE, KEY_INTERFACETYPE, KEY_EVENTMETHOD, KEY_CLIENT, BAR_DELETE, BAR_SAVE});
        }
    }

    public void afterLoadData(EventObject e) {
        if (!this.isCurrentIsv()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BAR_DELETE, BAR_SAVE});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_ROLE, KEY_INTERFACETYPE, KEY_EVENTMETHOD, KEY_CLIENT});
        this.setClientVal();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value = e.getChangeSet()[0].getNewValue();
        String key = e.getProperty().getName();
        if (value == null) {
            return;
        }
        if (KEY_ROLE.equals(key)) {
            this.setInterfacetypeComboItems(value.toString());
            if (ENTITY_ROLE.equals(value.toString())) {
                this.getModel().setValue(KEY_INTERFACETYPE, (Object)"4");
            } else {
                String interfacetype;
                String string = interfacetype = this.getModel().getValue(KEY_INTERFACETYPE) == null ? "" : (String)this.getModel().getValue(KEY_INTERFACETYPE);
                if (StringUtils.isBlank((CharSequence)interfacetype) || "4".equals(interfacetype)) {
                    this.getModel().setValue(KEY_INTERFACETYPE, (Object)LAYOUT_ROLE);
                }
            }
            this.setClientVal();
        } else if (KEY_INTERFACETYPE.equals(key) || KEY_CLIENT.equals(key)) {
            String interfacetype;
            String client = this.getModel().getValue(KEY_CLIENT) == null ? "" : (String)this.getModel().getValue(KEY_CLIENT);
            String string = interfacetype = this.getModel().getValue(KEY_INTERFACETYPE) == null ? "" : (String)this.getModel().getValue(KEY_INTERFACETYPE);
            if (StringUtils.isNotBlank((CharSequence)client) && StringUtils.isNotBlank((CharSequence)interfacetype)) {
                this.setEventmethodComboItems(interfacetype, client);
            }
            this.getModel().setValue(KEY_EVENTMETHOD, (Object)"");
            this.setClientVal();
        }
    }

    private void setEventmethodComboItems(String interfacetype, String client) {
        ArrayList<ComboItem> combolist = null;
        List eventmethodList = FormDynamicProxyPluginFactory.getEventmethodList((String)interfacetype, (String)client);
        if (CollectionUtils.isEmpty((Collection)eventmethodList)) {
            combolist = new ArrayList<ComboItem>(0);
        } else {
            combolist = new ArrayList(eventmethodList.size());
            for (Method method : eventmethodList) {
                combolist.add(new ComboItem(new LocaleString(method.getName()), method.getName()));
            }
        }
        this.resetComboItems(KEY_EVENTMETHOD, combolist);
    }

    private void setInterfacetypeComboItems(String role) {
        if (StringUtils.isEmpty((CharSequence)role)) {
            return;
        }
        ArrayList<ComboItem> combolist = new ArrayList<ComboItem>(3);
        if (LAYOUT_ROLE.equals(role)) {
            combolist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u5355\u63d2\u4ef6", (String)"DynPluginEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), LAYOUT_ROLE));
            combolist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u63d2\u4ef6", (String)"DynPluginEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), ENTITY_ROLE));
            combolist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868\u63d2\u4ef6", (String)"DynPluginEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "3"));
        } else if (ENTITY_ROLE.equals(role)) {
            combolist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c\u63d2\u4ef6", (String)"DynPluginEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "4"));
        }
        this.resetComboItems(KEY_INTERFACETYPE, combolist);
    }

    private void resetComboItems(String key, List<ComboItem> combolist) {
        String eventmethod;
        ComboEdit comboEdit = (ComboEdit)this.getControl(key);
        ArrayList<ComboItem> newCombolist = new ArrayList<ComboItem>(combolist.size());
        combolist.forEach(obj -> {
            ComboItem comboItem = new ComboItem(obj.getCaption(), obj.getValue());
            newCombolist.add(comboItem);
        });
        String string = eventmethod = this.getModel().getValue(KEY_EVENTMETHOD) == null ? "" : (String)this.getModel().getValue(KEY_EVENTMETHOD);
        if ("ALL".equals(eventmethod)) {
            newCombolist.add(new ComboItem(new LocaleString("ALL"), "ALL"));
        }
        comboEdit.setComboItems(newCombolist);
    }

    private void updateValBeforeSave() {
        long id;
        String classname;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Markdown md = (Markdown)this.getView().getControl(KEY_PLUGINDESC_MD);
        String sampleText = md.getText();
        HashMap<String, String> sampleContext = new HashMap<String, String>();
        sampleContext.put(KEY_TEXT, sampleText);
        this.getModel().setValue(KEY_PLUGINDESC_TAG, (Object)SerializationUtils.toJsonString(sampleContext));
        CodeEdit js = (CodeEdit)this.getView().getControl(KEY_PLUGINCODE_JS);
        String jsText = js.getText();
        HashMap<String, String> codeContext = new HashMap<String, String>();
        codeContext.put(KEY_TEXT, jsText);
        this.getModel().setValue(KEY_PLUGINCODE_TAG, (Object)SerializationUtils.toJsonString(codeContext));
        String eventmethod = this.getModel().getValue(KEY_EVENTMETHOD) == null ? "" : (String)this.getModel().getValue(KEY_EVENTMETHOD);
        this.getModel().setValue(KEY_NAME, (Object)eventmethod);
        String string = classname = this.getModel().getValue(KEY_CLASSNAME) == null ? "" : (String)this.getModel().getValue(KEY_CLASSNAME);
        if (StringUtils.isNotEmpty((CharSequence)classname)) {
            this.getModel().setValue(KEY_CLASSNAME, (Object)classname.trim());
            this.getModel().setValue(KEY_CLASSNAME_TS, (Object)classname.trim());
        }
        long l = id = dataEntity.getPkValue() == null ? 0L : (Long)dataEntity.getPkValue();
        if (id == 0L) {
            id = ID.genLongId();
            dataEntity.set("id", (Object)id);
        }
        classname = DynPluginEdit.getNumberByClassName(classname.trim());
        this.getModel().setValue(KEY_NUMBER, (Object)(classname + "_" + eventmethod + "_" + id));
    }

    private boolean doOperationValidate() {
        if (!this.isCurrentIsv()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u64cd\u4f5c\u975e\u672c\u5f00\u53d1\u5546\u7684\u63d2\u4ef6\u3002", (String)"DynPluginEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCurrentIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        String isv = (String)this.getModel().getValue(KEY_ISV);
        return StringUtils.equals((CharSequence)isv, (CharSequence)currentIsv);
    }

    private void setCurrentIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        this.getModel().setValue(KEY_ISV, (Object)currentIsv);
    }

    private void setClientVal() {
        String role;
        String string = role = this.getModel().getValue(KEY_ROLE) == null ? "" : (String)this.getModel().getValue(KEY_ROLE);
        if (LAYOUT_ROLE.equals(role)) {
            String client;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_CLIENT});
            String string2 = client = this.getModel().getValue(KEY_CLIENT) == null ? "" : (String)this.getModel().getValue(KEY_CLIENT);
            if (StringUtils.isEmpty((CharSequence)client)) {
                this.getModel().setValue(KEY_CLIENT, (Object)LAYOUT_ROLE);
            }
        } else if (ENTITY_ROLE.equals(role)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_CLIENT});
            this.getModel().setValue(KEY_CLIENT, (Object)"");
        }
    }

    public static String getNumberByClassName(String className) {
        if (StringUtils.isNotBlank((CharSequence)className)) {
            if (className.endsWith(".ts")) {
                className = className.substring(0, className.lastIndexOf(".ts"));
            }
            if (className.lastIndexOf("/") != -1) {
                className = className.substring(className.lastIndexOf("/") + 1);
            }
            if (className.lastIndexOf(".") != -1) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            return className;
        }
        return "";
    }
}

