/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dynplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.CustomMetaDeploy;
import kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta;
import kd.bos.metadata.dynplugin.DynamicPluginBindDesignMeta_Lang;
import kd.bos.metadata.dynplugin.DynamicPluginDesignMeta;
import kd.bos.metadata.dynplugin.DynamicPluginDesignMeta_Lang;

public class DynPluginListFilePlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(DynPluginListFilePlugin.class);
    private static final String FORMID_DYNPLUGIN = "bos_dynplugin";
    private static final String FORMID_DYNPLUGINBIND = "bos_dynpluginbind";
    private static final String BTNIMPORT = "btnimport";
    private static final String OP_EXPORT_XML = "exportxml";
    private static final String OP_IMPORT_XML = "importxml";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    private String[] getSelectedIds() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            return new String[0];
        }
        String[] ids = new String[rows.size()];
        for (int index = 0; index < rows.size(); ++index) {
            String id;
            ids[index] = id = String.valueOf(rows.get(index).getPrimaryKeyValue());
        }
        return ids;
    }

    protected CustomMetaDeploy createFileUtil() {
        CustomMetaDeploy fileUtil = null;
        String billFormId = ((IListView)this.getView()).getBillFormId();
        if (StringUtils.equals((CharSequence)FORMID_DYNPLUGIN, (CharSequence)billFormId)) {
            IDataEntityType designMetaType = OrmUtils.getDataEntityType(DynamicPluginDesignMeta.class);
            IDataEntityType designMetaTypeLang = OrmUtils.getDataEntityType(DynamicPluginDesignMeta_Lang.class);
            fileUtil = new CustomMetaDeploy(designMetaType, designMetaTypeLang, "dynplug");
        } else if (StringUtils.equals((CharSequence)FORMID_DYNPLUGINBIND, (CharSequence)billFormId)) {
            IDataEntityType designMetaType = OrmUtils.getDataEntityType(DynamicPluginBindDesignMeta.class);
            IDataEntityType designMetaTypeLang = OrmUtils.getDataEntityType(DynamicPluginBindDesignMeta_Lang.class);
            fileUtil = new CustomMetaDeploy(designMetaType, designMetaTypeLang, "dynplugbind");
        }
        return fileUtil;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            String opKey = e.getOperateKey();
            if (StringUtils.equals((CharSequence)opKey, (CharSequence)OP_EXPORT_XML)) {
                this.doExport();
            } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)OP_IMPORT_XML)) {
                this.showImportForm();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equalsIgnoreCase(BTNIMPORT)) {
            this.doImport((String)e.getReturnData());
        }
    }

    private void doExport() {
        String[] ids = this.getSelectedIds();
        if (ids.length == 0) {
            this.getView().showTipNotification(this.buildExportSelectDataTips());
            return;
        }
        CustomMetaDeploy fileUtil = this.createFileUtil();
        HashMap exportResult = new HashMap(4);
        String fileUrl = fileUtil.exportUrlFile(ids, exportResult);
        this.setTempFilePermItem(fileUrl);
        if (exportResult.get("error") != null) {
            List errMsgs = (List)exportResult.get("err_msgs");
            if (errMsgs != null) {
                this.getView().showTipNotification(StringUtils.join((Object[])errMsgs.toArray(), (String)"\r\n"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"BizExtPluginListFilePlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
            this.getView().openUrl(fileUrl);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"BizExtPluginListFilePlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
        }
    }

    private void setTempFilePermItem(String url) {
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", FORMID_DYNPLUGIN);
        refEntitiyMap.put("appId", "bos");
        DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        distributeCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    private void showImportForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_importfile");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6", (String)"BizExtPluginListFilePlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTNIMPORT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doImport(String importFile) {
        if (StringUtils.isBlank((CharSequence)importFile)) {
            return;
        }
        String[] fieldUrls = StringUtils.split((String)importFile, (String)";");
        CustomMetaDeploy fileUtil = this.createFileUtil();
        HashMap importResult = new HashMap(4);
        for (String fileUrl : fieldUrls) {
            fileUtil.importUrlFile(fileUrl, importResult);
        }
        if (importResult.get("error") != null) {
            List errMsgs = (List)importResult.get("err_msgs");
            if (errMsgs != null) {
                this.getView().showErrorNotification(StringUtils.join((Object[])errMsgs.toArray(), (String)"\r\n"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"BizExtPluginListFilePlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BizExtPluginListFilePlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            ((IListView)this.getView()).refresh();
            Object successFilesObj = importResult.get("success_files");
            if (successFilesObj instanceof ArrayList) {
                ArrayList successFiles = (ArrayList)successFilesObj;
                ArrayList<Long> dynPluginIds = new ArrayList<Long>(10);
                for (String successFile : successFiles) {
                    if (!StringUtils.isNotBlank((CharSequence)successFile) || !successFile.endsWith(".dynplugbind") && !successFile.endsWith(".dynplug")) continue;
                    if (successFile.endsWith(".dynplugbind")) {
                        successFile = successFile.substring(0, successFile.lastIndexOf(".dynplugbind"));
                    }
                    if (successFile.endsWith(".dynplug")) {
                        successFile = successFile.substring(0, successFile.lastIndexOf(".dynplug"));
                    }
                    if (successFile.lastIndexOf("_") != -1) {
                        successFile = successFile.substring(successFile.lastIndexOf("_") + 1);
                    }
                    try {
                        long tempId = Long.parseLong(successFile);
                        if (dynPluginIds.contains(tempId)) continue;
                        dynPluginIds.add(tempId);
                    }
                    catch (Exception e) {
                        log.error("\u5bfc\u5165\u6587\u4ef6\u540d\u6709\u8bef\uff1a{}", (Object)successFile);
                    }
                }
                if (dynPluginIds != null && dynPluginIds.size() > 0) {
                    String billFormId = ((IListView)this.getView()).getBillFormId();
                    if (StringUtils.equals((CharSequence)FORMID_DYNPLUGIN, (CharSequence)billFormId)) {
                        DynamicPluginDesignMeta.clearCacheByIds(dynPluginIds);
                    } else {
                        DynamicPluginBindDesignMeta.clearCacheByBindIds(dynPluginIds);
                    }
                }
            }
        }
    }

    private String buildExportSelectDataTips() {
        String billFormId = ((IListView)this.getView()).getBillFormId();
        if (StringUtils.equals((CharSequence)FORMID_DYNPLUGIN, (CharSequence)billFormId)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u52a8\u6001\u63d2\u4ef6\u5b9a\u4e49\u3002", (String)"DynPluginListFilePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u52a8\u6001\u63d2\u4ef6\u6ce8\u518c\u3002", (String)"DynPluginListFilePlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
    }
}

