/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dynplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DynPluginTScriptEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String OPTYPE_SELECT_TS = "selectts";
    private static final String RETURN_PLUGIN_CLASS_NAME = "ClassName";
    private static final String RETURN_PLUGIN_DESCRIPTION_NAME = "Description";
    private static final String KEY_CLASSNAME = "number";
    private static final String KEY_CLASSNAME_TS = "number_ts";
    private static final String KEY_CODETYPE = "codetype";
    private static final String KEY_BIZAPP = "bizapp";
    private static final String KEY_INTERFACETYPE = "interfacetype";
    private static final String KEY_CLIENT = "client";
    public static final String CODETYPE_JAVA = "0";
    public static final String CODETYPE_KINGSCRIPT = "4";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit classnameEdit = (TextEdit)this.getView().getControl(KEY_CLASSNAME_TS);
        classnameEdit.addClickListener((ClickListener)this);
        BasedataEdit objecttype = (BasedataEdit)this.getView().getControl(KEY_BIZAPP);
        if (objecttype != null) {
            objecttype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String codeType = (String)this.getModel().getValue(KEY_CODETYPE);
        if (StringUtils.isBlank((CharSequence)codeType)) {
            this.getModel().setValue(KEY_CODETYPE, (Object)CODETYPE_JAVA);
        } else if (StringUtils.equals((CharSequence)codeType, (CharSequence)CODETYPE_KINGSCRIPT)) {
            this.getModel().setValue(KEY_CLASSNAME_TS, this.getModel().getValue(KEY_CLASSNAME));
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String status;
        super.beforeFieldPostBack(e);
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)KEY_CLASSNAME_TS) && !StringUtils.equals((CharSequence)"A", (CharSequence)(status = (String)this.getModel().getValue("status")))) {
            e.setCancel(true);
            this.getView().updateView(e.getKey());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_CODETYPE)) {
            this.getModel().setValue(KEY_CLASSNAME, (Object)"");
            this.getModel().setValue(KEY_CLASSNAME_TS, (Object)"");
            this.getModel().setValue(KEY_BIZAPP, (Object)"");
        } else if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_BIZAPP)) {
            this.getModel().setValue(KEY_CLASSNAME, (Object)"");
            this.getModel().setValue(KEY_CLASSNAME_TS, (Object)"");
        } else if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_INTERFACETYPE)) {
            this.getModel().setValue(KEY_CLASSNAME, (Object)"");
            this.getModel().setValue(KEY_CLASSNAME_TS, (Object)"");
        }
    }

    public void click(EventObject event) {
        super.click(event);
        Control source = (Control)event.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_CLASSNAME_TS)) {
            this.doClickCodeType();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals(OPTYPE_SELECT_TS)) {
            List plugins = (List)event.getReturnData();
            this.afterSelectTs(plugins);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataEntityProperty prop = e.getProperty();
        if (KEY_BIZAPP.equalsIgnoreCase(prop.getName())) {
            ListShowParameter lsp = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("bizcloud", "!=", (Object)"2HGKCE94QELW"));
            filters.add(new QFilter("id", "!=", (Object)"2HGKTA7HH43C"));
            lsp.getListFilterParameter().getQFilters().addAll(filters);
        }
    }

    private void doClickCodeType() {
        String codeType = (String)this.getModel().getValue(KEY_CODETYPE);
        if (!StringUtils.equals((CharSequence)codeType, (CharSequence)CODETYPE_KINGSCRIPT)) {
            ComboProp prop = (ComboProp)this.getModel().getProperty(KEY_CODETYPE);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ee3\u7801\u7c7b\u578b\u4e3a\u3010%s\u3011\uff0c\u7136\u540e\u518d\u9009\u62e9\u63d2\u4ef6\u811a\u672c\u3002", (String)"DynPluginTScriptEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), prop.getItemByName(CODETYPE_KINGSCRIPT)));
            return;
        }
        String className = (String)this.getModel().getValue(KEY_CLASSNAME_TS);
        if (StringUtils.isBlank((CharSequence)className)) {
            this.openSelectTSForm("");
            return;
        }
        QFilter filter = new QFilter("classname", "=", (Object)className);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"id", (QFilter[])new QFilter[]{filter});
        if (objs == null || objs.length == 0) {
            this.openSelectTSForm("");
        } else {
            this.openSelectTSForm((String)objs[0].getPkValue());
        }
    }

    private void openSelectTSForm(String scriptId) {
        String bizAppId;
        String client;
        String interfacetype;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"DynPluginTScriptEdit_1", (String)BOS_DESIGNER_PLUGIN).getLocaleValue());
        parameter.setFormId("ide_select_ts_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPTYPE_SELECT_TS));
        parameter.setCustomParam("engineType", (Object)"1");
        parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(this.packagePlugins(scriptId)));
        String string = interfacetype = this.getModel().getValue(KEY_INTERFACETYPE) == null ? "" : (String)this.getModel().getValue(KEY_INTERFACETYPE);
        if (StringUtils.isEmpty((CharSequence)interfacetype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u63a5\u53e3\u7c7b\u578b\u3002", (String)"DynPluginTScriptEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String string2 = client = this.getModel().getValue(KEY_CLIENT) == null ? "" : (String)this.getModel().getValue(KEY_CLIENT);
        if (StringUtils.isEmpty((CharSequence)client) && !CODETYPE_KINGSCRIPT.equals(interfacetype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6236\u7aef\u3002", (String)"DynPluginTScriptEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if ("1".equals(interfacetype)) {
            if ("2".equals(client)) {
                parameter.setCustomParam("modelType", (Object)"MobileFormModel");
            } else {
                parameter.setCustomParam("modelType", (Object)"DynamicFormModel");
            }
        } else if ("2".equals(interfacetype)) {
            if ("2".equals(client)) {
                parameter.setCustomParam("modelType", (Object)"MobileBillFormModel");
            } else {
                parameter.setCustomParam("modelType", (Object)"BillFormModel");
            }
        } else if ("3".equals(interfacetype)) {
            if ("2".equals(client)) {
                parameter.setCustomParam("modelType", (Object)"MobileListModel");
            } else {
                parameter.setCustomParam("modelType", (Object)"BillFormModel");
                parameter.setCustomParam("designerPageId", (Object)this.getView().getPageId());
                this.getPageCache().put("designer", "ListMeta");
            }
        } else if (CODETYPE_KINGSCRIPT.equals(interfacetype)) {
            parameter.setCustomParam("scripttypefilter", (Object)"operate");
        }
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_BIZAPP);
        String string3 = bizAppId = bizApp == null ? "" : (String)bizApp.getPkValue();
        if (!StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"DynPluginTScriptEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        this.getView().showForm(parameter);
    }

    private void afterSelectTs(List<Map<String, Object>> plugins) {
        if (plugins == null || plugins.isEmpty()) {
            return;
        }
        for (Map<String, Object> plugin : plugins) {
            String className = (String)plugin.get(RETURN_PLUGIN_CLASS_NAME);
            if (!StringUtils.isNotBlank((CharSequence)className)) continue;
            this.getModel().setValue(KEY_CLASSNAME_TS, (Object)className);
            this.getModel().setValue(KEY_CLASSNAME, (Object)className);
            break;
        }
    }

    private List<Map<String, Object>> packagePlugins(String scriptId) {
        ArrayList<Map<String, Object>> newPlugins = new ArrayList<Map<String, Object>>(1);
        HashMap<String, Object> mapPlugin = new HashMap<String, Object>(16);
        mapPlugin.put("rowKey", 0);
        mapPlugin.put("FPK", scriptId);
        mapPlugin.put(RETURN_PLUGIN_CLASS_NAME, this.getModel().getValue(KEY_CLASSNAME_TS));
        mapPlugin.put(RETURN_PLUGIN_DESCRIPTION_NAME, "");
        mapPlugin.put("DisplayName", "");
        newPlugins.add(mapPlugin);
        return newPlugins;
    }
}

