/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;

public class CompareDatePlugin
extends AbstractFuncParamPlugIn {
    private static final String KEY_DATE_1 = "date1";
    private static final String KEY_DATE_2 = "date2";
    private static final String KEY_RADIO_GROUP_DATE = "radiogroupdate";
    private static final String KEY_RADIO_GROUP_SIGN = "radiogroupsign";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_DATE_1, KEY_DATE_2});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_DATE_1)) {
            this.showSelectFieldForm(KEY_DATE_1);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_DATE_2)) {
            this.showSelectFieldForm(KEY_DATE_2);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_DATE_1)) {
            this.getModel().setValue(KEY_DATE_1, closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_DATE_2)) {
            this.getModel().setValue(KEY_DATE_2, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String date1 = (String)this.getModel().getValue(KEY_DATE_1);
        String date2 = (String)this.getModel().getValue(KEY_DATE_2);
        if (StringUtils.isBlank((CharSequence)date1) && StringUtils.isBlank((CharSequence)date2)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u4e00\u3001\u65e5\u671f\u4e8c\u3002", (String)"CompareDatePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)date1)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u4e00\u3002", (String)"CompareDatePlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)date2)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u4e8c\u3002", (String)"CompareDatePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String getSetting() {
        String date1 = (String)this.getModel().getValue(KEY_DATE_1);
        String date2 = (String)this.getModel().getValue(KEY_DATE_2);
        String paramDateId = (String)this.getModel().getValue(KEY_RADIO_GROUP_DATE);
        String paramSignId = (String)this.getModel().getValue(KEY_RADIO_GROUP_SIGN);
        String setting = String.format("%s(%s, %s, '%s') %s 0", this.getFuncId(), date1, date2, paramDateId, paramSignId);
        return setting;
    }

    private void showSelectFieldForm(String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        TreeNode fieldNodes = this.getVarNodes();
        String nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

