/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.func.AbstractFuncParamPlugIn;

public class ConvertTimeByStringPlugin
extends AbstractFuncParamPlugIn {
    private static final String KEY_DATE_TIME = "datetime";

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String dateTimeString = (String)this.getModel().getValue(KEY_DATE_TIME);
        if (StringUtils.isBlank((CharSequence)dateTimeString)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u6570\u9879\u3002", (String)"ConvertTimeByStringPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.validateFormat(dateTimeString)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\uff0c\u683c\u5f0f\u652f\u6301yyyy-M-d\u6216\u8005yyyy/MM/dd\u3002", (String)"ConvertTimeByStringPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateFormat(String dateTime) {
        String reg = "^\\d{4}(\\-|\\/|\\.)\\d{1,2}\\1\\d{1,2}$";
        Pattern pattern = Pattern.compile(reg);
        Matcher mat = pattern.matcher(dateTime);
        return mat.matches();
    }

    public String getSetting() {
        String dateTimeString = (String)this.getModel().getValue(KEY_DATE_TIME);
        return String.format("%s('%s')", this.getFuncId(), dateTimeString);
    }
}

