/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.fielddefvalue.AbstractDefValueParamPlugIn;
import kd.bos.metadata.entity.fielddefvalue.DateTimeDefValue;
import kd.bos.service.InteTimeZone;

public class DateTimeDefValueParamPlugIn
extends AbstractDefValueParamPlugIn {
    private static Log log = LogFactory.getLog(DateTimeDefValueParamPlugIn.class);
    private static final String KEY_TIME_ZONE = "intetimezone";
    private static final String KEY_DATETIME = "datetime";
    private static final String KEY_FORMAT_STRING = "formatstring";

    public boolean check(StringBuilder sBuilder) {
        String datetime = (String)this.getModel().getValue(KEY_DATETIME);
        if (StringUtils.isBlank((CharSequence)datetime)) {
            sBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u65f6\u95f4\u3002", (String)"DateTimeDefValueParamPlugIn_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("formLayoutScheme"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap", KEY_DATETIME});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"datetimefield"});
            String datetimeStr = String.valueOf(this.getModel().getValue(KEY_DATETIME));
            String fmtStr = String.valueOf(this.getModel().getValue(KEY_FORMAT_STRING));
            if (StringUtils.isNotBlank((CharSequence)datetimeStr) && StringUtils.isNotBlank((CharSequence)fmtStr)) {
                try {
                    Date d = new SimpleDateFormat(fmtStr).parse(fmtStr);
                    this.getModel().setValue(KEY_DATETIME, (Object)d);
                }
                catch (ParseException err) {
                    log.error((Throwable)err);
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"datetimefield"});
        }
    }

    public String returnParameter() {
        DateTimeDefValue defValue = new DateTimeDefValue();
        DynamicObject timeZone = (DynamicObject)this.getModel().getValue(KEY_TIME_ZONE);
        if (timeZone == null) {
            timeZone = InteTimeZone.getSysTimeZone().getInfo();
        }
        defValue.setTimeZone(timeZone.getString(((BillEntityType)timeZone.getDataEntityType()).getBillNo()));
        defValue.setDateString((String)this.getModel().getValue(KEY_DATETIME));
        defValue.setFormartString((String)this.getModel().getValue(KEY_FORMAT_STRING));
        return SerializationUtils.toJsonString((Object)defValue);
    }

    protected void showParameter(String e) {
        DateTimeDefValue defValue = null;
        defValue = StringUtils.isBlank((CharSequence)e) ? new DateTimeDefValue() : (DateTimeDefValue)SerializationUtils.fromJsonString((String)e, DateTimeDefValue.class);
        this.getModel().setValue(KEY_DATETIME, (Object)defValue.getDateString());
        this.getModel().setValue(KEY_FORMAT_STRING, (Object)defValue.getFormartString());
        this.getModel().setItemValueByNumber(KEY_TIME_ZONE, defValue.getTimeZone(), 0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("datetimefield".equals(e.getProperty().getName())) {
            for (ChangeData data : e.getChangeSet()) {
                if (data.getNewValue() instanceof Date) {
                    String fmtStr;
                    DynamicObject timeZone = (DynamicObject)this.getModel().getValue(KEY_TIME_ZONE);
                    if (timeZone == null) {
                        timeZone = InteTimeZone.getSysTimeZone().getInfo();
                    }
                    if (StringUtils.isBlank((CharSequence)(fmtStr = (String)this.getModel().getValue(KEY_FORMAT_STRING)))) {
                        fmtStr = "yyyy-MM-dd HH:mm:ss";
                        this.getModel().setValue(KEY_FORMAT_STRING, (Object)fmtStr);
                    }
                    String num = timeZone.getString(((BillEntityType)timeZone.getDataEntityType()).getBillNo());
                    SimpleDateFormat sdf = new SimpleDateFormat(fmtStr);
                    sdf.setTimeZone(TimeZone.getTimeZone(num));
                    this.getModel().setValue(KEY_DATETIME, (Object)sdf.format((Date)data.getNewValue()));
                    continue;
                }
                if (data.getNewValue() != null) continue;
                this.getModel().setValue(KEY_DATETIME, null);
            }
        }
    }
}

