/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.util.EventObject;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;

public class ExchangeRateQueryPlugin
extends AbstractFuncParamPlugIn {
    private static final String ORIGINAL_CURRENCY = "originalcurrency";
    private static final String TARGET_CURRENCY = "targetcurrency";
    private static final String EXCHANGE_RATE_TYPE = "exchangeratetype";
    private static final String CONVERSION_DATE = "conversiondate";
    private static final String QUOTE_TYPE = "quotetype";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{ORIGINAL_CURRENCY, TARGET_CURRENCY, EXCHANGE_RATE_TYPE, CONVERSION_DATE, QUOTE_TYPE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey().toLowerCase();
        this.showSelectFieldForm(key);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String key = closedCallBackEvent.getActionId().toLowerCase();
        this.getModel().setValue(key, closedCallBackEvent.getReturnData());
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        boolean result;
        String originalCurrency = (String)this.getModel().getValue(ORIGINAL_CURRENCY);
        String targetCurrency = (String)this.getModel().getValue(TARGET_CURRENCY);
        String exchangeRateType = (String)this.getModel().getValue(EXCHANGE_RATE_TYPE);
        String conversionDate = (String)this.getModel().getValue(CONVERSION_DATE);
        String quoteType = (String)this.getModel().getValue(QUOTE_TYPE);
        boolean bl = result = StringUtils.isNotBlank((CharSequence)originalCurrency) && StringUtils.isNotBlank((CharSequence)targetCurrency) && StringUtils.isNotBlank((CharSequence)exchangeRateType) && StringUtils.isNotBlank((CharSequence)conversionDate);
        if (!result) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u6570\u9879\u3002", (String)"ExchangeRateQueryPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]);
            msgBuilder.append(errMsg);
        }
        return result;
    }

    public String getSetting() {
        String originalCurrency = (String)this.getModel().getValue(ORIGINAL_CURRENCY);
        String targetCurrency = (String)this.getModel().getValue(TARGET_CURRENCY);
        String exchangeRateType = (String)this.getModel().getValue(EXCHANGE_RATE_TYPE);
        String conversionDate = (String)this.getModel().getValue(CONVERSION_DATE);
        String quoteType = (String)this.getModel().getValue(QUOTE_TYPE);
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        joiner.add(originalCurrency).add(targetCurrency).add(exchangeRateType).add(conversionDate);
        if (StringUtils.isNotBlank((CharSequence)quoteType)) {
            joiner.add(quoteType);
        }
        return this.getFuncId() + joiner.toString();
    }

    private void showSelectFieldForm(String sourceCtrlKey) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        TreeNode fieldNodes = this.getVarNodes();
        String nodesJson = "";
        if (fieldNodes != null) {
            nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        }
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

