/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;

public class GetConvertTypePlugin
extends AbstractFuncParamPlugIn {
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_SRC_UNIT = "srcunit";
    private static final String KEY_DIST_UNIT = "distunit";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_MATERIAL, KEY_SRC_UNIT, KEY_DIST_UNIT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_MATERIAL)) {
            this.showSelectFieldForm(KEY_MATERIAL);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_SRC_UNIT)) {
            this.showSelectFieldForm(KEY_SRC_UNIT);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_DIST_UNIT)) {
            this.showSelectFieldForm(KEY_DIST_UNIT);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_MATERIAL)) {
            this.getModel().setValue(KEY_MATERIAL, closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_SRC_UNIT)) {
            this.getModel().setValue(KEY_SRC_UNIT, closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_DIST_UNIT)) {
            this.getModel().setValue(KEY_DIST_UNIT, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        boolean result;
        String material = (String)this.getModel().getValue(KEY_MATERIAL);
        String srcUnit = (String)this.getModel().getValue(KEY_SRC_UNIT);
        String distUnit = (String)this.getModel().getValue(KEY_DIST_UNIT);
        boolean bl = result = StringUtils.isNotBlank((CharSequence)material) && StringUtils.isNotBlank((CharSequence)srcUnit) && StringUtils.isNotBlank((CharSequence)distUnit);
        if (!result) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u6570\u9879\u3002", (String)"GetConvertTypePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]);
            msgBuilder.append(errMsg);
        }
        return result;
    }

    public String getSetting() {
        String material = (String)this.getModel().getValue(KEY_MATERIAL);
        String srcUnit = (String)this.getModel().getValue(KEY_SRC_UNIT);
        String distUnit = (String)this.getModel().getValue(KEY_DIST_UNIT);
        return String.format("%s(%s, %s, %s)", this.getFuncId(), material, srcUnit, distUnit);
    }

    private void showSelectFieldForm(String sourceCtrlKey) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        TreeNode fieldNodes = this.getVarNodes();
        String nodesJson = "";
        if (fieldNodes != null) {
            nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        }
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

