/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;

public class GetFieldValuePlugin
extends AbstractFuncParamPlugIn {
    private static final String KEY_ENTITY_NUMBER = "entitynumber";
    private static final String KEY_PROPERTY_NAME = "propertyname";
    private static final String KEY_PROPERTY_NAME_DESC = "propertynamedesc";
    private static final String KEY_FILTER_PROP_DESC = "filterpropdesc";
    private static final String KEY_FILTER_PROP_NAME = "filterpropname";
    private static final String KEY_VALUE_TYPE = "valuetype";
    private static final String KEY_FILTER_VALUE_DESC = "filtervaluedesc";
    private static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String VALUETYPE_VARABLE = "variable";
    private static final String VALUETYPE_CONST = "const";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String NUMBER = "number";
    private static final String FIELD = "field";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_PROPERTY_NAME_DESC, KEY_FILTER_PROP_DESC, KEY_FILTER_VALUE_DESC});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_ENTITY_NUMBER)) {
            this.getModel().setValue(KEY_PROPERTY_NAME, null);
            this.getModel().setValue(KEY_PROPERTY_NAME_DESC, null);
            this.getModel().setValue(KEY_FILTER_PROP_NAME, null);
            this.getModel().setValue(KEY_FILTER_PROP_DESC, null);
            this.getModel().setValue(KEY_FILTER_VALUE, null);
            this.getModel().setValue(KEY_FILTER_VALUE_DESC, null);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_PROPERTY_NAME_DESC)) {
            if (StringUtils.isBlank((Object)this.getModel().getValue(KEY_PROPERTY_NAME_DESC))) {
                this.getModel().setValue(KEY_PROPERTY_NAME, null);
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_FILTER_PROP_DESC)) {
            if (StringUtils.isBlank((Object)this.getModel().getValue(KEY_FILTER_PROP_DESC))) {
                this.getModel().setValue(KEY_FILTER_PROP_NAME, null);
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_VALUE_TYPE)) {
            this.getModel().setValue(KEY_FILTER_VALUE, null);
            this.getModel().setValue(KEY_FILTER_VALUE_DESC, null);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_FILTER_VALUE_DESC)) {
            this.getModel().setValue(KEY_FILTER_VALUE, this.getModel().getValue(KEY_FILTER_VALUE_DESC));
        }
    }

    public void click(EventObject evt) {
        String key;
        FieldEdit edit = (FieldEdit)evt.getSource();
        switch (key = edit.getFieldKey()) {
            case "propertynamedesc": {
                this.doClickPropName(KEY_PROPERTY_NAME);
                break;
            }
            case "filterpropdesc": {
                this.doClickPropName(KEY_FILTER_PROP_NAME);
                break;
            }
            case "filtervaluedesc": {
                this.doClickFilterValue();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        switch (actionId) {
            case "propertyname": {
                Map retDataMap = (Map)retData;
                this.getModel().setValue(KEY_PROPERTY_NAME_DESC, retDataMap.get("text"));
                this.getModel().setValue(KEY_PROPERTY_NAME, retDataMap.get("id"));
                break;
            }
            case "filterpropname": {
                Map retDataMap = (Map)retData;
                this.getModel().setValue(KEY_FILTER_PROP_DESC, retDataMap.get("text"));
                this.getModel().setValue(KEY_FILTER_PROP_NAME, retDataMap.get("id"));
                break;
            }
            case "filtervalue": {
                this.receiveFilterValue(retData);
                break;
            }
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        DynamicObject entity = (DynamicObject)this.getModel().getValue(KEY_ENTITY_NUMBER);
        String propertyName = (String)this.getModel().getValue(KEY_PROPERTY_NAME);
        String filterPropName = (String)this.getModel().getValue(KEY_FILTER_PROP_NAME);
        String valueType = (String)this.getModel().getValue(KEY_VALUE_TYPE);
        String filterValue = (String)this.getModel().getValue(KEY_FILTER_VALUE);
        if (entity == null || StringUtils.isBlank((CharSequence)propertyName) || StringUtils.isBlank((CharSequence)filterPropName) || StringUtils.isBlank((CharSequence)valueType) || StringUtils.isBlank((CharSequence)filterValue)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u6570\u9879\u3002", (String)"GetFieldValuePlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String getSetting() {
        DynamicObject entity = (DynamicObject)this.getModel().getValue(KEY_ENTITY_NUMBER);
        String entityNumber = entity.getString(NUMBER);
        String propertyName = (String)this.getModel().getValue(KEY_PROPERTY_NAME);
        String filterPropName = (String)this.getModel().getValue(KEY_FILTER_PROP_NAME);
        String filterValue = (String)this.getModel().getValue(KEY_FILTER_VALUE);
        String format = this.isVarableValueType() ? "%s('%s', '%s', '%s', %s)" : "%s('%s', '%s', '%s', '%s')";
        return String.format(format, this.getFuncId(), entityNumber, propertyName, filterPropName, filterValue);
    }

    private void doClickFilterValue() {
        if (this.isVarableValueType()) {
            Object entityItems = this.getView().getFormShowParameter().getCustomParam("entityItems");
            Object entityNumber = this.getView().getFormShowParameter().getCustomParam(KEY_ENTITY_NUMBER);
            if (entityItems == null && entityNumber == null) {
                return;
            }
            if (entityNumber == null) {
                List entityItemsMap = (List)entityItems;
                entityNumber = (String)((Map)entityItemsMap.get(0)).get("Key");
            }
            TreeNode fieldNodes = this.getVarNodes();
            String nodesJson = "";
            if (fieldNodes != null) {
                nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
            }
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, KEY_FILTER_VALUE);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ide_fieldselect");
            showParameter.setCloseCallBack(cb);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put("treenodes", nodesJson);
            showParameter.getCustomParams().put(FIELD, this.getModel().getValue(KEY_FILTER_PROP_NAME));
            showParameter.getCustomParams().put(KEY_ENTITY_NUMBER, entityNumber);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"id", (CharSequence)((String)this.getModel().getValue(KEY_FILTER_PROP_NAME)))) {
            DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_ENTITY_NUMBER);
            if (objectType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"GetFieldValuePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String entityNumber = objectType.getString(NUMBER);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FILTER_VALUE);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u624b\u5de5\u5f55\u5165\u5e38\u91cf\u503c\u3002", (String)"GetFieldValuePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
    }

    private void receiveFilterValue(Object returnData) {
        ListSelectedRowCollection rows;
        if (this.isVarableValueType()) {
            Map retDataMap = (Map)returnData;
            this.getModel().setValue(KEY_FILTER_VALUE_DESC, retDataMap.get("text"));
            this.getModel().setValue(KEY_FILTER_VALUE, retDataMap.get("id"));
        } else if (StringUtils.equals((CharSequence)"id", (CharSequence)((String)this.getModel().getValue(KEY_FILTER_PROP_NAME))) && (rows = (ListSelectedRowCollection)returnData) != null && !rows.isEmpty()) {
            String text = rows.get(0).getPrimaryKeyValue().toString();
            if (StringUtils.isNotBlank((CharSequence)rows.get(0).getName())) {
                text = rows.get(0).getName();
            } else if (StringUtils.isNotBlank((CharSequence)rows.get(0).getNumber())) {
                text = rows.get(0).getNumber();
            } else if (StringUtils.isNotBlank((CharSequence)rows.get(0).getBillNo())) {
                text = rows.get(0).getBillNo();
            }
            this.getModel().setValue(KEY_FILTER_VALUE_DESC, (Object)text);
            this.getModel().setValue(KEY_FILTER_VALUE, rows.get(0).getPrimaryKeyValue());
        }
    }

    private void doClickPropName(String clickProp) {
        DynamicObject entity = (DynamicObject)this.getModel().getValue(KEY_ENTITY_NUMBER);
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"GetFieldValuePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String entityNumber = entity.getString(NUMBER);
        CloseCallBack cb = new CloseCallBack((IFormPlugin)this, clickProp);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_fieldselect");
        showParameter.setCloseCallBack(cb);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("formId", entityNumber);
        showParameter.getCustomParams().put(FIELD, this.getModel().getValue(clickProp));
        this.getView().showForm(showParameter);
    }

    private boolean isVarableValueType() {
        String type = (String)this.getModel().getValue(KEY_VALUE_TYPE);
        return StringUtils.equals((CharSequence)VALUETYPE_VARABLE, (CharSequence)type);
    }

    private String getReadEntityNumber() {
        DynamicObject entity = (DynamicObject)this.getModel().getValue(KEY_ENTITY_NUMBER);
        if (entity != null) {
            return entity.getString(NUMBER);
        }
        return null;
    }
}

