/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.servicehelper.org.OrgServiceHelper;

public class GetRelationOrgPlugin
extends AbstractFuncParamPlugIn {
    private static final String KEY_ORG_FIELD = "orgfield";
    private static final String KEY_DIRECTION = "direction";
    private static final String KEY_RELATION_TYPE = "relationtype";
    private static final String CACHE_KEY_RELATION_TYPES = "relationtypes";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String orgField = (String)this.getModel().getValue(KEY_ORG_FIELD);
        String direction = (String)this.getModel().getValue(KEY_DIRECTION);
        String relationtypes = (String)this.getModel().getValue(KEY_RELATION_TYPE);
        boolean pass = true;
        if (StringUtils.isBlank((CharSequence)orgField)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7ec4\u7ec7\u5b57\u6bb5", (String)"GetRelationOrgPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).append("\r\n");
        }
        if (StringUtils.isBlank((CharSequence)direction)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u65b9\u5411", (String)"GetRelationOrgPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).append("\r\n");
        }
        if (StringUtils.isBlank((CharSequence)relationtypes)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u4e1a\u52a1", (String)"GetRelationOrgPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).append("\r\n");
        }
        return pass && super.checkSetting(msgBuilder) != false;
    }

    public String getSetting() {
        String orgField = (String)this.getModel().getValue(KEY_ORG_FIELD);
        String direction = (String)this.getModel().getValue(KEY_DIRECTION);
        String relationtype = (String)this.getModel().getValue(KEY_RELATION_TYPE);
        String formViewType = "";
        String toViewType = "";
        List<Map<String, String>> orgRelationTypes = this.getOrgRelationTypes();
        for (Map<String, String> relaType : orgRelationTypes) {
            String number = relaType.get("number");
            if (!StringUtils.equalsIgnoreCase((CharSequence)relationtype, (CharSequence)number)) continue;
            formViewType = relaType.get("fromtype");
            toViewType = relaType.get("totype");
            break;
        }
        if (formViewType == null) {
            formViewType = "";
        }
        if (toViewType == null) {
            toViewType = "";
        }
        return String.format("GetRelationOrg(%s, '%s', '%s', '%s')", orgField, direction, formViewType, toViewType);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit bizType = (ComboEdit)this.getView().getControl(KEY_RELATION_TYPE);
        bizType.setComboItems(this.buildBizTypes());
        ComboEdit orgField = (ComboEdit)this.getView().getControl(KEY_ORG_FIELD);
        orgField.setComboItems(this.buildOrgFieldItems());
    }

    private List<ComboItem> buildOrgFieldItems() {
        MainOrgProp mainOrgProp;
        String srcEntityNumber = this.getEntityNumber();
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        String mainOrg = null;
        if (StringUtils.isNotBlank((CharSequence)srcMainType.getMainOrg()) && (mainOrgProp = (MainOrgProp)srcMainType.findProperty(srcMainType.getMainOrg())) != null) {
            mainOrg = mainOrgProp.getName();
            ComboItem item = new ComboItem(mainOrgProp.getDisplayName(), mainOrgProp.getName());
            items.add(item);
        }
        for (IDataEntityProperty property : srcMainType.getProperties()) {
            if (!(property instanceof OrgProp) || StringUtils.equalsIgnoreCase((CharSequence)mainOrg, (CharSequence)property.getName())) continue;
            ComboItem item = new ComboItem(((OrgProp)property).getDisplayName(), property.getName());
            items.add(item);
        }
        return items;
    }

    private List<ComboItem> buildBizTypes() {
        List<Map<String, String>> orgRelationTypes = this.getOrgRelationTypes();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Map<String, String> orgRelationType : orgRelationTypes) {
            String id = orgRelationType.get("number");
            String name = orgRelationType.get("name");
            ComboItem item = new ComboItem(new LocaleString(name), id);
            items.add(item);
        }
        return items;
    }

    private List<Map<String, String>> getOrgRelationTypes() {
        String cacheValue = this.getPageCache().get(CACHE_KEY_RELATION_TYPES);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            return (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
        }
        List orgRelationTypes = OrgServiceHelper.getAllOrgRelationType();
        cacheValue = SerializationUtils.toJsonString((Object)orgRelationTypes);
        this.getPageCache().put(CACHE_KEY_RELATION_TYPES, cacheValue);
        return orgRelationTypes;
    }
}

