/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class GetSysParamPlugIn
extends AbstractFuncParamPlugIn {
    private static final String KEY_PARAM_TYPE = "paramtype";
    private static final String KEY_ORG_ID = "orgid";
    private static final String KEY_ACCT_BOOK_ID = "acctbookid";
    private static final String KEY_BIZ_CLOUD_ID = "bizcloudid";
    private static final String KEY_BIZ_APP_ID = "bizappid";
    private static final String KEY_VIEW_TYPE = "viewtype";
    private static final String KEY_PARAM_KEY = "key";
    private static final String DEF_VIEW_TYPE = "def";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_ORG_ID, KEY_ACCT_BOOK_ID});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(KEY_VIEW_TYPE, (Object)DEF_VIEW_TYPE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillViewType();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_ORG_ID)) {
            this.showSelectFieldForm(KEY_ORG_ID);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_ACCT_BOOK_ID)) {
            this.showSelectFieldForm(KEY_ACCT_BOOK_ID);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_ORG_ID)) {
            this.getModel().setValue(KEY_ORG_ID, closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_ACCT_BOOK_ID)) {
            this.getModel().setValue(KEY_ACCT_BOOK_ID, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String paramKey = (String)this.getModel().getValue(KEY_PARAM_KEY);
        if (StringUtils.isBlank((CharSequence)paramKey)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u6570\u9879\u3002", (String)"GetSysParamPlugIn_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String getSetting() {
        String acctBookId;
        String viewType;
        String orgId = (String)this.getModel().getValue(KEY_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = "0";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DEF_VIEW_TYPE, (CharSequence)(viewType = (String)this.getModel().getValue(KEY_VIEW_TYPE)))) {
            viewType = "";
        }
        if (StringUtils.isBlank((CharSequence)(acctBookId = (String)this.getModel().getValue(KEY_ACCT_BOOK_ID)))) {
            acctBookId = "0";
        }
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_BIZ_APP_ID);
        DynamicObject bizCloud = (DynamicObject)this.getModel().getValue(KEY_BIZ_CLOUD_ID);
        String bizCloudId = bizCloud == null ? "" : (String)bizCloud.getPkValue();
        String bizAppId = bizApp == null ? "" : (String)bizApp.getPkValue();
        String paramKey = (String)this.getModel().getValue(KEY_PARAM_KEY);
        String paramType = (String)this.getModel().getValue(KEY_PARAM_TYPE);
        if (StringUtils.isBlank((CharSequence)paramType)) {
            paramType = "0";
        }
        String setting = "";
        if (StringUtils.equals((CharSequence)"0", (CharSequence)paramType)) {
            setting = String.format("%s('%s')", this.getFuncId(), paramKey);
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)paramType)) {
            setting = String.format("%s('%s', '%s')", this.getFuncId(), bizCloudId, paramKey);
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)paramType)) {
            setting = String.format("%s('%s', '%s', %s, %s, '%s')", this.getFuncId(), bizAppId, viewType, orgId, acctBookId, paramKey);
        }
        return setting;
    }

    private void showSelectFieldForm(String sourceCtrlKey) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        TreeNode fieldNodes = this.getVarNodes();
        String nodesJson = "";
        if (fieldNodes != null) {
            nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        }
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("entitynumber", (Object)entityNumber);
        this.getView().showForm(showParameter);
    }

    private void fillViewType() {
        ArrayList<ComboItem> viewTypeItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue(DEF_VIEW_TYPE);
        blankItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4e1a\u52a1\u5e94\u7528\u7684\u804c\u80fd\u7c7b\u578b", (String)"GetSysParamPlugIn_1", (String)"bos-designer-plugin", (Object[])new Object[0])));
        viewTypeItems.add(blankItem);
        List listMap = OrgUnitServiceHelper.getOrgBizSelectorList();
        if (listMap != null && !listMap.isEmpty()) {
            for (Map map : listMap) {
                for (Map.Entry entry : map.entrySet()) {
                    ComboItem item = new ComboItem();
                    item.setValue((String)entry.getKey());
                    item.setCaption(new LocaleString((String)entry.getValue()));
                    viewTypeItems.add(item);
                }
            }
        }
        ComboEdit viewTypeEditor = (ComboEdit)this.getView().getControl(KEY_VIEW_TYPE);
        viewTypeEditor.setComboItems(viewTypeItems);
    }
}

