/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.func;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.TimeServiceHelper;

public class ToDatePlugin
extends AbstractFuncParamPlugIn {
    private static final String KEY_TIME_ZONE = "intetimezone";
    private static final String KEY_DATETIME = "datetime";
    private static final String KEY_FORMAT_STRING = "formatstring";
    private static final String KEY_BTN_NOW = "btnnow";
    private static final String KEY_BTN_TODAY = "btntoday";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_NOW, KEY_BTN_TODAY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("formLayoutScheme"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"datetimefield"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        IDataModel model = this.getModel();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_BTN_NOW)) {
            DynamicObject timezone = (DynamicObject)model.getValue(KEY_TIME_ZONE);
            InteTimeZone inteTimeZone = null;
            inteTimeZone = timezone == null ? KDDateUtils.getInteSysTimeZone() : new InteTimeZone(timezone);
            String formatStr = TimeServiceHelper.getDateTimeFormatString();
            model.setValue(KEY_DATETIME, (Object)inteTimeZone.format(TimeServiceHelper.now(), (DateFormat)new SimpleDateFormat(formatStr)));
            model.setValue(KEY_FORMAT_STRING, (Object)formatStr);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_BTN_TODAY)) {
            model.setValue(KEY_DATETIME, (Object)TimeServiceHelper.formatToday());
            model.setValue(KEY_FORMAT_STRING, (Object)TimeServiceHelper.getDateFormatString());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String datetime = (String)this.getModel().getValue(KEY_DATETIME);
        String formatstring = (String)this.getModel().getValue(KEY_FORMAT_STRING);
        if (StringUtils.isBlank((CharSequence)datetime)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u65f6\u95f4\u3002", (String)"ToDatePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getModel().setValue("defaultvalue", (Object)("TO_DATE" + this.getSetting()));
    }

    public String getSetting() {
        String datetime = (String)this.getModel().getValue(KEY_DATETIME);
        String formatstring = (String)this.getModel().getValue(KEY_FORMAT_STRING);
        DynamicObject timeZone = (DynamicObject)this.getModel().getValue(KEY_TIME_ZONE);
        if (timeZone == null) {
            timeZone = InteTimeZone.getSysTimeZone().getInfo();
        }
        String setting = String.format("%s('%s', '%s', '%s')", this.getFuncId(), datetime, formatstring, timeZone.getString(((BillEntityType)timeZone.getDataEntityType()).getBillNo()));
        return setting;
    }
}

