/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.meta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.utils.LocaleBuildUtils;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DomainXmlTranPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_URL = "url";
    private static final String KEY_FILENAME = "filename";
    private static final Log log = LogFactory.getLog(DomainXmlTranPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = (Map)this.getView().getFormShowParameter().getCustomParams().get("files");
        if (params == null) {
            this.getView().showErrorNotification("file error");
            return;
        }
        if (params.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, params.size());
        int i = 0;
        for (Map.Entry it : params.entrySet()) {
            this.getModel().setValue(KEY_FILENAME, it.getKey(), i);
            this.getModel().setValue(KEY_URL, it.getValue(), i);
            ++i;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        ArrayList<String> urls = new ArrayList<String>(10);
        switch (key) {
            case "trans": {
                urls.addAll(this.doTrans());
                break;
            }
            case "transall": {
                urls.addAll(this.doTransAll());
                break;
            }
            case "restore": {
                urls.addAll(this.doRestore());
                break;
            }
            case "restoreall": {
                urls.addAll(this.doRestoreAll());
            }
        }
        if (!urls.isEmpty()) {
            this.getView().download(tempFileCache.compress("trans_" + System.currentTimeMillis() + ".zip", urls.toArray(new String[0]), 600));
        }
    }

    private List<String> doRestore() {
        ArrayList<String> urls = new ArrayList<String>(10);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int row = entryGrid.getEntryState().getFocusRow();
        if (this.checkRowData(this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, row))) {
            try {
                String fileName = (String)this.getModel().getValue(KEY_FILENAME, row);
                String tmpUrl = (String)this.getModel().getValue(KEY_URL, row);
                SAXReader reader = LocaleBuildUtils.getSaxReader();
                Document document = reader.read(tempFileCache.getInputStream(tmpUrl));
                LocaleBuildUtils.replaceLocaleVars((String)fileName, (Document)document, (String)Lang.zh_CN.toString());
                File tempFile = DomainXmlTranPlugin.writeXML(fileName, document);
                try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                    urls.add(tempFileCache.saveAsUrl(fileName, (InputStream)fileInputStream, 180));
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format("read %s file failed, please check the file and try again", this.getModel().getValue(KEY_FILENAME, row)));
            }
        }
        return urls;
    }

    private static File writeXML(String fileName, Document doc) {
        File file = null;
        try {
            fileName = fileName.split("\\.")[0];
            String filePath = DomainXmlTranPlugin.getDictDir() + File.separatorChar + fileName + ".xml";
            file = new File(filePath);
            file.deleteOnExit();
            file.createNewFile();
            OutputStreamWriter osWrite = new OutputStreamWriter(new FileOutputStream(file));
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            format.setIndent(true);
            format.setNewlines(true);
            XMLWriter writer = new XMLWriter((Writer)osWrite, format);
            writer.write(doc);
            writer.flush();
            writer.close();
            ((Writer)osWrite).close();
            System.out.println("modelXML:" + filePath);
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (file != null) {
                file.deleteOnExit();
            }
        }
    }

    private static String getDictDir() {
        File file;
        String dir = System.getProperty("java.io.tmpdir");
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(file = new File(dir = dir + "domaintrans")).exists()) {
            file.mkdirs();
        }
        return dir;
    }

    private List<String> doRestoreAll() {
        ArrayList<String> urls = new ArrayList<String>(10);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        int count = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int i = 0;
        boolean success = true;
        ArrayList<String> errorMsg = new ArrayList<String>(10);
        while (i < count && success) {
            if (this.checkRowData(this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, i))) {
                String tmpUrl = (String)this.getModel().getValue(KEY_URL, i);
                String fileName = (String)this.getModel().getValue(KEY_FILENAME, i);
                try {
                    SAXReader reader = LocaleBuildUtils.getSaxReader();
                    Document document = reader.read(tempFileCache.getInputStream(tmpUrl));
                    LocaleBuildUtils.replaceLocaleVars((String)fileName, (Document)document, (String)Lang.zh_CN.toString());
                    File tempFile = DomainXmlTranPlugin.writeXML(fileName, document);
                    try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                        urls.add(tempFileCache.saveAsUrl(fileName, (InputStream)fileInputStream, 180));
                    }
                }
                catch (Exception e) {
                    errorMsg.add(String.format("Translation %s file failed, please check the file and try again", this.getModel().getValue(KEY_FILENAME, i)));
                }
                ++i;
                continue;
            }
            success = false;
        }
        if (!errorMsg.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)"\u3001", errorMsg));
        }
        return urls;
    }

    private List<String> doTrans() {
        ArrayList<String> urls = new ArrayList<String>(10);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int row = entryGrid.getEntryState().getFocusRow();
        if (this.checkRowData(this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, row))) {
            String tmpUrl = (String)this.getModel().getValue(KEY_URL, row);
            urls.addAll(LocaleBuildUtils.buildXmlAndProperties((String)((String)this.getModel().getValue(KEY_FILENAME)), (InputStream)tempFileCache.getInputStream(tmpUrl)));
        }
        return urls;
    }

    private List<String> doTransAll() {
        ArrayList<String> urls = new ArrayList<String>(10);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        int count = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int i = 0;
        boolean success = true;
        ArrayList<String> errorMsg = new ArrayList<String>(10);
        while (i < count && success) {
            if (this.checkRowData(this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, i))) {
                String tmpUrl = (String)this.getModel().getValue(KEY_URL, i);
                try {
                    urls.addAll(LocaleBuildUtils.buildXmlAndProperties((String)((String)this.getModel().getValue(KEY_FILENAME, i)), (InputStream)tempFileCache.getInputStream(tmpUrl)));
                }
                catch (Exception e) {
                    errorMsg.add(String.format("Translation %s file failed, please check the file and try again", this.getModel().getValue(KEY_FILENAME, i)));
                }
                ++i;
                continue;
            }
            success = false;
        }
        if (!errorMsg.isEmpty()) {
            this.getView().showErrorNotification(String.join((CharSequence)"\u3001", errorMsg));
        }
        return urls;
    }

    private boolean checkRowData(DynamicObject row) {
        String fileName = row.getString(KEY_FILENAME);
        String url = row.getString(KEY_URL);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            this.getView().showErrorNotification("file name is empty");
            return false;
        }
        if (!cache.exists(url)) {
            this.getView().showErrorNotification("file is timeout, url is " + url);
            return false;
        }
        return true;
    }
}

